/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.image.FilteredImageSource;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDragSource;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.graphics.TransparencyFilter;
import oracle.bali.share.datatransfer.ObjectTransferable;

public class DTreeDragSupport {
    static final String __CLIENT_PROP_DRAG_ITEMS = "_ewtDTreeDragItems";
    private DTree _tree;
    private boolean _enabled;

    public DTreeDragSupport(DTree dTree) {
        this._tree = dTree;
        this._enabled = true;
        Dragger dragger = new Dragger(dTree);
    }

    public DTree getTree() {
        return this._tree;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    protected Image createDragImage(DTreeSelection dTreeSelection, DTreeItem dTreeItem) {
        DTree dTree = this.getTree();
        Image image = null;
        if (dTreeSelection.getItemCount() > 1) {
            EWTTreeUI eWTTreeUI = dTree.getUI();
            image = eWTTreeUI.getMultiItemDragImage(dTree);
        } else {
            Dimension dimension = dTreeItem.getSize();
            Image image2 = dTree.createImage(dimension.width, dimension.height);
            Graphics graphics = image2.getGraphics();
            Color color = dTree.getBackground();
            graphics.setColor(color);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(dTree.getForeground());
            dTreeItem.paint(graphics, false, false, dimension.width, dimension.height);
            image = dTree.createImage(new FilteredImageSource(image2.getSource(), new TransparencyFilter(color)));
            graphics.dispose();
            image2.flush();
        }
        return image;
    }

    protected Transferable createTransferable(DTreeSelection dTreeSelection) {
        int n = dTreeSelection.getItemCount();
        if (n == 1) {
            DTreeItem dTreeItem = dTreeSelection.getFirstItem();
            DTreeDragSource dTreeDragSource = this.getDTreeDragSource(dTreeItem);
            if (dTreeDragSource != null) {
                return dTreeDragSource.getTransferable(dTreeItem);
            }
        } else if (n > 1) {
            DTreeItem[] dTreeItemArray = dTreeSelection.getItems();
            Transferable[] transferableArray = new Transferable[dTreeItemArray.length];
            int n2 = 0;
            while (n2 < dTreeItemArray.length) {
                DTreeItem dTreeItem = dTreeItemArray[n2];
                DTreeDragSource dTreeDragSource = this.getDTreeDragSource(dTreeItem);
                if (dTreeDragSource == null) {
                    return null;
                }
                Transferable transferable = dTreeDragSource.getTransferable(dTreeItem);
                if (transferable == null) {
                    return null;
                }
                transferableArray[n2++] = transferable;
            }
            return ObjectTransferable.createTransferable(transferableArray);
        }
        return null;
    }

    protected void dragDropEnd(DTreeSelection dTreeSelection, int n) {
        DTreeItem[] dTreeItemArray = dTreeSelection.getItems();
        int n2 = 0;
        while (n2 < dTreeItemArray.length) {
            DTreeItem dTreeItem = dTreeItemArray[n2];
            DTreeDragSource dTreeDragSource = this.getDTreeDragSource(dTreeItem);
            if (dTreeDragSource != null) {
                dTreeDragSource.dragDropEnd(dTreeItem, n);
            }
            ++n2;
        }
    }

    protected DTreeDragSource getDTreeDragSource(DTreeItem dTreeItem) {
        return dTreeItem.getDragSource();
    }

    protected int getSourceActions(DTreeSelection dTreeSelection) {
        if (dTreeSelection == null) {
            return 0;
        }
        DTreeItem[] dTreeItemArray = dTreeSelection.getItems();
        if (dTreeItemArray.length == 0) {
            return 0;
        }
        int n = 0x40000003;
        int n2 = 0;
        while (n2 < dTreeItemArray.length) {
            DTreeItem dTreeItem = dTreeItemArray[n2];
            DTreeDragSource dTreeDragSource = this.getDTreeDragSource(dTreeItem);
            if (n == 0 || dTreeDragSource == null) {
                return 0;
            }
            n &= dTreeDragSource.getSourceActions(dTreeItem);
            ++n2;
        }
        return n;
    }

    protected DTreeSelection getTransferSelection() {
        DTree dTree = this.getTree();
        DTreeSelectionManager dTreeSelectionManager = dTree.getSelectionManager();
        DTreeSelection dTreeSelection = dTreeSelectionManager.getSelection();
        return dTreeSelection.getAncestorSelection();
    }

    private class Dragger
    implements DragSourceListener,
    DragGestureListener {
        private DTreeSelection _dragItems;

        public Dragger(DTree dTree) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(dTree, 0x40000003, this);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (DTreeDragSupport.this.isEnabled()) {
                Transferable transferable;
                DTreeSelection dTreeSelection;
                int n;
                DTree dTree = DTreeDragSupport.this.getTree();
                Point point = dragGestureEvent.getDragOrigin();
                Point point2 = dTree.convertOuterToCanvas(point.x, point.y);
                DTreeItem dTreeItem = dTree.getDraggableItemAt(point2.x, point2.y);
                DTreeSelectionManager dTreeSelectionManager = dTree.getSelectionManager();
                if (dTreeItem != null && dTreeSelectionManager.isSelected(dTreeItem) && (n = DTreeDragSupport.this.getSourceActions(dTreeSelection = DTreeDragSupport.this.getTransferSelection())) != 0 && (transferable = DTreeDragSupport.this.createTransferable(dTreeSelection)) != null) {
                    this._setDragItems(dTreeSelection);
                    Image image = DTreeDragSupport.this.createDragImage(dTreeSelection, dTreeItem);
                    Point point3 = new Point(dTreeItem.getX() - point2.x, dTreeItem.getY() - point2.y);
                    Dimension dimension = dTreeItem.getSize();
                    int n2 = image.getWidth(dTree);
                    int n3 = image.getHeight(dTree);
                    if (n2 < dimension.width || n3 < dimension.height) {
                        point3.x = -n2;
                        point3.y = -n3;
                    }
                    dragGestureEvent.startDrag(null, image, point3, transferable, this);
                }
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            int n = dragSourceDropEvent.getDropSuccess() ? dragSourceDropEvent.getDropAction() : 0;
            DTreeDragSupport.this.dragDropEnd(this._getDragItems(), n);
            this._setDragItems(null);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        private DTreeSelection _getDragItems() {
            return this._dragItems;
        }

        private void _setDragItems(DTreeSelection dTreeSelection) {
            if (this._dragItems != dTreeSelection) {
                DTree dTree = DTreeDragSupport.this.getTree();
                if (this._dragItems != null) {
                    dTree.putClientProperty(DTreeDragSupport.__CLIENT_PROP_DRAG_ITEMS, null);
                    dTree.__removeSelection(this._dragItems);
                }
                this._dragItems = dTreeSelection;
                if (this._dragItems != null) {
                    dTree.__addSelection(this._dragItems);
                    dTree.putClientProperty(DTreeDragSupport.__CLIENT_PROP_DRAG_ITEMS, this._dragItems);
                }
            }
        }
    }
}

