/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.font;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.LocaleUtils;

public class FontPreviewArea
extends LWComponent {
    private static final String _KEY_EXAMPLE_TEXT = "FONTPANE.EXAMPLE_TEXT";
    private static final int _OUTER_HINSETS = 8;
    private static final int _OUTER_VINSETS = 8;
    private static final int _INNER_HINSETS = 4;
    private static final int _INNER_VINSETS = 4;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private Color _fontColor;
    private Color _fontBorderColor;
    private Color _fontBackground;
    private int _hAlignment;
    private int _vAlignment;
    private int _fontStyle;
    private int _fontWidth;
    private int _fontBaselineStyle;
    private String _exampleText;
    private boolean _fontBorderVisible;
    private boolean _baselineVisible;
    private Font _currentFont;
    private FontPane _pane;
    private FontPaneListener _listener;

    public FontPreviewArea() {
        this.setBackground(Color.white);
        this.setBorder(UIBorderFactory.getRaisedBevelBorder());
        this._hAlignment = 0;
        this._vAlignment = 0;
        this._fontStyle = 0;
        this._fontBaselineStyle = 1;
    }

    public Font getCurrentFont() {
        if (this._currentFont == null) {
            this._currentFont = this.getFont();
        }
        return this._currentFont;
    }

    public void setCurrentFont(Font font) {
        if (font == null) {
            font = this.getFont();
        }
        if (this._currentFont != font) {
            boolean bl;
            int n = this.getFontStyle();
            boolean bl2 = (n & 1) != 0;
            boolean bl3 = (n & 2) != 0;
            int n2 = font.getStyle();
            boolean bl4 = (n2 & 1) != 0;
            boolean bl5 = bl = (n2 & 2) != 0;
            if (bl2 != bl4) {
                n = bl2 ? (n &= 0xFFFFFFFE) : (n |= 1);
            }
            if (bl3 != bl) {
                n = bl3 ? (n &= 0xFFFFFFFD) : (n |= 2);
            }
            this._fontStyle = n;
            this._createCurrentFont(font);
            this.repaint();
        }
    }

    public void setFontColor(Color color) {
        if (this._fontColor != color) {
            this._fontColor = color;
            this.repaint();
        }
    }

    public Color getFontColor() {
        if (this._fontColor == null) {
            this._fontColor = this.getUIDefaults().getColor(LookAndFeel.TEXT_TEXT);
        }
        return this._fontColor;
    }

    public void setFontBackgroundColor(Color color) {
        if (this._fontBackground != color) {
            this._fontBackground = color;
            this.repaint();
        }
    }

    public Color getFontBackgroundColor() {
        if (this._fontBackground == null) {
            this._fontBackground = this.getUIDefaults().getColor(LookAndFeel.TEXT);
        }
        return this._fontBackground;
    }

    public void setFontBorderColor(Color color) {
        if (this._fontBorderColor != color) {
            this._fontBorderColor = color;
            if (this.isFontBorderVisible()) {
                this.repaint();
            }
        }
    }

    public Color getFontBorderColor() {
        if (this._fontBorderColor == null) {
            this._fontBorderColor = this.getFontBackgroundColor();
        }
        return this._fontBorderColor;
    }

    public boolean isFontBorderVisible() {
        return this._fontBorderVisible;
    }

    public void setFontBorderVisible(boolean bl) {
        if (this._fontBorderVisible != bl) {
            this._fontBorderVisible = bl;
            this.repaint();
        }
    }

    public void setFontHorizontalAlignment(int n) {
        if (this._hAlignment != n) {
            this._hAlignment = n;
            this.repaint();
        }
    }

    public int getFontHorizontalAlignment() {
        return this._hAlignment;
    }

    public void setFontVerticalAlignment(int n) {
        if (this._vAlignment != n) {
            this._vAlignment = n;
            this.repaint();
        }
    }

    public int getFontVerticalAlignment() {
        return this._vAlignment;
    }

    public void setFontStyle(int n) {
        if (this._fontStyle != n) {
            this._fontStyle = n;
            Font font = this.getCurrentFont();
            font = font.deriveFont(n);
            this._createCurrentFont(font);
            this.repaint();
        }
    }

    public int getFontStyle() {
        return this._fontStyle;
    }

    public void setFontWidth(int n) {
        if (this._fontWidth != n) {
            this._fontWidth = n;
            this._createCurrentFont(this.getCurrentFont());
            this.repaint();
        }
    }

    public int getFontWidth() {
        return this._fontWidth;
    }

    public void setFontBaselineStyle(int n) {
        if (this._fontBaselineStyle != n) {
            this._fontBaselineStyle = n;
            this.repaint();
        }
    }

    public int getFontBaselineStyle() {
        return this._fontBaselineStyle;
    }

    public boolean isBaselineVisible() {
        return this._baselineVisible;
    }

    public void setBaselineVisible(boolean bl) {
        if (this._baselineVisible != bl) {
            this._baselineVisible = bl;
            this.repaint();
        }
    }

    public void setPreviewText(String string) {
        if (this._exampleText != string) {
            this._exampleText = string;
            this.repaint();
        }
    }

    public String getPreviewText() {
        if (this._exampleText == null) {
            Locale locale = LocaleUtils.getDefaultableLocale(this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
            this._exampleText = resourceBundle.getString(_KEY_EXAMPLE_TEXT);
        }
        return this._exampleText;
    }

    public void setFontPane(FontPane fontPane) {
        if (this._pane != fontPane) {
            if (this._pane != null) {
                this._pane.removePropertyChangeListener(this._listener);
            }
            if (this._listener == null) {
                this._listener = new FontPaneListener();
            }
            this._pane = fontPane;
            if (this._pane != null) {
                this._pane.addPropertyChangeListener(this._listener);
            }
            this._init(fontPane);
        }
    }

    public FontPane getFontPane() {
        return this._pane;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        boolean bl;
        Shape shape = graphics.getClip();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        PaintContext paintContext = this.getPaintContext();
        boolean bl2 = (paintContext.getPaintState() & 1) == 0;
        ImmInsets immInsets = this.getBorderInsets();
        if (bl2) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(paintContext.getPaintUIDefaults().getColor("lightIntensity"));
        }
        graphics.fillRect(immInsets.left, immInsets.top, n2 - (immInsets.left + immInsets.right), n3 - (immInsets.bottom + immInsets.top));
        immInsets = new ImmInsets(immInsets.top + 8, immInsets.left + 8, immInsets.bottom + 8, immInsets.right + 8);
        n2 -= immInsets.left + immInsets.right;
        n3 -= immInsets.top + immInsets.bottom;
        if (bl2) {
            graphics.setColor(this.getFontBackgroundColor());
        } else {
            graphics.setColor(paintContext.getPaintUIDefaults().getColor("lightIntensity"));
        }
        graphics.fillRect(immInsets.left, immInsets.top, n2, n3);
        if (this.isFontBorderVisible() && bl2) {
            graphics.setColor(this.getFontBorderColor());
            graphics.drawRect(immInsets.left, immInsets.top, n2 - 1, n3 - 1);
            graphics.drawRect(immInsets.left + 1, immInsets.top + 1, n2 - 3, n3 - 3);
        }
        Font font = this.getCurrentFont();
        graphics.setFont(font);
        String string = this.getPreviewText();
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(graphics.getFont());
        int n4 = fontMetrics.stringWidth(string);
        int n5 = this.getFontHorizontalAlignment();
        int n6 = 0;
        Locale locale = LocaleUtils.getDefaultableLocale(this);
        boolean bl3 = bl = LocaleUtils.getReadingDirectionForLocale(locale) == 1;
        if (n5 == 10) {
            n5 = bl ? 2 : 4;
        } else if (n5 == 11) {
            n5 = bl ? 4 : 2;
        }
        switch (n5) {
            case 0: {
                n6 = (this.getWidth() - n4) / 2;
                break;
            }
            case 4: {
                n6 = this.getWidth() - (immInsets.right + 4) - n4;
                break;
            }
            default: {
                n6 = immInsets.left + 4;
            }
        }
        int n7 = 0;
        int n8 = fontMetrics.getMaxAscent() + immInsets.top;
        int n9 = this.getHeight() - (fontMetrics.getMaxDescent() + immInsets.bottom);
        int n10 = (n8 + n9) / 2;
        int n11 = this.getFontVerticalAlignment();
        switch (n11) {
            case 1: {
                n7 = Math.min(n8, n10);
                break;
            }
            case 3: {
                n7 = Math.max(n9, n10);
                break;
            }
            default: {
                n7 = n10;
            }
        }
        if (this.isBaselineVisible()) {
            graphics.setColor(Color.gray);
            n = immInsets.left + 1;
            int n12 = this.getWidth() - immInsets.right - 3;
            graphics.drawLine(n, n7 - 3, n, n7 + 3);
            graphics.drawLine(++n, n7 - 2, n, n7 + 2);
            graphics.drawLine(++n, n7 - 1, n, n7 + 1);
            graphics.drawLine(n12, n7 - 3, n12, n7 + 3);
            graphics.drawLine(--n12, n7 - 2, n12, n7 + 2);
            graphics.drawLine(--n12, n7 - 1, n12, n7 + 1);
            int n13 = n;
            while (n13 < n12) {
                graphics.drawLine(n13, n7, n13 + 1, n7);
                n13 += 3;
            }
        }
        n = this.getFontBaselineStyle();
        switch (n) {
            case 2: {
                n7 -= 3;
                break;
            }
            case 3: {
                n7 += 3;
            }
        }
        graphics.setColor(this.getFontColor());
        graphics.clipRect(immInsets.left, immInsets.top, n2, n3);
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AttributedString attributedString = new AttributedString(string, font.getAttributes());
            graphics2D.drawString(attributedString.getIterator(), n6, n7);
        } else {
            graphics.drawString(string, n6, n7);
        }
        if (shape != null) {
            graphics.setClip(shape);
        }
    }

    private void _init(FontPane fontPane) {
        if (fontPane == null) {
            return;
        }
        this.setFontColor(fontPane.getFontColor());
        this.setFontBackgroundColor(fontPane.getFontBackgroundColor());
        this.setFontHorizontalAlignment(fontPane.getFontHorizontalAlignment());
        this.setFontVerticalAlignment(fontPane.getFontVerticalAlignment());
        this.setFontBaselineStyle(fontPane.getFontBaselineStyle());
        this._updateBaselineVisibility();
        this.setFontBorderColor(fontPane.getBorderColor());
        this._updateBorderVisibility();
        this.setFontStyle(fontPane.getFontStyle());
        Font font = fontPane.getCurrentFont();
        this._setExampleFont(font);
    }

    private void _setExampleFont(Font font) {
        if (!this.getFontPane().isActualFontSizeUsed() && font != null) {
            font = new Font(font.getName(), font.getStyle(), 12);
        }
        this.setCurrentFont(font);
    }

    private void _updateBaselineVisibility() {
        FontPane fontPane = this.getFontPane();
        int n = fontPane.getFontBaselineStyle();
        boolean bl = n == 2;
        boolean bl2 = n == 3;
        int n2 = fontPane.getStyleButtonMask();
        boolean bl3 = (n2 & 0x10) != 0;
        boolean bl4 = (n2 & 0x20) != 0;
        this.setBaselineVisible(bl3 | bl4 | bl | bl2);
    }

    private void _updateBorderVisibility() {
        int n = this.getFontPane().getColorComponentMask();
        boolean bl = (n & 4) != 0;
        this.setFontBorderVisible(bl);
    }

    private void _createCurrentFont(Font font) {
        int n;
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(9);
        hashMap.put(TextAttribute.FAMILY, font.getFamily());
        hashMap.put(TextAttribute.SIZE, new Float(font.getSize2D()));
        int n2 = this.getFontStyle();
        if ((n2 & 4) != 0) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if ((n2 & 8) != 0) {
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if ((n = this.getFontBaselineStyle()) == 2) {
            hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        } else if (n == 3) {
            hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        if (this.getFontHorizontalAlignment() == 100) {
            hashMap.put(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_FULL);
        }
        if (font.isBold()) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (font.isItalic()) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        int n3 = this.getFontWidth();
        switch (n3) {
            case 0: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                break;
            }
            case 4: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 1: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
                break;
            }
            case 3: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
            }
        }
        this._currentFont = new Font(hashMap);
    }

    private class FontPaneListener
    implements PropertyChangeListener {
        private FontPaneListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            FontPane fontPane = FontPreviewArea.this.getFontPane();
            if ("fontName".equals(string) || "fontSize".equals(string)) {
                FontPreviewArea.this._setExampleFont(fontPane.getCurrentFont());
            } else if ("fontStyle".equals(string)) {
                FontPreviewArea.this.setFontStyle(fontPane.getFontStyle());
            } else if ("fontBaselineStyle".equals(string)) {
                FontPreviewArea.this.setFontBaselineStyle(fontPane.getFontBaselineStyle());
            } else if ("fontHorizontalAlignment".equals(string)) {
                FontPreviewArea.this.setFontHorizontalAlignment(fontPane.getFontHorizontalAlignment());
            } else if ("fontVerticalAlignment".equals(string)) {
                FontPreviewArea.this.setFontVerticalAlignment(fontPane.getFontVerticalAlignment());
            } else if ("actualFontSizeUsed".equals(string)) {
                FontPreviewArea.this._setExampleFont(fontPane.getCurrentFont());
            } else if ("fontColor".equals(string)) {
                FontPreviewArea.this.setFontColor(fontPane.getFontColor());
            } else if ("fontBackgroundColor".equals(string)) {
                FontPreviewArea.this.setFontBackgroundColor(fontPane.getFontBackgroundColor());
            } else if ("borderColor".equals(string)) {
                FontPreviewArea.this.setFontBorderColor(fontPane.getBorderColor());
            } else if ("colorComponentMask".equals(string)) {
                FontPreviewArea.this._updateBorderVisibility();
            } else if ("styleButtonMask".equals(string)) {
                FontPreviewArea.this._updateBaselineVisibility();
            } else if ("fontWidth".equals(string)) {
                FontPreviewArea.this.setFontWidth(fontPane.getFontWidth());
            } else if ("alignmentButtonMask".equals(string)) {
                // empty if block
            }
        }
    }
}

