/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.imageCanvas.ImageCanvas;

class ImageComponent
extends BaseColorEditor {
    private static final String _KEY_LABEL = "COLORCHOOSER.COLOR_SELECTOR";
    private static final int _WIDTH = 150;
    private static final int _BRI_WIDTH = 10;
    private static final int _HEIGHT = 150;
    private static final int _IMAGE_SIZE = 22500;
    private static final int _BRI_IMAGE_SIZE = 1500;
    private static final Dimension _SIZE_GAUGE = new Dimension(5, 150);
    private static final Dimension _SIZE_IMAGE = new Dimension(150, 150);
    private JLabel _label;
    private ImageCanvas _imageCanvas;
    private ImageCanvas _briCanvas;
    private Gauge _briGauge;
    private float _x = 0.0f;
    private float _y = 0.0f;
    private float _brightness = 150.0f;

    public ImageComponent() {
        Listener listener = new Listener();
        this.setLayout(new BorderLayout(0, 5));
        this._label = new JLabel(" ");
        this.add("North", this._label);
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        this._imageCanvas = new Canvas();
        this._imageCanvas.setImage(this._createImage());
        this._imageCanvas.addMouseListener(listener);
        this._imageCanvas.addMouseMotionListener(listener);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(UIBorderFactory.getLoweredBevelBorder());
        jPanel2.add("North", this._imageCanvas);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", jPanel2);
        jPanel.add("Center", jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this._briGauge = new Gauge();
        this._briGauge.addMouseListener(listener);
        this._briGauge.addMouseMotionListener(listener);
        this._briCanvas = new ImageCanvas();
        this._briCanvas.setBorder(new EmptyBorder(5, 0, 0, 0));
        this._setBrightnessImage();
        this._briCanvas.addMouseListener(listener);
        this._briCanvas.addMouseMotionListener(listener);
        jPanel4.add("West", this._briCanvas);
        jPanel4.add("Center", this._briGauge);
        jPanel.add("East", jPanel4);
        this.add("Center", jPanel);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._label.setEnabled(bl);
        this._imageCanvas.setEnabled(bl);
        this._briCanvas.setEnabled(bl);
        this._briGauge.setEnabled(bl);
    }

    protected void colorChanged(Color color) {
        this._updateLocation(color);
    }

    protected void updateLabels(Locale locale) {
        String string = BaseColorEditor.__getTranslatedString(locale, _KEY_LABEL);
        this._label.setText(string);
    }

    private void _updateColor(Object object, float f, float f2) {
        if (!this.isEnabled()) {
            return;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 150.0f) {
            f2 = 150.0f;
        }
        if (object == this._imageCanvas) {
            if (f < 0.0f) {
                f = 0.0f;
            } else if (f > 150.0f) {
                f = 150.0f;
            }
            this._x = f;
            this._y = f2;
        } else {
            this._brightness = f2;
        }
        Color color = Color.getHSBColor(1.0f - this._x / 150.0f, this._y / 150.0f, 1.0f - this._brightness / 150.0f);
        this.storeColor(color);
        this._imageCanvas.repaint();
        this._setBrightnessImage();
    }

    private void _updateLocation(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this._x = 150.0f - fArray[0] * 150.0f;
        this._y = fArray[1] * 150.0f;
        this._brightness = 150.0f - fArray[2] * 150.0f;
        this._imageCanvas.repaint();
        this._setBrightnessImage();
    }

    private void _setBrightnessImage() {
        int[] nArray = new int[1500];
        int n = 0;
        float f = 1.0f - this._x / 150.0f;
        float f2 = this._y / 150.0f;
        float f3 = 1.0f;
        float f4 = 0.006666667f;
        int n2 = 0;
        while (n2 < 150) {
            int n3 = Color.HSBtoRGB(f, f2, f3);
            int n4 = 0;
            while (n4 < 10) {
                nArray[n++] = n3;
                ++n4;
            }
            f3 -= f4;
            ++n2;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(10, 150, nArray, 0, 10);
        Image image = this.createImage(memoryImageSource);
        this._briCanvas.setImage(image);
        this._briGauge.repaint();
    }

    private Image _createImage() {
        int[] nArray = new int[22500];
        int n = 0;
        float f = 0.006666667f;
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < 150) {
            float f3 = 1.0f;
            int n3 = 0;
            while (n3 < 150) {
                nArray[n++] = Color.HSBtoRGB(f3, f2, 1.0f);
                f3 -= f;
                ++n3;
            }
            f2 += f;
            ++n2;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(150, 150, nArray, 0, 150);
        return this.createImage(memoryImageSource);
    }

    private class Canvas
    extends ImageCanvas {
        public Canvas() {
            this.setMinimumSize(_SIZE_IMAGE);
            this.setMaximumSize(_SIZE_IMAGE);
            this.setPreferredSize(_SIZE_IMAGE);
        }

        public void paintOverChildren(Graphics graphics) {
            int n = (int)ImageComponent.this._x;
            int n2 = (int)ImageComponent.this._y;
            graphics.setColor(Color.black);
            graphics.drawLine(n - 5, n2 - 5, n + 5, n2 + 5);
            graphics.drawLine(n - 5, n2 + 5, n + 5, n2 - 5);
        }
    }

    private class Gauge
    extends JPanel {
        public Gauge() {
            this.setMinimumSize(_SIZE_GAUGE);
            this.setMaximumSize(_SIZE_GAUGE);
            this.setPreferredSize(_SIZE_GAUGE);
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.black);
            int n = (int)ImageComponent.this._brightness + 5;
            graphics.drawLine(0, n, 0, n);
            graphics.drawLine(1, n - 1, 1, n + 1);
            graphics.drawLine(2, n - 2, 2, n + 2);
            graphics.drawLine(3, n - 3, 3, n + 3);
            graphics.drawLine(4, n - 4, 4, n + 4);
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private Listener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ImageComponent.this._updateColor(mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ImageComponent.this._updateColor(mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ImageComponent.this._updateColor(mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

