/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JLabel;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.chooser.color.HexEditor;
import oracle.bali.share.nls.StringUtils;

class HTMLHexComponent
extends BaseColorEditor {
    private static final String _KEY_LABEL = "COLORCHOOSER.HTML_LABEL";
    private boolean _ignoreEvents;
    private JLabel _label;
    private HexEditor _hexEditor;

    public HTMLHexComponent() {
        Listener listener = new Listener();
        this._hexEditor = new HexEditor();
        this._hexEditor.addPropertyChangeListener(listener);
        this._label = new JLabel(" ");
        this._label.setLabelFor(this._hexEditor);
        this.setLayout(new BorderLayout(5, 5));
        this.add("West", this._label);
        this.add("Center", this._hexEditor);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._label.setEnabled(bl);
        this._hexEditor.setEnabled(bl);
    }

    protected void colorChanged(Color color) {
        this._ignoreEvents = true;
        this._hexEditor.setColor(color);
        this._ignoreEvents = false;
    }

    protected void updateLabels(Locale locale) {
        String string = BaseColorEditor.__getTranslatedString(locale, _KEY_LABEL);
        this._label.setText(StringUtils.stripMnemonic(string));
        this._label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
    }

    private void _updateColor(Color color) {
        this.storeColor(color);
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("color".equals(string) && !HTMLHexComponent.this._ignoreEvents) {
                HTMLHexComponent.this._updateColor((Color)propertyChangeEvent.getNewValue());
            }
        }
    }
}

