/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;

class HSLComponent
extends BaseColorEditor {
    private static final int _MAX_HUE = 360;
    private static final int _MAX_SAT = 100;
    private static final int _MAX_LUM = 100;
    private static final String _HUE_SUFFIX = String.valueOf('\u00b0');
    private static final Insets _INSETS = new Insets(0, 0, 3, 3);
    private static final String _KEY_HUE = "COLORCHOOSER.HUE_LABEL";
    private static final String _KEY_SAT = "COLORCHOOSER.SAT_LABEL";
    private static final String _KEY_LUM = "COLORCHOOSER.LUM_LABEL";
    private static final String _KEY_HUE_DESC = "COLORCHOOSER.HUE_DESCRIPTION";
    private static final String _KEY_SAT_DESC = "COLORCHOOSER.SAT_DESCRIPTION";
    private static final String _KEY_LUM_DESC = "COLORCHOOSER.LUM_DESCRIPTION";
    private boolean _ignoreEvents;
    private JLabel _hueLabel;
    private JLabel _hueSuffix;
    private JLabel _lumLabel;
    private JLabel _lumSuffix;
    private JLabel _satLabel;
    private JLabel _satSuffix;
    private NumericSpinBox _hue;
    private NumericSpinBox _sat;
    private NumericSpinBox _lum;

    public HSLComponent() {
        Listener listener = new Listener();
        this._hue = new NumericSpinBox(0, 360);
        this._hue.addChangeListener(listener);
        this._sat = new NumericSpinBox(0, 100);
        this._sat.addChangeListener(listener);
        this._lum = new NumericSpinBox(0, 100);
        this._lum.addChangeListener(listener);
        this._hueLabel = new JLabel(" ");
        this._hueLabel.setLabelFor(this._hue);
        this._hueSuffix = new JLabel(_HUE_SUFFIX);
        this._satLabel = new JLabel(" ");
        this._satLabel.setLabelFor(this._sat);
        this._satSuffix = new JLabel("%");
        this._lumLabel = new JLabel(" ");
        this._lumLabel.setLabelFor(this._lum);
        this._lumSuffix = new JLabel("%");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = _INSETS;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this._hueLabel, gridBagConstraints);
        this.add(this._hueLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._hue, gridBagConstraints);
        this.add(this._hue);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._hueSuffix, gridBagConstraints);
        this.add(this._hueSuffix);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this._satLabel, gridBagConstraints);
        this.add(this._satLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._sat, gridBagConstraints);
        this.add(this._sat);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._satSuffix, gridBagConstraints);
        this.add(this._satSuffix);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this._lumLabel, gridBagConstraints);
        this.add(this._lumLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._lum, gridBagConstraints);
        this.add(this._lum);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._lumSuffix, gridBagConstraints);
        this.add(this._lumSuffix);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._hueLabel.setEnabled(bl);
        this._lumLabel.setEnabled(bl);
        this._satLabel.setEnabled(bl);
        this._hue.setEnabled(bl);
        this._sat.setEnabled(bl);
        this._lum.setEnabled(bl);
        this._hueSuffix.setEnabled(bl);
        this._lumSuffix.setEnabled(bl);
        this._satSuffix.setEnabled(bl);
    }

    protected void updateLabels(Locale locale) {
        String string = BaseColorEditor.__getTranslatedString(locale, _KEY_HUE);
        this._hueLabel.setText(StringUtils.stripMnemonic(string));
        this._hueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
        string = BaseColorEditor.__getTranslatedString(locale, _KEY_SAT);
        this._satLabel.setText(StringUtils.stripMnemonic(string));
        this._satLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
        string = BaseColorEditor.__getTranslatedString(locale, _KEY_LUM);
        this._lumLabel.setText(StringUtils.stripMnemonic(string));
        this._lumLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
    }

    protected void updateAccessibleNames() {
        String string = this.__getTranslatedString(_KEY_HUE_DESC);
        this._hue.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_SAT_DESC);
        this._sat.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_LUM_DESC);
        this._lum.getAccessibleContext().setAccessibleName(string);
    }

    protected void colorChanged(Color color) {
        double[] dArray = ColorUtils.rgbToHSL(color.getRed(), color.getGreen(), color.getBlue());
        this._ignoreEvents = true;
        this._hue.setIntValue((int)dArray[0]);
        this._sat.setIntValue((int)dArray[1]);
        this._lum.setIntValue((int)dArray[2]);
        this._ignoreEvents = false;
    }

    private void _updateColor() {
        double d = this._hue.getIntValue();
        double d2 = this._sat.getIntValue();
        double d3 = this._lum.getIntValue();
        int[] nArray = ColorUtils.hslToRGB(d, d2, d3);
        this.storeColor(new Color(nArray[0], nArray[1], nArray[2]));
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!HSLComponent.this._ignoreEvents) {
                HSLComponent.this._updateColor();
            }
        }
    }
}

