/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;

class HSBComponent
extends BaseColorEditor {
    private static final int _MAX_HUE = 360;
    private static final int _MAX_SAT = 100;
    private static final int _MAX_BRI = 100;
    private static final Insets _INSETS = new Insets(0, 0, 3, 3);
    private static final String _HUE_SUFFIX = String.valueOf('\u00b0');
    private static final String _KEY_HUE = "COLORCHOOSER.HUE_LABEL";
    private static final String _KEY_SAT = "COLORCHOOSER.SAT_LABEL";
    private static final String _KEY_BRI = "COLORCHOOSER.BRIGHTNESS_LABEL";
    private static final String _KEY_HUE_DESC = "COLORCHOOSER.HUE_DESCRIPTION";
    private static final String _KEY_SAT_DESC = "COLORCHOOSER.SAT_DESCRIPTION";
    private static final String _KEY_BRI_DESC = "COLORCHOOSER.BRIGHTNESS_DESCRIPTION";
    private boolean _ignoreEvents;
    private JLabel _hueLabel;
    private JLabel _hueSuffix;
    private JLabel _briLabel;
    private JLabel _briSuffix;
    private JLabel _satLabel;
    private JLabel _satSuffix;
    private NumericSpinBox _hue;
    private NumericSpinBox _sat;
    private NumericSpinBox _bri;

    public HSBComponent() {
        Listener listener = new Listener();
        this._hue = new NumericSpinBox(0, 360);
        this._hue.addChangeListener(listener);
        this._sat = new NumericSpinBox(0, 100);
        this._sat.addChangeListener(listener);
        this._bri = new NumericSpinBox(0, 100);
        this._bri.addChangeListener(listener);
        this._hueLabel = new JLabel(" ");
        this._hueLabel.setLabelFor(this._hue);
        this._hueSuffix = new JLabel(_HUE_SUFFIX);
        this._satLabel = new JLabel(" ");
        this._satLabel.setLabelFor(this._sat);
        this._satSuffix = new JLabel("%");
        this._briLabel = new JLabel(" ");
        this._briLabel.setLabelFor(this._bri);
        this._briSuffix = new JLabel("%");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = _INSETS;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this._hueLabel, gridBagConstraints);
        this.add(this._hueLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._hue, gridBagConstraints);
        this.add(this._hue);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._hueSuffix, gridBagConstraints);
        this.add(this._hueSuffix);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this._satLabel, gridBagConstraints);
        this.add(this._satLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._sat, gridBagConstraints);
        this.add(this._sat);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._satSuffix, gridBagConstraints);
        this.add(this._satSuffix);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this._briLabel, gridBagConstraints);
        this.add(this._briLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._bri, gridBagConstraints);
        this.add(this._bri);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._briSuffix, gridBagConstraints);
        this.add(this._briSuffix);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._hueLabel.setEnabled(bl);
        this._briLabel.setEnabled(bl);
        this._satLabel.setEnabled(bl);
        this._hueSuffix.setEnabled(bl);
        this._briSuffix.setEnabled(bl);
        this._satSuffix.setEnabled(bl);
        this._hue.setEnabled(bl);
        this._sat.setEnabled(bl);
        this._bri.setEnabled(bl);
    }

    protected void updateLabels(Locale locale) {
        String string = BaseColorEditor.__getTranslatedString(locale, _KEY_HUE);
        this._hueLabel.setText(StringUtils.stripMnemonic(string));
        this._hueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
        string = BaseColorEditor.__getTranslatedString(locale, _KEY_SAT);
        this._satLabel.setText(StringUtils.stripMnemonic(string));
        this._satLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
        string = BaseColorEditor.__getTranslatedString(locale, _KEY_BRI);
        this._briLabel.setText(StringUtils.stripMnemonic(string));
        this._briLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
    }

    protected void updateAccessibleNames() {
        String string = this.__getTranslatedString(_KEY_HUE_DESC);
        this._hue.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_SAT_DESC);
        this._sat.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_BRI_DESC);
        this._bri.getAccessibleContext().setAccessibleName(string);
    }

    protected void colorChanged(Color color) {
        double[] dArray = ColorUtils.colorToHSB(color);
        this._ignoreEvents = true;
        this._hue.setIntValue((int)dArray[0]);
        this._sat.setIntValue((int)dArray[1]);
        this._bri.setIntValue((int)dArray[2]);
        this._ignoreEvents = false;
    }

    private void _updateColor() {
        this.storeColor(ColorUtils.hsbToColor(this._hue.getIntValue(), this._sat.getIntValue(), this._bri.getIntValue()));
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!HSBComponent.this._ignoreEvents) {
                HSBComponent.this._updateColor();
            }
        }
    }
}

