/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.chooser.color.ColorChooserPane;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class ColorPalettePane
extends LWComponent
implements Accessible {
    public static final String PROPERTY_COLOR_PALETTE = "colorPalette";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_COLOR_NAME = "COLORPALETTE.COLOR_NAME";
    private static final String _KEY_TITLE = "COLORPALETTE.COLOR_PALETTE_TITLE";
    private static final String _KEY_LABEL = "COLORPALETTE.AVAILABLE_COLORS";
    private static final String _KEY_CUSTOM_LABEL = "COLORPALETTE.CUSTOM_COLORS";
    private static final String _KEY_EDIT = "COLORPALETTE.EDIT_COLOR";
    private Listener _listener = new Listener();
    private ColorGrid _grid = new AccessGrid(false);
    private JLabel _label;
    private JButton _editButton;
    private JLabel _colorName;
    private JLabel _colorNameLabel;
    private JPanel _colorNameComponent;
    private JPanel _customButtonPanel;
    private TwoDModel _names;
    private TwoDModel _customNames;
    private ColorGrid _customGrid;
    private JLabel _customLabel;
    private ColorChooserPane _colorChooserPane;
    private boolean _ignoreEvents;
    private boolean _chooserVisible;

    public static int showDialog(Component component, ColorPalettePane colorPalettePane) {
        return ColorPalettePane.showDialog(component, colorPalettePane, null, false);
    }

    public static int showDialog(Component component, ColorPalettePane colorPalettePane, String string, boolean bl) {
        Object object;
        if (colorPalettePane == null) {
            throw new IllegalArgumentException("ColorPalettePane must be non-null");
        }
        Locale locale = LocaleUtils.getDefaultableLocale(colorPalettePane);
        if (string == null) {
            object = ResourceBundle.getBundle(_RESOURCE, locale);
            string = ((ResourceBundle)object).getString(_KEY_TITLE);
        }
        object = JEWTDialog.createDialog(component, string, 7);
        ((Component)object).setLocale(locale);
        ((JEWTDialog)object).setContent(colorPalettePane);
        ((JEWTDialog)object).setCenterOver(component);
        ((Dialog)object).setResizable(bl);
        ((JEWTDialog)object).setInitialFocus(colorPalettePane._getInitialFocus());
        int n = ((JEWTDialog)object).runDialog() ? 1 : 2;
        ((JEWTDialog)object).dispose();
        return n;
    }

    public ColorPalettePane() {
        this(null);
    }

    public ColorPalettePane(TwoDModel twoDModel) {
        this(twoDModel, null, false);
    }

    public ColorPalettePane(TwoDModel twoDModel, Color color, boolean bl) {
        this(twoDModel, color, bl, null);
    }

    public ColorPalettePane(TwoDModel twoDModel, Color color, boolean bl, TwoDModel twoDModel2) {
        this._grid.addPropertyChangeListener(this._listener);
        this._label = new JLabel("");
        this._label.setLabelFor(this._grid);
        this._editButton = new JButton("");
        this._editButton.setActionCommand(_KEY_EDIT);
        this._editButton.addActionListener(this._listener);
        this._customGrid = new AccessGrid(true);
        this._customGrid.addPropertyChangeListener(this._listener);
        this._customGrid.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (ColorPalettePane.this.isEnabled() && !mouseEvent.isConsumed() && mouseEvent.getClickCount() == 2) {
                    ColorPalettePane.this._editColor();
                }
            }
        });
        this._customLabel = new JLabel("");
        this._customLabel.setLabelFor(this._customGrid);
        this._customButtonPanel = new JPanel(new EqualColumnLayout(5));
        this._colorName = new JLabel("");
        this._colorNameLabel = new JLabel("");
        this._colorNameComponent = new JPanel();
        this._colorNameComponent.setLayout(new BorderLayout(5, 5));
        this._colorNameComponent.add("West", this._colorNameLabel);
        this._colorNameComponent.add("Center", this._colorName);
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 3));
        jPanel.add("North", this._customLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 3));
        jPanel2.add("North", this._customGrid);
        jPanel2.add("Center", this._editButton);
        jPanel.add("Center", jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 5));
        jPanel3.add("North", this._grid);
        jPanel3.add("South", jPanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.add("West", jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add("North", this._customButtonPanel);
        jPanel4.add("Center", jPanel5);
        this.add("North", this._label);
        this.add("Center", jPanel4);
        this.add("South", this._colorNameComponent);
        this.setColorNameVisible(false);
        this.setColorPalette(twoDModel);
        this.setCustomColorsVisible(twoDModel2 != null);
        this.setCustomColorPalette(twoDModel2);
        this.setSelectedColor(color);
        this.setEditVisible(bl);
    }

    public void setColorPalette(TwoDModel twoDModel) {
        this._grid.setColorPalette(twoDModel);
    }

    public TwoDModel getColorPalette() {
        return this._grid.getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel twoDModel) {
        TwoDModel twoDModel2 = this._customGrid.getColorPalette();
        TwoDModel twoDModel3 = twoDModel;
        if (twoDModel == null) {
            twoDModel = NullTwoDModel.getTwoDModel();
        }
        this._customGrid.setColorPalette(twoDModel);
        this.firePropertyChange(PROPERTY_COLOR_PALETTE, twoDModel2, twoDModel);
    }

    public TwoDModel getCustomColorPalette() {
        TwoDModel twoDModel = this._customGrid.getColorPalette();
        if (twoDModel == NullTwoDModel.getTwoDModel()) {
            twoDModel = null;
        }
        return twoDModel;
    }

    public void setEditVisible(boolean bl) {
        this._editButton.setVisible(bl);
        this._revalidate();
    }

    public boolean isEditVisible() {
        return this._editButton.isVisible();
    }

    public void setSelectedColor(Color color) {
        this.setSelectedColor(color, false);
    }

    public Color getSelectedColor() {
        if (this.isCustomColorSelected()) {
            return this._customGrid.getSelectedColor();
        }
        return this._grid.getSelectedColor();
    }

    public boolean isCustomColorSelected() {
        return this._customGrid.isVisible() && this._customGrid.getSelectedColumn() != -1 && this._customGrid.getSelectedRow() != -1;
    }

    public void setSelectedColor(Color color, boolean bl) {
        if (bl) {
            this._grid.setDrawFocus(false);
            this._grid.setSelectedColor(null);
            this._customGrid.setSelectedColor(color);
            int n = this._customGrid.getSelectedColumn();
            int n2 = this._customGrid.getSelectedRow();
            if (n != -1 && n2 != -1) {
                this._customGrid.setFocusCell(new Cell(n, n2));
            }
            this._customGrid.setDrawFocus(true);
        } else {
            this._customGrid.setSelectedColor(null);
            this._customGrid.setDrawFocus(false);
            this._grid.setSelectedColor(color);
            int n = this._grid.getSelectedColumn();
            int n3 = this._grid.getSelectedRow();
            if (n != -1 && n3 != -1) {
                this._grid.setFocusCell(new Cell(n, n3));
            }
            this._grid.setDrawFocus(true);
        }
        this._updateEditButton();
    }

    public void setColorNames(TwoDModel twoDModel) {
        if (this._names != twoDModel) {
            if (this._names != null) {
                this._names.removeModelListener(this._listener);
            }
            this._names = twoDModel;
            if (this._names != null) {
                this._names.addModelListener(this._listener);
            }
        }
    }

    public TwoDModel getColorNames() {
        return this._names;
    }

    public void setCustomColorNames(TwoDModel twoDModel) {
        if (this._customNames != twoDModel) {
            if (this._customNames != null) {
                this._customNames.removeModelListener(this._listener);
            }
            this._customNames = twoDModel;
            if (this._customNames != null) {
                this._customNames.addModelListener(this._listener);
            }
        }
    }

    public TwoDModel getCustomColorNames() {
        return this._customNames;
    }

    public void setColorName(String string) {
        Color color = this.getSelectedColor();
        if (color != null) {
            this._colorName.setText(string);
            boolean bl = this.isCustomColorSelected();
            TwoDModel twoDModel = bl ? this.getCustomColorNames() : this.getColorNames();
            ColorGrid colorGrid = bl ? this._customGrid : this._grid;
            int n = colorGrid.getSelectedColumn();
            int n2 = colorGrid.getSelectedRow();
            if (n != -1 && n2 != -1 && twoDModel != null && n < twoDModel.getColumnCount() && n2 < twoDModel.getRowCount()) {
                twoDModel.setData(n, n2, string);
            }
        }
    }

    public String getColorName() {
        return this._colorName.getText();
    }

    public void setCustomColorsVisible(boolean bl) {
        this._customLabel.setVisible(bl);
        this._customGrid.setVisible(bl);
        this._revalidate();
    }

    public boolean isCustomColorsVisible() {
        return this._customGrid.isVisible();
    }

    public void setColorNameVisible(boolean bl) {
        this._colorNameComponent.setVisible(bl);
        this._revalidate();
    }

    public boolean isColorNameVisible() {
        return this._colorNameComponent.isVisible();
    }

    public void addCustomComponent(Component component) {
        this._customButtonPanel.add(component);
        this._revalidate();
    }

    public void removeCustomComponent(Component component) {
        this._customButtonPanel.remove(component);
        this._revalidate();
    }

    public int getCustomComponentCount() {
        return this._customButtonPanel.getComponentCount();
    }

    public Component getCustomComponent(int n) {
        return this._customButtonPanel.getComponent(n);
    }

    public ColorChooserPane getColorChooserPane() {
        if (this._colorChooserPane == null) {
            this._colorChooserPane = new ColorChooserPane();
            this._colorChooserPane.setLocale(LocaleUtils.getDefaultableLocale(this));
        }
        return this._colorChooserPane;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._grid.setEnabled(bl);
        this._customGrid.setEnabled(bl);
        this._updateEditButton();
        this._label.setEnabled(bl);
        this._customLabel.setEnabled(bl);
        this._colorNameLabel.setEnabled(bl);
        this._colorName.setEnabled(bl);
    }

    public void addNotify() {
        super.addNotify();
        Font font = this._colorNameLabel.getFont();
        if (font != null && !font.isBold()) {
            int n = font.getStyle() | 1;
            font = new Font(font.getName(), n, font.getSize());
            this._colorNameLabel.setFont(font);
        }
        this._setText(this.getLocale());
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleColorPalettePane();
        }
        return this.accessibleContext;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._label != null) {
            this._setText(locale);
        }
    }

    private void _setText(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getDefaultableLocale(this));
        String string = resourceBundle.getString(_KEY_LABEL);
        this._label.setText(StringUtils.stripMnemonic(string));
        this._label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
        string = resourceBundle.getString(_KEY_EDIT);
        this._editButton.setText(StringUtils.stripMnemonic(string));
        this._editButton.setMnemonic(StringUtils.getMnemonicKeyCode(string));
        string = resourceBundle.getString(_KEY_CUSTOM_LABEL);
        this._customLabel.setText(StringUtils.stripMnemonic(string));
        this._customLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
        string = resourceBundle.getString(_KEY_COLOR_NAME);
        this._colorNameLabel.setText(StringUtils.stripMnemonic(string));
    }

    private void _updateEditButton() {
        boolean bl = this.isCustomColorSelected() && this.isEnabled();
        this._editButton.setEnabled(bl);
    }

    private void _updateColorName() {
        String string = null;
        boolean bl = this.isCustomColorSelected();
        TwoDModel twoDModel = bl ? this.getCustomColorNames() : this.getColorNames();
        ColorGrid colorGrid = bl ? this._customGrid : this._grid;
        int n = colorGrid.getSelectedColumn();
        int n2 = colorGrid.getSelectedRow();
        if (n != -1 && n2 != -1 && twoDModel != null && n < twoDModel.getColumnCount() && n2 < twoDModel.getRowCount()) {
            Object object = twoDModel.getData(n, n2);
            string = object instanceof String ? object.toString() : null;
        }
        this._colorName.setText(string);
    }

    private void _editColor() {
        if (this._chooserVisible) {
            return;
        }
        this._chooserVisible = true;
        ColorChooserPane colorChooserPane = this.getColorChooserPane();
        colorChooserPane.setLocale(LocaleUtils.getDefaultableLocale(this));
        String string = this.getColorName();
        Color color = this.getSelectedColor();
        if (color == null) {
            color = Color.gray;
        }
        colorChooserPane.setOriginalColor(color);
        colorChooserPane.setColor(color);
        colorChooserPane.setColorNameVisible(this.isColorNameVisible());
        colorChooserPane.setColorName(string);
        if (ColorChooserPane.showDialog(this, colorChooserPane) == 1) {
            String string2;
            Color color2 = this._customGrid.getSelectedColor();
            Color color3 = colorChooserPane.getColor();
            this._customGrid.replaceSelectedColor(color3);
            this.firePropertyChange(PROPERTY_COLOR_PALETTE, null, this.getColorPalette());
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, color2, color3);
            if (this.isColorNameVisible() && string != (string2 = colorChooserPane.getColorName())) {
                this.setColorName(string2);
            }
        }
        this._chooserVisible = false;
    }

    private void _selectedColorChanged(ColorGrid colorGrid, Color color, Color color2) {
        boolean bl;
        if (this._ignoreEvents) {
            return;
        }
        this._updateEditButton();
        this._updateColorName();
        boolean bl2 = bl = colorGrid.getSelectedColumn() != -1 && colorGrid.getSelectedRow() != -1;
        if (bl) {
            this._ignoreEvents = true;
            if (colorGrid == this._grid) {
                this._customGrid.setDrawFocus(false);
                this._customGrid.setSelectedColor(null);
                this._grid.setDrawFocus(true);
            } else {
                this._grid.setDrawFocus(false);
                this._grid.setSelectedColor(null);
                this._customGrid.setDrawFocus(true);
            }
            this._ignoreEvents = false;
            this.repaint();
        }
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, color, color2);
    }

    private void _revalidate() {
        this.invalidate();
        this.repaint();
    }

    private Component _getInitialFocus() {
        return this.isCustomColorSelected() ? this._customGrid : this._grid;
    }

    private class Listener
    extends TwoDModelAdapter
    implements ActionListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (ColorPalettePane.PROPERTY_SELECTED_COLOR.equals(string)) {
                ColorPalettePane.this._selectedColorChanged((ColorGrid)propertyChangeEvent.getSource(), (Color)propertyChangeEvent.getOldValue(), (Color)propertyChangeEvent.getNewValue());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ColorPalettePane._KEY_EDIT.equals(string)) {
                ColorPalettePane.this._editColor();
            }
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            ColorPalettePane.this._updateColorName();
        }
    }

    private class AccessGrid
    extends ColorGrid {
        private boolean _custom;

        public AccessGrid(boolean bl) {
            this._custom = bl;
        }

        protected String getAccessibleName(int n, int n2, Color color) {
            String string = null;
            if (this._custom) {
                TwoDModel twoDModel = ColorPalettePane.this.getCustomColorNames();
                if (twoDModel != null) {
                    Object object = twoDModel.getData(n, n2);
                    string = object != null ? object.toString() : null;
                }
            } else {
                TwoDModel twoDModel = ColorPalettePane.this.getColorNames();
                if (twoDModel != null) {
                    Object object = twoDModel.getData(n, n2);
                    String string2 = string = object != null ? object.toString() : null;
                }
            }
            if (string == null) {
                string = super.getAccessibleName(n, n2, color);
            }
            return string;
        }
    }

    private class AccessibleColorPalettePane
    extends JComponent.AccessibleJComponent {
        private AccessibleColorPalettePane() {
            super(ColorPalettePane.this);
        }
    }
}

