/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.AbstractAppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class ColorGrid
extends Grid {
    public static final int PALETTE_DEFAULT = 0;
    public static final int PALETTE_CSS_16 = 1;
    public static final int PALETTE_49_COLOR = 2;
    public static final int PALETTE_80_COLOR = 3;
    public static final int PALETTE_OLAF_96 = 4;
    public static final int PALETTE_WEBSAFE_216 = 5;
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    private int _armedColumn;
    private int _armedRow;
    private int _selectedColumn;
    private int _selectedRow;
    private boolean _inDropDown;
    private boolean _drawFocus = true;
    private static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _ACCESSIBLE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _KEY_TOOLTIP = "COLORPALETTE.TOOLTIP";
    private static final String _KEY_NO_COLOR = "COLORPALETTE.NO_COLOR";
    private static final ImmInsets _SMALL_INSETS = new ImmInsets(1, 1, 1, 1);
    private static final ImmInsets _LARGE_INSETS = new ImmInsets(2, 2, 2, 2);
    private static final int _COLUMN_WIDTH = 16;
    private static final int _ROW_HEIGHT = 16;
    private static Color[][] _sCSSPalette;
    private static Color[][] _s49Palette;
    private static Color[][] _s80Palette;
    private static Color[][] _s96Palette;
    private static Color[][] _s216Palette;
    private static final Color[][] _sDefaultColors;
    private static final String[] _cssHEX;
    private static final String[] _49HEX;
    private static final String[] _80HEX;
    private static final String[] _96HEX;
    private static final String[] _216HEX;

    public ColorGrid() {
        this(null, null);
    }

    public ColorGrid(TwoDModel twoDModel, Color color) {
        Listener listener = new Listener();
        this.setDefaultInputHandler(listener);
        this.addPropertyChangeListener(listener);
        this.setDefaultRowHeight(16);
        this.setDefaultColumnWidth(16);
        this.setDefaultPainter(NullPainter.getPainter());
        this.setAppearanceManager(new ColorAppearanceManager());
        this.setHorizontalSeparatorsVisible(false);
        this.setVerticalSeparatorsVisible(false);
        this.setGridSelectionManager(null);
        this.setDrawFocusCellHighlite(false);
        this.setGridKeyHandler(new Navigate());
        this.setOverlayBorderVisible(false);
        this.setBorder(null);
        this._selectedRow = -1;
        this._selectedColumn = -1;
        this._armedRow = -1;
        this._armedColumn = -1;
        this.setColorPalette(twoDModel);
        this.setSelectedColor(color);
        this.setBackground(this.getUIDefaults().getColor(LookAndFeel.CONTROL));
        this.setToolTipManager(new Tooltip());
    }

    public void setColorPalette(TwoDModel twoDModel) {
        if (twoDModel == null) {
            twoDModel = ColorGrid.getDefaultColorPalette();
        }
        if (this.getModel() != twoDModel) {
            this.setModel(twoDModel);
            this.setPreferredRowsOnScreen(this.getRowCount());
            this.setPreferredColumnsOnScreen(this.getColumnCount());
            this.revalidate();
            this.repaint();
        }
    }

    public TwoDModel getColorPalette() {
        return this.getModel();
    }

    public void setSelectedColor(Color color) {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        if (color == null) {
            bl = true;
        } else {
            int n3 = 0;
            while (n3 < this.getColumnCount()) {
                int n4 = 0;
                while (n4 < this.getRowCount()) {
                    if (color.equals(this._getColor(n3, n4))) {
                        n = n3;
                        n2 = n4;
                        bl = true;
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Color not found " + color);
        }
        this._setSelectedColor(n, n2);
    }

    public Color getSelectedColor() {
        if (this._selectedColumn == -1 || this._selectedRow == -1) {
            return null;
        }
        return this._getColor(this._selectedColumn, this._selectedRow);
    }

    public static TwoDModel getDefaultColorPalette() {
        return new ArrayTwoDModel(_sDefaultColors);
    }

    public static TwoDModel getColorPalette(int n) {
        Object[][] objectArray;
        switch (n) {
            case 0: {
                objectArray = _sDefaultColors;
                break;
            }
            case 1: {
                objectArray = ColorGrid._getCSS();
                break;
            }
            case 2: {
                objectArray = ColorGrid._get49();
                break;
            }
            case 3: {
                objectArray = ColorGrid._get80();
                break;
            }
            case 4: {
                objectArray = ColorGrid._get96();
                break;
            }
            case 5: {
                objectArray = ColorGrid._get216();
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not valid");
            }
        }
        return new ArrayTwoDModel(objectArray);
    }

    public static Color getClosestColor(TwoDModel twoDModel, Color color) {
        int n = twoDModel.getColumnCount();
        int n2 = twoDModel.getRowCount();
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        Color color2 = null;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        while (n7 < n) {
            int n8 = 0;
            while (n8 < n2) {
                Color color3 = (Color)twoDModel.getData(n7, n8);
                if (color3 != null) {
                    int n9;
                    int n10;
                    int n11 = n3 - color3.getRed();
                    int n12 = n11 * n11 + (n10 = n4 - color3.getGreen()) * n10 + (n9 = n5 - color3.getBlue()) * n9;
                    if (n12 == 0) {
                        return color3;
                    }
                    if (n12 < n6) {
                        n6 = n12;
                        color2 = color3;
                    }
                }
                ++n8;
            }
            ++n7;
        }
        return color2;
    }

    public Color getClosestColor(Color color) {
        return ColorGrid.getClosestColor(this.getColorPalette(), color);
    }

    void setDrawFocus(boolean bl) {
        this._drawFocus = bl;
        this.repaint();
    }

    public void paintCanvasInterior(Graphics graphics) {
        super.paintCanvasInterior(graphics);
        if (this._drawFocus && this._selectedColumn != -1 && this._selectedRow != -1 && (this._selectedColumn != this._armedColumn || this._selectedRow != this._armedRow)) {
            Rectangle rectangle = graphics.getClipBounds();
            Rectangle rectangle2 = this._getCellRect(this._selectedColumn, this._selectedRow);
            rectangle2.x -= 2;
            rectangle2.y -= 2;
            rectangle2.width += 4;
            rectangle2.height += 4;
            if (rectangle.intersects(rectangle2)) {
                Color color = this._getColor(this._selectedColumn, this._selectedRow);
                PaintContext paintContext = this.getPaintContext();
                UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
                Color color2 = uIDefaults.getColor(LookAndFeel.DARK_INTENSITY);
                graphics.setColor(color);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(Color.white);
                graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x, rectangle2.y + rectangle2.height - 2);
                graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width - 2, rectangle2.y);
                graphics.setColor(color2);
                graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height - 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
                graphics.drawLine(rectangle2.x + rectangle2.width - 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setOverlayBorderVisible(false);
        this.setBorder(null);
        this.setBackground(this.getUIDefaults().getColor(LookAndFeel.CONTROL));
    }

    protected String getAccessibleName(int n, int n2, Color color) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_ACCESSIBLE_BUNDLE, LocaleUtils.getDefaultableLocale(this));
        if (color == null) {
            return resourceBundle.getString(_KEY_NO_COLOR);
        }
        String string = resourceBundle.getString(_KEY_TOOLTIP);
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{IntegerUtils.getInteger(color.getRed()), IntegerUtils.getInteger(color.getGreen()), IntegerUtils.getInteger(color.getBlue())};
        return messageFormat.format(objectArray);
    }

    protected Grid.AccessibleGrid createAccessibleGrid() {
        return new Access();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        Cell cell = this.getFocusCell();
        if (focusEvent.getID() == 1004 && cell != null && !this._inDropDown) {
            this._setSelectedColor(cell.column, cell.row);
        }
    }

    void replaceSelectedColor(Color color) {
        if (this._selectedColumn != -1 && this._selectedRow != -1) {
            this.getModel().setData(this._selectedColumn, this._selectedRow, color);
            this.paintCell(this._selectedColumn, this._selectedRow, true);
        }
    }

    void paintCell(int n, int n2, boolean bl) {
        if (bl || this._armedColumn == n && this._armedRow == n2) {
            Rectangle rectangle = this._getCellRect(n, n2);
            rectangle.x -= 2;
            rectangle.y -= 2;
            rectangle.width += 4;
            rectangle.height += 4;
            --rectangle.x;
            --rectangle.y;
            ++rectangle.width;
            ++rectangle.height;
            this.paintImmediateCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            super.paintCell(n, n2);
        }
    }

    void setArmedCell(int n, int n2) {
        int n3 = this._armedColumn;
        int n4 = this._armedRow;
        this._armedColumn = n;
        this._armedRow = n2;
        boolean bl = n3 == this._selectedColumn && n4 == this._selectedRow;
        this.paintCell(n3, n4, bl);
        this.paintCell(this._armedColumn, this._armedRow, false);
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext != null) {
            Grid.AccessibleGrid accessibleGrid = (Grid.AccessibleGrid)accessibleContext;
            int n5 = accessibleGrid.getAccessibleIndexAt(n3, n4);
            int n6 = accessibleGrid.getAccessibleIndexAt(this._armedColumn, this._armedRow);
            accessibleGrid.firePropertyChange("AccessibleActiveDescendant", n5 == -1 ? null : accessibleContext.getAccessibleChild(n5), n6 == -1 ? null : accessibleContext.getAccessibleChild(n6));
        }
    }

    int getArmedColumn() {
        return this._armedColumn;
    }

    int getArmedRow() {
        return this._armedRow;
    }

    int getSelectedColumn() {
        return this._selectedColumn;
    }

    int getSelectedRow() {
        return this._selectedRow;
    }

    void setInDropDown(boolean bl) {
        this._inDropDown = bl;
    }

    String __colorToString(Color color) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale(this));
        if (color == null) {
            return resourceBundle.getString(_KEY_NO_COLOR);
        }
        String string = resourceBundle.getString(_KEY_TOOLTIP);
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{IntegerUtils.getInteger(color.getRed()), IntegerUtils.getInteger(color.getGreen()), IntegerUtils.getInteger(color.getBlue())};
        return messageFormat.format(objectArray);
    }

    private Rectangle _getCellRect(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = this.getColumnPosition(n);
        rectangle.y = this.getRowPosition(n2);
        rectangle.width = this.getColumnWidth(n);
        rectangle.height = this.getRowHeight(n2);
        return rectangle;
    }

    private Color _getColor(int n, int n2) {
        return (Color)this.getModel().getData(n, n2);
    }

    private void _setSelectedColor(int n, int n2) {
        Color color;
        Color color2 = this._selectedColumn != -1 && this._selectedRow != -1 ? this._getColor(this._selectedColumn, this._selectedRow) : null;
        this._selectedColumn = n;
        this._selectedRow = n2;
        boolean bl = this._selectedColumn != -1 && this._selectedRow != -1;
        Color color3 = color = bl ? this._getColor(this._selectedColumn, this._selectedRow) : null;
        if (bl) {
            this.setArmedCell(-1, -1);
        }
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, color2, color);
        if (this.getFocusCell() == null && bl) {
            this.setFocusCell(new Cell(this._selectedColumn, this._selectedRow));
        }
    }

    private static Color[][] _createPalette(int n, int n2, String[] stringArray) {
        Color[][] colorArray = new Color[n2][n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                String string = stringArray[n3];
                colorArray[n4][n5] = ColorUtils.htmlToColor(string);
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return colorArray;
    }

    private static Color[][] _getCSS() {
        if (_sCSSPalette == null) {
            _sCSSPalette = ColorGrid._createPalette(4, 4, _cssHEX);
        }
        return _sCSSPalette;
    }

    private static Color[][] _get49() {
        if (_s49Palette == null) {
            _s49Palette = ColorGrid._createPalette(7, 7, _49HEX);
        }
        return _s49Palette;
    }

    private static Color[][] _get80() {
        if (_s80Palette == null) {
            _s80Palette = ColorGrid._createPalette(10, 8, _80HEX);
        }
        return _s80Palette;
    }

    private static Color[][] _get96() {
        if (_s96Palette == null) {
            _s96Palette = ColorGrid._createPalette(16, 6, _96HEX);
        }
        return _s96Palette;
    }

    private static Color[][] _get216() {
        if (_s216Palette == null) {
            _s216Palette = ColorGrid._createPalette(16, 14, _216HEX);
        }
        return _s216Palette;
    }

    static {
        _sDefaultColors = new Color[][]{{new Color(153, 0, 51), new Color(255, 51, 102), new Color(204, 0, 51), new Color(255, 0, 51), new Color(255, 0, 51), new Color(255, 153, 153), new Color(204, 51, 102), new Color(255, 204, 255), new Color(204, 51, 153), new Color(153, 51, 102), new Color(153, 51, 102), new Color(102, 0, 51), new Color(204, 51, 153), new Color(255, 153, 204), new Color(255, 102, 204), new Color(255, 153, 255)}, {new Color(255, 102, 153), new Color(204, 0, 102), new Color(255, 0, 102), new Color(255, 51, 153), new Color(255, 0, 153), new Color(255, 51, 204), new Color(255, 0, 204), new Color(255, 102, 255), new Color(255, 51, 255), new Color(255, 0, 255), new Color(204, 0, 153), new Color(153, 0, 102), new Color(204, 102, 204), new Color(204, 51, 204), new Color(204, 153, 255), new Color(204, 102, 255)}, {new Color(204, 51, 255), new Color(153, 51, 153), new Color(204, 0, 204), new Color(204, 0, 255), new Color(153, 0, 204), new Color(153, 0, 153), new Color(204, 153, 204), new Color(153, 102, 153), new Color(102, 51, 102), new Color(102, 0, 153), new Color(153, 51, 204), new Color(102, 0, 102), new Color(153, 0, 255), new Color(153, 51, 255), new Color(153, 102, 204), new Color(51, 0, 51)}, {new Color(102, 51, 153), new Color(102, 150, 204), new Color(102, 0, 204), new Color(153, 102, 255), new Color(51, 0, 102), new Color(102, 0, 255), new Color(102, 51, 255), new Color(204, 204, 255), new Color(153, 153, 255), new Color(153, 153, 204), new Color(102, 102, 204), new Color(102, 102, 255), new Color(102, 102, 153), new Color(51, 51, 102), new Color(51, 51, 153), new Color(51, 0, 153)}, {new Color(51, 0, 204), new Color(51, 0, 255), new Color(51, 51, 255), new Color(51, 51, 204), new Color(0, 102, 255), new Color(0, 102, 255), new Color(51, 102, 255), new Color(51, 102, 204), new Color(0, 0, 102), new Color(0, 0, 51), new Color(0, 0, 255), new Color(0, 0, 153), new Color(0, 51, 204), new Color(0, 0, 204), new Color(51, 102, 153), new Color(0, 102, 204)}, {new Color(153, 204, 255), new Color(102, 153, 255), new Color(0, 51, 102), new Color(102, 153, 204), new Color(0, 102, 153), new Color(51, 153, 204), new Color(0, 153, 204), new Color(102, 204, 255), new Color(51, 153, 255), new Color(0, 51, 153), new Color(0, 153, 255), new Color(51, 204, 255), new Color(0, 204, 255), new Color(153, 255, 255), new Color(102, 255, 255), new Color(51, 255, 255)}, {new Color(0, 255, 255), new Color(0, 204, 204), new Color(0, 153, 153), new Color(102, 153, 153), new Color(153, 204, 204), new Color(204, 255, 255), new Color(51, 204, 204), new Color(102, 204, 204), new Color(51, 153, 153), new Color(51, 102, 102), new Color(0, 102, 102), new Color(0, 51, 51), new Color(0, 255, 204), new Color(51, 255, 204), new Color(51, 204, 153), new Color(0, 204, 153)}, {new Color(102, 255, 204), new Color(153, 255, 204), new Color(0, 255, 153), new Color(51, 153, 102), new Color(0, 102, 51), new Color(51, 102, 51), new Color(102, 153, 102), new Color(102, 204, 102), new Color(153, 204, 153), new Color(102, 255, 102), new Color(51, 153, 51), new Color(153, 204, 153), new Color(102, 255, 153), new Color(51, 255, 153), new Color(51, 204, 102), new Color(0, 204, 102)}, {new Color(102, 204, 153), new Color(0, 153, 102), new Color(0, 153, 51), new Color(153, 204, 153), new Color(0, 204, 102), new Color(204, 255, 204), new Color(204, 255, 153), new Color(153, 255, 102), new Color(153, 255, 51), new Color(0, 255, 51), new Color(51, 255, 51), new Color(0, 204, 51), new Color(51, 204, 51), new Color(102, 204, 51), new Color(0, 255, 0), new Color(102, 204, 51)}, {new Color(0, 102, 0), new Color(0, 51, 0), new Color(0, 153, 0), new Color(51, 255, 0), new Color(102, 255, 0), new Color(153, 255, 0), new Color(102, 204, 0), new Color(0, 204, 0), new Color(51, 204, 0), new Color(51, 153, 0), new Color(153, 204, 102), new Color(102, 153, 51), new Color(153, 204, 51), new Color(51, 102, 0), new Color(102, 153, 0), new Color(153, 204, 0)}, {new Color(204, 255, 102), new Color(204, 255, 51), new Color(204, 255, 0), new Color(153, 153, 0), new Color(204, 204, 0), new Color(204, 204, 51), new Color(51, 51, 0), new Color(102, 102, 0), new Color(153, 153, 51), new Color(204, 204, 102), new Color(102, 102, 51), new Color(153, 153, 102), new Color(204, 204, 153), new Color(255, 255, 204), new Color(255, 255, 153), new Color(255, 255, 102)}, {new Color(255, 255, 51), new Color(255, 255, 0), new Color(255, 204, 0), new Color(255, 204, 102), new Color(255, 204, 51), new Color(204, 153, 51), new Color(153, 102, 0), new Color(204, 153, 0), new Color(255, 153, 0), new Color(204, 102, 0), new Color(153, 51, 0), new Color(204, 102, 51), new Color(102, 51, 0), new Color(255, 153, 102), new Color(255, 102, 51), new Color(255, 153, 51)}, {new Color(255, 102, 0), new Color(204, 51, 0), new Color(153, 102, 51), new Color(51, 0, 0), new Color(102, 51, 51), new Color(153, 102, 102), new Color(204, 153, 153), new Color(153, 51, 51), new Color(204, 102, 102), new Color(255, 204, 204), new Color(204, 51, 51), new Color(204, 51, 51), new Color(255, 102, 102), new Color(102, 0, 0), new Color(153, 0, 0), new Color(204, 0, 0)}, {new Color(255, 0, 0), new Color(255, 51, 0), new Color(204, 153, 102), new Color(255, 204, 153), new Color(255, 255, 255), new Color(204, 204, 204), new Color(153, 153, 153), new Color(102, 102, 102), new Color(51, 51, 51), new Color(0, 0, 0), new Color(-526361), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255)}};
        _cssHEX = new String[]{"#FFFFFF", "#FF00FF", "#00FFFF", "#FFFF00", "#CCCCCC", "#990099", "#009999", "#00FF00", "#999999", "#FF0000", "#0000FF", "#999900", "#000000", "#990000", "#000099", "#009900"};
        _49HEX = new String[]{"#FFFFFF", "#FFCCCC", "#FFCC99", "#FFFFCC", "#99FF99", "#CCFFFF", "#FFCCFF", "#F7F7E7", "#FF6666", "#FFCC33", "#FFFF99", "#66FF99", "#66FFFF", "#FF99FF", "#CCCCCC", "#FF0000", "#FF9900", "#FFFF00", "#33FF33", "#33CCFF", "#CC66CC", "#999999", "#CC0000", "#FF6600", "#FFCC00", "#00CC00", "#3366FF", "#CC33CC", "#666666", "#990000", "#CC6600", "#999900", "#009900", "#3333FF", "#993366", "#333333", "#660000", "#993300", "#666600", "#006600", "#000099", "#663366", "#000000", "#330000", "#663300", "#333300", "#003300", "#000066", "#330033"};
        _80HEX = new String[]{"#FFFFFF", "#FFCCCC", "#FFCC99", "#FFFFCC", "#CCFFCC", "#99FFCC", "#CCFFFF", "#99CCFF", "#CCCCFF", "#FFCCFF", "#F7F7E7", "#FF9999", "#FF9966", "#FFFF99", "#99FF99", "#66FFCC", "#99FFFF", "#66CCFF", "#9999FF", "#FF99FF", "#CCCCCC", "#FF6666", "#FF6633", "#FFFF66", "#66FF66", "#66CCCC", "#66FFFF", "#3399FF", "#9966FF", "#FF66FF", "#666666", "#FF0000", "#FF6600", "#FFFF33", "#00FF00", "#00CCCC", "#00CCFF", "#3366FF", "#9933FF", "#FF33CC", "#666666", "#CC0000", "#FF3300", "#FFFF00", "#009900", "#009999", "#0099FF", "#0000CC", "#9900CC", "#FF0099", "#333333", "#990000", "#CC3300", "#FFCC00", "#006600", "#006666", "#0066FF", "#000099", "#663399", "#CC0099", "#333333", "#660000", "#993300", "#CC9900", "#003300", "#336666", "#0033FF", "#000066", "#660099", "#990066", "#000000", "#330000", "#663300", "#996633", "#003300", "#003333", "#003399", "#000066", "#330066", "#660066"};
        _96HEX = new String[]{"#FFFFFF", "#F7F7E7", "#FDD9C7", "#FFCCCC", "#FFC4D4", "#FFCDE6", "#FFCCFF", "#E5CBFF", "#CBCBFD", "#CCCCFF", "#CEE7FF", "#CCFFFF", "#CDFFE6", "#CCFFCC", "#E7FFCE", "#FFCCCC", "#CCCCCC", "#FFCC99", "#FF9966", "#FF9999", "#FE8AA8", "#FF99CC", "#FF99FF", "#CC99FF", "#A4A4FC", "#9999FF", "#99CCFF", "#99FFFF", "#99FFCC", "#99FF99", "#CCFF99", "#FFFF99", "#999999", "#FFCC33", "#FF6633", "#FF3333", "#FF3366", "#FF33CC", "#FF33FF", "#CC33FF", "#6633FF", "#3366FF", "#33CCFF", "#33FFFF", "#33FFCC", "#33FF33", "#CCFF33", "#FFFF33", "#666666", "#FF9900", "#FF6600", "#FF0000", "#FF0066", "#FF0099", "#FF00FF", "#9900FF", "#6600FF", "#0000FF", "#0099FF", "#00FFFF", "#00FF99", "#00FF00", "#99FF00", "#FFFF00", "#333333", "#CC6600", "#CC3300", "#CC0000", "#CC0033", "#CC0066", "#CC00CC", "#6600CC", "#3300CC", "#0033CC", "#0066CC", "#00CCCC", "#00CC66", "#00CC00", "#66CC00", "#CCCC00", "#000000", "#663300", "#660000", "#660000", "#400010", "#660033", "#660066", "#330066", "#000066", "#000066", "#003366", "#006666", "#006633", "#336600", "#336600", "#666600"};
        _216HEX = new String[]{"#FFFFFF", "#FFFFCC", "#FFFF99", "#FFFF66", "#FFFF33", "#FFFF00", "#FFCCFF", "#FFCCCC", "#FFCC99", "#FFCC66", "#FFCC33", "#FFCC00", "#FF99FF", "#FF99CC", "#FF9999", "#FF9966", "#FF9933", "#FF9900", "#FF66FF", "#FF66CC", "#FF6699", "#FF6666", "#FF6633", "#FF6600", "#FF33FF", "#FF33CC", "#FF3399", "#FF3366", "#FF3333", "#FF3300", "#FF00FF", "#FF00CC", "#FF0099", "#FF0066", "#FF0033", "#FF0000", "#CCFFFF", "#CCFFCC", "#CCFF99", "#CCFF66", "#CCFF33", "#CCFF00", "#CCCCFF", "#CCCCCC", "#CCCC99", "#CCCC66", "#CCCC33", "#CCCC00", "#CC99FF", "#CC99CC", "#CC9999", "#CC9966", "#CC9933", "#CC9900", "#CC66FF", "#CC66CC", "#CC6699", "#CC6666", "#CC6633", "#CC6600", "#CC33FF", "#CC33CC", "#CC3399", "#CC3366", "#CC3333", "#CC3300", "#CC00FF", "#CC00CC", "#CC0099", "#CC0066", "#CC0033", "#CC0000", "#99FFFF", "#99FFCC", "#99FF99", "#99FF66", "#99FF33", "#99FF00", "#99CCFF", "#99CCCC", "#99CC99", "#99CC66", "#99CC33", "#99CC00", "#9999FF", "#9999CC", "#999999", "#999966", "#999933", "#999900", "#9966FF", "#9966CC", "#996699", "#996666", "#996633", "#996600", "#9933FF", "#9933CC", "#993399", "#993366", "#993333", "#993300", "#9900FF", "#9900CC", "#990099", "#990066", "#990033", "#990000", "#66FFFF", "#66FFCC", "#66FF99", "#66FF66", "#66FF33", "#66FF00", "#66CCFF", "#66CCCC", "#66CC99", "#66CC66", "#66CC33", "#66CC00", "#6699FF", "#6699CC", "#669999", "#669966", "#669933", "#669900", "#6666FF", "#6666CC", "#666699", "#666666", "#666633", "#666600", "#6633FF", "#6633CC", "#663399", "#663366", "#663333", "#663300", "#6600FF", "#6600CC", "#660099", "#660066", "#660033", "#660000", "#33FFFF", "#33FFCC", "#33FF99", "#33FF66", "#33FF33", "#33FF00", "#33CCFF", "#33CCCC", "#33CC99", "#33CC66", "#33CC33", "#33CC00", "#3399FF", "#3399CC", "#339999", "#339966", "#339933", "#339900", "#3366FF", "#3366CC", "#336699", "#336666", "#336633", "#336600", "#3333FF", "#3333CC", "#333399", "#333366", "#333333", "#333300", "#3300FF", "#3300CC", "#330099", "#330066", "#330033", "#330000", "#00FFFF", "#00FFCC", "#00FF99", "#00FF66", "#00FF33", "#00FF00", "#00CCFF", "#00CCCC", "#00CC99", "#00CC66", "#00CC33", "#00CC00", "#0099FF", "#0099CC", "#009999", "#009966", "#009933", "#009900", "#0066FF", "#0066CC", "#006699", "#006666", "#006633", "#006600", "#0033FF", "#0033CC", "#003399", "#003366", "#003333", "#003300", "#0000FF", "#0000CC", "#000099", "#000066", "#000033", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000"};
    }

    private class Access
    extends Grid.AccessibleGrid {
        private Access() {
        }

        public String getAccessibleName(int n, int n2, Object object) {
            return ColorGrid.this.getAccessibleName(n, n2, (Color)object);
        }
    }

    private class Tooltip
    implements GridToolTipManager {
        private Tooltip() {
        }

        public String getCellToolTipValue(Grid grid, int n, int n2) {
            Color color = (Color)grid.getModel().getData(n, n2);
            return ColorGrid.this.__colorToString(color);
        }
    }

    private class Navigate
    extends StandardGridKeyHandler {
        private Navigate() {
        }

        public Cell enter(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
            return cell;
        }
    }

    private class ColorAppearanceManager
    extends AbstractAppearanceManager {
        private BorderPainter _armedBorderPainter;
        private BorderPainter _normalBorderPainter;
        private Appearance _appearance;

        private ColorAppearanceManager() {
        }

        public Appearance getCellPaintingAppearance(int n, int n2) {
            if (this._appearance == null) {
                this._appearance = new Appearance();
            }
            this._appearance.setBackground(ColorGrid.this._getColor(n, n2));
            if (n == ColorGrid.this._armedColumn && n2 == ColorGrid.this._armedRow) {
                this._appearance.setBorderPainter(this._getArmedBorderPainter());
            } else {
                this._appearance.setBorderPainter(this._getNormalBorderPainter());
            }
            return this._appearance;
        }

        private BorderPainter _getArmedBorderPainter() {
            if (this._armedBorderPainter == null) {
                this._armedBorderPainter = new ArmedBorderPainter();
            }
            return this._armedBorderPainter;
        }

        private BorderPainter _getNormalBorderPainter() {
            if (this._normalBorderPainter == null) {
                this._normalBorderPainter = new NormalBorderPainter();
            }
            return this._normalBorderPainter;
        }

        private class NormalBorderPainter
        extends AbstractBorderPainter {
            private NormalBorderPainter() {
            }

            protected boolean isBorderTransparent(PaintContext paintContext) {
                return true;
            }

            protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
                UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
                Color color = uIDefaults.getColor(LookAndFeel.DARK_INTENSITY);
                Color color2 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
                if (color == null) {
                    color = Color.black;
                }
                if (color2 == null) {
                    color2 = Color.lightGray;
                }
                int n5 = n + n3 - 1;
                int n6 = n2 + n4 - 1;
                graphics.setColor(Color.white);
                graphics.drawLine(n + 1, n2, n5 - 1, n2);
                graphics.drawLine(n, n2 + 1, n, n6 - 1);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.setColor(color);
                graphics.drawLine(n + 2, n6, n5 - 1, n6);
                graphics.drawLine(n5, n2 + 2, n5, n6 - 1);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n6, n + 1, n6 - 1);
                graphics.drawLine(n5, n2 + 1, n5 - 1, n2 + 1);
                graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
            }

            protected ImmInsets getOwnInsets(PaintContext paintContext) {
                return _LARGE_INSETS;
            }

            protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
                return _SMALL_INSETS;
            }
        }

        private class ArmedBorderPainter
        extends AbstractBorderPainter {
            private ArmedBorderPainter() {
            }

            protected boolean isBorderTransparent(PaintContext paintContext) {
                return true;
            }

            protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
                UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
                Color color = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
                graphics.setColor(ColorGrid.this.getBackground());
                int n5 = n + n3 - 1;
                int n6 = n2 + n4 - 1;
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
                graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 1);
                graphics.drawLine(n + 1, n6 - 1, n + 1, n6 - 1);
            }

            protected ImmInsets getOwnInsets(PaintContext paintContext) {
                return _LARGE_INSETS;
            }

            protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
                return _SMALL_INSETS;
            }
        }
    }

    private class Listener
    extends CellInputHandler
    implements PropertyChangeListener {
        private Listener() {
        }

        public void mouseEntered(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            ColorGrid.this.setArmedCell(n, n2);
        }

        public void mouseExited(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            ColorGrid.this.setArmedCell(-1, -1);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("focusCell".equals(string)) {
                Cell cell = ColorGrid.this.getFocusCell();
                if (cell == null) {
                    ColorGrid.this._setSelectedColor(-1, -1);
                } else {
                    ColorGrid.this._setSelectedColor(cell.column, cell.row);
                }
            }
        }
    }
}

