/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.util.ImmInsets;

class ColorComponent
extends BaseColorEditor {
    private static final Dimension _SIZE = new Dimension(30, 20);
    private static final String _KEY_LABEL = "COLORCHOOSER.SELECTED_COLOR";
    private static final String _KEY_LABEL2 = "COLORCHOOSER.ORIGINAL_COLOR";
    private JLabel _selectedLabel = new JLabel("");
    private ColorPanel _selectedColorPanel = new ColorPanel(false);
    private JLabel _originalColorLabel;
    private ColorPanel _originalColorPanel;
    private Color _originalColor;

    public ColorComponent() {
        this._selectedColorPanel.setBackground(Color.black);
        this._originalColorLabel = new JLabel("");
        this._originalColorPanel = new ColorPanel(true);
        this.setOriginalColor(null);
        this.setLayout(new BorderLayout(7, 0));
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add("North", this._originalColorLabel);
        jPanel.add("South", this._selectedLabel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", this._originalColorPanel);
        jPanel2.add("South", this._selectedColorPanel);
        jPanel2.setBorder(UIBorderFactory.getRaisedBevelBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("West", jPanel2);
        this.add("West", jPanel);
        this.add("Center", jPanel3);
    }

    public void setOriginalColor(Color color) {
        this._originalColor = color;
        this._originalColorPanel.setBackground(this._originalColor);
        boolean bl = this._originalColor != null;
        this._originalColorPanel.setVisible(bl);
        this._originalColorLabel.setVisible(bl);
    }

    public Color getOriginalColor() {
        return this._originalColor;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._selectedLabel.setEnabled(bl);
        this._selectedColorPanel.setEnabled(bl);
        this._originalColorLabel.setEnabled(bl);
        this._originalColorPanel.setEnabled(bl);
    }

    protected void colorChanged(Color color) {
        this._selectedColorPanel.setBackground(color);
    }

    protected void updateLabels(Locale locale) {
        String string = BaseColorEditor.__getTranslatedString(locale, _KEY_LABEL);
        this._selectedLabel.setText(string);
        string = BaseColorEditor.__getTranslatedString(locale, _KEY_LABEL2);
        this._originalColorLabel.setText(string);
    }

    private class ColorPanel
    extends LWComponent {
        private boolean _changeOnClick;

        public ColorPanel(boolean bl) {
            if (bl) {
                this.enableEvents(16L);
            }
            this._changeOnClick = true;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.isConsumed() || !this.isEnabled() || !this._changeOnClick || mouseEvent.getID() != 501) {
                return;
            }
            ColorComponent.this.storeColor(this.getBackground());
            ColorComponent.this.colorChanged(this.getBackground());
        }

        protected void paintComponent(Graphics graphics) {
            ImmInsets immInsets = this.getBorderInsets();
            graphics.setColor(this.getBackground());
            graphics.fillRect(immInsets.left, immInsets.top, this.getWidth() - (immInsets.left + immInsets.right), this.getHeight() - (immInsets.top + immInsets.bottom));
        }

        public Dimension getMinimumSize() {
            return _SIZE;
        }

        public Dimension getPreferredSize() {
            return _SIZE;
        }
    }
}

