/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.chooser.color.CMYComponent;
import oracle.bali.ewt.chooser.color.ColorComponent;
import oracle.bali.ewt.chooser.color.ColorEditor;
import oracle.bali.ewt.chooser.color.HSBComponent;
import oracle.bali.ewt.chooser.color.HSLComponent;
import oracle.bali.ewt.chooser.color.HTMLHexComponent;
import oracle.bali.ewt.chooser.color.ImageComponent;
import oracle.bali.ewt.chooser.color.RGBComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class ColorChooserPane
extends LWComponent
implements Accessible {
    public static final String PROPERTY_COLOR = "color";
    public static final String PROPERTY_COLOR_NAME = "colorName";
    public static final int COLOR_PICKER_RGB = 1;
    public static final int COLOR_PICKER_HSB = 2;
    public static final int COLOR_PICKER_HSL = 4;
    public static final int COLOR_PICKER_HTMLHEX = 8;
    public static final int COLOR_PICKER_CMYK = 16;
    public static final int COLOR_PICKER_CMY = 16;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_TITLE = "COLORCHOOSER.TITLE";
    private static final String _KEY_COLOR_NAME = "COLORCHOOSER.COLOR_NAME";
    private static final int _DEFAULT_PICKERS = 11;
    private Listener _listener = new Listener();
    private JPanel _colorEditorPanel;
    private ColorComponent _colorComponent;
    private ImageComponent _imageComponent = new ImageComponent();
    private HSBComponent _hsbComponent;
    private HSLComponent _hslComponent;
    private RGBComponent _rgbComponent;
    private HTMLHexComponent _htmlComponent;
    private CMYComponent _cmyComponent;
    private JTextField _colorName;
    private JLabel _colorNameLabel;
    private JPanel _colorNameComponent;
    private JPanel _customPanel;
    private ArrayList _customEditors;

    public static int showDialog(Component component, ColorChooserPane colorChooserPane) {
        return ColorChooserPane.showDialog(component, colorChooserPane, null, false);
    }

    public static int showDialog(Component component, ColorChooserPane colorChooserPane, String string, boolean bl) {
        Object object;
        if (colorChooserPane == null) {
            throw new IllegalArgumentException("ColorChooserPane must be non-null");
        }
        Locale locale = LocaleUtils.getDefaultableLocale(colorChooserPane);
        if (string == null) {
            object = ResourceBundle.getBundle(_RESOURCE, locale);
            string = ((ResourceBundle)object).getString(_KEY_TITLE);
        }
        object = JEWTDialog.createDialog(component, string, 7);
        ((Component)object).setLocale(locale);
        ((JEWTDialog)object).setContent(colorChooserPane);
        ((JEWTDialog)object).setCenterOver(component);
        ((Dialog)object).setResizable(bl);
        int n = ((JEWTDialog)object).runDialog() ? 1 : 2;
        ((JEWTDialog)object).dispose();
        return n;
    }

    public ColorChooserPane() {
        this(Color.black, 11);
    }

    public ColorChooserPane(Color color, int n) {
        this._imageComponent.addPropertyChangeListener(this._listener);
        this._colorComponent = new ColorComponent();
        this._colorComponent.addPropertyChangeListener(this._listener);
        this._colorName = new JTextField();
        this._colorNameLabel = new JLabel(" ");
        this._colorNameLabel.setLabelFor(this._colorName);
        this._colorNameComponent = new JPanel();
        this._colorNameComponent.setLayout(new BorderLayout(5, 5));
        this._colorNameComponent.add("West", this._colorNameLabel);
        this._colorNameComponent.add("Center", this._colorName);
        this._hsbComponent = new HSBComponent();
        this._hsbComponent.addPropertyChangeListener(this._listener);
        this._hslComponent = new HSLComponent();
        this._hslComponent.addPropertyChangeListener(this._listener);
        this._rgbComponent = new RGBComponent();
        this._rgbComponent.addPropertyChangeListener(this._listener);
        this._htmlComponent = new HTMLHexComponent();
        this._htmlComponent.addPropertyChangeListener(this._listener);
        this._cmyComponent = new CMYComponent();
        this._cmyComponent.addPropertyChangeListener(this._listener);
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add("West", this._imageComponent);
        this.add("West", jPanel);
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(10);
        this._colorEditorPanel = new JPanel(flowLayout);
        this._colorEditorPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this._colorEditorPanel.add(this._rgbComponent);
        this._colorEditorPanel.add(this._hsbComponent);
        this._colorEditorPanel.add(this._cmyComponent);
        this._colorEditorPanel.add(this._hslComponent);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add("Center", this._colorEditorPanel);
        jPanel2.add("North", this._htmlComponent);
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add("North", this._colorComponent);
        jPanel3.add("Center", jPanel2);
        jPanel3.add("South", this._colorNameComponent);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add("West", jPanel3);
        this.add("Center", jPanel4);
        this._customPanel = new JPanel(new FlowLayout());
        this.add("South", this._customPanel);
        this.setColorPickerMask(n);
        this.setColor(color);
    }

    public void setColor(Color color) {
        if (color == null) {
            color = Color.black;
        }
        this._updateEditors(null, color, this.getColor());
    }

    public Color getColor() {
        return this._imageComponent.getColor();
    }

    public void setOriginalColor(Color color) {
        this._colorComponent.setOriginalColor(color);
        this.revalidate();
    }

    public Color getOriginalColor() {
        return this._colorComponent.getOriginalColor();
    }

    public void setColorName(String string) {
        this._colorName.setText(string);
    }

    public String getColorName() {
        return this._colorName.getText();
    }

    public void setColorNameVisible(boolean bl) {
        this._colorNameComponent.setVisible(bl);
        this.revalidate();
        this.repaint();
    }

    public boolean isColorNameVisible() {
        return this._colorNameComponent.isVisible();
    }

    public void setColorPickerMask(int n) {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = (n & 8) != 0;
        boolean bl5 = (n & 0x10) != 0;
        Color color = this.getColor();
        this._rgbComponent.setVisible(bl);
        if (bl) {
            this._rgbComponent.setColor(color);
        }
        this._hsbComponent.setVisible(bl2);
        if (bl2) {
            this._hsbComponent.setColor(color);
        }
        this._hslComponent.setVisible(bl3);
        if (bl3) {
            this._hslComponent.setColor(color);
        }
        this._htmlComponent.setVisible(bl4);
        if (bl4) {
            this._htmlComponent.setColor(color);
        }
        this._cmyComponent.setVisible(bl5);
        if (bl5) {
            this._cmyComponent.setColor(color);
        }
        this._colorEditorPanel.setVisible(bl | bl2 | bl3 | bl5);
        this.revalidate();
        this.repaint();
    }

    public int getColorPickerMask() {
        int n = 0;
        if (this._rgbComponent.isVisible()) {
            n |= 1;
        }
        if (this._hsbComponent.isVisible()) {
            n |= 2;
        }
        if (this._hslComponent.isVisible()) {
            n |= 4;
        }
        if (this._htmlComponent.isVisible()) {
            n |= 8;
        }
        if (this._cmyComponent.isVisible()) {
            n |= 0x10;
        }
        return n;
    }

    public void addCustomColorEditor(ColorEditor colorEditor) {
        if (this._customEditors == null) {
            this._customEditors = new ArrayList(2);
        }
        if (this._customEditors.contains(colorEditor)) {
            return;
        }
        this._customEditors.add(colorEditor);
        this._customPanel.add(colorEditor.getComponent());
        colorEditor.setColor(this.getColor());
        colorEditor.addPropertyChangeListener(this._listener);
        this.revalidate();
    }

    public void removeCustomColorEditor(ColorEditor colorEditor) {
        if (this._customEditors == null) {
            return;
        }
        if (!this._customEditors.contains(colorEditor)) {
            return;
        }
        ((AbstractCollection)this._customEditors).remove(colorEditor);
        this._customPanel.remove(colorEditor.getComponent());
        colorEditor.removePropertyChangeListener(this._listener);
        this.revalidate();
    }

    public ColorEditor[] getCustomColorEditors() {
        return this._customEditors == null ? null : this._customEditors.toArray(new ColorEditor[0]);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._imageComponent.getComponent().setEnabled(bl);
        this._colorComponent.getComponent().setEnabled(bl);
        this._colorNameLabel.setEnabled(bl);
        this._colorName.setEnabled(bl);
        this._hsbComponent.getComponent().setEnabled(bl);
        this._hslComponent.getComponent().setEnabled(bl);
        this._rgbComponent.getComponent().setEnabled(bl);
        this._htmlComponent.getComponent().setEnabled(bl);
        this._cmyComponent.getComponent().setEnabled(bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
        }
        return this.accessibleContext;
    }

    public void addNotify() {
        super.addNotify();
        this._setText(this.getLocale());
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._colorNameLabel != null) {
            this._setText(locale);
        }
    }

    private void _updateEditors(ColorEditor colorEditor, Color color, Color color2) {
        ColorEditor[] colorEditorArray;
        if (colorEditor != this._imageComponent) {
            this._imageComponent.setColor(color);
        }
        if (colorEditor != this._colorComponent) {
            this._colorComponent.setColor(color);
        }
        if (colorEditor != this._hsbComponent && this._hsbComponent.getComponent().isVisible()) {
            this._hsbComponent.setColor(color);
        }
        if (colorEditor != this._hslComponent && this._hslComponent.getComponent().isVisible()) {
            this._hslComponent.setColor(color);
        }
        if (colorEditor != this._rgbComponent && this._rgbComponent.getComponent().isVisible()) {
            this._rgbComponent.setColor(color);
        }
        if (colorEditor != this._htmlComponent && this._htmlComponent.getComponent().isVisible()) {
            this._htmlComponent.setColor(color);
        }
        if (colorEditor != this._cmyComponent && this._cmyComponent.getComponent().isVisible()) {
            this._cmyComponent.setColor(color);
        }
        int n = (colorEditorArray = this.getCustomColorEditors()) == null ? 0 : colorEditorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColorEditor colorEditor2 = colorEditorArray[n2];
            if (colorEditor2 != colorEditor && colorEditor2.getComponent().isVisible()) {
                colorEditor2.setColor(color);
            }
            ++n2;
        }
        this.firePropertyChange(PROPERTY_COLOR, color2, color);
    }

    private String _getTranslatedString(Locale locale, String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        return resourceBundle.getString(string);
    }

    private void _fireNameChanged(String string) {
        this.firePropertyChange(PROPERTY_COLOR_NAME, "", string);
    }

    private void _setText(Locale locale) {
        String string = this._getTranslatedString(locale, _KEY_COLOR_NAME);
        this._colorNameLabel.setText(StringUtils.stripMnemonic(string));
        this._colorNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
    }

    private class Listener
    implements PropertyChangeListener,
    DocumentListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (ColorChooserPane.PROPERTY_COLOR.equals(string)) {
                ColorEditor colorEditor = (ColorEditor)propertyChangeEvent.getSource();
                ColorChooserPane.this._updateEditors(colorEditor, (Color)propertyChangeEvent.getNewValue(), (Color)propertyChangeEvent.getOldValue());
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ColorChooserPane.this._fireNameChanged(ColorChooserPane.this._colorName.getText());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ColorChooserPane.this._fireNameChanged(ColorChooserPane.this._colorName.getText());
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            ColorChooserPane.this._fireNameChanged(ColorChooserPane.this._colorName.getText());
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        private Access() {
            super(ColorChooserPane.this);
        }
    }
}

