/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultButtonModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPalettePane;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class ColorChoice
extends JButton {
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_COLOR_PALETTE = "customColorPalette";
    public static final String PROPERTY_AUTOMATIC_SELECTED = "automaticSelected";
    public static final String PROPERTY_DEFAULT_SELECTED = "defaultSelected";
    private static final String _RESOURCE_FILE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _ACCESS_RESOURCE_FILE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _KEY_NO_COLOR = "COLORCHOICE.NO_COLOR";
    private static final String _KEY_AUTOMATIC = "COLORCHOICE.AUTOMATIC";
    private static final String _KEY_DEFAULT = "COLORCHOICE.DEFAULT";
    private static final String _KEY_EDIT_COLOR = "COLORCHOICE.EDIT_COLOR";
    private static final String _KEY_DEFAULT_TOOLTIP = "COLORCHOICE.DEFAULT_TOOLTIP";
    private static final String _KEY_ACCESS_NAME = "COLORCHOICE.ACCESSIBLE_NAME";
    private static final String _KEY_FULL_ACCESS_NAME = "COLORCHOICE.FULL_ACCESSIBLE_NAME";
    private static final String _IMAGE_NO_COLOR = "images/trans.gif";
    private static final String _IMAGE_AUTO = "images/auto.gif";
    private static final String _ICON_DEFAULT = "images/default_icon.gif";
    private static final String _ICON_NO_COLOR = "images/trans_icon.gif";
    private static final String _ICON_AUTO = "images/auto_icon.gif";
    private static Image _sDefaultIcon;
    private static final Color _DEFAULT_COLOR_TO_CHANGE;
    private static Color _sCOLOR;
    private static Image _sColorImage;
    private static Icon _sTransparentImage;
    private static Icon _sDisabledTransparentImage;
    private static Icon _sAutomaticImage;
    private static Icon _sDisabledAutomaticImage;
    private static final long _VISIBLE_MILLIS = 400L;
    private static final int _BOTTOM = 0;
    private static final int _TOP = 1;
    private static final int _RIGHT = 2;
    private static final int _LEFT = 3;
    private Listener _listener;
    private Image _image;
    private Color _colorToChange;
    private Filter _filter;
    private ColorGrid _grid;
    private ColorGrid _customGrid;
    private GridListener _gridListener;
    private long _popMillis;
    private boolean _dragging;
    private ColorGrid _dragGrid;
    private boolean _ignore;
    private ColorPopup _popup;
    private boolean _transparentAllowed;
    private JToggleButton _transparent;
    private boolean _automaticAllowed;
    private JToggleButton _automatic;
    private boolean _isAutomatic;
    private boolean _editAllowed;
    private JButton _editButton;
    private boolean _defaultAllowed;
    private boolean _isDefaultSelected;
    private boolean _defaultImageDirty;
    private Color _defaultColor;
    private JToggleButton _defaultButton;
    private ColorPalettePane _colorPalettePane;
    private Color _selectedColor;
    private boolean _isCustomColor;
    private FocusManager _focusManager;
    private Navigator _navigator;
    private static ColorChoice _poppedColorChoice;
    static /* synthetic */ Class class$oracle$bali$ewt$chooser$color$ColorChoice;

    public ColorChoice() {
        this._init(null, null, null, null);
    }

    public ColorChoice(String string) {
        this._init(string, null, null, null);
    }

    public ColorChoice(Icon icon) {
        this._init(null, icon, null, null);
    }

    public ColorChoice(String string, TwoDModel twoDModel, Color color) {
        this._init(string, null, twoDModel, color);
    }

    public ColorChoice(Icon icon, TwoDModel twoDModel, Color color) {
        this._init(null, icon, twoDModel, color);
    }

    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this._clearImage();
    }

    public void setDisabledIcon(Icon icon) {
        super.setDisabledIcon(icon);
        this._clearImage();
    }

    public void setImage(Image image, Color color) {
        if (this._image != image) {
            if (image == null) {
                image = ColorChoice._getColorImage();
                color = _sCOLOR;
            }
            this._image = image;
            this._colorToChange = color;
            this._filter = new Filter(color);
            this._filter.setColor(this.getSelectedColor());
            this._setIcons(this._image, this._filter);
        }
    }

    public Image getImage() {
        return this._image;
    }

    public Color getColorToChange() {
        return this._colorToChange;
    }

    public void setColorPalette(TwoDModel twoDModel) {
        this._getGrid().setColorPalette(twoDModel);
    }

    public TwoDModel getColorPalette() {
        return this._getGrid().getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel twoDModel) {
        if (twoDModel == null) {
            twoDModel = new ArrayTwoDModel(0, 0);
        }
        this._getCustomGrid().setColorPalette(twoDModel);
    }

    public TwoDModel getCustomColorPalette() {
        return this._getCustomGrid().getColorPalette();
    }

    public boolean isTransparentAllowed() {
        return this._transparentAllowed;
    }

    public void setTransparentAllowed(boolean bl) {
        if (this._transparentAllowed != bl) {
            this._transparentAllowed = bl;
            this.updateImage();
        }
    }

    public boolean isEditAllowed() {
        return this._editAllowed;
    }

    public void setEditAllowed(boolean bl) {
        if (this._editAllowed != bl) {
            this._editAllowed = bl;
        }
    }

    public boolean isAutomaticAllowed() {
        return this._automaticAllowed;
    }

    public void setAutomaticAllowed(boolean bl) {
        if (this._automaticAllowed != bl) {
            this._automaticAllowed = bl;
        }
    }

    public boolean isAutomaticSelected() {
        return this._isAutomatic;
    }

    public void setAutomaticSelected(boolean bl) {
        if (this._isAutomatic != bl) {
            boolean bl2 = this._isAutomatic;
            this._isAutomatic = bl;
            if (bl) {
                this.setSelectedColor(null);
            }
            this.updateImage();
            this.firePropertyChange(PROPERTY_AUTOMATIC_SELECTED, bl2, this._isAutomatic);
        }
    }

    public boolean isDefaultAllowed() {
        return this._defaultAllowed;
    }

    public void setDefaultAllowed(boolean bl) {
        if (this._defaultAllowed != bl) {
            this._defaultAllowed = bl;
            this._defaultImageDirty = true;
        }
    }

    public void setDefaultColor(Color color) {
        if (this._defaultColor != color) {
            this._defaultColor = color;
            this._defaultImageDirty = true;
        }
    }

    public Color getDefaultColor() {
        TwoDModel twoDModel;
        if (this._defaultColor == null && (twoDModel = this.getColorPalette()).getColumnCount() > 0 && twoDModel.getRowCount() > 0) {
            this._defaultColor = (Color)this.getColorPalette().getData(0, 0);
        }
        return this._defaultColor;
    }

    public boolean isDefaultSelected() {
        return this._isDefaultSelected;
    }

    public void setDefaultSelected(boolean bl) {
        if (this._isDefaultSelected != bl) {
            Color color = this.getSelectedColor();
            Color color2 = bl ? this.getDefaultColor() : this._selectedColor;
            this._setSelectedColor(color, color2, false, bl);
        }
    }

    public void setSelectedColor(Color color) {
        this.setSelectedColor(color, false);
    }

    public Color getSelectedColor() {
        if (this.isDefaultSelected()) {
            return this.getDefaultColor();
        }
        return this._selectedColor;
    }

    public boolean isCustomColorSelected() {
        return this._isCustomColor;
    }

    public void setSelectedColor(Color color, boolean bl) {
        if (bl) {
            this._getCustomGrid().setSelectedColor(color);
        } else {
            this._getGrid().setSelectedColor(color);
        }
        Color color2 = this._selectedColor;
        this._isCustomColor = bl;
        this._selectedColor = color;
        this._setSelectedColor(color2, color, bl, false);
    }

    public Color getClosestColor(Color color) {
        return this.getClosestColor(color, false);
    }

    public Color getClosestColor(Color color, boolean bl) {
        if (bl) {
            return this._getCustomGrid().getClosestColor(color);
        }
        return this._getGrid().getClosestColor(color);
    }

    public ColorPalettePane getColorPalettePane() {
        if (this._colorPalettePane == null) {
            this._colorPalettePane = new ColorPalettePane();
            this._initPane(this._colorPalettePane);
        }
        return this._colorPalettePane;
    }

    public static boolean isColorInPalette(TwoDModel twoDModel, Color color) {
        if (twoDModel == null) {
            return false;
        }
        if (color == null) {
            return true;
        }
        int n = 0;
        while (n < twoDModel.getColumnCount()) {
            int n2 = 0;
            while (n2 < twoDModel.getRowCount()) {
                if (color.equals(twoDModel.getData(n, n2))) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._updateStrings(locale);
    }

    public void addNotify() {
        super.addNotify();
        this._updateStrings(LocaleUtils.getDefaultableLocale(this));
    }

    public void removeNotify() {
        this._setDropDownVisible(false);
        super.removeNotify();
    }

    public void updateUI() {
        super.updateUI();
        this._getGrid().updateUI();
        if (this._popup != null) {
            this._popup.updateUI();
        }
        if (this._transparent != null) {
            this._transparent.updateUI();
        }
        if (this._automatic != null) {
            this._automatic.updateUI();
        }
        if (this._defaultButton != null) {
            this._defaultButton.updateUI();
        }
        if (this._editButton != null) {
            this._editButton.updateUI();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
        }
        return this.accessibleContext;
    }

    void processMouseDrag(MouseEvent mouseEvent) {
        if (!this._isDropDownVisible()) {
            return;
        }
        if (this._handleDragInGrid(mouseEvent, this._getGrid())) {
            return;
        }
        if (this._handleDragInGrid(mouseEvent, this._getCustomGrid())) {
            return;
        }
    }

    void processMouseReleased(MouseEvent mouseEvent) {
        long l = System.currentTimeMillis();
        if (l - this._popMillis < 400L) {
            mouseEvent.consume();
            return;
        }
        if (this._dragging) {
            Point point = this.getLocationOnScreen();
            Point point2 = this._dragGrid.getLocationOnScreen();
            int n = point.x - point2.x;
            int n2 = point.y - point2.y;
            mouseEvent.translatePoint(n, n2);
            this._gridListener.handleMouseReleased(mouseEvent, this._dragGrid);
            mouseEvent.consume();
        }
        this._dragging = false;
        this._dragGrid = null;
    }

    void internalKeyPressed(KeyEvent keyEvent) {
        ColorGrid colorGrid;
        if (!this.isEnabled()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        boolean bl = this._getGrid().hasFocus() || this.hasFocus();
        boolean bl2 = this._getCustomGrid().hasFocus();
        ColorGrid colorGrid2 = bl ? this._getGrid() : (colorGrid = bl2 ? this._getCustomGrid() : null);
        TwoDModel twoDModel = bl ? this.getColorPalette() : (bl2 ? this.getCustomColorPalette() : NullTwoDModel.getTwoDModel());
        int n2 = twoDModel.getColumnCount();
        int n3 = twoDModel.getRowCount();
        int n4 = -1;
        int n5 = -1;
        boolean bl3 = this._isDropDownVisible();
        if (!bl3) {
            n5 = this._getGrid().getSelectedColumn();
            n4 = this._getGrid().getSelectedRow();
        } else if (colorGrid != null) {
            n5 = colorGrid.getArmedColumn();
            n4 = colorGrid.getArmedRow();
        }
        boolean bl4 = false;
        switch (n) {
            case 40: {
                if (keyEvent.isAltDown()) {
                    this._setDropDownVisible(!this._isDropDownVisible());
                    bl4 = true;
                    break;
                }
            }
            case 34: {
                if (n5 == -1 || n4 == -1) {
                    n5 = 0;
                    n4 = 0;
                    break;
                }
                if (n4 >= n3 - 1) {
                    n4 = 0;
                    break;
                }
                ++n4;
                break;
            }
            case 39: {
                if (n5 == -1 || n4 == -1) {
                    n5 = 0;
                    n4 = 0;
                    break;
                }
                if (n5 >= n2 - 1) {
                    n5 = 0;
                    break;
                }
                ++n5;
                break;
            }
            case 38: {
                if (keyEvent.isAltDown()) {
                    this._setDropDownVisible(!this._isDropDownVisible());
                    bl4 = true;
                    break;
                }
            }
            case 33: {
                if (n5 == -1 || n4 == -1) {
                    n5 = n2 - 1;
                    n4 = n3 - 1;
                    break;
                }
                if (n4 == 0) {
                    n4 = n3 - 1;
                    break;
                }
                --n4;
                break;
            }
            case 37: {
                if (n5 == -1 || n4 == -1) {
                    n5 = n2 - 1;
                    n4 = n3 - 1;
                    break;
                }
                if (n5 == 0) {
                    n5 = n2 - 1;
                    break;
                }
                --n5;
                break;
            }
            case 36: {
                n5 = 0;
                n4 = 0;
                break;
            }
            case 35: {
                n5 = n2 - 1;
                n4 = n3 - 1;
                break;
            }
            case 10: {
                if (!this._isDropDownVisible() || !bl && !bl2) break;
                this._setDropDownVisible(false);
                if (n5 != -1 && n4 != -1) {
                    Color color = (Color)twoDModel.getData(n5, n4);
                    this.setSelectedColor(color, bl2);
                }
                this.repaint();
                bl4 = true;
                break;
            }
            case 27: {
                if (!this._isDropDownVisible()) break;
                this._setDropDownVisible(false);
                this.repaint();
                bl4 = true;
                break;
            }
            case 32: {
                if (this._isDropDownVisible()) break;
                this._setDropDownVisible(true);
                bl4 = true;
                break;
            }
            case 9: {
                if (!this._isDropDownVisible()) break;
                boolean bl5 = keyEvent.isShiftDown() & !keyEvent.isControlDown() & !keyEvent.isMetaDown() & !keyEvent.isAltDown();
                ColorChoice colorChoice = this.hasFocus() ? this : SwingUtilities.findFocusOwner(this._popup);
                this._transferFocus(colorChoice, bl5);
                bl4 = true;
                break;
            }
        }
        if (!bl4 && this._isDropDownVisible()) {
            this._tryMnemonic(keyEvent);
        }
        if (!(!this._isDropDownVisible() || this._getEditButton().hasFocus() || this._getTransparent().hasFocus() || this._getAutomatic().hasFocus() || this._getDefaultButton().hasFocus() || n5 == -1 || n4 == -1)) {
            if (colorGrid == null && this.hasFocus()) {
                colorGrid = this._getGrid();
            }
            colorGrid.scrollCellIntoView(n5, n4);
            this._setArmedCell(colorGrid, n5, n4);
            bl4 = true;
        }
        if (this._isDropDownVisible()) {
            this._getGrid().repaint();
        }
        if (bl4 || this._isDropDownVisible()) {
            keyEvent.consume();
        }
    }

    void updateImage() {
        Color color = this.getSelectedColor();
        if (this.isAutomaticAllowed() && this.isAutomaticSelected()) {
            this._setAutomaticIcons();
        } else if (color == null && this.isTransparentAllowed()) {
            this._setDisabledIcons();
        } else if (this.getImage() != null) {
            this._filter.setColor(color);
            this._setIcons(this.getImage(), this._filter);
        }
    }

    ColorGrid _getGrid() {
        if (this._grid == null) {
            this._grid = new ColorGrid();
            this._grid.setInDropDown(true);
            this._gridListener = new GridListener();
            this._grid.addMouseListener(this._gridListener);
            this._navigator = new Navigator();
            this._grid.addKeyListener(this._navigator);
            FocusUtils.setFocusTraversalKeysEnabled(this._grid, false);
        }
        return this._grid;
    }

    ColorPopup _getPopup() {
        if (this._popup == null) {
            this._popup = new ColorPopup();
            this._popup.setBackground(this.getBackground());
            FocusUtils.setFocusTraversalKeysEnabled(this._popup, false, true);
            FocusUtils.setFocusable(this._popup, false);
        }
        return this._popup;
    }

    ColorGrid _getCustomGrid() {
        if (this._customGrid == null) {
            this._customGrid = new ColorGrid();
            this._customGrid.setInDropDown(true);
            if (this._gridListener == null) {
                this._gridListener = new GridListener();
            }
            this._customGrid.addMouseListener(this._gridListener);
            this._customGrid.addKeyListener(this._navigator);
            this._customGrid.addPropertyChangeListener(this._gridListener);
            this._customGrid.setColorPalette(NullTwoDModel.getTwoDModel());
            FocusUtils.setFocusTraversalKeysEnabled(this._customGrid, false);
        }
        return this._customGrid;
    }

    private void _updateStrings(Locale locale) {
        String string;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_FILE, locale);
        if (this._transparent != null) {
            string = resourceBundle.getString(_KEY_NO_COLOR);
            this._transparent.setText(StringUtils.stripMnemonic(string));
            this._transparent.setMnemonic(StringUtils.getMnemonicKeyCode(string));
        }
        if (this._automatic != null) {
            string = resourceBundle.getString(_KEY_AUTOMATIC);
            this._automatic.setText(StringUtils.stripMnemonic(string));
            this._automatic.setMnemonic(StringUtils.getMnemonicKeyCode(string));
        }
        if (this._editButton != null) {
            string = resourceBundle.getString(_KEY_EDIT_COLOR);
            this._editButton.setText(StringUtils.stripMnemonic(string));
            this._editButton.setMnemonic(StringUtils.getMnemonicKeyCode(string));
        }
        if (this._defaultButton != null) {
            string = resourceBundle.getString(_KEY_DEFAULT);
            this._defaultButton.setText(StringUtils.stripMnemonic(string));
            this._defaultButton.setMnemonic(StringUtils.getMnemonicKeyCode(string));
        }
    }

    private void _transferFocus(Component component, boolean bl) {
        boolean bl2;
        Component component2 = component;
        boolean bl3 = bl2 = this._getCustomGrid().getColumnCount() != 0 && this._getCustomGrid().getRowCount() != 0;
        if (component == this._getGrid()) {
            if (bl) {
                if (this.isEditAllowed()) {
                    component2 = this._getEditButton();
                } else if (this.isDefaultAllowed()) {
                    component2 = this._getDefaultButton();
                } else if (this.isAutomaticAllowed()) {
                    component2 = this._getAutomatic();
                } else if (this.isTransparentAllowed()) {
                    component2 = this._getTransparent();
                } else if (bl2) {
                    component2 = this._getCustomGrid();
                }
            } else if (bl2) {
                component2 = this._getCustomGrid();
            } else if (this.isTransparentAllowed()) {
                component2 = this._getTransparent();
            } else if (this.isAutomaticAllowed()) {
                component2 = this._getAutomatic();
            } else if (this.isDefaultAllowed()) {
                component2 = this._getDefaultButton();
            } else if (this.isEditAllowed()) {
                component2 = this._getEditButton();
            }
        } else if (component == this._getCustomGrid()) {
            component2 = bl ? this._getGrid() : (this.isTransparentAllowed() ? this._getTransparent() : (this.isAutomaticAllowed() ? this._getAutomatic() : (this.isDefaultAllowed() ? this._getDefaultButton() : (this.isEditAllowed() ? this._getEditButton() : this._getGrid()))));
        } else if (component == this._getTransparent()) {
            component2 = bl ? (bl2 ? this._getCustomGrid() : this._getGrid()) : (this.isAutomaticAllowed() ? this._getAutomatic() : (this.isDefaultAllowed() ? this._getDefaultButton() : (this.isEditAllowed() ? this._getEditButton() : this._getGrid())));
        } else if (component == this._getEditButton()) {
            component2 = bl ? (this.isDefaultAllowed() ? this._getDefaultButton() : (this.isAutomaticAllowed() ? this._getAutomatic() : (this.isTransparentAllowed() ? this._getTransparent() : (bl2 ? this._getCustomGrid() : this._getGrid())))) : this._getGrid();
        } else if (component == this._getAutomatic()) {
            component2 = bl ? (this.isTransparentAllowed() ? this._getTransparent() : (bl2 ? this._getCustomGrid() : this._getGrid())) : (this.isDefaultAllowed() ? this._getDefaultButton() : (this.isEditAllowed() ? this._getEditButton() : this._getGrid()));
        } else if (component == this._getDefaultButton()) {
            component2 = bl ? (this.isAutomaticAllowed() ? this._getAutomatic() : (this.isTransparentAllowed() ? this._getTransparent() : (bl2 ? this._getCustomGrid() : this._getGrid()))) : (this.isEditAllowed() ? this._getEditButton() : this._getGrid());
        } else if (component == this && (this.isEditAllowed() || this.isTransparentAllowed() || bl2 || this.isAutomaticAllowed() || this.isDefaultAllowed())) {
            component2 = this._getGrid();
        }
        if (component != component2) {
            ColorGrid colorGrid;
            component2.requestFocus();
            ColorGrid colorGrid2 = colorGrid = component2 instanceof ColorGrid ? (ColorGrid)component2 : null;
            if (colorGrid != null) {
                Cell cell = colorGrid.getFocusCell();
                if (cell == null) {
                    cell = new Cell(0, 0);
                }
                colorGrid.scrollCellIntoView(cell.column, cell.row);
            }
        }
    }

    private void _clearImage() {
        this._image = null;
        this._colorToChange = null;
        this._filter = null;
    }

    private boolean _isDropDownAllowed() {
        TwoDModel twoDModel = this._getGrid().getModel();
        return twoDModel.getColumnCount() > 0 && twoDModel.getRowCount() > 0;
    }

    private void _setDropDownVisible(boolean bl) {
        if (this._isDropDownVisible() == bl) {
            return;
        }
        ColorPopup colorPopup = this._getPopup();
        ColorGrid colorGrid = this._getGrid();
        ColorGrid colorGrid2 = this._getCustomGrid();
        if (bl) {
            Cloneable cloneable;
            boolean bl2;
            if (!this._isDropDownAllowed()) {
                return;
            }
            if (_poppedColorChoice != null && _poppedColorChoice != this) {
                _poppedColorChoice._setDropDownVisible(false);
            }
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                FocusUtils.setFocusTraversalKeysEnabled(this, false);
            } else {
                this._focusManager = FocusManager.getCurrentManager();
                FocusManager.disableSwingFocusManager();
            }
            colorGrid.setForeground(this.getForeground());
            colorGrid.setBackground(this.getBackground());
            colorGrid2.setForeground(this.getForeground());
            colorGrid2.setBackground(this.getBackground());
            colorPopup.updatePanel();
            if (!this.isDefaultSelected()) {
                if (this.isCustomColorSelected()) {
                    colorGrid2.setSelectedColor(this.getSelectedColor());
                    colorGrid2.requestFocus(colorGrid2.getSelectedColumn(), colorGrid2.getSelectedRow(), null);
                    this._setArmedCell(colorGrid2, colorGrid2.getSelectedColumn(), colorGrid2.getSelectedRow());
                } else {
                    colorGrid.setSelectedColor(this.getSelectedColor());
                    colorGrid.requestFocus(colorGrid.getSelectedColumn(), colorGrid.getSelectedRow(), null);
                    this._setArmedCell(colorGrid, colorGrid.getSelectedColumn(), colorGrid.getSelectedRow());
                }
            }
            this._popMillis = System.currentTimeMillis();
            this._dragging = false;
            int n = 0;
            int n2 = this.getHeight();
            int n3 = colorPopup.getPreferredSize().width;
            int n4 = colorPopup.getPreferredSize().height;
            Window window = WindowUtils.getWindow(this);
            boolean bl3 = bl2 = window instanceof Dialog && ((Dialog)window).isModal();
            if (bl2) {
                Dimension dimension = colorPopup.getPreferredSize();
                Dialog dialog = (Dialog)window;
                cloneable = SwingUtilities.convertPoint(this, 0, 0, dialog);
                Container container = dialog instanceof JDialog ? ((JDialog)dialog).getRootPane() : dialog;
                Rectangle rectangle = container.getBounds();
                boolean bl4 = false;
                Dimension dimension2 = new Dimension(rectangle.width, rectangle.y + rectangle.height - (cloneable.y + this.getHeight()));
                Dimension dimension3 = new Dimension(rectangle.width, cloneable.y - rectangle.y);
                Dimension dimension4 = new Dimension(rectangle.x + rectangle.width - (cloneable.x + this.getWidth()), rectangle.height);
                Dimension dimension5 = new Dimension(cloneable.x - rectangle.x, rectangle.height);
                int[] nArray = new int[]{Math.min(dimension2.width, n3) * Math.min(dimension2.height, n4), Math.min(dimension3.width, n3) * Math.min(dimension3.height, n4), Math.min(dimension4.width, n3) * Math.min(dimension4.height, n4), Math.min(dimension5.width, n3) * Math.min(dimension5.height, n4)};
                int n5 = nArray[0];
                int n6 = 0;
                int n7 = 1;
                while (n7 < nArray.length) {
                    if (n5 < nArray[n7]) {
                        n5 = nArray[n7];
                        n6 = n7;
                    }
                    ++n7;
                }
                if (n6 == 0) {
                    bl4 = false;
                    n3 = Math.min(dimension2.width, dimension.width);
                    n4 = Math.min(dimension2.height, dimension.height);
                    n2 = this.getHeight();
                } else if (n6 == 1) {
                    bl4 = false;
                    n3 = Math.min(dimension3.width, dimension.width);
                    n4 = Math.min(dimension3.height, dimension.height);
                    n2 = -n4;
                } else if (n6 == 2) {
                    bl4 = true;
                    n3 = Math.min(dimension4.width, dimension.width);
                    n4 = Math.min(dimension4.height, dimension.height);
                    n = this.getWidth();
                } else if (n6 == 3) {
                    bl4 = true;
                    n3 = Math.min(dimension5.width, dimension.width);
                    n4 = Math.min(dimension5.height, dimension.height);
                    n = -n3;
                }
                if (bl4) {
                    int n8;
                    int n9 = Math.min(dimension2.height + this.getHeight(), n4);
                    n2 = n9 >= (n8 = Math.min(dimension3.height + this.getHeight(), n4)) ? n9 - n4 : this.getHeight() - n8;
                } else {
                    int n10;
                    int n11 = Math.min(dimension4.width + this.getWidth(), n3);
                    n = n11 >= (n10 = Math.min(dimension5.width + this.getWidth(), n3)) ? n11 - n3 : this.getWidth() - n10;
                }
            }
            colorPopup.preLayout(n3, n4);
            colorPopup.show(this, n, n2);
            colorPopup.postLayout();
            if (bl2) {
                int n12 = colorGrid.getSelectedColumn();
                int n13 = colorGrid.getSelectedRow();
                if (n12 != -1 && n13 != -1) {
                    cloneable = new Rectangle();
                    ((Rectangle)cloneable).x = colorGrid.getColumnPosition(n12);
                    ((Rectangle)cloneable).y = colorGrid.getRowPosition(n13);
                    ((Rectangle)cloneable).width = colorGrid.getColumnWidth(n12);
                    ((Rectangle)cloneable).height = colorGrid.getRowHeight(n13);
                    colorGrid.scrollRectToVisible((Rectangle)cloneable);
                }
            }
        } else {
            this.requestFocus();
            colorPopup.setVisible(false);
            this._setArmedCell(this._getGrid(), -1, -1);
            this._popup = null;
            this.requestFocus();
        }
        this.repaint();
    }

    private boolean _isDropDownVisible() {
        return this._popup == null ? false : this._popup.isVisible();
    }

    private boolean _handleDragInGrid(MouseEvent mouseEvent, ColorGrid colorGrid) {
        Point point = ((Component)mouseEvent.getSource()).getLocationOnScreen();
        Point point2 = colorGrid.getLocationOnScreen();
        int n = mouseEvent.getX() + point.x - point2.x;
        int n2 = mouseEvent.getY() + point.y - point2.y;
        Dimension dimension = colorGrid.getSize();
        if (n < 0 || n > dimension.width || n2 < 0 || n2 > dimension.height) {
            return false;
        }
        Point point3 = colorGrid.getLocationOnScreen();
        mouseEvent.translatePoint(point.x - point3.x, point.y - point3.y);
        this._gridListener.fakeMouseDragged(mouseEvent, colorGrid);
        this._dragging = true;
        if (this._dragGrid != null && this._dragGrid != colorGrid) {
            this._setArmedCell(this._dragGrid, -1, -1);
        }
        this._dragGrid = colorGrid;
        mouseEvent.consume();
        return true;
    }

    private void _setDisabledIcons() {
        if (_sTransparentImage == null) {
            Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorChoice == null ? (class$oracle$bali$ewt$chooser$color$ColorChoice = ColorChoice.class$("oracle.bali.ewt.chooser.color.ColorChoice")) : class$oracle$bali$ewt$chooser$color$ColorChoice, _IMAGE_NO_COLOR);
            _sTransparentImage = new ImageIcon(image);
            Image image2 = ImageUtils.createDisabledImage(image);
            _sDisabledTransparentImage = new ImageIcon(image2);
        }
        super.setIcon(_sTransparentImage);
        super.setDisabledIcon(_sDisabledTransparentImage);
    }

    private void _setAutomaticIcons() {
        if (_sAutomaticImage == null) {
            Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorChoice == null ? (class$oracle$bali$ewt$chooser$color$ColorChoice = ColorChoice.class$("oracle.bali.ewt.chooser.color.ColorChoice")) : class$oracle$bali$ewt$chooser$color$ColorChoice, _IMAGE_AUTO);
            _sAutomaticImage = new ImageIcon(image);
            Image image2 = ImageUtils.createDisabledImage(image);
            _sDisabledAutomaticImage = new ImageIcon(image2);
        }
        super.setIcon(_sAutomaticImage);
        super.setDisabledIcon(_sDisabledAutomaticImage);
    }

    private void _setDefaultIcon() {
        if (_sDefaultIcon == null) {
            _sDefaultIcon = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorChoice == null ? (class$oracle$bali$ewt$chooser$color$ColorChoice = ColorChoice.class$("oracle.bali.ewt.chooser.color.ColorChoice")) : class$oracle$bali$ewt$chooser$color$ColorChoice, _ICON_DEFAULT);
        }
        Color color = this.getDefaultColor();
        Filter filter = new Filter(_DEFAULT_COLOR_TO_CHANGE);
        filter.setColor(color);
        Image image = ColorChoice._createFilteredImage(_sDefaultIcon, filter);
        ImageIcon imageIcon = new ImageIcon(image);
        this._getDefaultButton().setIcon(imageIcon);
        image = ImageUtils.createDisabledImage(image);
        this._getDefaultButton().setDisabledIcon(new ImageIcon(image));
        String string = this._getTranslatedString(_KEY_DEFAULT_TOOLTIP);
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{IntegerUtils.getInteger(color.getRed()), IntegerUtils.getInteger(color.getGreen()), IntegerUtils.getInteger(color.getBlue())};
        String string2 = messageFormat.format(objectArray);
        this._getDefaultButton().setToolTipText(string2);
        this._getDefaultButton().getAccessibleContext().setAccessibleName(string2);
    }

    private void _setIcons(Image image, ImageFilter imageFilter) {
        image = ColorChoice._createFilteredImage(image, imageFilter);
        ImageIcon imageIcon = new ImageIcon(image);
        super.setIcon(imageIcon);
        image = ImageUtils.createDisabledImage(image);
        super.setDisabledIcon(new ImageIcon(image));
    }

    private void _tryMnemonic(KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        if (this.isAutomaticAllowed() && ColorChoice._sendMnemonicToButton(keyStroke, this._getAutomatic())) {
            keyEvent.consume();
            return;
        }
        if (this.isTransparentAllowed() && ColorChoice._sendMnemonicToButton(keyStroke, this._getTransparent())) {
            keyEvent.consume();
            return;
        }
        if (this.isDefaultAllowed() && ColorChoice._sendMnemonicToButton(keyStroke, this._getDefaultButton())) {
            keyEvent.consume();
            return;
        }
        if (this.isEditAllowed() && ColorChoice._sendMnemonicToButton(keyStroke, this._getEditButton())) {
            keyEvent.consume();
            return;
        }
    }

    private static boolean _sendMnemonicToButton(KeyStroke keyStroke, AbstractButton abstractButton) {
        ActionMap actionMap;
        Action action;
        InputMap inputMap;
        Object object;
        if (abstractButton.hasFocus() && (object = (inputMap = abstractButton.getInputMap(0)).get(keyStroke)) != null && (action = (actionMap = abstractButton.getActionMap()).get(object)) != null) {
            String string = object instanceof String ? (String)object : null;
            ActionEvent actionEvent = new ActionEvent(abstractButton, 1001, string, keyStroke.getModifiers());
            action.actionPerformed(actionEvent);
            return true;
        }
        inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
        object = inputMap.get(keyStroke);
        if (object != null && (action = (actionMap = abstractButton.getActionMap()).get(object)) != null) {
            String string = object instanceof String ? (String)object : null;
            ActionEvent actionEvent = new ActionEvent(abstractButton, 1001, string, keyStroke.getModifiers());
            action.actionPerformed(actionEvent);
            return true;
        }
        return false;
    }

    private static Image _getColorImage() {
        if (_sColorImage == null) {
            _sColorImage = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorChoice == null ? (class$oracle$bali$ewt$chooser$color$ColorChoice = ColorChoice.class$("oracle.bali.ewt.chooser.color.ColorChoice")) : class$oracle$bali$ewt$chooser$color$ColorChoice, "images/color.gif");
            _sCOLOR = new Color(100, 100, 100);
        }
        return _sColorImage;
    }

    private static Image _createFilteredImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    private void _init(String string, Icon icon, TwoDModel twoDModel, Color color) {
        this.setText(null);
        this._transparentAllowed = false;
        this._automaticAllowed = false;
        this._defaultAllowed = false;
        this._listener = new Listener();
        this.setModel(new Model());
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, true));
        this.setColorPalette(twoDModel);
        this.setSelectedColor(color);
        if (string != null) {
            this.setText(string);
        } else if (icon != null) {
            this.setIcon(icon);
        } else {
            Image image = ColorChoice._getColorImage();
            this.setImage(image, _sCOLOR);
        }
        this.updateImage();
        this.addMouseListener(this._listener);
        this.addMouseMotionListener(this._listener);
        this.addKeyListener(this._navigator);
        this.setEnabled(this.isEnabled() && this._isDropDownAllowed());
    }

    private void _setSelectedColor(Color color, Color color2, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2) {
            this._getGrid().setSelectedColor(null);
            this._getCustomGrid().setSelectedColor(null);
        } else if (bl) {
            this._getGrid().setSelectedColor(null);
        } else {
            this._getCustomGrid().setSelectedColor(null);
        }
        if (color2 != null) {
            bl3 = this._isAutomatic;
            this._isAutomatic = false;
            this.firePropertyChange(PROPERTY_AUTOMATIC_SELECTED, bl3, this._isAutomatic);
        }
        bl3 = this._isDefaultSelected;
        this._isDefaultSelected = bl2;
        this.firePropertyChange(PROPERTY_DEFAULT_SELECTED, bl3, this._isDefaultSelected);
        this.updateImage();
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, color, this.getSelectedColor());
    }

    private JToggleButton _getTransparent() {
        if (this._transparent == null) {
            this._transparent = new JToggleButton();
            this._registerEnterKeyAction(this._transparent);
            this._transparent.setMargin(new Insets(0, 2, 0, 2));
            this._transparent.setHorizontalAlignment(10);
            this._transparent.addItemListener(this._listener);
            String string = this._getTranslatedString(_KEY_NO_COLOR);
            this._transparent.setText(StringUtils.stripMnemonic(string));
            this._transparent.setMnemonic(StringUtils.getMnemonicKeyCode(string));
            this._transparent.addKeyListener(this._navigator);
            Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorChoice == null ? (class$oracle$bali$ewt$chooser$color$ColorChoice = ColorChoice.class$("oracle.bali.ewt.chooser.color.ColorChoice")) : class$oracle$bali$ewt$chooser$color$ColorChoice, _ICON_NO_COLOR);
            this._transparent.setIcon(new ImageIcon(image));
            FocusUtils.setFocusTraversalKeysEnabled(this._transparent, false);
        }
        return this._transparent;
    }

    private JToggleButton _getAutomatic() {
        if (this._automatic == null) {
            this._automatic = new JToggleButton();
            this._registerEnterKeyAction(this._automatic);
            this._automatic.setMargin(new Insets(0, 2, 0, 2));
            this._automatic.setHorizontalAlignment(10);
            this._automatic.addItemListener(this._listener);
            String string = this._getTranslatedString(_KEY_AUTOMATIC);
            this._automatic.setText(StringUtils.stripMnemonic(string));
            this._automatic.setMnemonic(StringUtils.getMnemonicKeyCode(string));
            this._automatic.addKeyListener(this._navigator);
            Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorChoice == null ? (class$oracle$bali$ewt$chooser$color$ColorChoice = ColorChoice.class$("oracle.bali.ewt.chooser.color.ColorChoice")) : class$oracle$bali$ewt$chooser$color$ColorChoice, _ICON_AUTO);
            this._automatic.setIcon(new ImageIcon(image));
            FocusUtils.setFocusTraversalKeysEnabled(this._automatic, false);
        }
        return this._automatic;
    }

    private JButton _getEditButton() {
        if (this._editButton == null) {
            this._editButton = new JButton();
            this._editButton.setMargin(new Insets(0, 2, 0, 2));
            this._editButton.addActionListener(this._listener);
            String string = this._getTranslatedString(_KEY_EDIT_COLOR);
            this._editButton.setText(StringUtils.stripMnemonic(string));
            this._editButton.setMnemonic(StringUtils.getMnemonicKeyCode(string));
            this._editButton.addKeyListener(this._navigator);
            FocusUtils.setFocusTraversalKeysEnabled(this._editButton, false);
        }
        return this._editButton;
    }

    private JToggleButton _getDefaultButton() {
        if (this._defaultButton == null) {
            this._defaultButton = new JToggleButton();
            this._registerEnterKeyAction(this._defaultButton);
            this._defaultButton.setMargin(new Insets(0, 2, 0, 2));
            this._defaultButton.setHorizontalAlignment(10);
            this._defaultButton.addItemListener(this._listener);
            String string = this._getTranslatedString(_KEY_DEFAULT);
            this._defaultButton.setText(StringUtils.stripMnemonic(string));
            this._defaultButton.setMnemonic(StringUtils.getMnemonicKeyCode(string));
            this._defaultButton.addKeyListener(this._navigator);
            FocusUtils.setFocusTraversalKeysEnabled(this._defaultButton, false);
        }
        return this._defaultButton;
    }

    private void _registerEnterKeyAction(JToggleButton jToggleButton) {
        InputMap inputMap = jToggleButton.getInputMap();
        if (inputMap != null) {
            inputMap.put(KeyStroke.getKeyStroke(10, 0, false), inputMap.get(KeyStroke.getKeyStroke(32, 0, false)));
            inputMap.put(KeyStroke.getKeyStroke(10, 0, true), inputMap.get(KeyStroke.getKeyStroke(32, 0, true)));
        }
    }

    private String _getTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_FILE, LocaleUtils.getDefaultableLocale(this));
        return resourceBundle.getString(string);
    }

    private String _getAccessTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_ACCESS_RESOURCE_FILE, LocaleUtils.getDefaultableLocale(this));
        return resourceBundle.getString(string);
    }

    private void _setArmedCell(ColorGrid colorGrid, int n, int n2) {
        colorGrid.setArmedCell(n, n2);
        if (this._isAccessible() && this._isDropDownVisible() && n != -1 && n2 != -1) {
            Color color = (Color)colorGrid.getColorPalette().getData(n, n2);
            String string = colorGrid.getAccessibleName(n, n2, color);
            this._getPopup().sendAccessibleEvent(string);
        }
    }

    private void _initPane(ColorPalettePane colorPalettePane) {
        boolean bl;
        colorPalettePane.setLocale(LocaleUtils.getDefaultableLocale(this));
        colorPalettePane.setColorPalette(this.getColorPalette());
        TwoDModel twoDModel = this.getCustomColorPalette();
        boolean bl2 = bl = twoDModel != null && twoDModel.getColumnCount() > 0 && twoDModel.getRowCount() > 0;
        if (bl) {
            int n = twoDModel.getColumnCount();
            int n2 = twoDModel.getRowCount();
            ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(n, n2);
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    arrayTwoDModel.setData(n3, n4, twoDModel.getData(n3, n4));
                    ++n4;
                }
                ++n3;
            }
            colorPalettePane.setCustomColorPalette(arrayTwoDModel);
        }
        colorPalettePane.setCustomColorsVisible(bl);
        colorPalettePane.setEditVisible(bl);
        if (!this.isDefaultSelected()) {
            colorPalettePane.setSelectedColor(this.getSelectedColor(), this.isCustomColorSelected());
        }
    }

    private boolean _isAccessible() {
        return this.accessibleContext != null;
    }

    private static void _copyModel(TwoDModel twoDModel, TwoDModel twoDModel2) {
        int n = twoDModel.getColumnCount();
        int n2 = twoDModel.getRowCount();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                twoDModel2.setData(n3, n4, twoDModel.getData(n3, n4));
                ++n4;
            }
            ++n3;
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _DEFAULT_COLOR_TO_CHANGE = Color.white;
    }

    private class AccessibleJLabel
    extends JLabel {
        private AccessibleJLabel() {
        }

        public void setText(String string) {
            String string2 = this.getText();
            super.setText(string);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
            }
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        public Access() {
            super(ColorChoice.this);
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null || "".equals(string)) {
                string = ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_ACCESS_NAME);
            } else {
                String string2 = ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_FULL_ACCESS_NAME);
                MessageFormat messageFormat = new MessageFormat(string2);
                Object[] objectArray = new Object[]{string};
                string = messageFormat.format(objectArray);
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            if (n == 0) {
                ColorPopup colorPopup = ColorChoice.this._getPopup();
                colorPopup.getAccessibleContext().setAccessibleParent(ColorChoice.this);
                return colorPopup;
            }
            return null;
        }
    }

    private class Listener
    extends MouseAdapter
    implements ItemListener,
    ActionListener,
    PropertyChangeListener,
    MouseMotionListener,
    KeyListener {
        private boolean _dirty;

        private Listener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            ColorChoice.this.internalKeyPressed(keyEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ColorChoice.this.processMouseDrag(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!ColorChoice.this.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 0 || n > dimension.width || n2 < 0 || n2 > dimension.height) {
                return;
            }
            mouseEvent.consume();
            ColorChoice.this._setDropDownVisible(!ColorChoice.this._isDropDownVisible());
            ColorChoice.this.requestFocus();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ColorChoice.this.processMouseReleased(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (ColorChoice.this._isDropDownVisible()) {
                ColorChoice.this._tryMnemonic(keyEvent);
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == ColorChoice.this._getTransparent()) {
                if (ColorChoice.this._getTransparent().isSelected()) {
                    ColorChoice.this.setAutomaticSelected(false);
                    ColorChoice.this.setSelectedColor(null);
                } else {
                    ColorChoice.this._getTransparent().removeItemListener(ColorChoice.this._listener);
                    ColorChoice.this._getTransparent().setSelected(true);
                    ColorChoice.this._getTransparent().addItemListener(ColorChoice.this._listener);
                }
            } else if (itemEvent.getSource() == ColorChoice.this._getAutomatic()) {
                if (ColorChoice.this._getAutomatic().isSelected()) {
                    ColorChoice.this.setAutomaticSelected(true);
                } else {
                    ColorChoice.this._getAutomatic().removeItemListener(ColorChoice.this._listener);
                    ColorChoice.this._getAutomatic().setSelected(true);
                    ColorChoice.this._getAutomatic().addItemListener(ColorChoice.this._listener);
                }
            } else if (itemEvent.getSource() == ColorChoice.this._getDefaultButton()) {
                if (ColorChoice.this._getDefaultButton().isSelected()) {
                    ColorChoice.this.setDefaultSelected(true);
                } else {
                    ColorChoice.this._getDefaultButton().removeItemListener(ColorChoice.this._listener);
                    ColorChoice.this._getDefaultButton().setSelected(true);
                    ColorChoice.this._getDefaultButton().addItemListener(ColorChoice.this._listener);
                }
            }
            ColorChoice.this._setDropDownVisible(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ColorChoice.this._ignore) {
                return;
            }
            ColorChoice.this._ignore = true;
            ColorPalettePane colorPalettePane = ColorChoice.this.getColorPalettePane();
            ColorChoice.this._initPane(colorPalettePane);
            colorPalettePane.addPropertyChangeListener(this);
            this._dirty = false;
            ColorChoice.this._setDropDownVisible(false);
            if (ColorPalettePane.showDialog(ColorChoice.this, colorPalettePane) == 1) {
                if (this._dirty) {
                    ColorChoice._copyModel(colorPalettePane.getCustomColorPalette(), ColorChoice.this.getCustomColorPalette());
                    ColorChoice.this.firePropertyChange(ColorChoice.PROPERTY_COLOR_PALETTE, null, ColorChoice.this.getCustomColorPalette());
                }
                ColorChoice.this.setSelectedColor(colorPalettePane.getSelectedColor(), colorPalettePane.isCustomColorSelected());
            } else {
                ColorChoice.this._setDropDownVisible(true);
                ColorChoice.this._editButton.requestFocus();
            }
            colorPalettePane.removePropertyChangeListener(this);
            ColorChoice.this._ignore = false;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("colorPalette".equals(string)) {
                this._dirty = true;
            }
        }
    }

    private class Navigator
    extends KeyAdapter {
        private Navigator() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            ColorChoice.this.internalKeyPressed(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (ColorChoice.this._isDropDownVisible()) {
                ColorChoice.this._tryMnemonic(keyEvent);
                keyEvent.consume();
            }
        }
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private int _colorToChange;

        public Filter(Color color) {
            this._colorToChange = color == null ? 0 : color.getRGB();
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            this._color = color == null ? 0 : color.getRGB();
        }

        public int filterRGB(int n, int n2, int n3) {
            if (n3 == this._colorToChange) {
                return this._color;
            }
            return n3;
        }
    }

    private class ColorPopup
    extends JPopupMenu {
        private JPanel _editPanel;
        private JPanel _buttonPanel;
        private JPanel _gridPanel;
        private JScrollPane _box;
        private boolean _boxAdded;
        private int _prefWidth;
        private int _prefHeight;
        private JLabel _statusBarLabel;
        private StatusBar _statusBar;

        public ColorPopup() {
            this.setLayout(new BorderLayout(0, 0));
            this._buttonPanel = new JPanel();
            this._buttonPanel.setLayout(new GridLayout(0, 1));
            this._editPanel = new JPanel();
            this._editPanel.setLayout(new BorderLayout(2, 2));
            this._gridPanel = new JPanel();
            this._gridPanel.setLayout(new BorderLayout(0, 2));
            this._gridPanel.add("North", ColorChoice.this._getGrid());
            this._gridPanel.add("Center", ColorChoice.this._getCustomGrid());
            this._gridPanel.setBorder(null);
            this._box = new JScrollPane();
            this._box.setBorder(null);
            this._boxAdded = false;
            this.setBorderPainted(true);
            this.setBorder(LineBorder.createBlackLineBorder());
            this.add("North", this._buttonPanel);
            this.add("Center", this._gridPanel);
            this.add("South", this._editPanel);
        }

        public Dimension getPreferredSize() {
            if (this._prefWidth != 0) {
                return new Dimension(this._prefWidth, this._prefHeight);
            }
            Dimension dimension = super.getPreferredSize();
            if (!ColorChoice.this.isEditAllowed()) {
                dimension.height -= 2;
            }
            return dimension;
        }

        public void preLayout(int n, int n2) {
            Dimension dimension = this.getPreferredSize();
            if (dimension.width > n || dimension.height > n2) {
                if (!this._boxAdded) {
                    this.remove(this._gridPanel);
                    this._box.setViewportView(this._gridPanel);
                    this.add("Center", this._box);
                    this._boxAdded = true;
                    this.validate();
                }
            } else if (this._boxAdded) {
                this._box.setViewportView(null);
                this.remove(this._box);
                this.add("Center", this._gridPanel);
                this._boxAdded = false;
                this.validate();
            }
            this._prefWidth = n;
            this._prefHeight = n2;
        }

        public void postLayout() {
            this._prefWidth = 0;
            this._prefHeight = 0;
        }

        public void updatePanel() {
            boolean bl;
            this._buttonPanel.removeAll();
            this._editPanel.removeAll();
            if (ColorChoice.this.isTransparentAllowed()) {
                this._buttonPanel.add(ColorChoice.this._getTransparent());
                bl = ColorChoice.this.getSelectedColor() == null && !ColorChoice.this.isAutomaticSelected();
                ColorChoice.this._getTransparent().removeItemListener(ColorChoice.this._listener);
                ColorChoice.this._getTransparent().setSelected(bl);
                ColorChoice.this._getTransparent().addItemListener(ColorChoice.this._listener);
            }
            if (ColorChoice.this.isAutomaticAllowed()) {
                this._buttonPanel.add(ColorChoice.this._getAutomatic());
                bl = ColorChoice.this.isAutomaticSelected();
                ColorChoice.this._getAutomatic().removeItemListener(ColorChoice.this._listener);
                ColorChoice.this._getAutomatic().setSelected(bl);
                ColorChoice.this._getAutomatic().addItemListener(ColorChoice.this._listener);
            }
            if (ColorChoice.this.isDefaultAllowed()) {
                this._buttonPanel.add(ColorChoice.this._getDefaultButton());
                bl = ColorChoice.this.isDefaultSelected();
                ColorChoice.this._getDefaultButton().removeItemListener(ColorChoice.this._listener);
                ColorChoice.this._getDefaultButton().setSelected(bl);
                ColorChoice.this._getDefaultButton().addItemListener(ColorChoice.this._listener);
                if (ColorChoice.this._defaultImageDirty) {
                    ColorChoice.this._setDefaultIcon();
                    ColorChoice.this._defaultImageDirty = false;
                }
            }
            if (ColorChoice.this.isEditAllowed()) {
                this._editPanel.add("East", ColorChoice.this._getEditButton());
            }
            if (ColorChoice.this._isAccessible() && this._statusBar == null) {
                this._statusBar = new StatusBar();
                this._statusBarLabel = new AccessibleJLabel();
                this._statusBar.add(this._statusBarLabel);
                this._statusBar.setVisible(false);
                this._editPanel.add("South", this._statusBar);
            }
        }

        public void sendAccessibleEvent(String string) {
            if (this._statusBarLabel != null) {
                this._statusBarLabel.setText(string);
            }
        }

        protected void firePopupMenuWillBecomeVisible() {
            super.firePopupMenuWillBecomeVisible();
            _poppedColorChoice = ColorChoice.this;
        }

        protected void firePopupMenuWillBecomeInvisible() {
            super.firePopupMenuWillBecomeInvisible();
            ColorChoice.this._setArmedCell(ColorChoice.this._getGrid(), -1, -1);
            ColorChoice.this._setArmedCell(ColorChoice.this._getCustomGrid(), -1, -1);
            ColorChoice.this.repaint();
            ColorChoice.this._popup = null;
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                FocusUtils.setFocusTraversalKeysEnabled(ColorChoice.this, true);
            } else {
                FocusManager.setCurrentManager(ColorChoice.this._focusManager);
            }
            if (_poppedColorChoice == ColorChoice.this) {
                _poppedColorChoice = null;
            }
        }

        protected void firePopupMenuCanceled() {
            super.firePopupMenuCanceled();
            ColorChoice.this._setArmedCell(ColorChoice.this._getGrid(), -1, -1);
            ColorChoice.this._setArmedCell(ColorChoice.this._getCustomGrid(), -1, -1);
            ColorChoice.this.repaint();
        }
    }

    private class GridListener
    extends MouseAdapter
    implements PropertyChangeListener {
        private GridListener() {
        }

        public void fakeMouseDragged(MouseEvent mouseEvent, ColorGrid colorGrid) {
            Point point = colorGrid.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            int n = colorGrid.getColumnAt(point.x);
            int n2 = colorGrid.getRowAt(point.y);
            ColorChoice.this._setArmedCell(colorGrid, n, n2);
            if (n2 != -1 && n != -1) {
                mouseEvent.consume();
            }
        }

        public void handleMouseReleased(MouseEvent mouseEvent, ColorGrid colorGrid) {
            int n;
            mouseEvent.consume();
            ColorChoice.this._setDropDownVisible(false);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            Point point = colorGrid.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            int n2 = point.x < 0 ? -1 : colorGrid.getColumnAt(point.x);
            int n3 = n = point.y < 0 ? -1 : colorGrid.getRowAt(point.y);
            if (n == -1 || n2 == -1) {
                return;
            }
            boolean bl = colorGrid == ColorChoice.this._customGrid;
            TwoDModel twoDModel = bl ? ColorChoice.this.getCustomColorPalette() : ColorChoice.this.getColorPalette();
            Color color = (Color)twoDModel.getData(n2, n);
            ColorChoice.this.setSelectedColor(color, bl);
            ColorChoice.this.requestFocus();
            ColorChoice.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ColorGrid colorGrid = (ColorGrid)mouseEvent.getSource();
            this.handleMouseReleased(mouseEvent, colorGrid);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (ColorChoice.PROPERTY_SELECTED_COLOR.equals(string) && propertyChangeEvent.getNewValue() != null) {
                if (propertyChangeEvent.getSource() == ColorChoice.this._getGrid()) {
                    ColorChoice.this._getCustomGrid().setSelectedColor(null);
                } else {
                    ColorChoice.this._getGrid().setSelectedColor(null);
                }
            }
        }
    }

    private class Model
    extends DefaultButtonModel {
        private Model() {
        }

        public boolean isArmed() {
            return ColorChoice.this._isDropDownVisible();
        }

        public boolean isPressed() {
            return ColorChoice.this._isDropDownVisible();
        }
    }
}

