/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.Component;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import oracle.bali.ewt.chooser.color.ColorEditor;
import oracle.bali.share.nls.LocaleUtils;

public abstract class BaseColorEditor
extends JPanel
implements ColorEditor {
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _ACCESS_RESOURCE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private Color _color;
    private boolean _initialized = true;

    public void setColor(Color color) {
        if (this._color != color) {
            this._color = color;
            this.colorChanged(color);
            this.repaint();
        }
    }

    public Color getColor() {
        if (this._color == null) {
            this._color = Color.black;
        }
        return this._color;
    }

    public Component getComponent() {
        return this;
    }

    public void addNotify() {
        super.addNotify();
        this.updateLabels(this.getLocale());
    }

    protected void storeColor(Color color) {
        Color color2 = this._color;
        this._color = color;
        this.fireColorPropertyChange(color2, this._color);
    }

    protected void colorChanged(Color color) {
    }

    protected void fireColorPropertyChange(Color color, Color color2) {
        this.firePropertyChange("color", color, color2);
    }

    protected void updateLabels(Locale locale) {
    }

    protected void updateAccessibleNames() {
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._initialized) {
            this.updateLabels(locale);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.updateAccessibleNames();
        }
        return super.getAccessibleContext();
    }

    static String __getTranslatedString(Locale locale, String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        return resourceBundle.getString(string);
    }

    String __getTranslatedString(String string) {
        return BaseColorEditor.__getTranslatedString(LocaleUtils.getDefaultableLocale(this), string);
    }
}

