/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.MenuUtils;

public class PopupButtonModel
extends DefaultButtonModel {
    AbstractButton _button;
    private JPopupMenu _popupMenu;
    private PopupMenuListener _pml;
    private Timer _timer;
    private static final int _POPUP_DELAY = 500;

    public PopupButtonModel(AbstractButton abstractButton) {
        this._button = abstractButton;
        Listen listen = new Listen();
        this._timer = new Timer(500, listen);
        this._timer.setRepeats(false);
        this._pml = listen;
    }

    public PopupButtonModel(AbstractButton abstractButton, JPopupMenu jPopupMenu) {
        this(abstractButton);
        this.setPopupMenu(jPopupMenu);
    }

    public JPopupMenu getPopupMenu() {
        return this._popupMenu;
    }

    public synchronized void setPopupMenu(JPopupMenu jPopupMenu) {
        if (jPopupMenu != this._popupMenu) {
            if (this._popupMenu != null) {
                this._popupMenu.removePopupMenuListener(this._pml);
            }
            this._popupMenu = jPopupMenu;
            if (jPopupMenu != null) {
                jPopupMenu.addPopupMenuListener(this._pml);
            }
        }
    }

    public void setDelay(int n) {
        this._timer.setInitialDelay(n);
    }

    public int getDelay() {
        return this._timer.getInitialDelay();
    }

    public boolean isPressed() {
        return super.isPressed() || this._isMenuVisible();
    }

    public boolean isArmed() {
        return super.isArmed() || this._isMenuVisible();
    }

    public void setPressed(boolean bl) {
        if (bl != super.isPressed()) {
            super.setPressed(bl);
            if (bl) {
                if (this._isMenuVisible()) {
                    this._hidePopup();
                } else {
                    this._timer.start();
                }
            } else {
                this._timer.stop();
            }
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            if (!bl) {
                this.setArmed(false);
                this.setPressed(false);
            }
            super.setEnabled(bl);
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this._isMenuVisible()) {
            return;
        }
        super.fireActionPerformed(actionEvent);
    }

    void __showPopup() {
        this.setArmed(false);
        super.setPressed(false);
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (jPopupMenu != null) {
            MenuUtils.showPopupMenu(jPopupMenu, this._button, 0, this._button.getHeight());
        }
    }

    private void _hidePopup() {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (jPopupMenu != null) {
            jPopupMenu.setVisible(false);
        }
    }

    private boolean _isMenuVisible() {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (jPopupMenu == null) {
            return false;
        }
        return jPopupMenu.isVisible();
    }

    private class Listen
    implements ActionListener,
    PopupMenuListener {
        private Listen() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PopupButtonModel.this.__showPopup();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            PopupButtonModel.this._button.repaint();
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

