/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextComponent;
import oracle.bali.ewt.util.ImmInsets;

public class BorderAdapter
implements Border {
    private BorderPainter _border;

    public BorderAdapter(BorderPainter borderPainter) {
        this._border = borderPainter;
    }

    public final BorderPainter getBorderPainter() {
        return this._border;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        PaintContext paintContext = this.getPaintContext(component);
        this._border.paint(paintContext, graphics, n, n2, n3, n4);
    }

    public Insets getBorderInsets(Component component) {
        PaintContext paintContext = this.getPaintContext(component);
        return this._border.getInsets(paintContext).toInsets();
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        PaintContext paintContext = this.getPaintContext(component);
        ImmInsets immInsets = this._border.getInsets(paintContext);
        insets.left = immInsets.left;
        insets.right = immInsets.right;
        insets.top = immInsets.top;
        insets.bottom = immInsets.bottom;
        return insets;
    }

    public boolean isBorderOpaque() {
        return this._border.isTransparent(null);
    }

    public String toString() {
        return "BorderAdapter[" + this._border + "]";
    }

    public PaintContext getPaintContext(Component component) {
        if (component instanceof PaintContextComponent) {
            return ((PaintContextComponent)component).getBorderContext();
        }
        PaintContext paintContext = JPaintContext.getPaintContext((JComponent)component);
        if (paintContext != null) {
            return paintContext;
        }
        return new JPaintContext((JComponent)component);
    }
}

