/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.StringTokenizer;
import jclass.util.ExpiryDialog;
import jclass.util.JCEval;
import jclass.util.ProductRegistry;

public final class JCVersion {
    public static final int major = 3;
    public static final int minor = 6;
    public static final int release = 0;
    public static final String platform_id = "J";
    public static final String platform = "JDK 1.2 Swing";
    private static String versionString = null;
    private static String versionNumber = null;
    private static ExpiryDialog expiryBox = null;

    public static final synchronized String getVersionString() {
        if (versionString == null) {
            versionString = "JClass Utilities " + 3 + "." + 6 + "." + 0 + platform_id + " for " + platform;
        }
        return versionString;
    }

    public static final String getVersionNumber() {
        if (versionNumber == null) {
            versionNumber = "" + 3 + 6 + 0 + platform_id;
        }
        return versionNumber;
    }

    public static final synchronized void setEval(String string, Frame frame) {
        if (expiryBox == null) {
            expiryBox = new ExpiryDialog(frame, "JClass Evaluation Information", false);
            ProductRegistry.registerListener(expiryBox);
        }
        ProductRegistry.registerProduct(JCVersion.getProductName(string));
    }

    private static final FileInputStream getEvalExpiryFileInputStream(String string) {
        String string2 = "|";
        String string3 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = null;
        String string4 = null;
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        string3 = string3.replace(System.getProperty("file.separator").charAt(0), '/');
        string3 = string3.replace(System.getProperty("path.separator").charAt(0), string2.charAt(0));
        stringTokenizer = new StringTokenizer(string3, string2);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (string4.charAt(string4.length() - 1) != '/') {
                if (string4.endsWith(".ZIP") || string4.endsWith(".zip") || string4.endsWith(".tar") || string4.endsWith(".TAR") || string4.endsWith(".jar") || string4.endsWith(".JAR")) {
                    int n2 = string4.length() - 1;
                    while (n2 >= 0) {
                        if (string4.charAt(n2) == '/') {
                            string4 = string4.substring(0, n2);
                            break;
                        }
                        --n2;
                    }
                }
                string4 = string4.concat("/");
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(String.valueOf(string4) + "jc" + string + "data");
                return fileInputStream;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        return null;
    }

    static final Date getEvalExpiryDate(String string) {
        Date date = null;
        try {
            FileInputStream fileInputStream = JCVersion.getEvalExpiryFileInputStream(string);
            if (fileInputStream == null) {
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            date = new Date(n, n2, n3, 0, 0, 0);
            dataInputStream.close();
        }
        catch (Exception exception) {}
        return date;
    }

    public static final boolean isExpired(String string) {
        Date date = JCVersion.getEvalExpiryDate(JCVersion.getProductName(string));
        Date date2 = new Date();
        Date date3 = JCVersion.getBuildDate(string);
        Date date4 = JCVersion.getExpiryDate(string);
        if (date3 != null && date2.before(date3)) {
            return true;
        }
        if (date4 != null && date2.after(date4)) {
            return true;
        }
        if (date != null) {
            return date2.after(date);
        }
        return false;
    }

    private static final JCEval getEval(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("jclass." + string + ".JCVersion");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        JCEval jCEval = null;
        try {
            jCEval = (JCEval)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassCastException classCastException) {}
        return jCEval;
    }

    private static final Date getBuildDate(String string) {
        Date date = null;
        JCEval jCEval = JCVersion.getEval(string);
        if (jCEval != null) {
            date = jCEval.getBuildDate();
        }
        return date;
    }

    private static final Date getExpiryDate(String string) {
        Date date = null;
        JCEval jCEval = JCVersion.getEval(string);
        if (jCEval != null) {
            date = jCEval.getExpiryDate();
        }
        return date;
    }

    static final String getProductName(String string) {
        String string2 = null;
        JCEval jCEval = JCVersion.getEval(string);
        if (jCEval != null) {
            string2 = jCEval.getProductName();
        }
        return string2;
    }

    static final boolean isEval(String string) {
        Class<?> clazz;
        Class<?>[] classArray;
        try {
            Class<?> clazz2 = Class.forName("jclass." + string + ".JCVersion");
            classArray = clazz2.getInterfaces();
            clazz = Class.forName("jclass.util.JCEval");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].equals(clazz)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final void setExpired(String string, String string2, int n) {
        Date date = new Date();
        long l = date.getTime();
        String string3 = System.getProperty("file.separator");
        string = JCVersion.getProductName(string);
        date.setTime(l += (long)n * 86400000L);
        string2.replace(string3.charAt(0), '/');
        if (string2.charAt(string2.length() - 1) != '/') {
            string2 = string2.concat("/");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string2) + "jc" + string + "data");
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            dataOutputStream.writeInt(date.getYear());
            dataOutputStream.writeInt(date.getMonth());
            dataOutputStream.writeInt(date.getDate());
            dataOutputStream.flush();
            dataOutputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final void main(String[] stringArray) {
        System.out.println(JCVersion.getVersionString());
    }
}

