/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jclass.chart.ChartDataView;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.customizer.swing.AxisOrientPage;
import jclass.chart.customizer.swing.JBooleanEditor;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JEnumEditor;
import jclass.chart.customizer.swing.JPropertyPage;

public class ViewAxisPage
extends JPropertyPage {
    protected JEnumEditor viewCombo;
    private JLabel viewLabel;
    protected JBooleanEditor xCheck;
    protected JBooleanEditor yCheck;
    private JPanel buttonsPanel;
    private JCAxis target;

    public void init() {
        super.init();
        this.setToolTipText(ViewAxisPage.getPageTitle());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        this.viewLabel = new JLabel("");
        this.viewLabel.setIcon(new ImageIcon(AxisOrientPage.getEnabledOrientationImage((Component)this, 0)));
        this.add(this.viewLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new GridLayout(2, 1));
        this.buttonsPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.xCheck = new JBooleanEditor("X " + JCustomizerBundle.string("jclass.chart.customizer.swing.Key83"));
        this.yCheck = new JBooleanEditor("Y " + JCustomizerBundle.string("jclass.chart.customizer.swing.Key83"));
        this.xCheck.addPropertyChangeListener(this);
        this.yCheck.addPropertyChangeListener(this);
        buttonGroup.add(this.xCheck);
        buttonGroup.add(this.yCheck);
        this.buttonsPanel.add(this.xCheck);
        this.buttonsPanel.add(this.yCheck);
        gridBagLayout.setConstraints(this.buttonsPanel, gridBagConstraints);
        this.add(this.buttonsPanel);
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key232")) + ":"));
        this.viewCombo = new JEnumEditor();
        this.viewCombo.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.viewCombo, gridBagConstraints);
        this.add(this.viewCombo);
    }

    private void setViewList(JCChart jCChart) {
        Object[] objectArray = jCChart.getDataView();
        if (objectArray != null) {
            String[] stringArray = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                ChartDataView chartDataView = objectArray[n];
                stringArray[n] = new String(n + ": " + chartDataView.getName());
                ++n;
            }
            this.viewCombo.setItems(stringArray, objectArray);
        }
    }

    public Object getObject() {
        return this.target;
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.setViewList((JCChart)object);
            this.viewCombo.setEnabled(true);
            this.buttonsPanel.setEnabled(true);
            return;
        }
        if (object instanceof JCAxis) {
            this.target = (JCAxis)object;
            JCChart jCChart = this.target.getParent();
            if (jCChart == null) {
                return;
            }
            ChartDataView[] chartDataViewArray = jCChart.getDataView();
            if (chartDataViewArray == null) {
                return;
            }
            JCAxis jCAxis = this.target.getFormula().getOriginator();
            JCAxis jCAxis2 = jCAxis != null ? jCAxis : this.target;
            this.setViewList(jCChart);
            String[] stringArray = new String[chartDataViewArray.length];
            int n = -1;
            int n2 = 0;
            while (n2 < chartDataViewArray.length) {
                ChartDataView chartDataView = chartDataViewArray[n2];
                stringArray[n2] = new String(n2 + ": " + chartDataView.getName());
                if (jCAxis2 == chartDataView.getXAxis() || jCAxis2 == chartDataView.getYAxis()) {
                    n = n2;
                }
                ++n2;
            }
            if (n >= 0) {
                this.viewCombo.setValue(chartDataViewArray[n]);
                this.viewLabel.setIcon(new ImageIcon(AxisOrientPage.getEnabledOrientationImage((Component)this, chartDataViewArray[n])));
                if (jCAxis2 == chartDataViewArray[n].getXAxis()) {
                    this.xCheck.setValue(new Boolean(true));
                    this.yCheck.setValue(new Boolean(false));
                } else {
                    this.yCheck.setValue(new Boolean(true));
                    this.xCheck.setValue(new Boolean(false));
                }
                this.viewCombo.setEnabled(false);
                this.buttonsPanel.setEnabled(false);
            }
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.target == null) {
            return;
        }
        if (object2 instanceof ChartDataView) {
            ChartDataView chartDataView = (ChartDataView)object2;
            this.viewLabel.setIcon(new ImageIcon(AxisOrientPage.getEnabledOrientationImage((Component)this, chartDataView)));
            if (this.target != chartDataView.getXAxis()) {
                chartDataView.getYAxis();
                return;
            }
        } else if (object instanceof JBooleanEditor) {
            JBooleanEditor jBooleanEditor = (JBooleanEditor)object;
            if (jBooleanEditor == null) {
                return;
            }
            boolean bl = (Boolean)object2;
            if (bl) {
                this.setObject(this.target);
                return;
            }
        } else if (object instanceof JEnumEditor) {
            JEnumEditor jEnumEditor = (JEnumEditor)object;
            ChartDataView chartDataView = (ChartDataView)jEnumEditor.getItem((Integer)object2);
            this.viewLabel.setIcon(new ImageIcon(AxisOrientPage.getEnabledOrientationImage((Component)this, chartDataView)));
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(ViewAxisPage.getPageTitle());
        serializable = new ViewAxisPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((ViewAxisPage)serializable).init();
        ((ViewAxisPage)serializable).setObject(new JCChart());
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key233");
    }

    public static String getPageName() {
        return "ViewAxisPage";
    }
}

