/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import jclass.chart.ChartDataView;
import jclass.chart.JCChart;
import jclass.chart.JCPieChartFormat;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JDoubleEditor;
import jclass.chart.customizer.swing.JIntegerEditor;
import jclass.chart.customizer.swing.JPropertyPage;
import jclass.chart.customizer.swing.JSpinBox;
import jclass.util.JCUtilConverter;

public class PieChartPage
extends JPropertyPage
implements AdjustmentListener {
    private JSpinBox thresholdMethod;
    private JDoubleEditor thresholdValueField;
    private JSpinBox sortOrder;
    private JIntegerEditor minSlicesField;
    private ChartDataView view;

    public void init() {
        super.init();
        this.setToolTipText(PieChartPage.getPageTitle());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.weightx = 1.0;
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key187")) + ":"));
        this.thresholdMethod = new JSpinBox(JCPieChartFormat.thresholdMethod_strings);
        this.thresholdMethod.getTextField().setEditable(false);
        this.thresholdMethod.getScrollBar().addAdjustmentListener(this);
        gridBagLayout.setConstraints(this.thresholdMethod, gridBagConstraints);
        this.add(this.thresholdMethod);
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key188")) + ":"));
        this.thresholdValueField = new JDoubleEditor(4);
        this.thresholdValueField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.thresholdValueField, gridBagConstraints);
        this.add(this.thresholdValueField);
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key189")) + ":"));
        this.sortOrder = new JSpinBox(JCPieChartFormat.sortOrder_strings);
        this.sortOrder.getTextField().setEditable(false);
        this.sortOrder.getScrollBar().addAdjustmentListener(this);
        gridBagLayout.setConstraints(this.sortOrder, gridBagConstraints);
        this.add(this.sortOrder);
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key190")) + ":"));
        this.minSlicesField = new JIntegerEditor();
        this.minSlicesField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.minSlicesField, gridBagConstraints);
        this.add(this.minSlicesField);
    }

    public Object getObject() {
        return this.view;
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.view = ((JCChart)object).getDataView(0);
        } else if (object instanceof ChartDataView) {
            this.view = (ChartDataView)object;
        }
        if (this.view != null && this.view.getChartType() == 11) {
            JCPieChartFormat jCPieChartFormat = this.view.getPieChartFormat();
            if (jCPieChartFormat != null) {
                String string;
                int n = jCPieChartFormat.getThresholdMethod();
                String string2 = JCUtilConverter.fromEnum(n, JCPieChartFormat.thresholdMethod_strings, JCPieChartFormat.thresholdMethod_values);
                if (string2 != (string = this.thresholdMethod.getTextValue())) {
                    this.thresholdMethod.setTextValue(string2);
                }
                this.thresholdMethod.getScrollBar().setEnabled(true);
                this.thresholdMethod.setIntValue(0);
                this.thresholdValueField.setValue(new Double(jCPieChartFormat.getThresholdValue()));
                this.thresholdValueField.textField.setEnabled(true);
                int n2 = jCPieChartFormat.getSortOrder();
                string2 = JCUtilConverter.fromEnum(n2, JCPieChartFormat.sortOrder_strings, JCPieChartFormat.sortOrder_values);
                string = this.sortOrder.getTextValue();
                if (string2 != string) {
                    this.sortOrder.setTextValue(string2);
                }
                this.sortOrder.getScrollBar().setEnabled(true);
                this.sortOrder.setIntValue(0);
                this.minSlicesField.setValue(new Integer(jCPieChartFormat.getMinSlices()));
                this.minSlicesField.box.getScrollBar().setEnabled(true);
                this.minSlicesField.box.getTextField().setEnabled(true);
                return;
            }
        } else {
            this.thresholdMethod.getScrollBar().setEnabled(false);
            this.thresholdValueField.textField.setEnabled(false);
            this.sortOrder.getScrollBar().setEnabled(false);
            this.minSlicesField.box.getScrollBar().setEnabled(false);
            this.minSlicesField.box.getTextField().setEnabled(false);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.view == null) {
            return;
        }
        if (object == this.thresholdValueField) {
            Double d = (Double)object2;
            this.view.getPieChartFormat().setThresholdValue(d);
            return;
        }
        if (object == this.minSlicesField) {
            Integer n = (Integer)object2;
            this.view.getPieChartFormat().setMinSlices(n);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.view == null) {
            return;
        }
        if (adjustmentEvent != null && adjustmentEvent.getSource() instanceof JScrollBar) {
            if (adjustmentEvent.getSource() == this.thresholdMethod.getScrollBar()) {
                this.thresholdMethod.setIntValue(adjustmentEvent.getValue());
                this.view.getPieChartFormat().setThresholdMethod(JCUtilConverter.toEnum(this.thresholdMethod.getTextValue(), JCPieChartFormat.thresholdMethod_strings, JCPieChartFormat.thresholdMethod_values, 0));
            }
            if (adjustmentEvent.getSource() == this.sortOrder.getScrollBar()) {
                this.sortOrder.setIntValue(adjustmentEvent.getValue());
                this.view.getPieChartFormat().setSortOrder(JCUtilConverter.toEnum(this.sortOrder.getTextValue(), JCPieChartFormat.sortOrder_strings, JCPieChartFormat.sortOrder_values, 0));
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(PieChartPage.getPageTitle());
        serializable = new PieChartPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((PieChartPage)serializable).init();
        ((PieChartPage)serializable).setObject(new JCChart(11));
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key191");
    }

    public static String getPageName() {
        return "PieChartPage";
    }
}

