/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class JSpinBox
extends JPanel {
    private JTextField textField;
    private JScrollBar scrollBar;
    private int minValue;
    private int maxValue = Integer.MAX_VALUE;
    private int value;
    private String[] strings;
    private boolean isStringsSpin = false;

    public JSpinBox() {
        this(0);
    }

    public JSpinBox(int n) {
        this.setLayout(new FlowLayout(0, 2, 2));
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.value = n;
        this.textField = new JTextField("", 5);
        this.textField.setText(String.valueOf(n));
        this.add(this.textField);
        this.scrollBar = new JScrollBar(1, n, 1, this.minValue, this.maxValue);
        this.scrollBar.setPreferredSize(new Dimension(20, 25));
        this.scrollBar.setUnitIncrement(-1);
        this.add(this.scrollBar);
    }

    public JSpinBox(String[] stringArray) {
        this.strings = stringArray;
        this.setLayout(new FlowLayout(0, 2, 2));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.value = 0;
        this.textField = new JTextField("", 10);
        this.textField.setText(this.strings[this.value]);
        this.add(this.textField);
        this.scrollBar = new JScrollBar(1, 0, 1, 0, this.strings.length);
        this.minValue = 0;
        this.maxValue = this.strings.length;
        this.scrollBar.setPreferredSize(new Dimension(20, 25));
        this.scrollBar.setUnitIncrement(-1);
        this.add(this.scrollBar);
        this.isStringsSpin = true;
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setIntValue(int n) {
        this.setValue(n);
    }

    public void setTextValue(String string) {
        try {
            int n;
            int n2 = n = this.isStringsSpin ? this.getStringIndex(string) : Integer.valueOf(string).intValue();
            if (this.isStringsSpin && n == -1) {
                throw new NumberFormatException();
            }
            this.setValue(n);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            if (!this.isStringsSpin) {
                this.textField.setText(String.valueOf(this.value));
            } else {
                this.textField.setText(this.strings[this.value]);
            }
            this.scrollBar.setValue(this.value);
            return;
        }
    }

    public int getIntValue() {
        return this.value;
    }

    public String getTextValue() {
        return this.textField.getText();
    }

    public void setMaximum(int n) {
        this.maxValue = n;
        this.scrollBar.setMaximum(n);
        if (this.maxValue < this.value) {
            this.value = this.maxValue;
            this.setIntValue(this.value);
        }
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public void setMinimum(int n) {
        this.minValue = n;
        this.scrollBar.setMinimum(n);
        if (this.value < this.minValue) {
            this.value = this.minValue;
            this.setIntValue(this.value);
        }
    }

    public int getMinimum() {
        return this.minValue;
    }

    public void setBackground(Color color) {
        if (this.textField != null) {
            this.textField.setBackground(color);
        }
    }

    private void setValue(int n) {
        if (n >= this.minValue && n <= this.maxValue) {
            this.value = n;
            this.scrollBar.setValue(this.value);
            if (!this.isStringsSpin) {
                this.textField.setText(String.valueOf(this.value));
                return;
            }
            this.textField.setText(this.strings[this.value]);
            return;
        }
        if (n < this.minValue) {
            this.scrollBar.setValue(this.minValue);
            if (!this.isStringsSpin) {
                this.textField.setText(String.valueOf(this.minValue));
                return;
            }
            this.textField.setText(this.strings[this.minValue]);
            return;
        }
        this.scrollBar.setValue(this.maxValue);
        if (!this.isStringsSpin) {
            this.textField.setText(String.valueOf(this.maxValue));
            return;
        }
        this.textField.setText(this.strings[this.maxValue]);
    }

    private int getStringIndex(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.strings.length) {
            if (string.compareTo(this.strings[n2]) == 0) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }
}

