/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jclass.chart.JCChart;
import jclass.chart.JCCustomizerPage;
import jclass.chart.customizer.swing.JBooleanEditor;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JFileNameEditor;
import jclass.chart.customizer.swing.JPropertyPage;

public class JLoadDialog
extends JPropertyPage
implements ActionListener {
    private JPanel modeBox;
    private ButtonGroup modeBoxGroup;
    private JBooleanEditor paramCheck;
    private JBooleanEditor serialCheck;
    private JFileNameEditor fileSelector;
    private JLabel loadedLabel;
    private JButton addButton;
    private JButton previewButton;
    private JButton removeButton;
    private JButton cancelButton;
    private Object preview;
    private Object target;
    private Object model;

    public void init() {
        super.init();
        this.setToolTipText(JLoadDialog.getPageTitle());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        String string = String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key294")) + " ";
        this.modeBox = new JPanel();
        this.modeBoxGroup = new ButtonGroup();
        this.modeBox.setLayout(new GridLayout(1, 2));
        this.modeBox.setBorder(BorderFactory.createTitledBorder(string));
        this.paramCheck = new JBooleanEditor(JCustomizerBundle.string("jclass.chart.customizer.swing.Key275"));
        this.paramCheck.setSelected(true);
        this.paramCheck.addPropertyChangeListener(this);
        this.modeBoxGroup.add(this.paramCheck);
        this.serialCheck = new JBooleanEditor(JCustomizerBundle.string("jclass.chart.customizer.swing.Key276"));
        this.serialCheck.addPropertyChangeListener(this);
        this.modeBoxGroup.add(this.serialCheck);
        this.modeBox.add(this.paramCheck);
        this.modeBox.add(this.serialCheck);
        jPanel2.add((Component)this.modeBox, "North");
        JPanel jPanel3 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key276")) + ":"));
        this.fileSelector = new JFileNameEditor();
        this.fileSelector.init();
        this.fileSelector.saveButton.setEnabled(false);
        this.fileSelector.nameField.textField.setText("test.html");
        this.fileSelector.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.fileSelector, gridBagConstraints);
        jPanel3.add(this.fileSelector);
        jPanel3.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key292")) + ":"));
        this.loadedLabel = new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key273")) + ":");
        this.loadedLabel.setFont(new Font("TimesRoman", 1, 14));
        this.loadedLabel.setHorizontalAlignment(2);
        this.loadedLabel.setVerticalAlignment(0);
        gridBagLayout.setConstraints(this.loadedLabel, gridBagConstraints);
        jPanel3.add(this.loadedLabel);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1, 10, 2));
        this.addButton = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key293"));
        this.addButton.addActionListener(this);
        this.addButton.setEnabled(false);
        jPanel4.add(this.addButton);
        if (this.hasPreview()) {
            this.previewButton = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key134"));
            this.previewButton.addActionListener(this);
            jPanel4.add(this.previewButton);
        }
        this.removeButton = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key135"));
        this.removeButton.addActionListener(this);
        jPanel4.add(this.removeButton);
        this.cancelButton = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key136"));
        this.cancelButton.addActionListener(this);
        jPanel4.add(this.cancelButton);
        jPanel.add((Component)jPanel4, "South");
        this.add((Component)jPanel, "South");
    }

    public Object getObject() {
        return this.target;
    }

    public void setObject(Object object) {
        this.target = object;
        if (this.target == null) {
            this.loadedLabel.setText(JCustomizerBundle.string("jclass.chart.customizer.swing.Key295"));
        } else {
            this.loadedLabel.setText(this.target.toString());
            this.loadedLabel.invalidate();
            this.loadedLabel.getParent().validate();
        }
        if (this.hasPreview() && this.preview != null) {
            this.showPreview();
        }
    }

    public void setModel(Object object) {
        if (object == null) {
            return;
        }
        this.model = object;
    }

    public boolean hasPreview() {
        return true;
    }

    public void showPreview() {
        Object object = this.getObject();
        if (object == null) {
            if (this.preview != null) {
                this.remove((Component)this.preview);
                this.preview = object;
                JPropertyPage.resizeFrame(this);
                return;
            }
        } else {
            if (object instanceof JCChart) {
                this.preview = object;
                JCChart jCChart = (JCChart)object;
                if (this.preview instanceof Component) {
                    this.remove((Component)this.preview);
                }
                this.add((Component)jCChart, "Center");
                JPropertyPage.resizeFrame(this);
                return;
            }
            JCCustomizerPage.showError(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key279")) + ":" + object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            JCCustomizerPage.getFrame(this).dispose();
            return;
        }
        if (actionEvent.getSource() == this.addButton) {
            this.firePropertyChange("", null, this.getObject());
            ((Component)JCCustomizerPage.getFrame(this)).setVisible(false);
            return;
        }
        if (actionEvent.getSource() == this.previewButton) {
            this.showPreview();
            return;
        }
        if (actionEvent.getSource() == this.removeButton) {
            this.setObject(null);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (object2 instanceof Boolean) {
            ((Boolean)object2).booleanValue();
            if (object == this.paramCheck) {
                this.fileSelector.nameField.textField.setText("*.html");
                return;
            }
            if (object == this.serialCheck) {
                this.fileSelector.nameField.textField.setText("*.ser");
                return;
            }
        } else if (object == this.fileSelector.loadButton || object == this.fileSelector.nameField) {
            String string = this.fileSelector.getDirectory();
            String string2 = this.fileSelector.getFile();
            if (((Boolean)this.serialCheck.getValue()).booleanValue()) {
                this.loadSerialized(String.valueOf(string) + string2);
                return;
            }
            if (((Boolean)this.paramCheck.getValue()).booleanValue()) {
                this.loadParams(String.valueOf(string) + string2);
            }
        }
    }

    private void loadSerialized(String string) {
        if (string != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                Object object = objectInputStream.readObject();
                fileInputStream.close();
                this.setObject(object);
                return;
            }
            catch (Exception exception) {
                JCCustomizerPage.showError(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key296")) + ":\n" + exception);
                exception.printStackTrace(System.out);
                return;
            }
        }
    }

    private void loadParams(String string) {
        JCChart jCChart = null;
        if (this.getObject() instanceof JCChart) {
            jCChart = (JCChart)this.getObject();
        } else if (this.model instanceof JCChart) {
            jCChart = (JCChart)this.model;
        }
        if (jCChart != null) {
            jCChart.loadParams(string);
            this.setObject(jCChart);
            return;
        }
        JCCustomizerPage.showError(JCustomizerBundle.string("jclass.chart.customizer.swing.Key297"));
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(JLoadDialog.getPageTitle());
        serializable = new JLoadDialog();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((JLoadDialog)serializable).init();
        ((JLoadDialog)serializable).setObject(new JCChart());
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key298");
    }

    public static String getPageName() {
        return "JLoadDialog";
    }
}

