/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jclass.chart.customizer.swing.EndsWithFilter;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JFieldEditor;
import jclass.chart.customizer.swing.JPropertyPage;
import jclass.util.JCImageCreator;

public class JFileNameEditor
extends JPropertyPage
implements ActionListener,
PropertyEditor {
    public JFieldEditor dirField;
    public JFieldEditor nameField;
    public JButton loadButton;
    public JButton saveButton;
    private FilenameFilter filter;
    protected FileDialog loadDialog;
    protected FileDialog saveDialog;
    private String directory;
    private String filename;
    Vector listeners;
    private static String[] loadPixels = new String[]{"                    ", "           ddd      ", "          d   d d   ", "               dd   ", "   ...        ddd   ", "  .ccc.......       ", "  .ggggggggg.       ", "  .ggggggggg.       ", "  .gggg...........  ", "  .ggg.bbbbbbbbb.   ", "  .gg.bbbbbbbbb.    ", "  .g.bbbbbbbbb.     ", "  ..bbbbbbbbb.      ", "  ...........       ", "                    ", "                    "};
    private static String[] savePixels = new String[]{"                    ", "  dddrrrrrrrrrrddd  ", "  dcdrrrrrrrrrrdcd  ", "  dddccccccccccddd  ", "  dddcc.c..c.ccddd  ", "  dddccccccccccddd  ", "  dddcc...c..ccddd  ", "  dddccccccccccddd  ", "  dddcc..c.c.ccddd  ", "  ddddccccccccdddd  ", "  dddddddddddddddd  ", "  ddddaaaaaaaadddd  ", "  dddda..aaaaadddd  ", "  dddda..aaaaadddd  ", "  dddda..aaaaadddd  ", "   ddda..aaaaadddd  ", "    dddddddddddddd  ", "                    "};

    public void init() {
        super.init();
        this.setToolTipText(JFileNameEditor.getPageTitle());
        this.setLayout(new FlowLayout(0, 2, 2));
        this.dirField = new JFieldEditor("", 12);
        this.dirField.setBackground(JPropertyPage.textBG);
        this.dirField.addPropertyChangeListener(this);
        this.nameField = new JFieldEditor("", 12);
        this.nameField.setBackground(JPropertyPage.textBG);
        this.nameField.addPropertyChangeListener(this);
        this.add(this.nameField);
        this.loadButton = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key33"), new ImageIcon(JFileNameEditor.makeLoadImage(this)));
        this.loadButton.addActionListener(this);
        this.add(this.loadButton);
        this.saveButton = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key34"), new ImageIcon(JFileNameEditor.makeSaveImage(this)));
        this.saveButton.addActionListener(this);
        this.add(this.saveButton);
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFile() {
        return this.filename;
    }

    private void setDialogFile(FileDialog fileDialog, String string) {
        if (string == null == string.equals("")) {
            fileDialog.setFile("*");
        }
        if (string.indexOf(42) >= 0) {
            fileDialog.setFile(string);
            return;
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            fileDialog.setFilenameFilter(new EndsWithFilter(string.substring(n)));
        }
    }

    public void propertyChanged(Object object, Object object2) {
        boolean bl = false;
        if (object == this.dirField) {
            if (!((String)object2).equals(this.directory)) {
                this.directory = (String)object2;
                bl = true;
            }
        } else if (object == this.nameField) {
            if (object2 instanceof String) {
                this.filename = (String)object2;
            }
            bl = true;
        }
        if (bl) {
            if (object instanceof Component) {
                this.firePropertyChange((Component)object, null, this.getValue());
                return;
            }
            this.firePropertyChange("", null, this.getValue());
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        Vector vector;
        if (object != null && object.equals(object2)) {
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                Object var6_5 = null;
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        serializable = new PropertyChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < vector.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
            propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
            ++n;
        }
    }

    public void firePropertyChange(Component component, Object object, Object object2) {
        Vector vector;
        if (object != null && object.equals(object2)) {
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                Object var6_5 = null;
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        serializable = new PropertyChangeEvent(component, null, object, object2);
        int n = 0;
        while (n < vector.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
            propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
            ++n;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.loadButton) {
                if (this.loadDialog == null) {
                    this.loadDialog = new FileDialog((Frame)this.getDialogFrame(), JCustomizerBundle.string("jclass.chart.customizer.swing.Key35"), 0);
                }
                this.setDialogFile(this.loadDialog, this.nameField.textField.getText());
                this.loadDialog.show();
                this.directory = this.loadDialog.getDirectory();
                this.filename = this.loadDialog.getFile();
                boolean bl = false;
                if (this.directory != null && !this.directory.equals("") && !this.dirField.textField.getText().equals(this.directory)) {
                    this.dirField.textField.setText(this.directory);
                    bl = true;
                }
                if (this.filename != null && !this.filename.equals("") && !this.nameField.textField.getText().equals(this.filename)) {
                    this.nameField.textField.setText(this.filename);
                    bl = true;
                }
                if (bl) {
                    this.firePropertyChange(this.loadButton, null, this.getValue());
                    return;
                }
            } else if (jButton == this.saveButton) {
                if (this.saveDialog == null) {
                    this.saveDialog = new FileDialog((Frame)this.getDialogFrame(), JCustomizerBundle.string("jclass.chart.customizer.swing.Key36"), 1);
                    String string = this.nameField.textField.getText();
                    if (string.indexOf(42) >= 0) {
                        this.saveDialog.setFile(string);
                    }
                }
                this.setDialogFile(this.saveDialog, this.nameField.textField.getText());
                this.saveDialog.show();
                this.directory = this.saveDialog.getDirectory();
                this.filename = this.saveDialog.getFile();
                boolean bl = false;
                if (this.directory != null && !this.directory.equals("") && !this.dirField.textField.getText().equals(this.directory)) {
                    this.dirField.textField.setText(this.directory);
                    bl = true;
                }
                if (this.filename != null && !this.filename.equals("") && !this.nameField.textField.getText().equals(this.filename)) {
                    this.nameField.textField.setText(this.filename);
                    bl = true;
                }
                if (bl) {
                    this.firePropertyChange(this.saveButton, null, this.getValue());
                }
            }
        }
    }

    public void setValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            int n = string.lastIndexOf(47);
            if (n > 0) {
                this.dirField.setValue(string.substring(0, n));
            }
            this.nameField.setValue(string.substring(n + 1));
        }
    }

    public Object getValue() {
        return String.valueOf(this.directory) + this.filename;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public String getAsText() {
        return (String)this.getValue();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void setBackground(Color color) {
        if (this.dirField != null) {
            this.dirField.setBackground(color);
        }
        if (this.nameField != null) {
            this.nameField.setBackground(color);
        }
    }

    static Image makeLoadImage(Component component) {
        JCImageCreator jCImageCreator = new JCImageCreator(component, loadPixels[0].length(), loadPixels.length);
        jCImageCreator.setColor('.', new Color(0));
        jCImageCreator.setColor('g', new Color(65280));
        jCImageCreator.setColor('b', new Color(0x848400));
        jCImageCreator.setColor('c', new Color(0xFFFFFF));
        jCImageCreator.setColor('d', new Color(255));
        jCImageCreator.setPixels(loadPixels);
        return jCImageCreator.create();
    }

    static Image makeSaveImage(Component component) {
        JCImageCreator jCImageCreator = new JCImageCreator(component, savePixels[0].length(), savePixels.length);
        jCImageCreator.setColor('.', new Color(0));
        jCImageCreator.setColor('b', new Color(0x848400));
        jCImageCreator.setColor('c', new Color(0xFFFFFF));
        jCImageCreator.setColor('d', new Color(255));
        jCImageCreator.setPixels(savePixels);
        return jCImageCreator.create();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(JFileNameEditor.getPageTitle());
        serializable = new JFileNameEditor();
        ((JFileNameEditor)serializable).setBackground(Color.lightGray);
        ((JFileNameEditor)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key37");
    }

    public static String getPageName() {
        return "JFileNameEditor";
    }
}

