/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JPropertyPage;
import jclass.util.JCImageCreator;

public class JColorEditor
extends JPropertyPage
implements PropertyEditor,
ActionListener {
    private static String INHERIT_STRING = JCustomizerBundle.string("jclass.chart.customizer.swing.Key53");
    private JButton colorButton;
    private JPanel colorLabel;
    private JTextField colorField;
    private JColorChooser colorChooser;
    private JDialog colorChooserDialog;
    protected PropertyChangeSupport listeners;
    private static String[] rainbow = new String[]{"rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "              ", "              ", "              ", "  ..  ..  ..  ", "  ..  ..  ..  "};

    public JColorEditor() {
        this((Color)null);
    }

    public JColorEditor(Color color) {
        if (color == null) {
            this.getBackground();
        }
        this.setLayout(new FlowLayout(0, 2, 2));
        this.colorChooser = new JColorChooser();
        this.colorField = new JTextField("", 15);
        this.colorField.addActionListener(this);
        this.add(this.colorField);
        this.colorLabel = new JPanel();
        this.colorLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.add(this.colorLabel);
        this.colorButton = new JButton(new ImageIcon(JColorEditor.rainbowImage(this)));
        this.colorButton.addActionListener(this);
        this.add(this.colorButton);
        this.setValue(color);
    }

    public void setValue(Object object) {
        String string;
        Color color;
        if (object == null) {
            this.colorField.setText(INHERIT_STRING);
            this.colorLabel.setBackground(null);
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
            return;
        }
        if (object instanceof Color) {
            Color color2 = (Color)object;
            String string2 = this.getColorName(color2);
            this.colorField.setText(string2);
            this.colorLabel.setBackground(color2);
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
            this.colorChooser.setColor(color2);
            return;
        }
        if (object instanceof String && (color = JColorEditor.toColor(string = (String)object)) != null) {
            this.colorField.setText(string);
            this.colorLabel.setBackground(color);
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
            this.colorChooser.setColor(color);
        }
    }

    public Object getValue() {
        return this.colorLabel.getBackground();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.setColor((Color)this.getValue());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String getJavaInitializationString() {
        Color color = (Color)this.getValue();
        return "new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    public String getAsText() {
        return this.getJavaInitializationString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.colorChooserDialog == null) {
            this.colorChooserDialog = JColorChooser.createDialog(this.colorButton, "Choose Color", true, this.colorChooser, this, this);
        }
        return this.colorChooserDialog;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.colorField) {
            String string = this.colorField.getText();
            Color color = JColorEditor.toColor(string);
            if (color == null || string.equalsIgnoreCase("null") || string.indexOf(INHERIT_STRING) >= 0) {
                this.colorField.setText(INHERIT_STRING);
                this.colorLabel.setBackground(null);
                if (this.listeners != null) {
                    this.listeners.firePropertyChange("", null, null);
                }
            } else {
                this.colorLabel.setBackground(color);
                if (this.listeners != null) {
                    this.listeners.firePropertyChange("", null, this.getValue());
                }
            }
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
            return;
        }
        if (actionEvent.getSource() == this.colorButton) {
            if (this.colorChooserDialog == null) {
                this.colorChooserDialog = (JDialog)this.getCustomEditor();
            }
            this.colorChooser.setColor((Color)this.getValue());
            this.colorChooserDialog.show();
            return;
        }
        if (actionEvent.getSource() instanceof JButton && actionEvent.getActionCommand().compareTo("OK") == 0) {
            Color color = this.colorChooser.getColor();
            this.colorField.setText(this.getColorName(color));
            this.colorLabel.setBackground(color);
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
            if (this.listeners != null) {
                this.listeners.firePropertyChange("", null, this.getValue());
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    private String getColorName(Color color) {
        if (color == null) {
            return INHERIT_STRING;
        }
        if (color.equals(Color.black)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key54");
        }
        if (color.equals(Color.blue)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key55");
        }
        if (color.equals(Color.cyan)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key56");
        }
        if (color.equals(Color.darkGray)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key57");
        }
        if (color.equals(Color.gray)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key58");
        }
        if (color.equals(Color.green)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key59");
        }
        if (color.equals(Color.lightGray)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key60");
        }
        if (color.equals(Color.magenta)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key61");
        }
        if (color.equals(Color.orange)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key62");
        }
        if (color.equals(Color.pink)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key63");
        }
        if (color.equals(Color.red)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key64");
        }
        if (color.equals(Color.white)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key65");
        }
        if (color.equals(Color.yellow)) {
            return JCustomizerBundle.string("jclass.chart.customizer.swing.Key66");
        }
        return color.getRed() + "-" + color.getGreen() + "-" + color.getBlue();
    }

    private static Color toColor(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken("-");
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key54"))) {
            return Color.black;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key55"))) {
            return Color.blue;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key56"))) {
            return Color.cyan;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key57"))) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key58"))) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key59"))) {
            return Color.green;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key60"))) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key61"))) {
            return Color.magenta;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key62"))) {
            return Color.orange;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key63"))) {
            return Color.pink;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key64"))) {
            return Color.red;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key65"))) {
            return Color.white;
        }
        if (string2.equalsIgnoreCase(JCustomizerBundle.string("jclass.chart.customizer.swing.Key66"))) {
            return Color.yellow;
        }
        try {
            if (string2.startsWith("#")) {
                if (string2.length() >= 13) {
                    return new Color(Integer.valueOf(string2.substring(1, 5), 16) / 256, Integer.valueOf(string2.substring(5, 9), 16) / 256, Integer.valueOf(string2.substring(9, 13), 16) / 256);
                }
                if (string2.length() >= 7) {
                    return new Color(Integer.valueOf(string2.substring(1, 3), 16), Integer.valueOf(string2.substring(3, 5), 16), Integer.valueOf(string2.substring(5, 7), 16));
                }
                return new Color(Integer.valueOf(string2.substring(1), 16));
            }
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(stringTokenizer.nextToken("-"));
            int n3 = Integer.parseInt(stringTokenizer.nextToken("-"));
            return new Color(n, n2, n3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Image rainbowImage(Component component) {
        JCImageCreator jCImageCreator = new JCImageCreator(component, rainbow[0].length(), rainbow.length);
        jCImageCreator.setColor('.', new Color(0));
        jCImageCreator.setColor('r', new Color(0xFF0000));
        jCImageCreator.setColor('g', new Color(65280));
        jCImageCreator.setColor('b', new Color(255));
        jCImageCreator.setPixels(rainbow);
        return jCImageCreator.create();
    }
}

