/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.customizer.swing.JBooleanEditor;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JFieldEditor;
import jclass.chart.customizer.swing.JPropertyPage;
import jclass.util.JCVector;

public class DataViewLabelPage
extends JPropertyPage
implements ActionListener {
    private JTextArea pointLabelArea;
    private JButton applyPointLabels;
    private JTextArea setLabelArea;
    private JButton applySetLabels;
    private JBooleanEditor autoLabelCheck;
    private JFieldEditor otherSliceLabel;
    private JLabel otherSliceLabelLabel;
    private ChartDataView view;

    public void init() {
        super.init();
        this.setToolTipText(DataViewLabelPage.getPageTitle());
        this.setLayout(new GridLayout(1, 3));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setLabelArea = new JTextArea(null, 6, 20);
        jScrollPane.setPreferredSize(new Dimension(this.setLabelArea.getPreferredScrollableViewportSize()));
        jScrollPane.getViewport().add(this.setLabelArea);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(2, 2));
        jPanel.add((Component)new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key246")) + ":"), "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.applySetLabels = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key247"));
        this.applySetLabels.addActionListener(this);
        jPanel.add((Component)this.applySetLabels, "South");
        this.add(jPanel);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pointLabelArea = new JTextArea(null, 6, 20);
        jScrollPane2.setPreferredSize(new Dimension(this.pointLabelArea.getPreferredScrollableViewportSize()));
        jScrollPane2.getViewport().add(this.pointLabelArea);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(2, 2));
        jPanel2.add((Component)new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key248")) + ":"), "North");
        jPanel2.add((Component)jScrollPane2, "Center");
        this.applyPointLabels = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key247"));
        this.applyPointLabels.addActionListener(this);
        jPanel2.add((Component)this.applyPointLabels, "South");
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        this.autoLabelCheck = new JBooleanEditor(JCustomizerBundle.string("jclass.chart.customizer.swing.Key249"));
        this.autoLabelCheck.setBorder(BorderFactory.createEmptyBorder(10, 2, 0, 0));
        this.autoLabelCheck.addPropertyChangeListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(this.autoLabelCheck, gridBagConstraints);
        jPanel3.add(this.autoLabelCheck);
        this.otherSliceLabelLabel = new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key250")) + ":");
        this.otherSliceLabelLabel.setEnabled(false);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.otherSliceLabelLabel, gridBagConstraints);
        jPanel3.add(this.otherSliceLabelLabel);
        this.otherSliceLabel = new JFieldEditor("", 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(this.otherSliceLabel, gridBagConstraints);
        this.otherSliceLabel.addPropertyChangeListener(this);
        jPanel3.add(this.otherSliceLabel);
        this.add(jPanel3);
    }

    private String arrayToText(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setObject(Object object) {
        if (object instanceof ChartDataView) {
            this.view = (ChartDataView)object;
        }
        if (this.view != null) {
            ChartDataViewSeries[] chartDataViewSeriesArray = this.view.getSeries();
            String[] stringArray = new String[this.view.getNumSeries()];
            int n = 0;
            while (n < this.view.getNumSeries()) {
                stringArray[n] = chartDataViewSeriesArray[n].getLabel();
                ++n;
            }
            this.setLabelArea.setText(this.arrayToText(stringArray));
            String string = this.arrayToText(this.view.getPointLabels());
            this.pointLabelArea.setText(string);
            this.autoLabelCheck.setValue(new Boolean(this.view.getAutoLabel()));
            if (this.view.getChartType() == 11) {
                this.otherSliceLabel.setEnabled(true);
                this.otherSliceLabelLabel.setEnabled(true);
                this.otherSliceLabel.setValue(this.view.getPieChartFormat().getOtherLabel());
                return;
            }
            this.otherSliceLabel.setValue("");
            this.otherSliceLabel.setEnabled(false);
            this.otherSliceLabelLabel.setEnabled(false);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.view == null || object2 == null) {
            return;
        }
        if (object == this.autoLabelCheck) {
            this.view.setAutoLabel((Boolean)object2);
        }
        if (object instanceof JFieldEditor) {
            JFieldEditor jFieldEditor = (JFieldEditor)object;
            if (this.view.getChartType() == 11) {
                this.view.getPieChartFormat().setOtherLabel(jFieldEditor.textField.getText());
            }
            this.setObject();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.view == null) {
            return;
        }
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.applyPointLabels) {
                int n;
                String string = this.pointLabelArea.getText();
                int n2 = 0;
                JCVector jCVector = new JCVector();
                while ((n = string.indexOf(10, n2)) >= 0) {
                    if (n <= n2) {
                        ++n2;
                        continue;
                    }
                    jCVector.addElement(string.substring(n2, n));
                    n2 = n;
                }
                String[] stringArray = new String[jCVector.size()];
                int n3 = 0;
                while (n3 < jCVector.size()) {
                    stringArray[n3] = (String)jCVector.elementAt(n3);
                    ++n3;
                }
                this.view.setPointLabels(stringArray);
                this.setObject();
                return;
            }
            if (jButton == this.applySetLabels) {
                int n;
                String string = this.setLabelArea.getText();
                int n4 = 0;
                int n5 = 0;
                while ((n = string.indexOf(10, n4)) >= 0) {
                    if (n <= n4) {
                        ++n4;
                        continue;
                    }
                    this.view.getSeries(n5).setLabel(string.substring(n4, n));
                    n4 = n;
                    ++n5;
                }
                this.setObject();
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(DataViewLabelPage.getPageTitle());
        serializable = new DataViewLabelPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((DataViewLabelPage)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key251");
    }

    public static String getPageName() {
        return "DataViewLabelPage";
    }
}

