/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.JCChart;
import jclass.chart.JCCustomizerPage;
import jclass.chart.customizer.swing.JBooleanEditor;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JDoubleEditor;
import jclass.chart.customizer.swing.JFieldEditor;
import jclass.chart.customizer.swing.JPropertyPage;
import jclass.chart.customizer.swing.JSpinBox;

public class DataViewDataPage
extends JPropertyPage
implements AdjustmentListener {
    private JFieldEditor seriesNameField;
    private JFieldEditor seriesLabelField;
    private JDoubleEditor firstPointField;
    private JDoubleEditor lastPointField;
    private JDoubleEditor dataHoleField;
    private JSpinBox numPointsSpin;
    private JBooleanEditor isIncludedCheck;
    private JBooleanEditor isShowingCheck;
    private JBooleanEditor isShowingLegendCheck;
    private JDoubleEditor xValueField;
    private JDoubleEditor yValueField;
    private ChartDataView view;
    private ChartDataViewSeries series;
    private int currentSeries;
    private int currentPoint;

    public void init() {
        super.init();
        this.setToolTipText(DataViewDataPage.getPageTitle());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(new FlowLayout(1, 3, 3));
        jPanel.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key145")) + ":"));
        this.seriesNameField = new JFieldEditor("", 12);
        this.seriesNameField.addPropertyChangeListener(this);
        jPanel.add(this.seriesNameField);
        jPanel.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key267")) + ":"));
        this.seriesLabelField = new JFieldEditor("", 12);
        this.seriesLabelField.addPropertyChangeListener(this);
        jPanel.add(this.seriesLabelField);
        this.add((Component)jPanel, "North");
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key146")) + ":"));
        this.firstPointField = new JDoubleEditor(4);
        this.firstPointField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.firstPointField, gridBagConstraints);
        jPanel2.add(this.firstPointField);
        jPanel2.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key147")) + ":"));
        this.lastPointField = new JDoubleEditor(4);
        this.lastPointField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.lastPointField, gridBagConstraints);
        jPanel2.add(this.lastPointField);
        jPanel2.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key148")) + ":"));
        this.dataHoleField = new JDoubleEditor(8);
        this.dataHoleField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.dataHoleField, gridBagConstraints);
        jPanel2.add(this.dataHoleField);
        jPanel2.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key150")) + ":"));
        this.numPointsSpin = new JSpinBox();
        this.numPointsSpin.getScrollBar().addAdjustmentListener(this);
        gridBagLayout.setConstraints(this.numPointsSpin, gridBagConstraints);
        jPanel2.add(this.numPointsSpin);
        jPanel2.add(new JLabel("X " + JCustomizerBundle.string("jclass.chart.customizer.swing.Key97") + ":"));
        this.xValueField = new JDoubleEditor(8);
        this.xValueField.addPropertyChangeListener(this);
        this.xValueField.textField.setEditable(false);
        gridBagLayout.setConstraints(this.xValueField, gridBagConstraints);
        jPanel2.add(this.xValueField);
        jPanel2.add(new JLabel("Y " + JCustomizerBundle.string("jclass.chart.customizer.swing.Key97") + ":"));
        this.yValueField = new JDoubleEditor(8);
        this.yValueField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.yValueField, gridBagConstraints);
        jPanel2.add(this.yValueField);
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        this.isIncludedCheck = new JBooleanEditor(JCustomizerBundle.string("jclass.chart.customizer.swing.Key149"));
        this.isIncludedCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.isIncludedCheck, gridBagConstraints);
        jPanel3.add(this.isIncludedCheck);
        this.isShowingCheck = new JBooleanEditor(JCustomizerBundle.string("jclass.chart.customizer.swing.Key27"));
        this.isShowingCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.isShowingCheck, gridBagConstraints);
        jPanel3.add(this.isShowingCheck);
        this.isShowingLegendCheck = new JBooleanEditor(JCustomizerBundle.string("jclass.chart.customizer.swing.Key28"));
        this.isShowingLegendCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.isShowingLegendCheck, gridBagConstraints);
        jPanel3.add(this.isShowingLegendCheck);
        this.add((Component)jPanel3, "West");
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.view = ((JCChart)object).getDataView(0);
            this.setObject(this.view);
            return;
        }
        if (object instanceof ChartDataView) {
            this.view = (ChartDataView)object;
            if (this.view != null) {
                if (this.view.getHoleValue() == Double.MAX_VALUE) {
                    this.dataHoleField.textField.setText("Double.MAX");
                    return;
                }
                Double d = new Double(this.view.getHoleValue());
                this.dataHoleField.textField.setText(d.toString());
                return;
            }
        } else if (object instanceof ChartDataViewSeries) {
            double d;
            this.series = (ChartDataViewSeries)object;
            this.seriesNameField.setValue(this.series.getName());
            this.seriesLabelField.setValue(this.series.getLabel());
            int n = this.series.getFirstPoint();
            int n2 = this.series.getLastPoint();
            this.firstPointField.textField.setText(String.valueOf(n));
            this.lastPointField.textField.setText(String.valueOf(n2));
            this.isIncludedCheck.setValue(new Boolean(this.series.getIsIncluded()));
            this.isShowingCheck.setValue(new Boolean(this.series.getIsShowing()));
            this.isShowingLegendCheck.setValue(new Boolean(this.series.getIsShowingInLegend()));
            this.numPointsSpin.setIntValue(this.currentPoint);
            this.numPointsSpin.setMinimum(this.series.getFirstPoint());
            this.numPointsSpin.setMaximum(this.series.getLastPoint());
            try {
                d = this.series.getX(this.currentPoint);
                this.xValueField.setValue(new Double(d));
            }
            catch (Exception exception) {
                this.xValueField.textField.setText("");
            }
            try {
                d = this.series.getY(this.currentPoint);
                this.yValueField.setValue(new Double(d));
                return;
            }
            catch (Exception exception) {
                this.yValueField.textField.setText("");
                return;
            }
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.series == null || object2 == null) {
            return;
        }
        if (object == this.isIncludedCheck) {
            this.series.setIsIncluded((Boolean)object2);
            return;
        }
        if (object == this.isShowingCheck) {
            this.series.setIsShowing((Boolean)object2);
            return;
        }
        if (object == this.isShowingLegendCheck) {
            this.series.setIsShowingInLegend((Boolean)object2);
            return;
        }
        if (object == this.seriesNameField) {
            this.series.setName((String)object2);
            if (this.getParent() instanceof JPropertyPage) {
                JPropertyPage jPropertyPage = (JPropertyPage)this.getParent();
                jPropertyPage.setObject();
                jPropertyPage.repaint();
                return;
            }
        } else {
            if (object == this.seriesLabelField) {
                this.series.setLabel((String)object2);
                return;
            }
            if (object == this.yValueField) {
                int n = this.numPointsSpin.getIntValue();
                this.series.editPoint(n, (Double)object2);
                return;
            }
            if (object == this.dataHoleField && this.view != null) {
                double d;
                String string = (String)object2;
                if (string.indexOf("MAX") >= 0) {
                    d = Double.MAX_VALUE;
                } else {
                    Double d2 = new Double(string);
                    d = d2;
                }
                this.view.setHoleValue(d);
                return;
            }
            if (object == this.firstPointField) {
                Double d = (Double)object2;
                try {
                    this.series.setFirstPoint(d.intValue());
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JCCustomizerPage.showError(illegalArgumentException.getMessage());
                    return;
                }
            }
            if (object == this.lastPointField) {
                Double d = (Double)object2;
                try {
                    this.series.setLastPoint(d.intValue());
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JCCustomizerPage.showError(illegalArgumentException.getMessage());
                    return;
                }
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent != null && adjustmentEvent.getSource() == this.numPointsSpin.getScrollBar()) {
            this.numPointsSpin.setIntValue(adjustmentEvent.getValue());
            this.currentPoint = this.numPointsSpin.getIntValue();
            this.setObject(this.series);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(DataViewDataPage.getPageTitle());
        serializable = new DataViewDataPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((DataViewDataPage)serializable).init();
        ((DataViewDataPage)serializable).setObject(new JCChart());
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key151");
    }

    public static String getPageName() {
        return "DataViewDataPage";
    }
}

