/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jclass.chart.AxesOrientationImages;
import jclass.chart.ChartDataView;
import jclass.chart.JCChart;
import jclass.chart.JCCustomizerPage;
import jclass.chart.customizer.swing.JAddRemoveDialog;
import jclass.chart.customizer.swing.JBooleanEditor;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JPropertyPage;

public class AxisOrientPage
extends JPropertyPage
implements ActionListener,
ItemListener {
    private JBooleanEditor isInvertedCheck;
    private ButtonGroup orientBox;
    private JButton xAxisButton;
    private JButton yAxisButton;
    private JAddRemoveDialog dialog;
    private Object[] radioButtons;
    private JRadioButton currentButton;
    private ChartDataView target;

    public void init() {
        Serializable serializable;
        super.init();
        this.setToolTipText(AxisOrientPage.getPageTitle());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 2, 3));
        jPanel3.setLayout(new GridLayout(4, 2));
        jPanel3.setBorder(BorderFactory.createTitledBorder(JCustomizerBundle.string("jclass.chart.customizer.swing.Key224")));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        this.isInvertedCheck = new JBooleanEditor(JCustomizerBundle.string("jclass.chart.customizer.swing.Key223"));
        this.isInvertedCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.isInvertedCheck, gridBagConstraints);
        jPanel2.add(this.isInvertedCheck);
        int n = AxesOrientationImages.getOrientationImageLength();
        this.radioButtons = new Object[n];
        this.orientBox = new ButtonGroup();
        int n2 = 0;
        while (n2 < n) {
            serializable = new JRadioButton(new ImageIcon(AxesOrientationImages.getOrientationImage((Component)this, n2, AxesOrientationImages.ENABLED)));
            this.radioButtons[n2] = serializable;
            this.orientBox.add((AbstractButton)serializable);
            jPanel3.add((Component)serializable);
            ((AbstractButton)serializable).addItemListener(this);
            ++n2;
        }
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        serializable = new GridBagConstraints();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout2);
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets = new Insets(5, 5, 5, 5);
        ((GridBagConstraints)serializable).weightx = 1.0;
        this.xAxisButton = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key225"));
        this.xAxisButton.addActionListener(this);
        gridBagLayout2.setConstraints(this.xAxisButton, (GridBagConstraints)serializable);
        jPanel4.add(this.xAxisButton);
        this.yAxisButton = new JButton(JCustomizerBundle.string("jclass.chart.customizer.swing.Key226"));
        this.yAxisButton.addActionListener(this);
        gridBagLayout2.setConstraints(this.yAxisButton, (GridBagConstraints)serializable);
        jPanel4.add(this.yAxisButton);
        jPanel.add(jPanel4);
        this.add(jPanel);
    }

    public Object getObject() {
        return this.target;
    }

    public void setObject(Object object) {
        if (object instanceof ChartDataView) {
            this.target = (ChartDataView)object;
            boolean bl = this.target.getIsInverted();
            this.isInvertedCheck.setValue(new Boolean(bl));
            this.setViewOrient(this.target);
        }
    }

    void setViewOrient(ChartDataView chartDataView) {
        int n = AxesOrientationImages.viewToValue(chartDataView);
        int n2 = chartDataView.getIsInverted() ? 1 : 0;
        int n3 = 0;
        while (n3 < this.radioButtons.length) {
            int n4 = 0;
            while (n4 < 2) {
                JRadioButton jRadioButton = (JRadioButton)this.radioButtons[n3 + n4];
                if (n3 + n4 == n) {
                    if (this.currentButton != null) {
                        this.currentButton.setBorderPainted(false);
                    }
                    this.setCurrentButton(jRadioButton);
                }
                if (n2 == n4) {
                    jRadioButton.setIcon(new ImageIcon(AxesOrientationImages.getOrientationImage((Component)this, n3 + n4, AxesOrientationImages.ENABLED)));
                    jRadioButton.setEnabled(true);
                } else {
                    jRadioButton.setIcon(new ImageIcon(AxesOrientationImages.getOrientationImage((Component)this, n3 + n4, AxesOrientationImages.DISABLED)));
                    jRadioButton.setEnabled(false);
                }
                ++n4;
            }
            ++n3;
            ++n3;
        }
    }

    static Image getEnabledOrientationImage(Component component, int n) {
        return AxesOrientationImages.getOrientationImage(component, n, AxesOrientationImages.ENABLED);
    }

    static Image getEnabledOrientationImage(Component component, ChartDataView chartDataView) {
        return AxesOrientationImages.getOrientationImage(component, chartDataView, AxesOrientationImages.ENABLED);
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.target == null || object2 == null) {
            return;
        }
        if (object == this.isInvertedCheck) {
            boolean bl = (Boolean)object2;
            this.target.setIsInverted(bl);
            this.setObject();
            return;
        }
        if (object == this.dialog) {
            ((Component)JCCustomizerPage.getFrame(this.dialog)).setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.target == null) {
            return;
        }
        if (itemEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            if (jRadioButton == null || this.target == null) {
                return;
            }
            if (jRadioButton == this.currentButton) {
                return;
            }
            boolean bl = jRadioButton.isSelected();
            if (!bl) {
                return;
            }
            int n = this.getButtonIndex(jRadioButton);
            boolean bl2 = (n & 1) == 1;
            boolean bl3 = (n & 4) == 4;
            boolean bl4 = (n & 2) == 2;
            ChartDataView chartDataView = this.target;
            this.setCurrentButton(jRadioButton);
            chartDataView.setIsBatched(true);
            if (chartDataView.getXAxis() != null && chartDataView.getYAxis() != null) {
                if (bl2) {
                    chartDataView.getXAxis().setIsReversed(bl3);
                    chartDataView.getYAxis().setIsReversed(bl4);
                } else {
                    chartDataView.getYAxis().setIsReversed(bl3);
                    chartDataView.getXAxis().setIsReversed(bl4);
                }
            }
            chartDataView.setIsBatched(false);
            this.setObject();
        }
    }

    private void setCurrentButton(JRadioButton jRadioButton) {
        if (jRadioButton != null) {
            if (this.currentButton != null) {
                this.currentButton.setBorderPainted(false);
            }
            jRadioButton.setBorderPainted(true);
            this.currentButton = jRadioButton;
            this.currentButton.setSelected(true);
        }
    }

    private int getButtonIndex(JRadioButton jRadioButton) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.radioButtons.length) {
            if (this.radioButtons[n2] == jRadioButton) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.target == null) {
            return;
        }
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (this.dialog == null) {
                try {
                    this.dialog = (JAddRemoveDialog)this.getFramedPage("JCAxisDialog");
                }
                catch (Throwable throwable) {
                    this.dialog = null;
                }
                if (this.dialog == null) {
                    JCCustomizerPage.showError(JCustomizerBundle.string("jclass.chart.customizer.swing.Key228"));
                    jButton.setEnabled(false);
                } else {
                    this.dialog.addButton.setText(JCustomizerBundle.string("jclass.chart.customizer.swing.Key227"));
                    this.dialog.addPropertyChangeListener(this);
                }
            }
            if (this.dialog != null) {
                Frame frame = JCCustomizerPage.getFrame(this.dialog);
                if (jButton == this.xAxisButton) {
                    this.dialog.setObject(this.target.getXAxis());
                    frame.setTitle(JCustomizerBundle.string("jclass.chart.customizer.swing.Key229"));
                } else if (jButton == this.yAxisButton) {
                    this.dialog.setObject(this.target.getYAxis());
                    frame.setTitle(JCustomizerBundle.string("jclass.chart.customizer.swing.Key230"));
                }
                frame.pack();
                frame.show();
                frame.toFront();
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(AxisOrientPage.getPageTitle());
        serializable = new AxisOrientPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((AxisOrientPage)serializable).init();
        ((AxisOrientPage)serializable).setObject(new JCChart());
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key231");
    }

    public static String getPageName() {
        return "AxisOrientPage";
    }
}

