/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Component;
import java.awt.Frame;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCLabel;
import jclass.chart.ChartDataView;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCChart;
import jclass.chart.customizer.JCBooleanEditor;
import jclass.chart.customizer.JCIntegerEditor;
import jclass.chart.customizer.JCPropertyPage;

public class BarChartPage
extends JCPropertyPage {
    private JCBooleanEditor is100PercentCheck;
    private JCIntegerEditor clusterWidthField;
    private JCIntegerEditor clusterOverlapField;
    ChartDataView view;

    public void init() {
        this.setLayout(new JCAlignerLayout(2, 1, 3));
        this.add(new JCLabel("100 percent:"));
        this.is100PercentCheck = new JCBooleanEditor("");
        this.is100PercentCheck.addPropertyChangeListener(this);
        this.add(this.is100PercentCheck);
        this.add(new JCLabel("Cluster Width:"));
        this.clusterWidthField = new JCIntegerEditor(4);
        this.clusterWidthField.addPropertyChangeListener(this);
        this.clusterWidthField.setBackground(JCPropertyPage.textBG);
        this.clusterWidthField.setMaximum(100);
        this.add(this.clusterWidthField);
        this.add(new JCLabel("Cluster Overlap:"));
        this.clusterOverlapField = new JCIntegerEditor(4);
        this.clusterOverlapField.addPropertyChangeListener(this);
        this.clusterOverlapField.setBackground(JCPropertyPage.textBG);
        this.clusterOverlapField.setMinimum(-100);
        this.clusterOverlapField.setMaximum(100);
        this.add(this.clusterOverlapField);
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.view = ((JCChart)object).getDataView(0);
        } else if (object instanceof ChartDataView) {
            this.view = (ChartDataView)object;
        }
        if (this.view != null && (this.view.getChartType() == 9 || this.view.getChartType() == 10)) {
            JCBarChartFormat jCBarChartFormat = this.view.getBarChartFormat();
            if (jCBarChartFormat != null) {
                this.is100PercentCheck.setValue(new Boolean(jCBarChartFormat.get100Percent()));
                this.is100PercentCheck.enable();
                this.clusterWidthField.setValue(new Integer(jCBarChartFormat.getClusterWidth()));
                ((Component)this.clusterWidthField).enable();
                this.clusterOverlapField.setValue(new Integer(jCBarChartFormat.getClusterOverlap()));
                ((Component)this.clusterOverlapField).enable();
                return;
            }
        } else {
            this.is100PercentCheck.disable();
            ((Component)this.clusterWidthField).disable();
            ((Component)this.clusterOverlapField).disable();
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.view == null) {
            return;
        }
        if (object == this.is100PercentCheck) {
            boolean bl = (Boolean)object2;
            this.view.getBarChartFormat().set100Percent(bl);
            return;
        }
        if (object == this.clusterWidthField) {
            Integer n = (Integer)object2;
            this.view.getBarChartFormat().setClusterWidth(n);
            return;
        }
        if (object == this.clusterOverlapField) {
            Integer n = (Integer)object2;
            this.view.getBarChartFormat().setClusterOverlap(n);
        }
    }

    public static void main(String[] stringArray) {
        String string = BarChartPage.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(BarChartPage.getPageTitle());
        jCPropertyPage.setObject(new JCChart());
    }

    public static String getPageTitle() {
        return "Bar Chart Specific Property Page";
    }

    public static String getPageName() {
        return "BarChartPage";
    }
}

