/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import jclass.chart.JCChartBundle;
import jclass.chart.bean.GroupPanel;

public abstract class RadioEditor
extends Panel
implements PropertyEditor,
ItemListener {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected CheckboxGroup radioG;
    protected Checkbox[] radioB;
    int radioSel = -1;
    String[] radioNames;
    String radioTitle;
    String propertyTitle;
    Object valueObj;

    public RadioEditor(String string, String[] stringArray) {
        this.radioNames = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.radioNames, 0, stringArray.length);
        this.radioTitle = string;
        this.init();
    }

    protected void init() {
        if (this.radioNames == null) {
            return;
        }
        this.setLayout(new BorderLayout());
        GroupPanel groupPanel = new GroupPanel(this.radioTitle);
        groupPanel.setLayout(new GridLayout(1, this.radioNames.length));
        this.radioG = new CheckboxGroup();
        this.radioB = new Checkbox[this.radioNames.length];
        int n = 0;
        while (n < this.radioNames.length) {
            this.radioB[n] = new Checkbox(this.radioNames[n]);
            this.radioB[n].setCheckboxGroup(this.radioG);
            groupPanel.add(this.radioB[n]);
            this.radioB[n].addItemListener(this);
            ++n;
        }
        this.radioG.setSelectedCheckbox(this.radioB[0]);
        this.add("North", groupPanel);
        Panel panel = this.makePropertyPanel();
        if (panel != null) {
            this.add("Center", panel);
        }
    }

    protected abstract Panel makePropertyPanel();

    public void setValue(Object object) {
        this.valueObj = object;
    }

    protected void switchItem(Checkbox checkbox) {
        if (this.radioB == null) {
            return;
        }
        int n = 0;
        while (n < this.radioB.length) {
            if (checkbox == this.radioB[n]) {
                this.radioSel = n;
                this.switchValues(this.radioSel);
                return;
            }
            ++n;
        }
    }

    protected abstract void switchValues(int var1);

    public Object getValue() {
        return this.valueObj;
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return "Click to edit...";
    }

    public String[] getTags() {
        return null;
    }

    public String getJavaInitializationString() {
        return "\"" + this.valueObj + "\"";
    }

    public Dimension preferredSize() {
        Dimension dimension = new Dimension(200, 0);
        return dimension;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBundle.string("jclass.chart.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)object;
            if (itemEvent.getStateChange() == 1) {
                boolean bl = false;
                if (bl) {
                    checkbox.setState(true);
                }
                this.switchItem(checkbox);
            }
        }
    }

    public void setIntIsDefProperty(String string, int[] nArray, boolean[] blArray, int n) {
        String string2 = this.checkForEmptyString(string);
        if (string2 == null) {
            if (!blArray[n]) {
                blArray[n] = true;
                nArray[n] = Integer.MAX_VALUE;
                this.support.firePropertyChange("", null, null);
                return;
            }
        } else {
            int n2 = Integer.valueOf(string2);
            if (n2 != nArray[n]) {
                nArray[n] = n2;
                blArray[n] = false;
                this.support.firePropertyChange("", null, null);
            }
        }
    }

    public void setIntProperty(String string, int[] nArray, int n) {
        this.setIntProperty(string, nArray, n, 0);
    }

    public void setIntProperty(String string, int[] nArray, int n, int n2) {
        String string2 = this.checkForEmptyString(string);
        int n3 = string2 != null ? Integer.valueOf(string2) : n2;
        if (n3 != nArray[n]) {
            nArray[n] = n3;
            this.support.firePropertyChange("", null, null);
        }
    }

    public void setDoubleIsDefProperty(String string, double[] dArray, boolean[] blArray, int n) {
        String string2 = this.checkForEmptyString(string);
        if (string2 == null) {
            if (!blArray[n]) {
                blArray[n] = true;
                dArray[n] = Double.MAX_VALUE;
                this.support.firePropertyChange("", null, null);
                return;
            }
        } else {
            double d = Double.valueOf(string2);
            if (d != dArray[n]) {
                dArray[n] = d;
                blArray[n] = false;
                this.support.firePropertyChange("", null, null);
            }
        }
    }

    public void setDoubleProperty(String string, double[] dArray, int n) {
        this.setDoubleProperty(string, dArray, n, 0.0);
    }

    public void setDoubleProperty(String string, double[] dArray, int n, double d) {
        String string2 = this.checkForEmptyString(string);
        double d2 = string2 != null ? Double.valueOf(string2) : d;
        if (d2 != dArray[n]) {
            dArray[n] = d2;
            this.support.firePropertyChange("", null, null);
        }
    }

    public void setStringIsDefProperty(String string, String[] stringArray, boolean[] blArray, int n) {
        String string2 = this.checkForEmptyString(string);
        if (string2 == null) {
            if (!blArray[n]) {
                blArray[n] = true;
                stringArray[n] = "";
                this.support.firePropertyChange("", null, null);
                return;
            }
        } else if (!string2.equals(stringArray[n])) {
            stringArray[n] = string2;
            blArray[n] = false;
            this.support.firePropertyChange("", null, null);
        }
    }

    public String checkForEmptyString(String string) {
        String string2;
        String string3 = string2 = string == null ? null : string.trim();
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return string2;
    }
}

