/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import jclass.beans.GroupPanel;
import jclass.chart.JCChartBundle;
import jclass.util.JCString;
import jclass.util.JCStringComponent;
import jclass.util.JCUtilConverter;

public class RadioButtonImageEditor
extends Panel
implements PropertyEditor,
ItemListener {
    transient Image[] images;
    String[] strings;
    int[] values;
    String prepend = "";
    int rows;
    int cols;
    int numImages;
    boolean upperCaseEnum = true;
    int selectedValue;
    Checkbox[] cbList;
    CheckboxGroup orientBox;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public void init(int n, String[] stringArray, int[] nArray, Image[] imageArray, int n2, int n3, String string) {
        this.numImages = n;
        this.strings = stringArray;
        this.values = nArray;
        this.images = imageArray;
        this.rows = n2;
        this.cols = n3;
        this.prepend = string;
        this.init();
    }

    protected void init() {
        this.setLayout(new GridLayout(1, 1));
        GroupPanel groupPanel = new GroupPanel(JCChartBundle.string("jclass.chart.Key174"));
        groupPanel.setLayout(new GridLayout(this.rows, this.cols));
        Object[] objectArray = new Object[this.numImages];
        int n = 0;
        while (n < this.numImages) {
            JCString jCString = new JCString("");
            jCString.add(this.images[n]);
            objectArray[n] = jCString;
            ++n;
        }
        this.orientBox = new CheckboxGroup();
        this.cbList = new Checkbox[objectArray.length];
        int n2 = 0;
        while (n2 < this.cbList.length) {
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout());
            this.cbList[n2] = new Checkbox();
            this.cbList[n2].setCheckboxGroup(this.orientBox);
            this.cbList[n2].setCheckboxGroup(this.orientBox);
            this.cbList[n2].addItemListener(this);
            panel.add(this.cbList[n2]);
            JCStringComponent jCStringComponent = new JCStringComponent((JCString)objectArray[n2]);
            panel.add(jCStringComponent);
            groupPanel.add(panel);
            ++n2;
        }
        this.add(groupPanel);
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return "Click to edit...";
    }

    public String[] getTags() {
        return null;
    }

    public String getJavaInitializationString() {
        if (this.getValue() == null) {
            return "NULL";
        }
        if (this.upperCaseEnum) {
            return String.valueOf(this.prepend) + this.getValueAsText().toUpperCase();
        }
        return String.valueOf(this.prepend) + this.getValueAsText();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBundle.string("jclass.chart.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Object getValue() {
        return new Integer(this.selectedValue);
    }

    protected String getValueAsText() {
        return JCUtilConverter.fromEnum(this.selectedValue, this.strings, this.values);
    }

    public void setValue(Object object) {
        this.setSelectedValue(((Number)object).intValue(), true, true);
    }

    protected void setSelectedValue(int n, boolean bl) {
        this.selectedValue = n;
        if (bl) {
            int n2 = 0;
            while (n2 < this.cbList.length) {
                if (this.values[n2] == n) {
                    this.orientBox.setSelectedCheckbox(this.cbList[n2]);
                    return;
                }
                ++n2;
            }
        }
    }

    protected void setSelectedValue(int n, boolean bl, boolean bl2) {
        this.setSelectedValue(n, bl);
        if (bl2) {
            this.support.firePropertyChange("", null, null);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof Checkbox) {
            boolean bl;
            Checkbox checkbox = (Checkbox)itemEvent.getSource();
            if (checkbox == null) {
                return;
            }
            boolean bl2 = bl = checkbox.getState();
            if (!bl) {
                return;
            }
            if (checkbox.getCheckboxGroup() == this.orientBox) {
                int n = 0;
                while (n < this.cbList.length) {
                    if (this.cbList[n] == checkbox) {
                        this.setSelectedValue(this.values[n], false, true);
                        return;
                    }
                    ++n;
                }
            }
        }
    }
}

