/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jclass.chart.JCChartBundle;
import jclass.chart.bean.ColorEditable;
import jclass.chart.bean.ColorSample;
import jclass.chart.bean.GroupPanel;

public class ColorDialog
extends Dialog
implements ActionListener,
TextListener {
    ColorEditable editor;
    Component tag;
    private TextField red;
    private TextField green;
    private TextField blue;
    private ColorSample sample;
    private Button buttonOK;

    ColorDialog(ColorEditable colorEditable, String string, Component component) {
        super(colorEditable.findParent(), string == null ? JCChartBundle.string("jclass.chart.Key206") : string, true);
        this.editor = colorEditable;
        this.tag = component;
        Color color = colorEditable.getColor(this.tag);
        if (color == null) {
            color = Color.black;
        }
        this.red = new TextField(String.valueOf(color.getRed()), 4);
        this.green = new TextField(String.valueOf(color.getGreen()), 4);
        this.blue = new TextField(String.valueOf(color.getBlue()), 4);
        GroupPanel groupPanel = new GroupPanel(JCChartBundle.string("jclass.chart.Key283"));
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel.add((Component)new Label("Red"), gridBagConstraints);
        groupPanel.add((Component)this.red, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new Label("Green"), gridBagConstraints);
        groupPanel.add((Component)this.green, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new Label("Blue"), gridBagConstraints);
        groupPanel.add((Component)this.blue, gridBagConstraints);
        this.sample = new ColorSample(color);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this.sample);
        this.buttonOK = new Button(JCChartBundle.string("jclass.chart.Key284"));
        Button button = new Button(JCChartBundle.string("jclass.chart.Key285"));
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(2));
        panel2.add(this.buttonOK);
        panel2.add(button);
        this.setLayout(new BorderLayout(10, 4));
        this.add("Center", groupPanel);
        this.add("East", panel);
        this.add("South", panel2);
        this.red.addTextListener(this);
        this.green.addTextListener(this);
        this.blue.addTextListener(this);
        button.addActionListener(this);
        this.buttonOK.addActionListener(this);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonOK) {
            this.editor.selectColor(this.sample.getColor(), this.tag);
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
        return super.handleEvent(event);
    }

    public void textValueChanged(TextEvent textEvent) {
        this.sample.setColor(new Color(this.getColor(this.red), this.getColor(this.green), this.getColor(this.blue)));
    }

    private int getColor(TextField textField) {
        try {
            int n = new Integer(textField.getText());
            if (n < 0) {
                n = 0;
            }
            if (n > 255) {
                n = 255;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

