/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Point;
import jclass.chart.ActionHandler;
import jclass.chart.ErrorDialog;
import jclass.chart.JCAxis;
import jclass.chart.JCChartBundle;

class TranslateHandler
extends ActionHandler {
    JCAxis xAxis;
    JCAxis yAxis;
    Point last;
    double xRange;
    double yRange;

    TranslateHandler() {
    }

    void start(int n, int n2) {
        if (this.parent.horizActionAxis != null && this.parent.vertActionAxis != null && this.parent.horizActionAxis.getIsVertical() == this.parent.vertActionAxis.getIsVertical()) {
            ErrorDialog.raise(JCChartBundle.string("jclass.chart.Key45"));
            return;
        }
        this.parent.inAction = true;
        this.last = new Point(n, n2);
        if (this.parent.horizActionAxis != null) {
            if (this.parent.horizActionAxis.getIsVertical()) {
                this.yAxis = this.parent.horizActionAxis;
            } else {
                this.xAxis = this.parent.horizActionAxis;
            }
        }
        if (this.parent.vertActionAxis != null) {
            if (this.parent.vertActionAxis.getIsVertical()) {
                this.yAxis = this.parent.vertActionAxis;
            } else {
                this.xAxis = this.parent.vertActionAxis;
            }
        }
        if (this.xAxis != null && this.xAxis.isEditable && this.getChart() != null) {
            this.getChart().translateStart(this.xAxis);
        }
        if (this.yAxis != null && this.yAxis.isEditable && this.getChart() != null) {
            this.getChart().translateStart(this.yAxis);
        }
        if (this.xAxis != null) {
            this.xRange = this.xAxis.range();
        }
        if (this.yAxis != null) {
            this.yRange = this.yAxis.range();
        }
    }

    void animate(int n, int n2) {
        double d;
        int n3;
        if (this.last == null) {
            return;
        }
        boolean bl = false;
        if (this.xAxis != null && this.xAxis.isEditable && (n3 = 100 * (this.last.x - n) / this.parent.plotRect.width) != 0) {
            d = this.xRange * (double)n3 / 100.0;
            if (this.getChart() != null) {
                this.getChart().translate(d, this.xAxis, false);
            }
            bl = true;
            this.last.x = n;
        }
        if (this.yAxis != null && this.yAxis.isEditable && (n3 = 100 * (n2 - this.last.y) / this.parent.plotRect.height) != 0) {
            d = this.yRange * (double)n3 / 100.0;
            if (this.getChart() != null) {
                this.getChart().translate(d, this.yAxis, false);
            }
            bl = true;
            this.last.y = n2;
        }
        if (bl) {
            this.parent.setChanged(true, 2);
        }
    }

    void reanimate(int n, int n2) {
    }

    void end(int n, int n2) {
        this.parent.inAction = false;
        if (this.parent.fastAction) {
            this.parent.setChanged(true, 2);
        }
    }
}

