/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.table.TableModel;
import jclass.chart.AppearanceWrapper;
import jclass.chart.AxisAnnoWrapper;
import jclass.chart.AxisGridWrapper;
import jclass.chart.AxisInfoWrapper;
import jclass.chart.AxisMiscWrapper;
import jclass.chart.AxisOrientationWrapper;
import jclass.chart.AxisOriginWrapper;
import jclass.chart.AxisPlacementWrapper;
import jclass.chart.AxisPointLabelWrapper;
import jclass.chart.AxisRelationshipWrapper;
import jclass.chart.AxisScaleWrapper;
import jclass.chart.AxisTimeLabelWrapper;
import jclass.chart.AxisTitleWrapper;
import jclass.chart.AxisValueLabelWrapper;
import jclass.chart.ChartDataSupport;
import jclass.chart.ChartDataView;
import jclass.chart.ChartRegion;
import jclass.chart.ChartSwingDataSource;
import jclass.chart.Chartable;
import jclass.chart.EventTrigger;
import jclass.chart.FileDataSource;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartBundle;
import jclass.chart.LegendWrapper;
import jclass.chart.MultiDataChartWrapper;
import jclass.chart.MultiDataMiscWrapper;
import jclass.chart.MultiDataSourceWrapper;
import jclass.chart.PlotArea;
import jclass.chart.StringDataSource;
import jclass.chart.TitleWrapper;
import jclass.chart.TriggerWrapper;
import jclass.chart.URLDataSource;
import jclass.chart.VectorDataSource;

public class MultiChart
extends JCChart {
    public static final String[] AXIS_RADIO_NAMES = new String[]{String.valueOf(JCChartBundle.string("jclass.chart.Key259")) + " 1", String.valueOf(JCChartBundle.string("jclass.chart.Key260")) + " 1", String.valueOf(JCChartBundle.string("jclass.chart.Key259")) + " 2", String.valueOf(JCChartBundle.string("jclass.chart.Key260")) + " 2"};
    public static final String[] AXIS_RADIO_IDS = new String[]{"x1", "y1", "x2", "y2"};
    public static final String AXIS_RADIO_TITLE = JCChartBundle.string("jclass.chart.Key288");
    public static final String[] DATA_RADIO_NAMES = new String[]{String.valueOf(JCChartBundle.string("jclass.chart.Key287")) + " 1", String.valueOf(JCChartBundle.string("jclass.chart.Key287")) + " 2"};
    public static final String[] DATA_RADIO_IDS = new String[]{"data1", "data2"};
    public static final String DATA_RADIO_TITLE = JCChartBundle.string("jclass.chart.Key289");
    public static final int ORIENT_X_NORMAL_Y_NORMAL = 0;
    public static final int ORIENT_X_REVERSED_Y_NORMAL = 1;
    public static final int ORIENT_X_NORMAL_Y_REVERSED = 2;
    public static final int ORIENT_X_REVERSED_Y_REVERSED = 3;
    public static final int ORIENT_INVERTED_X_NORMAL_Y_NORMAL = 4;
    public static final int ORIENT_INVERTED_X_REVERSED_Y_NORMAL = 5;
    public static final int ORIENT_INVERTED_X_NORMAL_Y_REVERSED = 6;
    public static final int ORIENT_INVERTED_X_REVERSED_Y_REVERSED = 7;
    public static final int[] axesOrientationValues;
    public static final String[] axesOrientationStrings;
    public static final int OBJ_UNKNOWN = -1;
    public static final int OBJ_CHART_REGION = 0;
    public static final int OBJ_PLOT_AREA = 1;
    public static final int OBJ_CHART = 2;
    JCAxis[] axisArray;
    ChartDataView[] dataViewArray;
    String[] data;
    String[] dataOther = new String[2];
    public TableModel tableModel;
    public TableModel tableModel2;
    public ChartDataSupport dataSource;
    public ChartDataSupport dataSource2;

    public MultiChart() {
        this.dataOther[0] = "";
        this.dataOther[1] = "";
        this.data = new String[2];
        this.setData(new VectorDataSource().buildDataSourceString(), 0);
        this.setData(new VectorDataSource().buildDataSourceString(), 1);
        JCAxis jCAxis = new JCAxis();
        jCAxis.setIsShowing(false);
        jCAxis.setIsEditable(false);
        JCAxis jCAxis2 = new JCAxis();
        jCAxis2.setIsVertical(true);
        jCAxis2.setIsShowing(false);
        jCAxis2.setIsEditable(false);
        this.getChartArea().setXAxis(1, jCAxis);
        this.getChartArea().setYAxis(1, jCAxis2);
        this.axisArray = new JCAxis[4];
        this.axisArray[0] = this.getChartArea().getXAxis(0);
        this.axisArray[1] = this.getChartArea().getYAxis(0);
        this.axisArray[2] = jCAxis;
        this.axisArray[3] = jCAxis2;
        this.setTrigger(0, new EventTrigger(0, -1));
        this.setTrigger(1, new EventTrigger(1, -1));
        this.setTrigger(2, new EventTrigger(2, -1));
        this.setTrigger(3, new EventTrigger(8, -1));
        this.setTrigger(4, new EventTrigger(4, -1));
        this.dataViewArray = this.getDataView();
        this.dataViewArray[1].setXAxis(this.axisArray[0]);
        this.dataViewArray[1].setYAxis(this.axisArray[1]);
        this.dataViewArray[0].setChartType(9);
        this.axisArray[0].setAnnotationMethod(0);
    }

    public MultiDataSourceWrapper getDataSource() {
        MultiDataSourceWrapper multiDataSourceWrapper = new MultiDataSourceWrapper();
        multiDataSourceWrapper.setWrapperValues(this.dataViewArray);
        multiDataSourceWrapper.data[0] = this.getData(0);
        multiDataSourceWrapper.data[1] = this.getData(1);
        multiDataSourceWrapper.data_other[0] = this.dataOther[0];
        multiDataSourceWrapper.data_other[1] = this.dataOther[1];
        return multiDataSourceWrapper;
    }

    public void setDataSource(MultiDataSourceWrapper multiDataSourceWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            int n = 0;
            while (n < multiDataSourceWrapper.data.length) {
                this.setData(multiDataSourceWrapper.data[n], n);
                ++n;
            }
            this.dataOther[0] = multiDataSourceWrapper.data_other[0];
            this.dataOther[1] = multiDataSourceWrapper.data_other[1];
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    String getData(int n) {
        if (this.data[n] == null) {
            this.data[n] = new String("");
        }
        return this.data[n];
    }

    void setData(String string, int n) {
        if (this.getDataView(n) == null) {
            this.setDataView(n, new ChartDataView());
        }
        if (string == null || string.equals("")) {
            this.getDataView(n).setDataSource(null);
        } else if (string.indexOf("http") != -1) {
            try {
                this.getDataView(n).setDataSource(new URLDataSource(string));
            }
            catch (Exception exception) {
                this.getDataView(n).setDataSource(null);
            }
        } else {
            try {
                this.getDataView(n).setDataSource(new FileDataSource(string));
            }
            catch (Exception exception) {
                try {
                    this.getDataView(n).setDataSource(new StringDataSource(string));
                }
                catch (Exception exception2) {
                    this.getDataView(n).setDataSource(null);
                }
            }
        }
        this.data[n] = string;
    }

    public MultiDataChartWrapper getDataChart() {
        MultiDataChartWrapper multiDataChartWrapper = new MultiDataChartWrapper();
        multiDataChartWrapper.setWrapperValues(this.dataViewArray);
        int n = 0;
        while (n < this.dataViewArray.length) {
            multiDataChartWrapper.xaxis[n] = this.findAxisIndex(this.dataViewArray[n].getXAxis());
            multiDataChartWrapper.yaxis[n] = this.findAxisIndex(this.dataViewArray[n].getYAxis());
            ++n;
        }
        return multiDataChartWrapper;
    }

    public void setDataChart(MultiDataChartWrapper multiDataChartWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            multiDataChartWrapper.setPropertyValues(this.dataViewArray);
            int n = 0;
            while (n < this.dataViewArray.length) {
                if (multiDataChartWrapper.xaxis[n] == -1) {
                    this.dataViewArray[n].setXAxis(null);
                } else {
                    this.dataViewArray[n].setXAxis(this.axisArray[multiDataChartWrapper.xaxis[n]]);
                }
                if (multiDataChartWrapper.yaxis[n] == -1) {
                    this.dataViewArray[n].setYAxis(null);
                } else {
                    this.dataViewArray[n].setYAxis(this.axisArray[multiDataChartWrapper.yaxis[n]]);
                }
                ++n;
            }
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public MultiDataMiscWrapper getDataMisc() {
        MultiDataMiscWrapper multiDataMiscWrapper = new MultiDataMiscWrapper();
        multiDataMiscWrapper.setWrapperValues(this.dataViewArray);
        return multiDataMiscWrapper;
    }

    public void setDataMisc(MultiDataMiscWrapper multiDataMiscWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            multiDataMiscWrapper.setPropertyValues(this.dataViewArray);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets insets) {
        this.margins = insets;
        this.setChanged(true, 4);
    }

    public String getView3D() {
        JCChartArea jCChartArea = this.getChartArea();
        return jCChartArea.getDepth() + "," + jCChartArea.getElevation() + "," + jCChartArea.getRotation();
    }

    public void setView3D(String string) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            JCChartArea jCChartArea = this.getChartArea();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = 0;
            while (n < 3) {
                int n2 = 0;
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                }
                switch (n) {
                    case 0: {
                        jCChartArea.setDepth(n2);
                        break;
                    }
                    case 1: {
                        jCChartArea.setElevation(n2);
                        break;
                    }
                    case 2: {
                        jCChartArea.setRotation(n2);
                        break;
                    }
                }
                ++n;
            }
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AxisMiscWrapper getAxisMisc() {
        AxisMiscWrapper axisMiscWrapper = new AxisMiscWrapper();
        axisMiscWrapper.setWrapperValues(this.axisArray);
        return axisMiscWrapper;
    }

    public void setAxisMisc(AxisMiscWrapper axisMiscWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisMiscWrapper.setPropertyValues(this.axisArray);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AxisScaleWrapper getAxisScale() {
        AxisScaleWrapper axisScaleWrapper = new AxisScaleWrapper();
        axisScaleWrapper.setWrapperValues(this.axisArray);
        return axisScaleWrapper;
    }

    public void setAxisScale(AxisScaleWrapper axisScaleWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisScaleWrapper.setPropertyValues(this.axisArray);
            this.setIsBatched(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        axisScaleWrapper.setWrapperValues(this.axisArray);
    }

    public AxisAnnoWrapper getAxisAnnotations() {
        AxisAnnoWrapper axisAnnoWrapper = new AxisAnnoWrapper();
        axisAnnoWrapper.setWrapperValues(this.axisArray);
        return axisAnnoWrapper;
    }

    public void setAxisAnnotations(AxisAnnoWrapper axisAnnoWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisAnnoWrapper.setPropertyValues(this.axisArray);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AxisTimeLabelWrapper getAxisTimeLabels() {
        AxisTimeLabelWrapper axisTimeLabelWrapper = new AxisTimeLabelWrapper();
        if (axisTimeLabelWrapper == null) {
            axisTimeLabelWrapper = new AxisTimeLabelWrapper();
        }
        axisTimeLabelWrapper.setWrapperValues(this.axisArray);
        return axisTimeLabelWrapper;
    }

    public void setAxisTimeLabels(AxisTimeLabelWrapper axisTimeLabelWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisTimeLabelWrapper.setPropertyValues(this.axisArray);
            this.setIsBatched(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        axisTimeLabelWrapper.setWrapperValues(this.axisArray);
    }

    public AxisValueLabelWrapper getAxisValueLabels() {
        AxisValueLabelWrapper axisValueLabelWrapper = new AxisValueLabelWrapper();
        axisValueLabelWrapper.setWrapperValues(this.axisArray);
        return axisValueLabelWrapper;
    }

    public void setAxisValueLabels(AxisValueLabelWrapper axisValueLabelWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisValueLabelWrapper.setPropertyValues(this.axisArray);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AxisPointLabelWrapper getAxisPointLabels() {
        AxisPointLabelWrapper axisPointLabelWrapper = new AxisPointLabelWrapper();
        axisPointLabelWrapper.setWrapperValues(this.axisArray);
        return axisPointLabelWrapper;
    }

    public void setAxisPointLabels(AxisPointLabelWrapper axisPointLabelWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisPointLabelWrapper.setPropertyValues(this.axisArray);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AxisTitleWrapper getAxisTitle() {
        AxisTitleWrapper axisTitleWrapper = new AxisTitleWrapper();
        axisTitleWrapper.setWrapperValues(this.axisArray);
        return axisTitleWrapper;
    }

    public void setAxisTitle(AxisTitleWrapper axisTitleWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisTitleWrapper.setPropertyValues(this.axisArray);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AxisGridWrapper getAxisGrid() {
        AxisGridWrapper axisGridWrapper = new AxisGridWrapper();
        axisGridWrapper.setWrapperValues(this.axisArray);
        return axisGridWrapper;
    }

    public void setAxisGrid(AxisGridWrapper axisGridWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisGridWrapper.setPropertyValues(this.axisArray);
            this.setIsBatched(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        axisGridWrapper.setWrapperValues(this.axisArray);
    }

    public AxisOriginWrapper getAxisOrigin() {
        AxisOriginWrapper axisOriginWrapper = new AxisOriginWrapper();
        axisOriginWrapper.setWrapperValues(this.axisArray);
        return axisOriginWrapper;
    }

    public void setAxisOrigin(AxisOriginWrapper axisOriginWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisOriginWrapper.setPropertyValues(this.axisArray);
            this.setIsBatched(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        axisOriginWrapper.setWrapperValues(this.axisArray);
    }

    public AxisPlacementWrapper getAxisPlacement() {
        AxisPlacementWrapper axisPlacementWrapper = new AxisPlacementWrapper();
        axisPlacementWrapper.setWrapperValues(this.axisArray);
        int n = 0;
        while (n < this.axisArray.length) {
            axisPlacementWrapper.paxis[n] = this.findAxisIndex(this.axisArray[n].getPlacementAxis());
            ++n;
        }
        return axisPlacementWrapper;
    }

    public void setAxisPlacement(AxisPlacementWrapper axisPlacementWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisPlacementWrapper.setPropertyValues(this.axisArray);
            int n = 0;
            while (n < this.axisArray.length) {
                if (axisPlacementWrapper.paxis[n] == -1) {
                    this.axisArray[n].setPlacementAxis(null);
                } else if (this.axisArray[n].getIsVertical() != this.axisArray[axisPlacementWrapper.paxis[n]].getIsVertical()) {
                    this.axisArray[n].setPlacementAxis(this.axisArray[axisPlacementWrapper.paxis[n]]);
                } else {
                    axisPlacementWrapper.paxis[n] = this.findAxisIndex(this.axisArray[n].getPlacementAxis());
                }
                ++n;
            }
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private int findAxisIndex(JCAxis jCAxis) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.axisArray.length) {
            if (jCAxis == this.axisArray[n2]) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public AxisRelationshipWrapper getAxisRelationship() {
        AxisRelationshipWrapper axisRelationshipWrapper = new AxisRelationshipWrapper();
        axisRelationshipWrapper.setWrapperValues(this.axisArray);
        int n = 0;
        while (n < this.axisArray.length) {
            axisRelationshipWrapper.raxis[n] = this.findAxisIndex(this.axisArray[n].getFormula().getOriginator());
            ++n;
        }
        return axisRelationshipWrapper;
    }

    public void setAxisRelationship(AxisRelationshipWrapper axisRelationshipWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            axisRelationshipWrapper.setPropertyValues(this.axisArray);
            int n = 0;
            while (n < this.axisArray.length) {
                if (axisRelationshipWrapper.raxis[n] == -1 || axisRelationshipWrapper.raxis[n] == n) {
                    this.axisArray[n].getFormula().setOriginator(null);
                } else {
                    this.axisArray[n].getFormula().setOriginator(this.axisArray[axisRelationshipWrapper.raxis[n]]);
                }
                ++n;
            }
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AxisOrientationWrapper getAxisOrientation() {
        AxisOrientationWrapper axisOrientationWrapper = new AxisOrientationWrapper(this.axisArray.length);
        int n = 0;
        while (n < this.axisArray.length) {
            AxisInfoWrapper axisInfoWrapper = new AxisInfoWrapper();
            axisInfoWrapper.getAxisInformation(this.axisArray[n]);
            axisOrientationWrapper.orientation[n] = this.getActualAxisOrientation(this.axisArray[n], axisInfoWrapper);
            axisOrientationWrapper.other_axis_index[n] = -1;
            int n2 = 0;
            while (n2 < this.axisArray.length) {
                if (this.axisArray[n2] == axisInfoWrapper.axis_other_axis) {
                    axisOrientationWrapper.other_axis_index[n] = n2;
                }
                ++n2;
            }
            ++n;
        }
        axisOrientationWrapper.trigger_index = -1;
        return axisOrientationWrapper;
    }

    public void setAxisOrientation(AxisOrientationWrapper axisOrientationWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            int n = 0;
            while (n < this.axisArray.length) {
                if (axisOrientationWrapper.trigger_index < 0 || axisOrientationWrapper.trigger_index == n) {
                    AxisInfoWrapper axisInfoWrapper = new AxisInfoWrapper();
                    axisInfoWrapper.getAxisInformation(this.axisArray[n]);
                    this.setActualAxisOrientation(this.axisArray[n], axisInfoWrapper, axisOrientationWrapper.orientation[n]);
                }
                ++n;
            }
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private int getActualAxisOrientation(JCAxis jCAxis, AxisInfoWrapper axisInfoWrapper) {
        JCAxis jCAxis2;
        ChartDataView chartDataView = axisInfoWrapper.axis_cdv;
        JCAxis jCAxis3 = axisInfoWrapper.axis_other_axis;
        boolean bl = axisInfoWrapper.axis_xory;
        int n = 0;
        if (chartDataView != null && chartDataView.getIsInverted()) {
            n += 4;
        }
        if ((jCAxis2 = bl ? jCAxis : jCAxis3) != null && jCAxis2.getIsReversed()) {
            ++n;
        }
        if ((jCAxis2 = !bl ? jCAxis : jCAxis3) != null && jCAxis2.getIsReversed()) {
            n += 2;
        }
        return n;
    }

    private void setActualAxisOrientation(JCAxis jCAxis, AxisInfoWrapper axisInfoWrapper, int n) {
        ChartDataView chartDataView = axisInfoWrapper.axis_cdv;
        JCAxis jCAxis2 = axisInfoWrapper.axis_other_axis;
        boolean bl = axisInfoWrapper.axis_xory;
        int n2 = n;
        if (n2 > 3) {
            if (chartDataView != null) {
                chartDataView.setIsInverted(true);
            }
            n2 -= 4;
        } else if (chartDataView != null) {
            chartDataView.setIsInverted(false);
        }
        if (n2 > 1) {
            if (!bl) {
                jCAxis.setIsReversed(true);
            } else if (jCAxis2 != null) {
                jCAxis2.setIsReversed(true);
            }
            n2 -= 2;
        } else if (!bl) {
            jCAxis.setIsReversed(false);
        } else if (jCAxis2 != null) {
            jCAxis2.setIsReversed(false);
        }
        if (bl) {
            jCAxis.setIsReversed(n2 != 0);
            return;
        }
        if (jCAxis2 != null) {
            jCAxis2.setIsReversed(n2 != 0);
        }
    }

    public LegendWrapper getLegendLayout() {
        LegendWrapper legendWrapper = new LegendWrapper();
        legendWrapper.setWrapperValues(this.getLegend());
        return legendWrapper;
    }

    public void setLegendLayout(LegendWrapper legendWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            legendWrapper.setPropertyValues(this.getLegend());
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AppearanceWrapper getLegendAppearance() {
        AppearanceWrapper appearanceWrapper = new AppearanceWrapper();
        this.getAppearance(this.getLegend(), appearanceWrapper);
        appearanceWrapper.prefix = JCChartBundle.string("jclass.chart.Key290");
        return appearanceWrapper;
    }

    public void setLegendAppearance(AppearanceWrapper appearanceWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            this.setAppearance(this.getLegend(), appearanceWrapper);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AppearanceWrapper getFooterAppearance() {
        AppearanceWrapper appearanceWrapper = new AppearanceWrapper();
        this.getAppearance(this.getFooter(), appearanceWrapper);
        appearanceWrapper.prefix = JCChartBundle.string("jclass.chart.Key291");
        return appearanceWrapper;
    }

    public void setFooterAppearance(AppearanceWrapper appearanceWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            this.setAppearance(this.getFooter(), appearanceWrapper);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AppearanceWrapper getHeaderAppearance() {
        AppearanceWrapper appearanceWrapper = new AppearanceWrapper();
        this.getAppearance(this.getHeader(), appearanceWrapper);
        appearanceWrapper.prefix = JCChartBundle.string("jclass.chart.Key292");
        return appearanceWrapper;
    }

    public void setHeaderAppearance(AppearanceWrapper appearanceWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            this.setAppearance(this.getHeader(), appearanceWrapper);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AppearanceWrapper getChartAreaAppearance() {
        AppearanceWrapper appearanceWrapper = new AppearanceWrapper();
        this.getAppearance(this.getChartArea(), appearanceWrapper);
        appearanceWrapper.prefix = JCChartBundle.string("jclass.chart.Key293");
        return appearanceWrapper;
    }

    public void setChartAreaAppearance(AppearanceWrapper appearanceWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            this.setAppearance(this.getChartArea(), appearanceWrapper);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AppearanceWrapper getChartAppearance() {
        AppearanceWrapper appearanceWrapper = new AppearanceWrapper();
        this.getAppearance(this, appearanceWrapper);
        appearanceWrapper.prefix = JCChartBundle.string("jclass.chart.Key294");
        return appearanceWrapper;
    }

    public void setChartAppearance(AppearanceWrapper appearanceWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            this.setAppearance(this, appearanceWrapper);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public AppearanceWrapper getPlotAreaAppearance() {
        AppearanceWrapper appearanceWrapper = new AppearanceWrapper();
        this.getAppearance(this.getChartArea().getPlotArea(), appearanceWrapper);
        appearanceWrapper.prefix = JCChartBundle.string("jclass.chart.Key295");
        return appearanceWrapper;
    }

    public void setPlotAreaAppearance(AppearanceWrapper appearanceWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            this.setAppearance(this.getChartArea().getPlotArea(), appearanceWrapper);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void getAppearance(Object object, AppearanceWrapper appearanceWrapper) {
        if (object instanceof ChartRegion) {
            ChartRegion chartRegion = (ChartRegion)object;
            appearanceWrapper.background = chartRegion.getBackground();
            appearanceWrapper.foreground = chartRegion.getForeground();
            appearanceWrapper.showing = chartRegion.getIsShowing();
            appearanceWrapper.bordertype = chartRegion.getBorderType();
            appearanceWrapper.borderwidth = chartRegion.getBorderWidth();
            appearanceWrapper.axisbounding = false;
            appearanceWrapper.thisobj = 0;
            return;
        }
        if (object instanceof JCChart) {
            JCChart jCChart = (JCChart)object;
            appearanceWrapper.background = jCChart.getBackground();
            appearanceWrapper.foreground = jCChart.getForeground();
            appearanceWrapper.bordertype = jCChart.getBorderType();
            appearanceWrapper.borderwidth = jCChart.getBorderWidth();
            appearanceWrapper.axisbounding = false;
            appearanceWrapper.thisobj = 2;
            return;
        }
        if (object instanceof PlotArea) {
            PlotArea plotArea = (PlotArea)object;
            appearanceWrapper.background = plotArea.getBackground();
            appearanceWrapper.foreground = plotArea.getForeground();
            appearanceWrapper.showing = true;
            appearanceWrapper.bordertype = 0;
            appearanceWrapper.borderwidth = 0;
            appearanceWrapper.axisbounding = ((JCChartArea)plotArea.getParent()).getAxisBoundingBox();
            appearanceWrapper.thisobj = 1;
            return;
        }
        appearanceWrapper.background = Color.white;
        appearanceWrapper.foreground = Color.black;
        appearanceWrapper.showing = true;
        appearanceWrapper.bordertype = 0;
        appearanceWrapper.borderwidth = 0;
        appearanceWrapper.axisbounding = false;
        appearanceWrapper.thisobj = -1;
    }

    private void setAppearance(Object object, AppearanceWrapper appearanceWrapper) {
        if (object instanceof ChartRegion) {
            ChartRegion chartRegion = (ChartRegion)object;
            chartRegion.setBackground(appearanceWrapper.background);
            chartRegion.setForeground(appearanceWrapper.foreground);
            chartRegion.setIsShowing(appearanceWrapper.showing);
            chartRegion.setBorderType(appearanceWrapper.bordertype);
            chartRegion.setBorderWidth(appearanceWrapper.borderwidth);
            appearanceWrapper.thisobj = 0;
            return;
        }
        if (object instanceof JCChart) {
            JCChart jCChart = (JCChart)object;
            jCChart.setBackground(appearanceWrapper.background);
            jCChart.setForeground(appearanceWrapper.foreground);
            jCChart.setBorderType(appearanceWrapper.bordertype);
            jCChart.setBorderWidth(appearanceWrapper.borderwidth);
            appearanceWrapper.thisobj = 2;
            return;
        }
        if (object instanceof PlotArea) {
            PlotArea plotArea = (PlotArea)object;
            plotArea.setBackground(appearanceWrapper.background);
            plotArea.setForeground(appearanceWrapper.foreground);
            ((JCChartArea)plotArea.getParent()).setAxisBoundingBox(appearanceWrapper.axisbounding);
            appearanceWrapper.thisobj = 1;
        }
    }

    public TitleWrapper getHeaderText() {
        TitleWrapper titleWrapper = new TitleWrapper();
        titleWrapper.setWrapperValues(this.getHeader());
        titleWrapper.prefix = JCChartBundle.string("jclass.chart.Key292");
        return titleWrapper;
    }

    public void setHeaderText(TitleWrapper titleWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            titleWrapper.setPropertyValues(this.getHeader());
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public TitleWrapper getFooterText() {
        TitleWrapper titleWrapper = new TitleWrapper();
        titleWrapper.setWrapperValues(this.getFooter());
        titleWrapper.prefix = JCChartBundle.string("jclass.chart.Key291");
        return titleWrapper;
    }

    public void setFooterText(TitleWrapper titleWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            titleWrapper.setPropertyValues(this.getFooter());
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public TriggerWrapper getTriggerList() {
        TriggerWrapper triggerWrapper = new TriggerWrapper();
        triggerWrapper.setWrapperValues(this);
        return triggerWrapper;
    }

    public void setTriggerList(TriggerWrapper triggerWrapper) {
        try {
            boolean bl = false;
            bl = this.getIsBatched();
            this.setIsBatched(true);
            triggerWrapper.setPropertyValues(this);
            this.setIsBatched(bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setSwingDataModel1(TableModel tableModel) {
        this.tableModel = tableModel;
        if (this.dataSource != null) {
            this.dataSource.removeChartDataListener(this);
        }
        this.dataSource = new ChartSwingDataSource(tableModel);
        this.getDataView(0).setDataSource((Chartable)((Object)this.dataSource));
        this.dataSource.addChartDataListener(this);
    }

    public TableModel getSwingDataModel1() {
        return this.tableModel;
    }

    public void setSwingDataModel2(TableModel tableModel) {
        this.tableModel2 = tableModel;
        if (this.dataSource2 != null) {
            this.dataSource2.removeChartDataListener(this);
        }
        this.dataSource2 = new ChartSwingDataSource(tableModel);
        this.getDataView(1).setDataSource((Chartable)((Object)this.dataSource2));
        this.dataSource2.addChartDataListener(this);
    }

    public TableModel getSwingDataModel2() {
        return this.tableModel2;
    }

    static {
        int[] nArray = new int[8];
        nArray[1] = 4;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 2;
        nArray[5] = 6;
        nArray[6] = 3;
        nArray[7] = 7;
        axesOrientationValues = nArray;
        axesOrientationStrings = new String[]{"ORIENT_X_NORMAL_Y_NORMAL", "ORIENT_INVERTED_X_NORMAL_Y_NORMAL", "ORIENT_X_REVERSED_Y_NORMAL", "ORIENT_INVERTED_X_REVERSED_Y_NORMAL", "ORIENT_X_NORMAL_Y_REVERSED", "ORIENT_INVERTED_X_NORMAL_Y_REVERSED", "ORIENT_X_REVERSED_Y_REVERSED", "ORIENT_INVERTED_X_REVERSED_Y_REVERSED"};
    }
}

