/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLineStyle;
import jclass.chart.JCSymbolStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class FastPlotChartDraw
extends ChartDraw {
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point prev;
    Point next;
    Point last;
    Rectangle r;
    public static final int TOP_EDGE = 8;
    public static final int BOTTOM_EDGE = 4;
    public static final int RIGHT_EDGE = 2;
    public static final int LEFT_EDGE = 1;

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n, int n2) {
        this.recalc(n, n2, -1);
    }

    public void recalc(int n, int n2, int n3) {
        super.recalc();
        boolean bl = false;
        if (n >= 0 && n2 >= 0 && n2 >= n) {
            bl = true;
        }
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.inverted = this.xaxis.isVertical;
        this.holeValue = this.dataObject.holeValue;
        if (bl) {
            int n4 = 0;
            int n5 = this.seriesList.length;
            int n6 = n4;
            while (n6 < n5) {
                ChartDataViewSeries chartDataViewSeries = this.seriesList[n6];
                if (chartDataViewSeries.isShowing && chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                    double[] dArray = chartDataViewSeries.getX();
                    double[] dArray2 = chartDataViewSeries.getY();
                    int n7 = n;
                    while (n7 <= n2) {
                        this.xlim.setMinMax(dArray[n7], this.holeValue);
                        this.ylim.setMinMax(dArray2[n7], this.holeValue);
                        ++n7;
                    }
                }
                ++n6;
            }
            this.dataObject.getDataBounds(this.xlim, this.ylim);
            return;
        }
        if (n3 == -1 || n3 == 0) {
            this.xlim = new MinMax(this.dataObject.xLimits.min, this.dataObject.xLimits.max);
            this.ylim = new MinMax(this.dataObject.yLimits.min, this.dataObject.yLimits.max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1);
    }

    public void draw(Graphics graphics, int n, int n2) {
        try {
            if (this.seriesList == null) {
                return;
            }
            boolean bl = false;
            if (n >= 0 && n2 >= 0 && n2 >= n) {
                bl = true;
            }
            int n3 = 0;
            int n4 = this.seriesList.length;
            int n5 = n3;
            while (n5 < n4) {
                ChartDataViewSeries chartDataViewSeries = this.seriesList[n5];
                if (chartDataViewSeries.isShowing && chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                    JCChartStyle jCChartStyle;
                    if (!bl) {
                        n = chartDataViewSeries.getFirstPoint();
                        n2 = chartDataViewSeries.getLastPoint();
                    } else {
                        int n6 = chartDataViewSeries.getLastPoint();
                        if (n < n6) {
                            n = n6;
                        }
                    }
                    double[] dArray = chartDataViewSeries.getX();
                    double[] dArray2 = chartDataViewSeries.getY();
                    double d = 0.0;
                    double d2 = this.holeValue;
                    boolean bl2 = false;
                    if (bl && n > 0) {
                        d = dArray[n - 1];
                        d2 = dArray2[n - 1];
                    }
                    if ((jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                        JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                        JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
                        boolean bl3 = jCSymbolStyle.getShape() == 0;
                        PlotPoint plotPoint = new PlotPoint();
                        plotPoint.valid = false;
                        PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                        int n7 = n;
                        while (n7 <= n2) {
                            double d3 = dArray[n7];
                            double d4 = dArray2[n7];
                            plotPointArray[0].valid = false;
                            plotPointArray[1].valid = false;
                            bl2 = this.plotClip(d, d2, d3, d4, this.xlim, this.ylim, plotPointArray, bl2, this.inverted);
                            int n8 = 0;
                            while (n8 < plotPointArray.length) {
                                if (plotPointArray[n8].valid && plotPoint.valid && this.chartType == 0) {
                                    Color color = null;
                                    if (this.dataObject.colorHandler != null) {
                                        color = this.dataObject.colorHandler.getColor(plotPoint.px, plotPoint.py, plotPointArray[n8].px, plotPointArray[n8].py);
                                    }
                                    jCLineStyle.draw(graphics, plotPoint.px, plotPoint.py, plotPointArray[n8].px, plotPointArray[n8].py, color);
                                }
                                if (n8 == 0 || plotPointArray[n8].valid) {
                                    if (plotPoint.valid && plotPoint.drawPoint && !bl3) {
                                        jCSymbolStyle.draw(graphics, plotPoint.px, plotPoint.py);
                                    }
                                    plotPoint.px = plotPointArray[n8].px;
                                    plotPoint.py = plotPointArray[n8].py;
                                    plotPoint.drawPoint = plotPointArray[n8].drawPoint;
                                    plotPoint.valid = plotPointArray[n8].valid;
                                }
                                ++n8;
                            }
                            if (!bl2) {
                                plotPoint.valid = false;
                            }
                            d = d3;
                            d2 = d4;
                            ++n7;
                        }
                        if (plotPoint.valid && plotPoint.drawPoint && !bl3) {
                            jCSymbolStyle.draw(graphics, plotPoint.px, plotPoint.py);
                        }
                    }
                }
                ++n5;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        double d = this.inverted ? this.xaxis.toData(point2.y, this.drawFront) : this.xaxis.toData(point2.x, this.drawFront);
        double d2 = this.inverted ? this.yaxis.toData(point2.x, this.drawFront) : this.yaxis.toData(point2.y, this.drawFront);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        double d3 = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        int n4 = 0;
        int n5 = this.seriesList.length;
        double d4 = 0.0;
        double d5 = 0.0;
        try {
            int n6;
            int n7 = n4;
            while (n7 < n5) {
                if (this.seriesList[n7] != null && this.seriesList[n7].isShowing) {
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n7];
                    n6 = chartDataViewSeries.getFirstPoint();
                    int n8 = chartDataViewSeries.getLastPoint();
                    if (n6 != Integer.MAX_VALUE && n8 != Integer.MAX_VALUE) {
                        double[] dArray = chartDataViewSeries.getX();
                        double[] dArray2 = chartDataViewSeries.getY();
                        int n9 = n6;
                        while (n9 <= n8) {
                            d4 = dArray[n9];
                            d5 = dArray2[n9];
                            if (!(d4 == this.holeValue || d5 == this.holeValue || d4 > this.xlim.max || d4 < this.xlim.min || d5 > this.ylim.max || d5 < this.ylim.min)) {
                                double d6 = Double.MAX_VALUE;
                                switch (n) {
                                    case 1: {
                                        d6 = Math.abs(d4 - d);
                                        break;
                                    }
                                    case 2: {
                                        d6 = Math.abs(d5 - d2);
                                        break;
                                    }
                                    default: {
                                        d6 = Math.sqrt((d4 - d) * (d4 - d) + (d5 - d2) * (d5 - d2));
                                    }
                                }
                                if (d6 < d3) {
                                    n2 = n7;
                                    n3 = n9;
                                    d3 = d6;
                                }
                            }
                            ++n9;
                        }
                    }
                }
                ++n7;
            }
            if (n2 >= 0 && n3 >= 0) {
                jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
                int n10 = this.inverted ? this.yaxis.toPixel(this.seriesList[n2].getY(n3)) : this.xaxis.toPixel(this.seriesList[n2].getX(n3));
                n6 = this.inverted ? this.xaxis.toPixel(this.seriesList[n2].getX(n3)) : this.yaxis.toPixel(this.seriesList[n2].getY(n3));
                jCDataIndex.distance = (int)Math.sqrt((n10 - point2.x) * (n10 - point2.x) + (n6 - point2.y) * (n6 - point2.y));
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d;
        double d2;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return;
        }
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        int n = jCDataIndex.point;
        if (n - 1 >= 0) {
            d2 = jCDataIndex.series.getX(n - 1);
            d = jCDataIndex.series.getY(n - 1);
            if (d2 != Double.MAX_VALUE && d != Double.MAX_VALUE && d2 != this.dataObject.holeValue && d != this.dataObject.holeValue && JCChartUtil.locateXY(d2, d, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max) == 0) {
                Point point = this.prev = this.inverted ? new Point(this.yaxis.toPixel(d) + this.r.x, this.xaxis.toPixel(d2) + this.r.y) : new Point(this.xaxis.toPixel(d2) + this.r.x, this.yaxis.toPixel(d) + this.r.y);
            }
        }
        if (n + 1 <= jCDataIndex.series.getLastPoint()) {
            d2 = jCDataIndex.series.getX(n + 1);
            d = jCDataIndex.series.getY(n + 1);
            if (d2 != Double.MAX_VALUE && d != Double.MAX_VALUE && d2 != this.dataObject.holeValue && d != this.dataObject.holeValue && JCChartUtil.locateXY(d2, d, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max) == 0) {
                this.next = this.inverted ? new Point(this.yaxis.toPixel(d) + this.r.x, this.xaxis.toPixel(d2) + this.r.y) : new Point(this.xaxis.toPixel(d2) + this.r.x, this.yaxis.toPixel(d) + this.r.y);
            }
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            this.last = bl ? new Point(n, jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.last.x = n;
        } else {
            this.last.y = n2;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    boolean plotClip(double d, double d2, double d3, double d4, MinMax minMax, MinMax minMax2, PlotPoint[] plotPointArray, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        double d5 = minMax.min;
        double d6 = minMax.max;
        double d7 = minMax2.min;
        double d8 = minMax2.max;
        boolean bl3 = true;
        boolean bl4 = true;
        int n6 = 0;
        int n7 = 0;
        boolean bl5 = false;
        boolean bl6 = true;
        if (!bl) {
            if (d2 == this.dataObject.holeValue || d == this.dataObject.holeValue) {
                n6 = 1;
                bl6 = false;
                bl5 = true;
            } else {
                n5 = (d > d6 ? 1 : 0) << 1;
                n4 = d < d5 ? 1 : 0;
                n3 = (d2 > d8 ? 1 : 0) << 3;
                n2 = (d2 < d7 ? 1 : 0) << 2;
                n6 = n5 | n4 | n3 | n2;
            }
        } else {
            n5 = (d > d6 ? 1 : 0) << 1;
            n4 = d < d5 ? 1 : 0;
            n3 = (d2 > d8 ? 1 : 0) << 3;
            n2 = (d2 < d7 ? 1 : 0) << 2;
            n6 = n5 | n4 | n3 | n2;
        }
        if (d4 == this.dataObject.holeValue || d3 == this.dataObject.holeValue) {
            n7 = 1;
            bl6 = false;
            bl5 = true;
        } else {
            n5 = d3 > d6 ? 1 : 0;
            n4 = n5 << 1;
            n3 = d3 < d5 ? 1 : 0;
            n2 = (d4 > d8 ? 1 : 0) << 3;
            n = (d4 < d7 ? 1 : 0) << 2;
            n7 = n4 | n3 | n2 | n;
        }
        n5 = n6;
        n4 = n7;
        while (bl6 && (n5 | n4) != 0 && (n5 & n4) == 0) {
            double d9;
            double d10;
            int n8 = n3 = n5 != 0 ? n5 : n4;
            if ((n3 & 1) != 0) {
                d10 = d2 + (d4 - d2) * (d5 - d) / (d3 - d);
                d9 = d5;
                n2 = (d10 > d8 ? 1 : 0) << 3;
                n = (d10 < d7 ? 1 : 0) << 2;
                n3 = n2 | n;
            } else if ((n3 & 2) != 0) {
                d10 = d2 + (d4 - d2) * (d6 - d) / (d3 - d);
                d9 = d6;
                n2 = (d10 > d8 ? 1 : 0) << 3;
                n = (d10 < d7 ? 1 : 0) << 2;
                n3 = n2 | n;
            } else if ((n3 & 4) != 0) {
                d9 = d + (d3 - d) * (d7 - d2) / (d4 - d2);
                d10 = d7;
                n2 = (d9 > d6 ? 1 : 0) << 1;
                n = d9 < d5 ? 1 : 0;
                n3 = n2 | n;
            } else {
                d9 = d + (d3 - d) * (d8 - d2) / (d4 - d2);
                d10 = d8;
                n2 = (d9 > d6 ? 1 : 0) << 1;
                n = d9 < d5 ? 1 : 0;
                n3 = n2 | n;
            }
            if (n5 != 0) {
                n5 = n3;
                d = d9;
                d2 = d10;
                bl3 = false;
                continue;
            }
            n4 = n3;
            d3 = d9;
            d4 = d10;
            bl4 = false;
        }
        int n9 = n3 = bl || !bl5 || n6 != 0 && n7 != 0 ? 0 : 1;
        if ((n5 | n4) == 0 || n3 != 0) {
            if (bl) {
                if (!bl5) {
                    this.addClippedPoint(plotPointArray, 0, d3, d4, this.xaxis, this.yaxis, bl2, bl4);
                    bl = n7 == 0;
                } else {
                    bl = false;
                }
            } else {
                if (n3 != 0 && n7 == 0) {
                    d = d3;
                    d2 = d4;
                    bl3 = bl4;
                }
                this.addClippedPoint(plotPointArray, 0, d, d2, this.xaxis, this.yaxis, bl2, bl3);
                if (n3 == 0) {
                    this.addClippedPoint(plotPointArray, 1, d3, d4, this.xaxis, this.yaxis, bl2, bl4);
                }
                bl = n7 == 0;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

