/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCChartStyle;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class FastHiloChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 2;
    static final int HI_SERIES_INDEX = 0;
    static final int LO_SERIES_INDEX = 1;
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point start;
    Point end;
    Rectangle r;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.holeValue = this.dataObject.holeValue;
        this.inverted = this.xaxis.isVertical;
        if (n == -1 || n == 0) {
            this.xlim = new MinMax(this.dataObject.xLimits.min, this.dataObject.xLimits.max);
            this.ylim = new MinMax(this.dataObject.yLimits.min, this.dataObject.yLimits.max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    public void draw(Graphics graphics) {
        try {
            if (this.seriesList == null) {
                return;
            }
            int n = this.seriesList.length / 2;
            int n2 = 0;
            int n3 = n;
            int n4 = n2;
            while (n4 < n3) {
                Serializable serializable;
                boolean bl = true;
                boolean bl2 = true;
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MAX_VALUE;
                int n7 = 2 * n4;
                int n8 = 0;
                while (n8 < 2) {
                    serializable = this.seriesList[n7];
                    if (!((ChartDataViewSeries)serializable).isShowing) {
                        bl = false;
                        break;
                    }
                    if (((ChartDataViewSeries)serializable).maxXIndex() == 0 || ((ChartDataViewSeries)serializable).maxYIndex() == 0) {
                        bl2 = false;
                        break;
                    }
                    n5 = Math.min(n5, ((ChartDataViewSeries)serializable).getFirstPoint());
                    n6 = Math.min(n6, ((ChartDataViewSeries)serializable).getLastPoint());
                    ++n8;
                    ++n7;
                }
                if (bl2 && bl && (serializable = this.seriesList[2 * n4].getStyle()) != null) {
                    JCLineStyle jCLineStyle = ((JCChartStyle)serializable).getLineStyle();
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    int n9 = n5;
                    while (n9 <= n6) {
                        int n10 = 2 * n4;
                        ChartDataViewSeries chartDataViewSeries = this.seriesList[n10++];
                        double d = chartDataViewSeries.getX(n9);
                        double d2 = chartDataViewSeries.getY(n9);
                        chartDataViewSeries = this.seriesList[n10++];
                        double d3 = chartDataViewSeries.getX(n9);
                        double d4 = chartDataViewSeries.getY(n9);
                        plotPointArray[0].valid = false;
                        plotPointArray[1].valid = false;
                        this.financialClip(d, d2, d3, d4, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                        if (plotPointArray[0].valid && plotPointArray[1].valid) {
                            jCLineStyle.draw(graphics, plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py);
                        }
                        ++n9;
                    }
                }
                ++n4;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        double d = this.inverted ? this.xaxis.toData(point2.y, this.drawFront) : this.xaxis.toData(point2.x, this.drawFront);
        double d2 = this.inverted ? this.yaxis.toData(point2.x, this.drawFront) : this.yaxis.toData(point2.y, this.drawFront);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        double d3 = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        double d4 = this.dataObject.holeValue;
        int n4 = this.seriesList.length / 2;
        int n5 = 0;
        int n6 = n4;
        try {
            int n7;
            int n8;
            int n9 = n5;
            while (n9 < n6) {
                n8 = 1;
                n7 = 1;
                int n10 = Integer.MAX_VALUE;
                int n11 = Integer.MAX_VALUE;
                int n12 = 2 * n9;
                int n13 = 0;
                while (n13 < 2) {
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n12];
                    if (!this.seriesList[n12].isShowing) {
                        n7 = 0;
                        break;
                    }
                    if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                        n8 = 0;
                        break;
                    }
                    n10 = Math.min(n10, chartDataViewSeries.getFirstPoint());
                    n11 = Math.min(n11, chartDataViewSeries.getLastPoint());
                    ++n13;
                    ++n12;
                }
                if (n8 != 0 && n7 != 0) {
                    int n14 = 2 * n9;
                    double[] dArray = this.seriesList[n14].getX();
                    double[] dArray2 = this.seriesList[n14].getY();
                    double[] dArray3 = this.seriesList[n14 + 1].getX();
                    double[] dArray4 = this.seriesList[n14 + 1].getY();
                    double d5 = 0.0;
                    double d6 = 0.0;
                    int n15 = n10;
                    while (n15 <= n11) {
                        int n16 = 0;
                        while (n16 < 2) {
                            switch (n16) {
                                case 0: {
                                    d5 = dArray[n15];
                                    d6 = dArray2[n15];
                                    break;
                                }
                                case 1: {
                                    d5 = dArray3[n15];
                                    d6 = dArray4[n15];
                                    break;
                                }
                            }
                            if (!(d5 == d4 || d6 == d4 || d5 > this.xlim.max || this.xlim.min > d5 || d6 > this.ylim.max || this.ylim.min > d6)) {
                                double d7;
                                switch (n) {
                                    case 1: {
                                        d7 = Math.abs(d5 - d);
                                        break;
                                    }
                                    case 2: {
                                        d7 = Math.abs(d6 - d2);
                                        break;
                                    }
                                    default: {
                                        d7 = Math.sqrt((d5 - d) * (d5 - d) + (d6 - d2) * (d6 - d2));
                                    }
                                }
                                if (d3 > d7) {
                                    n2 = n9 * 2 + n16;
                                    n3 = n15;
                                    d3 = d7;
                                }
                            }
                            ++n16;
                        }
                        ++n15;
                    }
                }
                ++n9;
            }
            if (n2 >= 0 && n3 >= 0) {
                jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
                n8 = this.inverted ? this.yaxis.toPixel(this.seriesList[n2].getY(n3)) : this.xaxis.toPixel(this.seriesList[n2].getX(n3));
                n7 = this.inverted ? this.xaxis.toPixel(this.seriesList[n2].getX(n3)) : this.yaxis.toPixel(this.seriesList[n2].getY(n3));
                jCDataIndex.distance = (int)Math.sqrt((n8 - point2.x) * (n8 - point2.x) + (n7 - point2.y) * (n7 - point2.y));
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n = jCDataIndex.series.drawingOrder / 2;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n2 = n * 2;
        int n3 = jCDataIndex.seriesIndex - n2;
        double d = this.seriesList[n2 + n3].getX(jCDataIndex.point);
        double d2 = this.seriesList[n2 + n3].getY(jCDataIndex.point);
        if (this.inverted) {
            this.start = new Point(this.yaxis.toPixel(d2) + this.r.x, this.xaxis.toPixel(d) + this.r.y);
            return;
        }
        this.start = new Point(this.xaxis.toPixel(d) + this.r.x, this.yaxis.toPixel(d2) + this.r.y);
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            this.end = bl ? new Point(n, jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    int getNumSeriesPerData() {
        return 2;
    }
}

