/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCChartStyle;
import jclass.chart.JCDataIndex;
import jclass.chart.JCHLOCChartFormat;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class FastHLOCChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    static final int HI_SERIES_INDEX = 0;
    static final int LO_SERIES_INDEX = 1;
    static final int OPEN_SERIES_INDEX = 2;
    static final int CLOSE_SERIES_INDEX = 3;
    JCHLOCChartFormat hlocf;
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point start;
    Point end;
    Rectangle r;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.hlocf = this.dataObject.getHLOCChartFormat();
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.holeValue = this.dataObject.holeValue;
        this.inverted = this.xaxis.isVertical;
        if (n == -1 || n == 0) {
            this.xlim = new MinMax(this.dataObject.xLimits.min, this.dataObject.xLimits.max);
            this.ylim = new MinMax(this.dataObject.yLimits.min, this.dataObject.yLimits.max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    public void draw(Graphics graphics) {
        try {
            if (this.seriesList == null) {
                return;
            }
            boolean bl = this.hlocf.getIsOpenCloseFullWidth();
            boolean bl2 = this.hlocf.getIsShowingOpen();
            boolean bl3 = this.hlocf.getIsShowingClose();
            int n = this.seriesList.length / 4;
            int n2 = 0;
            int n3 = n;
            int n4 = n2;
            while (n4 < n3) {
                Serializable serializable;
                int n5 = this.hlocf.getTickSize(n4);
                boolean bl4 = true;
                boolean bl5 = true;
                int n6 = Integer.MAX_VALUE;
                int n7 = Integer.MAX_VALUE;
                int n8 = 4 * n4;
                int n9 = 0;
                while (n9 < 4) {
                    serializable = this.seriesList[n8];
                    if (!this.seriesList[n8].isShowing) {
                        bl5 = false;
                        break;
                    }
                    if (((ChartDataViewSeries)serializable).maxXIndex() == 0 || ((ChartDataViewSeries)serializable).maxYIndex() == 0) {
                        bl4 = false;
                        break;
                    }
                    n6 = Math.min(n6, ((ChartDataViewSeries)serializable).getFirstPoint());
                    n7 = Math.min(n7, ((ChartDataViewSeries)serializable).getLastPoint());
                    ++n9;
                    ++n8;
                }
                if (bl4 && bl5 && (serializable = this.seriesList[4 * n4].getStyle()) != null) {
                    JCLineStyle jCLineStyle = ((JCChartStyle)serializable).getLineStyle();
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    int n10 = n6;
                    while (n10 <= n7) {
                        this.drawPoints(graphics, this.seriesList, n4, n10, plotPointArray, jCLineStyle, bl, bl2, bl3, n5);
                        ++n10;
                    }
                }
                ++n4;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    private final void drawPoints(Graphics graphics, ChartDataViewSeries[] chartDataViewSeriesArray, int n, int n2, PlotPoint[] plotPointArray, JCLineStyle jCLineStyle, boolean bl, boolean bl2, boolean bl3, int n3) {
        int n4;
        double d;
        double d2;
        int n5 = 4 * n;
        ChartDataViewSeries chartDataViewSeries = chartDataViewSeriesArray[n5++];
        double d3 = chartDataViewSeries.getX(n2);
        double d4 = chartDataViewSeries.getY(n2);
        chartDataViewSeries = chartDataViewSeriesArray[n5++];
        double d5 = chartDataViewSeries.getX(n2);
        double d6 = chartDataViewSeries.getY(n2);
        plotPointArray[0].valid = false;
        plotPointArray[1].valid = false;
        this.financialClip(d3, d4, d5, d6, this.xlim, this.ylim, plotPointArray, this.inverted, false);
        if (plotPointArray[0].valid && plotPointArray[1].valid) {
            jCLineStyle.draw(graphics, plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py);
        }
        if (n3 > 0 && bl2) {
            chartDataViewSeries = chartDataViewSeriesArray[n5++];
            d2 = chartDataViewSeries.getX(n2);
            d = chartDataViewSeries.getY(n2);
            n4 = this.xaxis.toPixel(d2, this.drawFront);
            d3 = this.xaxis.toData(n4 - n3, this.drawFront);
            d4 = d;
            d5 = bl ? this.xaxis.toData(n4 + n3, this.drawFront) : d2;
            d6 = d;
            plotPointArray[0].valid = false;
            plotPointArray[1].valid = false;
            this.financialClip(d3, d4, d5, d6, this.xlim, this.ylim, plotPointArray, this.inverted, false);
            if (plotPointArray[0].valid && plotPointArray[1].valid) {
                jCLineStyle.draw(graphics, plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py);
            }
        } else {
            ++n5;
        }
        if (n3 > 0 && bl3) {
            chartDataViewSeries = chartDataViewSeriesArray[n5++];
            d2 = chartDataViewSeries.getX(n2);
            d = chartDataViewSeries.getY(n2);
            n4 = this.xaxis.toPixel(d2, this.drawFront);
            d3 = bl ? this.xaxis.toData(n4 - n3, this.drawFront) : d2;
            d4 = d;
            d5 = this.xaxis.toData(n4 + n3, this.drawFront);
            d6 = d;
            plotPointArray[0].valid = false;
            plotPointArray[1].valid = false;
            this.financialClip(d3, d4, d5, d6, this.xlim, this.ylim, plotPointArray, this.inverted, false);
            if (plotPointArray[0].valid && plotPointArray[1].valid) {
                jCLineStyle.draw(graphics, plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py);
                return;
            }
        } else {
            ++n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        double d = this.inverted ? this.xaxis.toData(point2.y, this.drawFront) : this.xaxis.toData(point2.x, this.drawFront);
        double d2 = this.inverted ? this.yaxis.toData(point2.x, this.drawFront) : this.yaxis.toData(point2.y, this.drawFront);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        double d3 = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        double d4 = this.xlim.max;
        double d5 = this.xlim.min;
        double d6 = this.ylim.max;
        double d7 = this.ylim.min;
        boolean bl = this.hlocf.getIsShowingOpen();
        boolean bl2 = this.hlocf.getIsShowingClose();
        boolean bl3 = this.hlocf.getIsOpenCloseFullWidth();
        int n4 = !this.xaxis.isVertical && !this.xaxis.isReversed || this.xaxis.isVertical && this.xaxis.isReversed ? -1 : 1;
        double d8 = this.dataObject.holeValue;
        int n5 = this.seriesList.length / 4;
        int n6 = 0;
        int n7 = n5;
        try {
            int n8;
            int n9 = n6;
            while (n9 < n7) {
                n8 = this.hlocf.getTickSize(n9);
                double d9 = n8 == 0 ? 0.0 : Math.abs(this.xaxis.toData(0) - this.xaxis.toData(n8));
                boolean bl4 = true;
                boolean bl5 = true;
                int n10 = Integer.MAX_VALUE;
                int n11 = Integer.MAX_VALUE;
                int n12 = 4 * n9;
                int n13 = 0;
                while (n13 < 4) {
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n12];
                    if (!chartDataViewSeries.isShowing) {
                        bl5 = false;
                        break;
                    }
                    if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                        bl4 = false;
                        break;
                    }
                    n10 = Math.min(n10, chartDataViewSeries.getFirstPoint());
                    n11 = Math.min(n11, chartDataViewSeries.getLastPoint());
                    ++n13;
                    ++n12;
                }
                if (bl4 && bl5) {
                    int n14 = 4 * n9;
                    double[] dArray = this.seriesList[n14].getX();
                    double[] dArray2 = this.seriesList[n14].getY();
                    double[] dArray3 = this.seriesList[n14 + 1].getX();
                    double[] dArray4 = this.seriesList[n14 + 1].getY();
                    double[] dArray5 = this.seriesList[n14 + 2].getX();
                    double[] dArray6 = this.seriesList[n14 + 2].getY();
                    double[] dArray7 = this.seriesList[n14 + 3].getX();
                    double[] dArray8 = this.seriesList[n14 + 3].getY();
                    double d10 = 0.0;
                    double d11 = 0.0;
                    int n15 = n10;
                    while (n15 <= n11) {
                        boolean bl6 = false;
                        boolean bl7 = dArray[n15] != d8 && dArray2[n15] != d8 && dArray3[n15] != d8 && dArray4[n15] != d8;
                        boolean bl8 = dArray5[n15] != d8 && dArray6[n15] != d8;
                        boolean bl9 = dArray7[n15] != d8 && dArray8[n15] != d8;
                        int n16 = bl7 ? 0 : 2;
                        block15: while (n16 < 4) {
                            double d12;
                            switch (n16) {
                                case 0: {
                                    d10 = dArray[n15];
                                    d11 = dArray2[n15];
                                    break;
                                }
                                case 1: {
                                    d10 = dArray3[n15];
                                    d11 = dArray4[n15];
                                    break;
                                }
                                case 2: {
                                    if (!bl || !bl8 || n8 == 0) {
                                        ++n16;
                                        continue block15;
                                    }
                                    if (!bl6) {
                                        d10 = dArray5[n15];
                                        d11 = dArray6[n15];
                                        if (bl3) {
                                            d10 += (double)(-n4) * d9;
                                        }
                                        bl6 = true;
                                        break;
                                    }
                                    d10 = dArray5[n15] + (double)n4 * d9;
                                    bl6 = false;
                                    break;
                                }
                                case 3: {
                                    if (!bl2 || !bl9 || n8 == 0) {
                                        ++n16;
                                        continue block15;
                                    }
                                    if (!bl6) {
                                        d10 = dArray7[n15];
                                        d11 = dArray8[n15];
                                        if (bl3) {
                                            d10 += (double)n4 * d9;
                                        }
                                        bl6 = true;
                                        break;
                                    }
                                    d10 = dArray7[n15] - (double)n4 * d9;
                                    bl6 = false;
                                }
                            }
                            if (d10 > d4 || d5 > d10 || d11 > d6 || d7 > d11) {
                                if (bl6) continue;
                                ++n16;
                                continue;
                            }
                            switch (n) {
                                case 1: {
                                    d12 = Math.abs(d10 - d);
                                    break;
                                }
                                case 2: {
                                    d12 = Math.abs(d11 - d2);
                                    break;
                                }
                                default: {
                                    d12 = Math.sqrt((d10 - d) * (d10 - d) + (d11 - d2) * (d11 - d2));
                                }
                            }
                            if (d3 > d12) {
                                n2 = n9 * 4 + n16;
                                n3 = n15;
                                d3 = d12;
                            }
                            if (bl6) continue;
                            ++n16;
                        }
                        ++n15;
                    }
                }
                ++n9;
            }
            if (n2 >= 0 && n3 >= 0) {
                jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
                n8 = this.inverted ? this.yaxis.toPixel(this.seriesList[n2].getY(n3)) : this.xaxis.toPixel(this.seriesList[n2].getX(n3));
                int n17 = this.inverted ? this.xaxis.toPixel(this.seriesList[n2].getX(n3)) : this.yaxis.toPixel(this.seriesList[n2].getY(n3));
                jCDataIndex.distance = (int)Math.sqrt((n8 - point2.x) * (n8 - point2.x) + (n17 - point2.y) * (n17 - point2.y));
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n = jCDataIndex.series.drawingOrder / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n2 = n * 4;
        int n3 = jCDataIndex.seriesIndex - n2;
        double d = this.seriesList[n2 + n3].getX(jCDataIndex.point);
        double d2 = this.seriesList[n2 + n3].getY(jCDataIndex.point);
        if (this.inverted) {
            this.start = new Point(this.yaxis.toPixel(d2) + this.r.x, this.xaxis.toPixel(d) + this.r.y);
            return;
        }
        this.start = new Point(this.xaxis.toPixel(d) + this.r.x, this.yaxis.toPixel(d2) + this.r.y);
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            this.end = bl ? new Point(n, jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    int getNumSeriesPerData() {
        return 4;
    }
}

