/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCCandleChartFormat;
import jclass.chart.JCChartStyle;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class FastCandleChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    static final int HI_SERIES_INDEX = 0;
    static final int LO_SERIES_INDEX = 1;
    static final int OPEN_SERIES_INDEX = 2;
    static final int CLOSE_SERIES_INDEX = 3;
    JCCandleChartFormat cf;
    boolean isComplex = false;
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point start;
    Point end;
    Rectangle r;
    boolean useRubberBand = false;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.cf = this.dataObject.getCandleChartFormat();
        this.holeValue = this.dataObject.holeValue;
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.inverted = this.xaxis.isVertical;
        if (n == -1 || n == 0) {
            this.xlim = new MinMax(this.dataObject.xLimits.min, this.dataObject.xLimits.max);
            this.ylim = new MinMax(this.dataObject.yLimits.min, this.dataObject.yLimits.max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    public void draw(Graphics graphics) {
        try {
            if (this.seriesList == null) {
                return;
            }
            this.isComplex = this.cf.getIsComplex();
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            int n = this.seriesList.length / 4;
            int n2 = 0;
            while (n2 < n) {
                block28: {
                    JCChartStyle jCChartStyle;
                    JCChartStyle jCChartStyle2;
                    JCChartStyle jCChartStyle3;
                    JCLineStyle jCLineStyle;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    block30: {
                        JCChartStyle jCChartStyle4;
                        block29: {
                            boolean bl4 = true;
                            n7 = Integer.MAX_VALUE;
                            n6 = Integer.MAX_VALUE;
                            boolean bl5 = true;
                            n5 = 0;
                            int n8 = 0;
                            n5 = 4 * n2;
                            n8 = 0;
                            while (n8 < 4) {
                                ChartDataViewSeries chartDataViewSeries = this.seriesList[n5];
                                if (!chartDataViewSeries.isShowing) {
                                    bl5 = false;
                                    break;
                                }
                                if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                                    bl4 = false;
                                    break;
                                }
                                n7 = Math.min(n7, chartDataViewSeries.getFirstPoint());
                                n6 = Math.min(n6, chartDataViewSeries.getLastPoint());
                                ++n8;
                                ++n5;
                            }
                            if (!bl5 || !bl4) break block28;
                            n4 = 0;
                            n3 = 0;
                            jCChartStyle4 = this.cf.getHiloStyle(n2);
                            if (jCChartStyle4 == null) break block28;
                            jCLineStyle = jCChartStyle4.getLineStyle();
                            if (!this.isComplex) break block29;
                            jCChartStyle3 = this.cf.getRisingCandleStyle(n2);
                            if (jCChartStyle3 == null) break block28;
                            n4 = jCChartStyle3.getSymbolSize();
                            jCChartStyle2 = this.cf.getFallingCandleStyle(n2);
                            if (jCChartStyle2 == null) break block28;
                            n3 = jCChartStyle2.getSymbolSize();
                            jCChartStyle = this.cf.getCandleOutlineStyle(n2);
                            if (jCChartStyle != null) break block30;
                            break block28;
                        }
                        jCChartStyle3 = jCChartStyle4;
                        jCChartStyle2 = jCChartStyle4;
                        jCChartStyle = jCChartStyle4;
                        n3 = n4 = jCChartStyle4.getSymbolSize();
                    }
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    int n9 = n7;
                    while (n9 <= n6) {
                        block32: {
                            double d;
                            double d2;
                            double d3;
                            double d4;
                            double d5;
                            double d6;
                            double d7;
                            double d8;
                            block31: {
                                int n10 = 4 * n2;
                                ChartDataViewSeries chartDataViewSeries = this.seriesList[n10++];
                                double d9 = chartDataViewSeries.getX(n9);
                                double d10 = chartDataViewSeries.getY(n9);
                                chartDataViewSeries = this.seriesList[n10++];
                                double d11 = chartDataViewSeries.getX(n9);
                                double d12 = chartDataViewSeries.getY(n9);
                                if (d10 < d12) {
                                    d8 = d9;
                                    d7 = d10;
                                    d9 = d11;
                                    d10 = d12;
                                    d11 = d8;
                                    d12 = d7;
                                }
                                chartDataViewSeries = this.seriesList[n10++];
                                d6 = chartDataViewSeries.getX(n9);
                                d5 = chartDataViewSeries.getY(n9);
                                chartDataViewSeries = this.seriesList[n10++];
                                d4 = chartDataViewSeries.getX(n9);
                                d3 = chartDataViewSeries.getY(n9);
                                bl = d5 < d3;
                                bl3 = d10 != this.holeValue && d12 != this.holeValue && d9 != this.holeValue && d11 != this.holeValue;
                                bl2 = d3 != this.holeValue && d5 != this.holeValue && d4 != this.holeValue && d6 != this.holeValue;
                                d8 = d9;
                                d7 = d10;
                                if (!bl3) break block31;
                                if (bl2) {
                                    d2 = bl ? d4 : d6;
                                    d = bl ? d3 : d5;
                                } else {
                                    d2 = d11;
                                    d = d12;
                                }
                                plotPointArray[0].valid = false;
                                plotPointArray[1].valid = false;
                                this.financialClip(d8, d7, d2, d, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                                    jCLineStyle.draw(graphics, plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py);
                                }
                                if (!bl2) break block32;
                                d8 = d11;
                                d7 = d12;
                                d2 = bl ? d6 : d4;
                                d = bl ? d5 : d3;
                                plotPointArray[0].valid = false;
                                plotPointArray[1].valid = false;
                                this.financialClip(d8, d7, d2, d, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                                    jCLineStyle.draw(graphics, plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py);
                                }
                            }
                            if (bl2) {
                                boolean bl6 = false;
                                int n11 = Integer.MAX_VALUE;
                                int n12 = Integer.MAX_VALUE;
                                int n13 = Integer.MIN_VALUE;
                                int n14 = Integer.MIN_VALUE;
                                double d13 = d6;
                                double d14 = d5;
                                int n15 = this.xaxis.toPixel(d13, this.drawFront);
                                int n16 = (bl ? n4 : n3) / 2;
                                d8 = this.xaxis.toData(n15 - n16, this.drawFront);
                                d7 = d14;
                                d2 = this.xaxis.toData(n15 + n16, this.drawFront);
                                d = d14;
                                boolean bl7 = !(d5 > this.ylim.max && d3 > this.ylim.max || d5 < this.ylim.min && d3 < this.ylim.min);
                                plotPointArray[0].valid = false;
                                plotPointArray[1].valid = false;
                                this.financialClip(d8, d7, d2, d, this.xlim, this.ylim, plotPointArray, this.inverted, bl7);
                                n5 = 0;
                                while (n5 < plotPointArray.length && !bl6) {
                                    if (plotPointArray[n5].valid) {
                                        n11 = Math.min(n11, plotPointArray[n5].px);
                                        n13 = Math.max(n13, plotPointArray[n5].px);
                                        n12 = Math.min(n12, plotPointArray[n5].py);
                                        n14 = Math.max(n14, plotPointArray[n5].py);
                                    } else {
                                        bl6 = true;
                                    }
                                    ++n5;
                                }
                                if (!bl6) {
                                    d13 = d4;
                                    d14 = d3;
                                    n15 = this.xaxis.toPixel(d13, this.drawFront);
                                    d8 = this.xaxis.toData(n15 - n16, this.drawFront);
                                    d7 = d14;
                                    d2 = this.xaxis.toData(n15 + n16, this.drawFront);
                                    d = d14;
                                    plotPointArray[0].valid = false;
                                    plotPointArray[1].valid = false;
                                    this.financialClip(d8, d7, d2, d, this.xlim, this.ylim, plotPointArray, this.inverted, bl7);
                                    n5 = 0;
                                    while (n5 < plotPointArray.length && !bl6) {
                                        if (plotPointArray[n5].valid) {
                                            n11 = Math.min(n11, plotPointArray[n5].px);
                                            n13 = Math.max(n13, plotPointArray[n5].px);
                                            n12 = Math.min(n12, plotPointArray[n5].py);
                                            n14 = Math.max(n14, plotPointArray[n5].py);
                                        } else {
                                            bl6 = true;
                                        }
                                        ++n5;
                                    }
                                    if (!bl6) {
                                        if (bl) {
                                            this.drawCandleRect(graphics, jCChartStyle3.getFillStyle(), jCChartStyle.getLineStyle(), n11, n12, n13, n14, this.isComplex, bl);
                                        } else {
                                            this.drawCandleRect(graphics, jCChartStyle2.getFillStyle(), jCChartStyle.getLineStyle(), n11, n12, n13, n14, this.isComplex, bl);
                                        }
                                    }
                                }
                            }
                        }
                        ++n9;
                    }
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    private final void drawCandleRect(Graphics graphics, JCFillStyle jCFillStyle, JCLineStyle jCLineStyle, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = Math.max(n3 - n, 1);
        int n6 = Math.max(n4 - n2, 1);
        if (bl) {
            jCFillStyle.fillRect(graphics, n, n2, n5, n6);
            jCLineStyle.drawRect(graphics, n, n2, n5, n6);
            return;
        }
        if (!bl2) {
            jCLineStyle.fillRect(graphics, n, n2, n5, n6);
        }
        jCLineStyle.drawRect(graphics, n, n2, n5, n6);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        double d = this.inverted ? this.xaxis.toData(point2.y, this.drawFront) : this.xaxis.toData(point2.x, this.drawFront);
        double d2 = this.inverted ? this.yaxis.toData(point2.x, this.drawFront) : this.yaxis.toData(point2.y, this.drawFront);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        double d3 = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        int n4 = this.seriesList.length / 4;
        try {
            int n5;
            int n6;
            int n7 = 0;
            while (n7 < n4) {
                n6 = 1;
                n5 = Integer.MAX_VALUE;
                int n8 = Integer.MAX_VALUE;
                boolean bl = true;
                int n9 = 4 * n7;
                int n10 = 0;
                while (n10 < 4) {
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n9];
                    if (!chartDataViewSeries.isShowing) {
                        bl = false;
                        break;
                    }
                    if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                        n6 = 0;
                        break;
                    }
                    n5 = Math.min(n5, chartDataViewSeries.getFirstPoint());
                    n8 = Math.min(n8, chartDataViewSeries.getLastPoint());
                    ++n10;
                    ++n9;
                }
                if (bl && n6 != 0) {
                    Object object;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    if (this.isComplex) {
                        object = this.cf.getRisingCandleStyle(n7);
                        if (object != null) {
                            d4 = Math.abs(this.xaxis.toData(0) - this.xaxis.toData(((JCChartStyle)object).getSymbolSize()));
                        }
                        if ((object = this.cf.getFallingCandleStyle(n7)) != null) {
                            d5 = Math.abs(this.xaxis.toData(0) - this.xaxis.toData(((JCChartStyle)object).getSymbolSize()));
                        }
                    } else {
                        object = this.cf.getHiloStyle(n7);
                        if (object != null) {
                            d5 = d4 = Math.abs(this.xaxis.toData(0) - this.xaxis.toData(((JCChartStyle)object).getSymbolSize()));
                        }
                    }
                    object = this.seriesList[4 * n7].getX();
                    double[] dArray = this.seriesList[4 * n7].getY();
                    double[] dArray2 = this.seriesList[4 * n7 + 1].getX();
                    double[] dArray3 = this.seriesList[4 * n7 + 1].getY();
                    double[] dArray4 = this.seriesList[4 * n7 + 2].getX();
                    double[] dArray5 = this.seriesList[4 * n7 + 2].getY();
                    double[] dArray6 = this.seriesList[4 * n7 + 3].getX();
                    double[] dArray7 = this.seriesList[4 * n7 + 3].getY();
                    double d6 = 0.0;
                    double d7 = 0.0;
                    int n11 = n5;
                    while (n11 <= n8) {
                        int n12;
                        int n13;
                        Object object2 = object[n11];
                        double d8 = dArray[n11];
                        Object object3 = dArray2[n11];
                        double d9 = dArray3[n11];
                        if (d8 < d9) {
                            Object object4 = object2;
                            double d10 = d8;
                            object2 = object3;
                            d8 = d9;
                            object3 = object4;
                            d9 = d10;
                        }
                        double d11 = dArray4[n11];
                        double d12 = dArray5[n11];
                        double d13 = dArray6[n11];
                        double d14 = dArray7[n11];
                        boolean bl2 = d14 != this.holeValue && d12 != this.holeValue && d13 != this.holeValue && d11 != this.holeValue;
                        double d15 = d12 < d14 ? d4 : d5;
                        boolean bl3 = false;
                        if (d8 != this.holeValue && d9 != this.holeValue && object2 != this.holeValue && object3 != this.holeValue) {
                            if (bl2) {
                                n13 = 0;
                                n12 = 4;
                            } else {
                                n13 = 0;
                                n12 = 2;
                            }
                        } else if (bl2) {
                            n13 = 2;
                            n12 = 4;
                        } else {
                            n13 = 0;
                            n12 = 0;
                        }
                        int n14 = n13;
                        block15: while (n14 < n12) {
                            double d16;
                            switch (n14) {
                                case 0: {
                                    d6 = (double)object2;
                                    d7 = d8;
                                    break;
                                }
                                case 1: {
                                    d6 = object3;
                                    d7 = d9;
                                    break;
                                }
                                case 2: {
                                    if (d15 == 0.0) {
                                        ++n14;
                                        continue block15;
                                    }
                                    if (!bl3) {
                                        d6 = d11 - d15;
                                        d7 = d12;
                                        bl3 = true;
                                        break;
                                    }
                                    d6 = d11 + d15;
                                    bl3 = false;
                                    break;
                                }
                                case 3: {
                                    if (d15 == 0.0) {
                                        ++n14;
                                        continue block15;
                                    }
                                    if (!bl3) {
                                        d6 = d13 - d15;
                                        d7 = d14;
                                        bl3 = true;
                                        break;
                                    }
                                    d6 = d13 + d15;
                                    bl3 = false;
                                }
                            }
                            if (d6 > this.xlim.max || this.xlim.min > d6 || d7 > this.ylim.max || this.ylim.min > d7) {
                                if (bl3) continue;
                                ++n14;
                                continue;
                            }
                            switch (n) {
                                case 1: {
                                    d16 = Math.abs(d6 - d);
                                    break;
                                }
                                case 2: {
                                    d16 = Math.abs(d7 - d2);
                                    break;
                                }
                                default: {
                                    d16 = Math.sqrt((d6 - d) * (d6 - d) + (d7 - d2) * (d7 - d2));
                                }
                            }
                            if (d3 > d16) {
                                n2 = n7 * 4 + n14;
                                n3 = n11;
                                d3 = d16;
                            }
                            if (bl3) continue;
                            ++n14;
                        }
                        ++n11;
                    }
                }
                ++n7;
            }
            if (n2 >= 0 && n3 >= 0) {
                jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
                n6 = this.inverted ? this.yaxis.toPixel(this.seriesList[n2].getY(n3)) : this.xaxis.toPixel(this.seriesList[n2].getX(n3));
                n5 = this.inverted ? this.xaxis.toPixel(this.seriesList[n2].getX(n3)) : this.yaxis.toPixel(this.seriesList[n2].getY(n3));
                jCDataIndex.distance = (int)Math.sqrt((n6 - point2.x) * (n6 - point2.x) + (n5 - point2.y) * (n5 - point2.y));
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d;
        double d2;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        int n = jCDataIndex.series.drawingOrder / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        this.useRubberBand = false;
        int n2 = n * 4;
        int n3 = jCDataIndex.seriesIndex - n2;
        int n4 = 0;
        int n5 = 0;
        if (this.isComplex) {
            JCChartStyle jCChartStyle = this.cf.getRisingCandleStyle(n);
            if (jCChartStyle != null) {
                n4 = jCChartStyle.getSymbolSize();
            }
            if ((jCChartStyle = this.cf.getFallingCandleStyle(n)) != null) {
                n5 = jCChartStyle.getSymbolSize();
            }
        } else {
            JCChartStyle jCChartStyle = this.cf.getHiloStyle(n);
            if (jCChartStyle != null) {
                n5 = n4 = jCChartStyle.getSymbolSize();
            }
        }
        boolean bl2 = (d2 = this.seriesList[n2 + 2].getY(jCDataIndex.point)) < (d = this.seriesList[n2 + 3].getY(jCDataIndex.point));
        int n6 = bl2 ? n4 : n5;
        double d3 = this.seriesList[n2 + n3].getX(jCDataIndex.point);
        double d4 = this.seriesList[n2 + n3].getY(jCDataIndex.point);
        if (n3 > 1) {
            this.useRubberBand = true;
            if (bl) {
                this.start = new Point(this.yaxis.toPixel(d4) + this.r.x, this.xaxis.toPixel(d3) + this.r.y - n6 / 2);
                this.end = new Point(this.start.x, this.start.y + n6);
                return;
            }
            this.start = new Point(this.xaxis.toPixel(d3) + this.r.x - n6 / 2, this.yaxis.toPixel(d4) + this.r.y);
            this.end = new Point(this.start.x + n6, this.start.y);
            return;
        }
        this.start = bl ? new Point(this.yaxis.toPixel(d4) + this.r.x, this.xaxis.toPixel(d3) + this.r.y) : new Point(this.xaxis.toPixel(d3) + this.r.x, this.yaxis.toPixel(d4) + this.r.y);
        this.end = new Point(this.start.x, this.start.y);
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
            return;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    int getNumSeriesPerData() {
        return 4;
    }
}

