/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import jclass.chart.Changeable;
import jclass.chart.ChartData;
import jclass.chart.ChartDataModelUpdate;
import jclass.chart.ChartDataViewHTMLLoad;
import jclass.chart.ChartDataViewHTMLSave;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.Chartable;
import jclass.chart.DataInterpretation;
import jclass.chart.DoubleCoord;
import jclass.chart.EditableChartable;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCAreaChartFormat;
import jclass.chart.JCAxis;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCCandleChartFormat;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartLabel;
import jclass.chart.JCChartListener;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataCoord;
import jclass.chart.JCDataIndex;
import jclass.chart.JCDrawableColorHandler;
import jclass.chart.JCHLOCChartFormat;
import jclass.chart.JCHiloChartFormat;
import jclass.chart.JCPieChartFormat;
import jclass.chart.MinMax;
import jclass.util.JCString;
import jclass.util.JCVector;

public class ChartDataView
implements Observer,
Changeable,
Serializable,
HTMLHandler {
    protected JCVector series = new JCVector();
    public static final int PICK_FOCUS_LOCAL = -1;
    public static final int PICK_FOCUS_XY = 0;
    public static final int PICK_FOCUS_X = 1;
    public static final int PICK_FOCUS_Y = 2;
    private double[] xvalues;
    boolean isBatched = false;
    boolean fastUpdate = false;
    boolean bufferPlotData = true;
    double holeValue = Double.MAX_VALUE;
    int chartType = 0;
    String name;
    JCString realName;
    int drawingOrder = -1;
    boolean drawFrontPlane = true;
    Chartable dataSource;
    DataInterpretation dataInterpretation;
    int datatype = 0;
    JCAxis xaxis;
    JCAxis yaxis;
    JCVector pointLabels = new JCVector();
    JCAreaChartFormat areaChartFormat;
    JCBarChartFormat barChartFormat;
    JCPieChartFormat pieChartFormat;
    JCHiloChartFormat hiloChartFormat;
    JCHLOCChartFormat HLOCChartFormat;
    JCCandleChartFormat CandleChartFormat;
    private transient Object transientData;
    boolean isInverted = false;
    int pickFocus = 0;
    boolean isShowingInLegend = true;
    private JCVector styles = new JCVector();
    boolean autoLabel = false;
    JCChartLabel[][] autoLabelList;
    Color outlineColor;
    JCDrawableColorHandler colorHandler;
    boolean isShowing = true;
    boolean changed = true;
    int changedFlag = 0;
    boolean allowPick = true;
    JCChart chart;
    MinMax xLimits;
    MinMax yLimits;
    public static final String[] chartType_strings = new String[]{"PLOT", "SCATTER_PLOT", "AREA", "STACKING_AREA", "BAR", "STACKING_BAR", "PIE", "HILO", "HILO_OPEN_CLOSE", "CANDLE"};
    public static final int[] chartType_values;
    static int dataViewNum;

    ChartDataView(JCChart jCChart) {
        this.setChartType(0);
        this.setParent(jCChart);
        this.name = String.valueOf(JCChartBundle.string("jclass.chart.Key26")) + ++dataViewNum;
    }

    public ChartDataView() {
        this.setChartType(0);
        this.name = String.valueOf(JCChartBundle.string("jclass.chart.Key26")) + ++dataViewNum;
    }

    public void setParent(JCChart jCChart) {
        this.chart = jCChart;
        if (this.chart != null && this.chart.chartArea != null) {
            if (this.xaxis == null || !this.chart.chartArea.xaxes.contains(this.xaxis)) {
                this.xaxis = this.chart.chartArea.getXAxis(0);
            }
            if (this.yaxis == null || !this.chart.chartArea.yaxes.contains(this.yaxis)) {
                this.yaxis = this.chart.chartArea.getYAxis(0);
            }
        }
        this.setChanged(true, 2, false);
    }

    public JCChart getParent() {
        return this.chart;
    }

    void draw(Graphics graphics) {
    }

    boolean editPoint(ChartDataViewSeries chartDataViewSeries, int n, double d) {
        if (this.dataSource == null) {
            return true;
        }
        if (!(this.dataSource instanceof EditableChartable)) {
            return false;
        }
        int n2 = -1;
        n2 = this.series.indexOf(chartDataViewSeries);
        if (n2 == -1) {
            throw new RuntimeException(JCChartBundle.string("jclass.chart.Key8"));
        }
        return this.dataInterpretation.editPoint(n2, n, d);
    }

    public void update(Observable observable, Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof ChartDataModelUpdate)) {
            return;
        }
        ChartDataModelUpdate chartDataModelUpdate = (ChartDataModelUpdate)object;
        switch (chartDataModelUpdate.message) {
            case 0: {
                this.dataInterpretation.changeValue(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 1: {
                this.dataInterpretation.addValue(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 2: {
                this.dataInterpretation.removeValue(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 3: {
                this.dataInterpretation.changeRow(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 4: {
                this.dataInterpretation.addRow(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 5: {
                this.dataInterpretation.removeRow(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 6: {
                this.dataInterpretation.changeColumn(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 7: {
                this.dataInterpretation.addColumn(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 8: {
                this.dataInterpretation.removeColumn(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 9: {
                this.dataInterpretation.changePointLabel(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 10: {
                this.dataInterpretation.changeSeriesName(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 11: {
                this.dataInterpretation.changeSeriesLabel(chartDataModelUpdate.row, chartDataModelUpdate.column);
                break;
            }
            case 12: {
                this.dataInterpretation.appendColumns(0, chartDataModelUpdate.column, chartDataModelUpdate.row);
                int n = this.getChartType();
                if (!this.fastUpdate || this.chart.getPeer() == null || n != 0 && n != 1 && n != 8 || !this.checkNewPoints(chartDataModelUpdate.row)) break;
                boolean bl = false;
                ChartDraw chartDraw = this.chart.chartArea.getDrawable(this);
                if (chartDraw != null) {
                    Enumeration enumeration = this.chart.chartArea.getRegionLock();
                    synchronized (enumeration) {
                        Graphics graphics = null;
                        Graphics graphics2 = null;
                        try {
                            chartDraw.recalc(chartDataModelUpdate.column, chartDataModelUpdate.column + chartDataModelUpdate.row - 1);
                            graphics = this.chart.chartArea.getGraphics();
                            Rectangle rectangle = this.chart.getDrawingArea();
                            graphics.translate(rectangle.x, rectangle.y);
                            rectangle = this.chart.chartArea.getDrawingArea();
                            graphics.translate(rectangle.x, rectangle.y);
                            graphics2 = this.chart.chartArea.clipForDrawing(graphics);
                            this.chart.repaint();
                            bl = true;
                        }
                        catch (Exception exception) {}
                        if (graphics != null) {
                            graphics.dispose();
                        }
                        if (graphics2 != null) {
                            graphics2.dispose();
                        }
                    }
                    if (bl) {
                        enumeration = this.chart.listeners.elements();
                        while (enumeration.hasMoreElements()) {
                            ((JCChartListener)enumeration.nextElement()).paintChart(this.chart);
                        }
                    }
                }
                if (!bl) break;
                return;
            }
            case 13: {
                this.setChartType(chartDataModelUpdate.row);
                break;
            }
            case 14: 
            case 21: {
                this.setChanged(true, 34, false);
                boolean bl = this.getIsBatched();
                this.setIsBatched(true);
                this.dataInterpretation.reset(chartDataModelUpdate.row, chartDataModelUpdate.column);
                this.setIsBatched(bl);
                return;
            }
            case 15: {
                this.setDataSource(this.dataSource, false);
                return;
            }
            case 16: {
                this.setChanged(true, 34, false);
                this.dataInterpretation.loadData(this.dataSource);
                return;
            }
            case 17: {
                this.dataInterpretation.changePointLabels();
                break;
            }
            case 18: {
                this.dataInterpretation.changeSeriesNames();
                break;
            }
            case 19: {
                this.dataInterpretation.changeSeriesLabels();
                break;
            }
            case 20: {
                this.dataInterpretation.changeName();
                break;
            }
            case 22: {
                this.setDataSource(null);
                break;
            }
        }
        this.setChanged(true, 34);
    }

    public void update(Object object) {
        this.update(null, object);
    }

    public boolean checkNewPoints(int n) {
        int n2 = 0;
        while (n2 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = this.getSeries(n2);
            int n3 = chartDataViewSeries.maxIndex();
            int n4 = n3 - n + 1;
            while (n4 <= n3) {
                double d = chartDataViewSeries.getX(n4);
                if (d != this.holeValue && (this.xaxis.getMaxIsDefault() && d > this.xaxis.getMax() || this.xaxis.getMinIsDefault() && d < this.xaxis.getMin())) {
                    return false;
                }
                double d2 = chartDataViewSeries.getY(n4);
                if (d2 != this.holeValue && (this.yaxis.getMaxIsDefault() && d2 > this.yaxis.getMax() || this.yaxis.getMinIsDefault() && d2 < this.yaxis.getMin())) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public double getHoleValue() {
        return this.holeValue;
    }

    public void setHoleValue(double d) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.holeValue = d;
        }
        this.setChanged(true, 130);
    }

    public boolean getIsBatched() {
        return this.isBatched;
    }

    public void setIsBatched(boolean bl) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (this.isBatched == bl) {
                Object var3_3 = null;
                return;
            }
            this.isBatched = bl;
        }
        if (!bl) {
            this.propagateChange();
        }
    }

    public boolean getFastUpdate() {
        return this.fastUpdate;
    }

    public void setFastUpdate(boolean bl) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (this.fastUpdate == bl) {
                Object var3_3 = null;
                return;
            }
            this.fastUpdate = bl;
            return;
        }
    }

    public boolean getBufferPlotData() {
        return this.bufferPlotData;
    }

    public void setBufferPlotData(boolean bl) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (this.bufferPlotData == bl) {
                Object var3_3 = null;
                return;
            }
            this.bufferPlotData = bl;
            return;
        }
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int n) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (this.chartType == n) {
                Object var3_3 = null;
                return;
            }
            if (this.xaxis != null) {
                this.xaxis.annotationMethod = this.xaxis.savedXAxisAnnotationMethod;
            }
            switch (n) {
                case 2: 
                case 3: 
                case 4: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key21"));
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key55"));
                }
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
            }
            switch (this.chartType) {
                case 11: {
                    if (this.yaxis != null) {
                        this.yaxis.isShowing = true;
                        this.yaxis.setChanged(true, 2, false);
                    }
                    if (this.xaxis == null) break;
                    this.xaxis.isShowing = true;
                    this.xaxis.setChanged(true, 2, false);
                    break;
                }
                case 9: 
                case 10: {
                    if (this.xaxis == null) break;
                    this.xaxis.setChanged(true, 2, false);
                    break;
                }
            }
            this.chartType = n;
            if (this.chartType == 11 && this.pieChartFormat == null) {
                this.pieChartFormat = new JCPieChartFormat(this);
            }
            if ((this.chartType == 8 || this.chartType == 12) && this.areaChartFormat == null) {
                this.areaChartFormat = new JCAreaChartFormat(this);
            }
            if ((this.chartType == 9 || this.chartType == 10) && this.barChartFormat == null) {
                this.barChartFormat = new JCBarChartFormat(this);
            }
            if (this.chartType == 5 && this.hiloChartFormat == null) {
                this.hiloChartFormat = new JCHiloChartFormat(this);
            }
            if (this.chartType == 6 && this.HLOCChartFormat == null) {
                this.HLOCChartFormat = new JCHLOCChartFormat(this);
            }
            if (this.chartType == 7 && this.CandleChartFormat == null) {
                this.CandleChartFormat = new JCCandleChartFormat(this);
            }
            switch (this.chartType) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    if (this.yaxis == null || this.xaxis == null) break;
                    boolean bl = false;
                    if (this.yaxis.getOriginPlacementIsDefault() && this.yaxis.originPlacement.value != 0) {
                        this.yaxis.originPlacement.value = 0;
                        bl = true;
                    }
                    if (this.yaxis.getPlacementIsDefault() && this.yaxis.placement.value != 0) {
                        this.yaxis.placement.value = 0;
                        bl = true;
                    }
                    if (bl) {
                        this.yaxis.setChanged(true, 2, false);
                    }
                    if (!this.xaxis.getPlacementIsDefault() || this.xaxis.placement.value == 0) break;
                    this.xaxis.placement.value = 0;
                    this.xaxis.setChanged(true, 2, false);
                    break;
                }
                case 9: 
                case 10: {
                    int n2;
                    if (this.yaxis == null || this.xaxis == null) break;
                    this.xaxis.savedXAxisAnnotationMethod = this.xaxis.annotationMethod;
                    this.xaxis.placementAxis = this.yaxis;
                    boolean bl = true;
                    if (this.chart != null) {
                        n2 = 0;
                        while (n2 < this.chart.chartArea.xaxes.size()) {
                            if (this.chart.chartArea.getXAxis((int)n2).annotationMethod != 0) {
                                bl = false;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (bl) {
                        this.xaxis.annotationMethod = 3;
                    }
                    if (this.xaxis.getPlacementIsDefault()) {
                        this.xaxis.placement.value = 5;
                    }
                    this.xaxis.setChanged(true, 2, false);
                    n2 = 0;
                    if (this.yaxis.getPlacementIsDefault()) {
                        this.yaxis.placement.value = 1;
                        n2 = 1;
                    }
                    if (this.yaxis.getOriginPlacementIsDefault()) {
                        this.yaxis.originPlacement.value = 3;
                        n2 = 1;
                    }
                    if (n2 == 0) break;
                    this.yaxis.setChanged(true, 2, false);
                    break;
                }
                case 8: 
                case 12: {
                    if (this.yaxis == null || this.xaxis == null) break;
                    boolean bl = false;
                    if (this.yaxis.getPlacementIsDefault()) {
                        this.yaxis.placement.value = 1;
                        bl = true;
                    }
                    if (this.yaxis.getOriginPlacementIsDefault()) {
                        this.yaxis.originPlacement.value = 3;
                        bl = true;
                    }
                    if (bl) {
                        this.yaxis.setChanged(true, 2, false);
                    }
                    if (this.xaxis.getPlacementIsDefault()) {
                        this.xaxis.placement.value = 5;
                    }
                    this.xaxis.placementAxis = this.yaxis;
                    this.xaxis.setChanged(true, 2, false);
                    break;
                }
                case 11: {
                    if (this.yaxis != null) {
                        this.yaxis.isShowing = false;
                        this.yaxis.setChanged(true, 2, false);
                    }
                    if (this.xaxis == null) break;
                    this.xaxis.isShowing = false;
                    this.xaxis.setChanged(true, 2, false);
                    break;
                }
            }
        }
        if (this.chart != null) {
            this.chart.chartArea.removeDrawable(this);
        }
        this.setChanged(true, 34);
    }

    public String getName() {
        return this.name;
    }

    JCString getRealName() {
        return this.realName;
    }

    public void setName(String string) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (this.name != null && this.name.equals(string)) {
                Object var3_3 = null;
                return;
            }
            if (string != null) {
                this.name = string;
            }
            this.realName = this.name == null ? null : (this.chart != null ? JCString.parse(this.chart, this.name) : JCString.parse(null, this.name));
        }
        this.setChanged(true, 33);
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public void setDrawingOrder(int n) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (n < 0 || this.chart != null && n >= this.chart.data.size()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key30"));
            }
            this.drawingOrder = n;
        }
        this.setChanged(true, 17);
    }

    public boolean getDrawFrontPlane() {
        return this.drawFrontPlane;
    }

    public void setDrawFrontPlane(boolean bl) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.drawFrontPlane = bl;
        }
        this.setChanged(true, 1);
    }

    public Chartable getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(Chartable chartable) {
        this.setDataSource(chartable, true);
    }

    void setDataSource(Chartable chartable, boolean bl) {
        boolean bl2 = false;
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.dataSource = chartable;
            if (this.dataSource == null) {
                this.dataInterpretation = null;
                this.series = new JCVector();
                this.autoLabelList = null;
                this.setX(null);
                this.setChanged(true, 162);
                Object var5_5 = null;
                return;
            }
            bl2 = this.getIsBatched();
            this.setIsBatched(true);
            this.dataInterpretation = DataInterpretation.getData(this, chartable);
            this.datatype = chartable.getDataInterpretation();
            if (bl) {
                int n;
                String[] stringArray = chartable.getPointLabels();
                if (stringArray != null) {
                    this.pointLabels = new JCVector();
                    n = 0;
                    while (n < stringArray.length) {
                        this.pointLabels.addElement(stringArray[n]);
                        ++n;
                    }
                }
                n = 0;
                while (n < this.series.size()) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n);
                    chartDataViewSeries.setName(chartable.getSeriesName(n));
                    chartDataViewSeries.setLabel(chartable.getSeriesLabel(n));
                    ++n;
                }
                this.setName(chartable.getName());
                if (chartable instanceof Observable) {
                    ((Observable)((Object)chartable)).addObserver(this);
                }
                if (!(this.dataSource instanceof EditableChartable || this.dataSource instanceof Observable || this.dataSource instanceof ChartData)) {
                    this.dataSource = null;
                }
            }
        }
        this.generateAutoLabels();
        this.setChanged(true, 162, false);
        this.setIsBatched(bl2);
    }

    public String getPointLabel(int n) {
        if (n < 0 || n >= this.pointLabels.size()) {
            throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key65"));
        }
        return (String)this.pointLabels.elementAt(n);
    }

    public void setPointLabel(int n, String string) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (n < 0 || n >= this.pointLabels.size()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key65"));
            }
            this.pointLabels.setElementAt(n, string);
        }
        this.setChanged(true, 130);
    }

    public String[] getPointLabels() {
        if (this.pointLabels == null || this.pointLabels.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.pointLabels.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)this.pointLabels.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public int getNumPointLabels() {
        return this.pointLabels.size();
    }

    public void setPointLabels(String[] stringArray) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.pointLabels = new JCVector(stringArray);
        }
        this.setChanged(true, 130);
    }

    public JCChartLabel[][] getAutoLabelList() {
        return this.autoLabelList;
    }

    public ChartDataViewSeries[] getSeries() {
        ChartDataViewSeries[] chartDataViewSeriesArray = new ChartDataViewSeries[this.series.size()];
        int n = 0;
        while (n < this.series.size()) {
            chartDataViewSeriesArray[n] = (ChartDataViewSeries)this.series.elementAt(n);
            ++n;
        }
        return chartDataViewSeriesArray;
    }

    public ChartDataViewSeries getSeries(int n) {
        if (n < 0 || n >= this.series.size()) {
            throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key58"));
        }
        return (ChartDataViewSeries)this.series.elementAt(n);
    }

    public void setSeries(ChartDataViewSeries[] chartDataViewSeriesArray) {
        this.removeAutoLabels();
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.series = new JCVector(chartDataViewSeriesArray);
        }
        this.generateAutoLabels();
        if (this.chart != null) {
            if (this.chartType == 11) {
                this.getPieChartFormat().getOtherStyle();
            }
            int n = 0;
            while (n < this.series.size()) {
                this.getChartStyle(n);
                ++n;
            }
        }
        this.setChanged(true, 162);
    }

    public void setSeries(int n, ChartDataViewSeries chartDataViewSeries) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (n < 0 || n >= this.series.size()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key58"));
            }
            this.series.setElementAt(n, chartDataViewSeries);
            int n2 = 0;
            while (n2 <= chartDataViewSeries.maxIndex()) {
                this.setAutoLabelText(n, n2);
                ++n2;
            }
        }
        this.setChanged(true, 162);
    }

    public ChartDataViewSeries addSeries(int n) {
        ChartDataViewSeries chartDataViewSeries = null;
        if (n < 0) {
            n = 0;
        }
        if (n > this.series.size()) {
            n = this.series.size();
        }
        chartDataViewSeries = new ChartDataViewSeries();
        chartDataViewSeries.init(null, null, this);
        chartDataViewSeries.setDrawingOrder(n);
        this.series.insertElementAt(chartDataViewSeries, n);
        this.addAutoLabels(n, -1);
        this.setChanged(true, 2);
        return chartDataViewSeries;
    }

    public void addSeries(ChartDataViewSeries chartDataViewSeries) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            chartDataViewSeries.setDrawingOrder(this.series.size());
            this.series.addElement(chartDataViewSeries);
            this.addAutoLabels(this.series.size() - 1, -1);
        }
        this.setChanged(true, 2);
    }

    public void removeSeries(int n) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (n < 0 || n >= this.series.size()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key57"));
            }
            this.series.removeElementAt(n);
        }
        this.removeAutoLabels(n, -1);
        this.setChanged(true, 2);
    }

    public int getSeriesIndex(String string) {
        try {
            int n = 0;
            while (n < this.series.size()) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n);
                if (string.equals(chartDataViewSeries.getName())) {
                    return n;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return -1;
    }

    public int getSeriesIndex(ChartDataViewSeries chartDataViewSeries) {
        return this.series.indexOf(chartDataViewSeries);
    }

    public JCPieChartFormat getPieChartFormat() {
        if (this.pieChartFormat == null) {
            this.pieChartFormat = new JCPieChartFormat(this);
        }
        return this.pieChartFormat;
    }

    public JCAreaChartFormat getAreaChartFormat() {
        if (this.areaChartFormat == null) {
            this.areaChartFormat = new JCAreaChartFormat(this);
        }
        return this.areaChartFormat;
    }

    public JCBarChartFormat getBarChartFormat() {
        if (this.barChartFormat == null) {
            this.barChartFormat = new JCBarChartFormat(this);
        }
        return this.barChartFormat;
    }

    public JCHiloChartFormat getHiloChartFormat() {
        if (this.hiloChartFormat == null) {
            this.hiloChartFormat = new JCHiloChartFormat(this);
        }
        return this.hiloChartFormat;
    }

    public JCHLOCChartFormat getHLOCChartFormat() {
        if (this.HLOCChartFormat == null) {
            this.HLOCChartFormat = new JCHLOCChartFormat(this);
        }
        return this.HLOCChartFormat;
    }

    public JCCandleChartFormat getCandleChartFormat() {
        if (this.CandleChartFormat == null) {
            this.CandleChartFormat = new JCCandleChartFormat(this);
        }
        return this.CandleChartFormat;
    }

    public JCAxis getXAxis() {
        return this.xaxis;
    }

    public void setXAxis(JCAxis jCAxis) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.xaxis = jCAxis;
        }
        this.setChanged(true, 130);
    }

    public JCAxis getYAxis() {
        return this.yaxis;
    }

    public void setYAxis(JCAxis jCAxis) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.yaxis = jCAxis;
        }
        this.setChanged(true, 130);
    }

    public JCDataCoord map(int n, int n2) {
        Rectangle rectangle = this.chart.chartArea.getDrawingArea();
        Rectangle rectangle2 = this.chart.getDrawingArea();
        n -= rectangle.x + rectangle2.x;
        n2 -= rectangle.y + rectangle2.y;
        JCDataCoord jCDataCoord = new JCDataCoord(this.holeValue, this.holeValue);
        if (this.xaxis != null) {
            double d = jCDataCoord.x = this.xaxis.isVertical ? this.xaxis.toData(n2) : this.xaxis.toData(n);
        }
        if (this.yaxis != null) {
            jCDataCoord.y = this.yaxis.isVertical ? this.yaxis.toData(n2) : this.yaxis.toData(n);
        }
        return jCDataCoord;
    }

    public Point unmap(double d, double d2) {
        Rectangle rectangle = this.chart.chartArea.getDrawingArea();
        Rectangle rectangle2 = this.chart.getDrawingArea();
        Point point = new Point(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y);
        if (this.xaxis != null) {
            if (this.xaxis.isVertical) {
                point.y += this.xaxis.toPixel(d);
            } else {
                point.x += this.xaxis.toPixel(d);
            }
        }
        if (this.yaxis != null) {
            if (this.yaxis.isVertical) {
                point.y += this.yaxis.toPixel(d2);
            } else {
                point.x += this.yaxis.toPixel(d2);
            }
        }
        return point;
    }

    public JCDataCoord coordToDataCoord(int n, int n2) {
        return this.map(n, n2);
    }

    public Point dataCoordToCoord(double d, double d2) {
        return this.unmap(d, d2);
    }

    public Point dataIndexToCoord(JCDataIndex jCDataIndex) {
        Point point = this.chart.unpick(this, jCDataIndex.point, jCDataIndex.seriesIndex);
        return point;
    }

    public JCDataIndex coordToDataIndex(int n, int n2, int n3) {
        Point point = this.chart.chartArea.location();
        return this.chart.chartArea.pick(new Point(n - point.x, n2 - point.y), this, n3);
    }

    public boolean is3DChartType() {
        return this.chartType == 9 || this.chartType == 10;
    }

    public int getNumSeries() {
        if (this.series == null) {
            return 0;
        }
        return this.series.size();
    }

    double[] toDoubleArray(Vector vector) {
        if (vector == null || vector.size() <= 0) {
            return null;
        }
        double[] dArray = new double[vector.size()];
        int n = 0;
        while (n < dArray.length) {
            Object e = vector.elementAt(n);
            dArray[n] = e == null ? this.holeValue : (e instanceof Number ? ((Number)e).doubleValue() : (e instanceof String ? Double.valueOf((String)e) : this.holeValue));
            ++n;
        }
        return dArray;
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            return JCChartBundle.string("jclass.chart.Key142");
        }
        return string;
    }

    void calcXMinMax(MinMax minMax) {
        double d = this.xaxis.step;
        this.xaxis.step = Double.MAX_VALUE;
        int n = 0;
        while (n < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n);
            if (chartDataViewSeries.isIncluded) {
                chartDataViewSeries.getXMinMax(minMax);
                chartDataViewSeries.calcStep(this.xaxis);
            }
            ++n;
        }
        if (this.xaxis.step == Double.MAX_VALUE) {
            this.xaxis.step = d;
        }
    }

    void calcYMinMax(MinMax minMax) {
        int n = 0;
        while (n < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n);
            if (chartDataViewSeries.isIncluded) {
                chartDataViewSeries.getYMinMax(minMax);
            }
            ++n;
        }
    }

    private void calcYMinMaxOfTotals(MinMax minMax) {
        Point point = this.getFirstLast();
        if (point == null) {
            return;
        }
        int n = this.series.size();
        MinMax minMax2 = new MinMax();
        int n2 = point.x;
        while (n2 <= point.y) {
            MinMax minMax3 = new MinMax(0.0, 0.0);
            int n3 = 0;
            while (n3 < n) {
                double d;
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n3);
                if (chartDataViewSeries.isIncluded && (d = chartDataViewSeries.getY(n2)) != this.holeValue) {
                    if (d >= 0.0) {
                        minMax3.max += d;
                    } else {
                        minMax3.min += d;
                    }
                }
                ++n3;
            }
            minMax2.union(minMax3);
            ++n2;
        }
        minMax.union(minMax2);
    }

    void getDataBounds(MinMax minMax, MinMax minMax2) {
        boolean bl;
        boolean bl2 = this.chartType == 2;
        boolean bl3 = this.chartType == 3 || this.chartType == 4;
        boolean bl4 = bl2 || bl3;
        boolean bl5 = bl = this.chartType == 6 || this.chartType == 7;
        if (minMax.min == Double.MAX_VALUE && minMax.max == -1.7976931348623157E308) {
            this.calcXMinMax(minMax);
        }
        if (minMax2.min == Double.MAX_VALUE && minMax2.max == -1.7976931348623157E308) {
            this.calcYMinMax(minMax2);
        }
        if (minMax.min == Double.MAX_VALUE && minMax.max == -1.7976931348623157E308) {
            minMax.min = -1.7976931348623157E308;
            minMax.max = Double.MAX_VALUE;
        }
        if (minMax2.min == Double.MAX_VALUE && minMax2.max == -1.7976931348623157E308) {
            minMax2.min = -1.7976931348623157E308;
            minMax2.max = Double.MAX_VALUE;
        }
        if (bl) {
            double d = JCChartUtil.abs(this.xaxis.getTickSpacing());
            minMax.min -= d;
            minMax.max += d;
        }
        if (!this.xaxis.min.isDefault && this.xaxis.min.value > minMax.min || bl4) {
            minMax.min = this.xaxis.min.value;
        }
        if (!this.xaxis.max.isDefault && this.xaxis.max.value < minMax.max || bl4) {
            minMax.max = this.xaxis.max.value;
        }
        if (!this.yaxis.min.isDefault && this.yaxis.min.value > minMax2.min || bl4) {
            minMax2.min = this.yaxis.min.value;
        }
        if (bl2 && minMax2.min < 0.0) {
            if (JCChartUtil.abs(minMax2.min) > minMax2.max) {
                minMax2.max = JCChartUtil.abs(minMax2.min);
            }
            minMax2.min = 0.0;
        }
        if (!this.yaxis.max.isDefault && this.yaxis.max.value < minMax2.max || bl4) {
            minMax2.max = this.yaxis.max.value;
        }
    }

    /*
     * Unable to fully structure code
     */
    DoubleCoord getOrigin(MinMax var1_1, MinMax var2_2, boolean var3_3) {
        block23: {
            block22: {
                block21: {
                    block20: {
                        block18: {
                            block19: {
                                var4_4 = new DoubleCoord(var1_1.min, var2_2.min);
                                if (!var3_3) {
                                    return var4_4;
                                }
                                var5_5 = this.chart.getChartArea().angleUnit;
                                if (!this.xaxis.origin.isDefault) break block18;
                                if (this.chartType != 2 && this.chartType != 3 && this.chartType != 4) break block19;
                                switch (var5_5) {
                                    case 1: {
                                        var4_4.x = 90.0;
                                        ** GOTO lbl37
                                    }
                                    case 2: {
                                        var4_4.x = 1.5707963267948966;
                                        ** GOTO lbl37
                                    }
                                    case 3: {
                                        var4_4.x = 100.0;
                                        ** GOTO lbl37
                                    }
                                    default: {
                                        if (this.chartType == 10) break block20;
                                    }
                                }
                            }
                            switch (this.xaxis.originPlacement.value) {
                                case 3: {
                                    var4_4.x = 0.0;
                                    ** GOTO lbl37
                                }
                                case 1: {
                                    var4_4.x = var1_1.min;
                                    ** GOTO lbl37
                                }
                                case 2: {
                                    var4_4.x = var1_1.max;
                                    ** GOTO lbl37
                                }
                                case 0: {
                                    var4_4.x = var1_1.min <= 0.0 && var1_1.max >= 0.0 ? 0.0 : var1_1.min;
                                    ** GOTO lbl37
                                }
                                default: {
                                    if (this.chartType == 10) break block20;
                                }
                            }
                        }
                        var4_4.x = JCChartUtil.boundAngle(var5_5, this.xaxis.origin.value);
lbl37:
                        // 8 sources

                        if (this.chartType == 10) break block20;
                        if (this.chartType != 12) break block21;
                    }
                    var4_4.y = this.yaxis.isLogarithmic ? JCChartUtil.max(var2_2.min, 0.0) : 0.0;
                    ** GOTO lbl65
                }
                if (this.chartType != 2 && this.chartType != 3 && this.chartType != 4) break block22;
                var4_4.y = this.yaxis.isReversed ? var2_2.min : var2_2.max;
                ** GOTO lbl65
            }
            if (!this.yaxis.origin.isDefault) break block23;
            switch (this.yaxis.originPlacement.value) {
                case 3: {
                    var4_4.y = 0.0;
                    ** GOTO lbl65
                }
                case 1: {
                    var4_4.y = var2_2.min;
                    ** GOTO lbl65
                }
                case 2: {
                    var4_4.y = var2_2.max;
                    ** GOTO lbl65
                }
                case 0: {
                    var4_4.y = !(this.chartType != 9 && this.chartType != 8 || this.yaxis.isLogarithmic) ? 0.0 : (var2_2.min <= 0.0 && var2_2.max >= 0.0 ? 0.0 : var2_2.min);
                    ** GOTO lbl65
                }
                default: {
                    return var4_4;
                }
            }
        }
        var4_4.y = this.yaxis.origin.value;
lbl65:
        // 7 sources

        return var4_4;
    }

    void clearLimits() {
        if (this.xaxis != null) {
            this.xaxis.clearLimits();
        }
        if (this.yaxis != null) {
            this.yaxis.clearLimits();
        }
        this.xLimits = null;
        this.yLimits = null;
    }

    void calcLimits() {
        if (this.xaxis != null) {
            this.xLimits = new MinMax();
            this.calcXMinMax(this.xLimits);
            this.xaxis.setLimits(this.xLimits);
        }
        if (this.yaxis != null) {
            this.yLimits = new MinMax();
            boolean bl = false;
            switch (this.chartType) {
                case 10: {
                    bl = this.barChartFormat.get100Percent();
                    break;
                }
                case 12: {
                    bl = this.areaChartFormat.get100Percent();
                    break;
                }
            }
            if (this.chartType == 10 || this.chartType == 12) {
                this.calcYMinMaxOfTotals(this.yLimits);
                if (bl) {
                    this.yLimits.min = this.yLimits.min < 0.0 ? -100.0 : 0.0;
                    this.yLimits.max = this.yLimits.max > 0.0 ? 100.0 : 0.0;
                }
            } else {
                this.calcYMinMax(this.yLimits);
            }
            this.yaxis.setLimits(this.yLimits);
        }
    }

    public MinMax getXLimits() {
        return this.xLimits;
    }

    public MinMax getYLimits() {
        return this.yLimits;
    }

    void getDataBoundValues(MinMax minMax, MinMax minMax2) {
        if (this.xLimits != null) {
            minMax.reset(this.xLimits);
        }
        if (this.yLimits != null) {
            minMax2.reset(this.yLimits);
        }
    }

    public boolean isChanged() {
        return this.getChanged();
    }

    public boolean isChanged(int n) {
        return this.getChanged(n);
    }

    public boolean getChanged() {
        return this.changed;
    }

    public boolean getChanged(int n) {
        return (this.changedFlag & n) == n;
    }

    public void setChanged(boolean bl, int n) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.changed = bl;
            if (!this.changed) {
                this.changedFlag = n;
                Object var4_4 = null;
                return;
            }
            this.changedFlag |= n;
        }
        this.markAsChanged(n);
        this.propagateChange();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void propagateChange() {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (!this.changed) {
                return;
            }
            if (this.getIsBatched()) {
                return;
            }
            if (this.chart == null) {
                return;
            }
            if (this.chart.getIsBatched()) {
                return;
            }
        }
        this.chart.update();
        this.setChanged(false, 0);
    }

    private void markAsChanged(int n) {
        int n2 = 0;
        if ((n & 0x80) > 0) {
            n2 |= 2;
        } else if ((n & 0x40) > 0) {
            n2 |= 1;
        }
        if (n2 != 0) {
            if (this.xaxis != null) {
                this.xaxis.setChanged(true, n2, false);
            }
            if (this.yaxis != null) {
                this.yaxis.setChanged(true, n2, false);
            }
        }
        if (this.chart != null && this.chart.chartArea != null) {
            this.chart.chartArea.setChanged(true, n & 3, false);
        }
        int n3 = 0;
        if ((n & 0x20) > 0) {
            n3 |= 2;
        } else if ((n & 0x10) > 0) {
            n3 |= 1;
        }
        if (n3 != 0 && this.chart != null && this.chart.legend != null) {
            this.chart.legend.setChanged(true, n3, false);
        }
    }

    public void setChanged(boolean bl, int n, boolean bl2) {
        if (this.changed == bl && (this.changedFlag & n) == n) {
            return;
        }
        if (bl2) {
            this.setChanged(bl, n);
            return;
        }
        this.changed = bl;
        if (this.changed) {
            this.changedFlag |= n;
            this.markAsChanged(n);
            return;
        }
        this.changedFlag = n;
    }

    public Point getFirstLast() {
        if (this.series == null) {
            return null;
        }
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n4);
            if (chartDataViewSeries.isShowing) {
                int n5;
                if (n < chartDataViewSeries.getFirstPoint()) {
                    n = chartDataViewSeries.getFirstPoint();
                }
                if (n2 > chartDataViewSeries.getLastPoint()) {
                    n2 = chartDataViewSeries.getLastPoint();
                }
                if (n3 > (n5 = chartDataViewSeries.maxIndex())) {
                    n3 = n5;
                }
            }
            ++n4;
        }
        if (n3 == Integer.MAX_VALUE) {
            return null;
        }
        if (n > n3) {
            return null;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n > n2) {
            return null;
        }
        return new Point(n, n2);
    }

    public int getVisibleDataSeries() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n2);
            if (chartDataViewSeries.isShowing) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void calcTransientData() {
        boolean bl = false;
        Changeable changeable = this;
        synchronized (changeable) {
            bl = this.getChartType() == 11;
        }
        if (bl && (changeable = this.chart.chartArea.getDrawable(this)) != null) {
            ((ChartDraw)changeable).calcTransientData();
        }
    }

    public void setIsInverted(boolean bl) {
        int n = 0;
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (this.isInverted == bl) {
                Object var4_4 = null;
                return;
            }
            this.isInverted = bl;
            if (this.xaxis != null) {
                this.xaxis.isVertical = bl;
            }
            if (this.yaxis != null) {
                this.yaxis.isVertical = !bl;
            }
            n = 130;
            if (this.chartType == 5 || this.chartType == 6 || this.chartType == 7) {
                n |= 0x20;
            }
        }
        this.setChanged(true, n);
    }

    public boolean getIsInverted() {
        return this.isInverted;
    }

    public void setPickFocus(int n) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.pickFocus = n;
            return;
        }
    }

    public int getPickFocus() {
        return this.pickFocus;
    }

    public boolean getIsShowingInLegend() {
        return this.isShowingInLegend;
    }

    public void setIsShowingInLegend(boolean bl) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (bl == this.isShowingInLegend) {
                Object var3_3 = null;
                return;
            }
            this.isShowingInLegend = bl;
        }
        this.setChanged(true, 32);
    }

    public boolean getAutoLabel() {
        return this.autoLabel;
    }

    public void setAutoLabel(boolean bl) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (this.autoLabel == bl) {
                Object var3_3 = null;
                return;
            }
            this.autoLabel = bl;
        }
        if (this.autoLabel) {
            this.generateAutoLabels();
        } else {
            this.removeAutoLabels();
        }
        this.setChanged(true, 2);
    }

    public Color getOutlineColor() {
        if (this.outlineColor == null) {
            if (this.chart != null && this.chart.chartArea != null) {
                return this.chart.chartArea.getForeground();
            }
            return null;
        }
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (this.outlineColor == color) {
                Object var3_3 = null;
                return;
            }
            this.outlineColor = color;
        }
        this.setChanged(true, 2);
    }

    public void setChartStyle(int n, JCChartStyle jCChartStyle) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (n < 0 || n > this.styles.size()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key60"));
            }
            jCChartStyle.addParent(this);
            if (n < this.styles.size()) {
                this.styles.setElementAt(jCChartStyle, n);
            } else {
                this.styles.insertElementAt(jCChartStyle, n);
            }
        }
        this.setChanged(true, 33);
    }

    public JCChartStyle getChartStyle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key13"));
        }
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (n >= this.styles.size()) {
                while (n >= this.styles.size()) {
                    this.styles.addElement(null);
                }
            }
            JCChartStyle[] jCChartStyleArray = new JCChartStyle[]{(JCChartStyle)this.styles.elementAt(n)};
            if (jCChartStyleArray[0] == null) {
                JCChartStyle jCChartStyle = new JCChartStyle();
                jCChartStyleArray[0] = JCChartStyle.makeDefault(this.chart, this);
                this.styles.setElementAt(jCChartStyleArray[0], n);
                jCChartStyle = null;
            }
            JCChartStyle jCChartStyle = jCChartStyleArray[0];
            Object var4_6 = null;
            return jCChartStyle;
        }
    }

    public JCChartStyle[] getChartStyle() {
        if (this.styles == null || this.styles.size() == 0) {
            return null;
        }
        JCChartStyle[] jCChartStyleArray = new JCChartStyle[this.styles.size()];
        int n = 0;
        while (n < jCChartStyleArray.length) {
            jCChartStyleArray[n] = (JCChartStyle)this.styles.elementAt(n);
            ++n;
        }
        return jCChartStyleArray;
    }

    public void setChartStyle(JCChartStyle[] jCChartStyleArray) {
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            this.styles = new JCVector();
            if (jCChartStyleArray == null) {
                Object var3_3 = null;
                return;
            }
            int n = 0;
            while (n < jCChartStyleArray.length) {
                jCChartStyleArray[n].addParent(this);
                this.styles.setElementAt(n, jCChartStyleArray[n]);
                ++n;
            }
        }
        this.setChanged(true, 33);
    }

    public void setColorHandler(JCDrawableColorHandler jCDrawableColorHandler) {
        if (this.colorHandler == jCDrawableColorHandler) {
            return;
        }
        this.colorHandler = jCDrawableColorHandler;
        this.setChanged(true, 33);
    }

    public JCDrawableColorHandler getColorHandler() {
        return this.colorHandler;
    }

    public double[] getXArrayCopy() {
        if (this.xvalues == null) {
            return null;
        }
        double[] dArray = new double[this.xvalues.length];
        System.arraycopy(this.xvalues, 0, dArray, 0, this.xvalues.length);
        return dArray;
    }

    double[] getX() {
        return this.xvalues;
    }

    void setX(double[] dArray) {
        this.xvalues = dArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.dataSource != null && this.dataSource instanceof Observable) {
                ((Observable)((Object)this.dataSource)).addObserver(this);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    Object getTransientData() {
        return this.transientData;
    }

    void setTransientData(Object object) {
        this.transientData = object;
        if (this.chart != null && this.chart.legend != null) {
            this.chart.legend.setChanged(true, 2, false);
        }
    }

    int getNumSeriesPerData() {
        int n = 1;
        switch (this.chartType) {
            case 5: {
                n = 2;
                break;
            }
            case 6: {
                n = 4;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
        }
        return n;
    }

    void generateAutoLabels() {
        if (!this.autoLabel) {
            return;
        }
        JCChartLabel[][] jCChartLabelArray = this.autoLabelList;
        int n = this.series.size();
        this.autoLabelList = new JCChartLabel[n][];
        int n2 = 0;
        while (n2 < n) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n2);
            int n3 = chartDataViewSeries.maxIndex() + 1;
            if (chartDataViewSeries.getX() == null || chartDataViewSeries.getY() == null) {
                n3 = 0;
            }
            this.autoLabelList[n2] = new JCChartLabel[n3];
            int n4 = 0;
            while (n4 < n3) {
                if (jCChartLabelArray != null && n2 < jCChartLabelArray.length && jCChartLabelArray[n2] != null && n4 < jCChartLabelArray[n2].length) {
                    this.chart.deleteChartLabel(jCChartLabelArray[n2][n4]);
                }
                this.autoLabelList[n2][n4] = this.createAutoLabel(this.createAutoLabelText(n2, n4), chartDataViewSeries, n4);
                this.chart.appendChartLabel(this.autoLabelList[n2][n4]);
                ++n4;
            }
            ++n2;
        }
    }

    JCChartLabel createAutoLabel(String string, ChartDataViewSeries chartDataViewSeries, int n) {
        JCChartLabel jCChartLabel = new JCChartLabel(string, false);
        jCChartLabel.setDataIndex(new JCDataIndex(n, chartDataViewSeries));
        jCChartLabel.setAttachMethod(3);
        jCChartLabel.setAnchor(10);
        jCChartLabel.setBorderType(4);
        jCChartLabel.setBorderWidth(1);
        jCChartLabel.setDataView(this);
        jCChartLabel.setInsets(new Insets(0, 0, 0, 0));
        jCChartLabel.setOffset(new Point(0, -1));
        jCChartLabel.setDwellDelay(500);
        jCChartLabel.setIsDwellLabel(true);
        return jCChartLabel;
    }

    String createAutoLabelText(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.getSeries(n);
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getChartType()) {
            case 0: 
            case 1: {
                stringBuffer.append(" (");
                stringBuffer.append(chartDataViewSeries.getX(n2));
                stringBuffer.append(",");
                stringBuffer.append(chartDataViewSeries.getY(n2));
                stringBuffer.append(") ");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                stringBuffer.append(" ");
                stringBuffer.append(chartDataViewSeries.getY(n2));
                stringBuffer.append(" ");
                break;
            }
            default: {
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    void setAutoLabelText(int n, int n2) {
        if (!this.autoLabel) {
            return;
        }
        if (this.autoLabelList[n][n2] != null) {
            this.autoLabelList[n][n2].setText(this.createAutoLabelText(n, n2));
        }
    }

    void addAutoLabels(int n, int n2) {
        if (!this.autoLabel || this.autoLabelList == null) {
            return;
        }
        if (n != -1 && n2 == -1) {
            int n3 = n;
            int n4 = this.series.size();
            JCChartLabel[][] jCChartLabelArray = this.autoLabelList;
            this.autoLabelList = new JCChartLabel[n4][];
            System.arraycopy(jCChartLabelArray, 0, this.autoLabelList, 0, n3);
            if (jCChartLabelArray.length > n3) {
                System.arraycopy(jCChartLabelArray, n3 + 1, this.autoLabelList, n3 + 1, n4 - n3 - 1);
            }
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n3);
            int n5 = chartDataViewSeries.maxIndex() + 1;
            this.autoLabelList[n3] = new JCChartLabel[n5];
            int n6 = 0;
            while (n6 < n5) {
                this.autoLabelList[n3][n6] = this.createAutoLabel(this.createAutoLabelText(n3, n6), chartDataViewSeries, n6);
                this.chart.appendChartLabel(this.autoLabelList[n3][n6]);
                ++n6;
            }
            return;
        }
        if (n2 != -1) {
            int n7 = n2;
            int n8 = this.series.size();
            int n9 = 0;
            if (n != -1) {
                n8 = n + 1;
                n9 = n;
            }
            int n10 = n9;
            while (n10 < n8) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n10);
                int n11 = this.autoLabelList[n10].length + 1;
                JCChartLabel[] jCChartLabelArray = this.autoLabelList[n10];
                this.autoLabelList[n10] = new JCChartLabel[n11];
                if (n7 != 0) {
                    System.arraycopy(jCChartLabelArray, 0, this.autoLabelList[n10], 0, n7);
                }
                if (n7 != n11 - 1) {
                    System.arraycopy(jCChartLabelArray, n7, this.autoLabelList[n10], n7 + 1, n11 - n7 - 1);
                }
                this.autoLabelList[n10][n7] = this.createAutoLabel(this.createAutoLabelText(n10, n7), chartDataViewSeries, n7);
                this.chart.appendChartLabel(this.autoLabelList[n10][n7]);
                ++n10;
            }
        }
    }

    void removeAutoLabels(int n, int n2) {
        if (!this.autoLabel || this.autoLabelList == null) {
            return;
        }
        if (n != -1 && n2 == -1) {
            int n3 = n;
            int n4 = this.series.size();
            int n5 = this.autoLabelList[n3].length;
            int n6 = 0;
            while (n6 < n5) {
                this.chart.deleteChartLabel(this.autoLabelList[n3][n6]);
                ++n6;
            }
            JCChartLabel[][] jCChartLabelArray = this.autoLabelList;
            this.autoLabelList = new JCChartLabel[n4][];
            System.arraycopy(jCChartLabelArray, 0, this.autoLabelList, 0, n3);
            if (jCChartLabelArray.length > n3) {
                System.arraycopy(jCChartLabelArray, n3 + 1, this.autoLabelList, n3, n4 - n3);
                return;
            }
        } else if (n2 != -1) {
            int n7 = n2;
            int n8 = this.series.size();
            int n9 = 0;
            if (n != -1) {
                n8 = n + 1;
                n9 = n;
            }
            int n10 = n9;
            while (n10 < n8) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.elementAt(n10);
                int n11 = this.autoLabelList[n10].length;
                this.chart.deleteChartLabel(this.autoLabelList[n10][n7]);
                JCChartLabel[] jCChartLabelArray = this.autoLabelList[n10];
                this.autoLabelList[n10] = new JCChartLabel[n11 - 1];
                System.arraycopy(jCChartLabelArray, 0, this.autoLabelList[n10], 0, n7);
                System.arraycopy(jCChartLabelArray, n7 + 1, this.autoLabelList[n10], n7, n11 - n7 - 1);
                ++n10;
            }
        }
    }

    void removeAutoLabels() {
        JCChartLabel[][] jCChartLabelArray;
        ChartDataView chartDataView = this;
        synchronized (chartDataView) {
            if (this.autoLabelList == null) {
                Object var3_3 = null;
                return;
            }
            jCChartLabelArray = this.autoLabelList;
            this.autoLabelList = null;
        }
        int n = 0;
        while (n < jCChartLabelArray.length) {
            if (jCChartLabelArray[n] != null) {
                int n2 = 0;
                while (n2 < jCChartLabelArray[n].length) {
                    this.chart.deleteChartLabel(jCChartLabelArray[n][n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void setIsShowing(boolean bl) {
        if (this.isShowing == bl) {
            return;
        }
        this.setIsShowingInLegend(bl);
        this.isShowing = bl;
        this.setChanged(true, 2);
    }

    public boolean getIsShowing() {
        return this.isShowing;
    }

    public void outputData(OutputStream outputStream) {
        ChartDataViewHTMLSave chartDataViewHTMLSave = new ChartDataViewHTMLSave(this);
        String string = chartDataViewHTMLSave.getDataString();
        if (string != null) {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                dataOutputStream.writeBytes(string);
                dataOutputStream.flush();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        ChartDataViewHTMLSave chartDataViewHTMLSave = new ChartDataViewHTMLSave(this);
        chartDataViewHTMLSave.save(string, hTMLSaveDriver);
    }

    public void loadParams(String string, JCChart jCChart) {
        ChartDataViewHTMLLoad chartDataViewHTMLLoad = new ChartDataViewHTMLLoad(this);
        chartDataViewHTMLLoad.load(string, jCChart);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        this.changed = true;
        int n = this.changedFlag;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n;
    }

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 8;
        nArray[3] = 12;
        nArray[4] = 9;
        nArray[5] = 10;
        nArray[6] = 11;
        nArray[7] = 5;
        nArray[8] = 6;
        nArray[9] = 7;
        chartType_values = nArray;
    }
}

