/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import jclass.chart.BarPoint;
import jclass.chart.ChartDraw;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;

class BarChartDraw
extends ChartDraw
implements Serializable {
    public static final int SIDE_0 = 1;
    public static final int SIDE_1 = 2;
    public static final int SIDE_2 = 4;
    public static final int SIDE_3 = 8;
    public static final int OUTLINE_SENSITIVITY = 3;
    Point firstLast;
    Color outlineColor = Color.black;
    int x_reversed;
    int y_reversed;
    int delta_x;
    int delta_y;
    double xAxisPos = Double.MAX_VALUE;
    double[] xGridLineList;
    JCLineStyle gridLineStyle;
    boolean fastAction = false;
    boolean inAction = false;
    double yOrigin;
    transient BarPoint[][] pts;
    double bar_base;
    int top;
    int bottom;
    int left;
    int right;
    boolean is_3d = false;
    boolean drawOutline = true;
    Rectangle r;
    boolean editInverted = false;
    Point start;
    Point end;

    public void recalc() {
        super.recalc();
        JCBarChartFormat jCBarChartFormat = this.dataObject.barChartFormat;
        if (jCBarChartFormat == null || jCBarChartFormat.clusterWidth == 0) {
            this.pts = null;
            return;
        }
        this.delta_x = this.chartArea.deltaX;
        this.delta_y = this.chartArea.deltaY;
        this.is_3d = this.delta_x != 0 || this.delta_y != 0;
        int n = jCBarChartFormat.clusterOverlap;
        if (this.is_3d && n > 0) {
            n = 0;
        }
        MinMax minMax = new MinMax(this.dataObject.xLimits.min, this.dataObject.xLimits.max);
        MinMax minMax2 = new MinMax(this.dataObject.yLimits.min, this.dataObject.yLimits.max);
        this.dataObject.getDataBounds(minMax, minMax2);
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        double d = 1.0 - (double)n / 100.0;
        double d2 = this.numActiveDataSeries;
        d2 = (d2 - 1.0) * d + 1.0;
        this.bar_base = this.xaxis.step * (double)jCBarChartFormat.clusterWidth / (d2 * 100.0);
        double d3 = d2 * this.bar_base / 2.0;
        double d4 = d * this.bar_base;
        this.inverted = this.xaxis.isVertical;
        minMax.min -= d3;
        minMax.max += d3;
        this.xaxis.setLimits(minMax);
        this.xaxis.calcTransformation();
        this.xaxis.layoutAnnotations();
        this.xaxis.checkAnnotations();
        minMax2.min = JCChartUtil.min(this.yaxis.origin.value, minMax2.min);
        minMax2.max = JCChartUtil.max(this.yaxis.origin.value, minMax2.max);
        this.yaxis.setLimits(minMax2);
        this.yaxis.calcTransformation();
        minMax = this.xaxis.dataLimits;
        minMax2 = this.yaxis.dataLimits;
        this.drawOutline = Math.abs(this.xaxis.toPixel(this.xaxis.min.value + this.bar_base, this.drawFront) - this.xaxis.toPixel(this.xaxis.min.value, this.drawFront)) > 3;
        int n2 = this.inverted ? this.yaxis.getWidth() : this.xaxis.getHeight();
        int n3 = this.inverted ? this.xaxis.getWidth() : this.yaxis.getHeight();
        this.left = this.inverted ? this.yaxis.getLeft() : this.xaxis.getLeft();
        this.right = this.left + n2 - 1;
        this.top = this.inverted ? this.xaxis.getTop() : this.yaxis.getTop();
        this.bottom = this.top + n3 - 1;
        this.firstLast = this.dataObject.getFirstLast();
        if (this.firstLast == null) {
            return;
        }
        this.seriesList = this.dataObject.getSeries();
        int n4 = this.seriesList.length;
        this.dataObject.getVisibleDataSeries();
        this.outlineColor = this.dataObject.getOutlineColor();
        this.holeValue = this.dataObject.holeValue;
        this.pts = new BarPoint[this.firstLast.y - this.firstLast.x + 1][n4];
        this.yOrigin = this.yaxis.origin.value;
        int n5 = this.yaxis.toPixel(this.yOrigin, this.drawFront);
        this.x_reversed = this.xaxis.isReversed ? 1 : 0;
        int n6 = this.y_reversed = this.yaxis.isReversed ? 1 : 0;
        int n7 = this.inverted ? (this.delta_y > 0 ? 1 ^ this.x_reversed : this.x_reversed) : (this.delta_x <= 0 ? 1 ^ this.x_reversed : this.x_reversed);
        this.fastAction = this.chartArea.fastAction;
        this.inAction = this.chartArea.inAction;
        if (!this.fastAction || !this.inAction) {
            this.xAxisPos = this.xaxis.getRealPlacementLocation();
            this.xGridLineList = this.xaxis.getGridLineList();
            if (this.xGridLineList == null) {
                this.xGridLineList = new double[0];
            }
            this.gridLineStyle = this.xaxis.getGridStyle().getLineStyle();
        }
        int n8 = this.firstLast.x;
        while (n8 <= this.firstLast.y) {
            int n9 = 0;
            int n10 = 0;
            while (n10 < this.seriesList.length) {
                BarPoint[] barPointArray = this.pts[n8 - this.firstLast.x];
                if (this.seriesList[n10].isShowing) {
                    this.seriesList[n10].getX(n8);
                    double d5 = this.seriesList[n10].getX(n8) - d3;
                    double d6 = d5 + (double)n9 * d4;
                    double d7 = d6 + this.bar_base;
                    ++n9;
                    if (!(d6 < this.xaxis.min.value && d7 < this.xaxis.min.value || d6 > this.xaxis.max.value && d7 > this.xaxis.max.value)) {
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        double d8;
                        barPointArray[n10] = new BarPoint();
                        barPointArray[n10].x = d6;
                        if (minMax != null && (d7 <= minMax.min || d6 >= minMax.max)) {
                            barPointArray[n10].x = this.holeValue;
                        }
                        barPointArray[n10].y = (d8 = this.seriesList[n10].getY(n8)) == this.holeValue ? this.holeValue : d8;
                        BarPoint barPoint = barPointArray[n10];
                        barPoint.front = null;
                        barPoint.top = null;
                        barPoint.side = null;
                        if (this.inverted) {
                            n14 = this.yaxis.toPixel(barPoint.y, this.drawFront);
                            n13 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                            n12 = n13 - this.xaxis.toPixel(barPoint.x + this.bar_base, this.drawFront);
                            n11 = n14 - n5;
                        } else {
                            n14 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                            n13 = this.yaxis.toPixel(barPoint.y, this.drawFront);
                            n11 = this.xaxis.toPixel(barPoint.x + this.bar_base, this.drawFront) - n14;
                            n12 = n5 - n13;
                        }
                        if (this.is_3d && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                            int n15;
                            Point[] pointArray = new Point[4];
                            Point[] pointArray2 = new Point[4];
                            pointArray[0] = new Point(0, 0);
                            pointArray[1] = new Point(this.delta_x, this.delta_y);
                            pointArray[2] = new Point(0, 0);
                            pointArray[3] = new Point(-this.delta_x, -this.delta_y);
                            pointArray2[0] = new Point(0, 0);
                            pointArray2[1] = new Point(this.delta_x, this.delta_y);
                            pointArray2[2] = new Point(0, 0);
                            pointArray2[3] = new Point(-this.delta_x, -this.delta_y);
                            if (this.inverted) {
                                pointArray2[0].x = n11 >= 0 ? (this.delta_x > 0 ? n14 : n5) : (this.delta_x > 0 ? n5 : n14);
                                n15 = n7 != 0 ? n13 : n13 - n12;
                                pointArray[0].x = n14 - n11;
                                pointArray[0].y = n15;
                                pointArray[2].x = n11;
                                pointArray2[0].y = n13 - n12;
                                pointArray2[2].y = n12;
                                barPoint.top = pointArray;
                                barPoint.side = pointArray2;
                            } else {
                                pointArray[0].y = n12 >= 0 ? (this.delta_y <= 0 ? n13 : n5) : (this.delta_y <= 0 ? n5 : n13);
                                pointArray2[0].x = n15 = n7 != 0 ? n14 : n14 + n11;
                                pointArray2[0].y = n13 + n12;
                                pointArray2[2].y = -n12;
                                pointArray[0].x = n14;
                                pointArray[2].x = n11;
                                barPoint.top = pointArray;
                                barPoint.side = pointArray2;
                            }
                        }
                        if (this.inverted) {
                            n14 = n5;
                            n13 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                            n11 = this.yaxis.toPixel(barPoint.y, this.drawFront) - n14;
                            n12 = n13 - this.xaxis.toPixel(barPoint.x + this.bar_base, this.drawFront);
                            n13 -= n12;
                        }
                        if (n11 < 0) {
                            n11 = -n11;
                            n14 -= n11;
                        }
                        if (n12 < 0) {
                            n12 = -n12;
                            n13 -= n12;
                        }
                        if (this.inverted) {
                            n12 = Math.max(1, n12);
                        } else {
                            n11 = Math.max(1, n11);
                        }
                        barPoint.front = new Rectangle(n14, n13, n11, n12);
                    }
                }
                ++n10;
            }
            ++n8;
        }
    }

    public void draw(Graphics graphics) {
        int n;
        boolean bl;
        if (this.firstLast == null) {
            return;
        }
        if (this.pts == null) {
            try {
                this.recalc();
                if (this.pts == null) {
                    return;
                }
            }
            catch (Exception exception) {}
        }
        if (this.is_3d) {
            boolean bl2;
            int n2;
            int n3;
            int n4;
            bl = false;
            boolean bl3 = false;
            n = this.inverted ? (this.delta_y > 0 ? 1 ^ this.x_reversed : this.x_reversed) : (this.delta_x <= 0 ? 1 ^ this.x_reversed : this.x_reversed);
            int n5 = 0;
            int n6 = 0;
            int n7 = this.seriesList.length - 1;
            if (n != 0) {
                n4 = this.firstLast.y;
                n3 = n7;
                n2 = -1;
                bl2 = n4 >= this.firstLast.x;
                n5 = this.xGridLineList.length - 1;
            } else {
                n4 = this.firstLast.x;
                n3 = n6;
                n2 = 1;
                bl2 = n4 <= this.firstLast.y;
                n5 = 0;
            }
            int n8 = n4;
            while (bl2) {
                boolean bl4 = n != 0 ? n3 >= n6 : n3 <= n7;
                int n9 = n3;
                while (bl4) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n8 - this.firstLast.x][n9];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (!(barPoint == null || this.fastAction && this.inAction)) {
                        int n10 = 0;
                        int n11 = 0;
                        if (this.inverted) {
                            n11 = barPoint.front.y + barPoint.front.height;
                            n10 = barPoint.front.y;
                        } else {
                            n10 = barPoint.front.x;
                            n11 = barPoint.front.x + barPoint.front.width;
                        }
                        if (!bl) {
                            int n12 = this.tryDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, n10, n11);
                            if (n12 == 1) {
                                bl = true;
                            } else if (n12 == 2) {
                                bl3 = true;
                                bl = true;
                            }
                        }
                        if (this.xaxis.gridIsShowing) {
                            n5 = this.drawXAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.xaxis, this.y_reversed, this.xAxisPos, n10, n11, barPoint.y, this.yOrigin, this.xGridLineList, n5, n2, this.gridLineStyle);
                        }
                    }
                    if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue && this.seriesList[n9].getStyle().getFillStyle().getImage() == null) {
                        this.draw_3dbar(graphics, n8, n9, barPoint.top, barPoint.side, this.drawOutline);
                        if (bl3) {
                            this.finishDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, this.y_reversed, barPoint.y, this.yOrigin);
                            bl3 = false;
                        }
                    }
                    bl4 = n != 0 ? n9 > n6 : n9 < n7;
                    n9 += n2;
                }
                bl2 = n != 0 ? n8 > this.firstLast.x : n8 < this.firstLast.y;
                n8 += n2;
            }
            if (!this.fastAction || !this.inAction) {
                this.finalDrawAxisTroughGrid(graphics, this.xaxis, this.yaxis, n, bl, this.xGridLineList, n5, n2, this.gridLineStyle);
            }
        }
        bl = false;
        while (bl < this.seriesList.length) {
            if (this.seriesList[bl].isShowing) {
                JCChartStyle jCChartStyle = this.seriesList[bl].getStyle();
                n = this.firstLast.x;
                while (n <= this.firstLast.y) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n - this.firstLast.x][bl];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                        JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                        if (this.seriesList[bl].getStyle().getFillStyle().getImage() != null) {
                            jCFillStyle.fillImageRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, barPoint.y >= 0.0, this.inverted);
                        } else if (this.drawOutline) {
                            jCFillStyle.fillOutlineRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.outlineColor);
                        } else {
                            jCFillStyle.fillRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height);
                        }
                    }
                    ++n;
                }
            }
            bl += 1;
        }
    }

    void draw_3dbar(Graphics graphics, int n, int n2, Point[] pointArray, Point[] pointArray2, boolean bl) {
        Polygon polygon;
        JCFillStyle jCFillStyle = this.seriesList[n2].getStyle().getFillStyle();
        if (pointArray != null) {
            polygon = JCChartUtil.pointsToPolygon(pointArray);
            if (this.delta_y <= 0) {
                if (bl) {
                    jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, this.outlineColor);
                } else {
                    jCFillStyle.fillPolygonHighlight(graphics, polygon);
                }
            } else if (bl) {
                jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, this.outlineColor);
            } else {
                jCFillStyle.fillPolygonShadow(graphics, polygon);
            }
        }
        if (pointArray2 != null) {
            polygon = JCChartUtil.pointsToPolygon(pointArray2);
            if (this.delta_x <= 0) {
                if (bl) {
                    jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, this.outlineColor);
                    return;
                }
                jCFillStyle.fillPolygonHighlight(graphics, polygon);
                return;
            }
            if (bl) {
                jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, this.outlineColor);
                return;
            }
            jCFillStyle.fillPolygonShadow(graphics, polygon);
        }
    }

    JCDataIndex pick(Point point, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n6 = -1;
        int n7 = -1;
        JCDataIndex jCDataIndex = null;
        int n8 = Integer.MAX_VALUE;
        if (this.firstLast == null || this.pts == null) {
            return null;
        }
        boolean bl2 = bl = this.delta_x != 0 || this.delta_y != 0;
        if (bl) {
            int n9;
            n5 = this.inverted ? (this.delta_y > 0 ? 1 ^ this.x_reversed : this.x_reversed) : (this.delta_x <= 0 ? 1 ^ this.x_reversed : this.x_reversed);
            int n10 = 0;
            int n11 = this.seriesList.length - 1;
            if (n5 != 0) {
                n4 = this.firstLast.y;
                n3 = n11;
                n9 = -1;
                n2 = n4 < this.firstLast.x ? 0 : 1;
            } else {
                n4 = this.firstLast.x;
                n3 = n10;
                n9 = 1;
                n2 = n4 > this.firstLast.y ? 0 : 1;
            }
            int n12 = n4;
            while (n2 != 0) {
                boolean bl3 = n5 != 0 ? n3 >= n10 : n3 <= n11;
                int n13 = n3;
                while (bl3) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n12 - this.firstLast.x][n13];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (barPoint != null) {
                        int n14 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint.top, this.inverted, n);
                        int n15 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint.side, this.inverted, n);
                        if (n14 <= n8 || n15 <= n8) {
                            n6 = n13;
                            n7 = n12;
                            n8 = Math.min(n15, n14);
                        }
                    }
                    bl3 = n5 != 0 ? n13 > n10 : n13 < n11;
                    n13 += n9;
                }
                n2 = n5 != 0 ? (n12 <= this.firstLast.x ? 0 : 1) : (n12 >= this.firstLast.y ? 0 : 1);
                n12 += n9;
            }
        }
        n5 = this.firstLast.x;
        while (n5 <= this.firstLast.y) {
            n4 = n5 - this.firstLast.x;
            if (this.pts[n4] != null) {
                n3 = 0;
                while (n3 < this.pts[n4].length) {
                    if (this.seriesList[n3].isShowing) {
                        BarPoint barPoint = null;
                        try {
                            barPoint = this.pts[n4][n3];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                            n2 = 0;
                            if (barPoint.front != null && (n2 = JCChartUtil.distanceToFrontRect(point2.x, point2.y, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.inverted, n)) <= n8) {
                                n6 = n3;
                                n7 = n5;
                                n8 = n2;
                            }
                        }
                    }
                    ++n3;
                }
            }
            ++n5;
        }
        if (n6 >= 0 && n7 >= 0) {
            jCDataIndex = new JCDataIndex(n7, this.seriesList[n6], n6);
            jCDataIndex.distance = n8;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[n - this.firstLast.x][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return null;
        }
        double d = barPoint.y;
        double d2 = barPoint.x;
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = barPoint.front.y + barPoint.front.height / 2;
            } else {
                n4 = this.yaxis.toPixel(d, this.drawFront);
                n3 = barPoint.front.x + barPoint.front.width / 2;
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        this.r = this.chartArea.getDrawingArea();
        this.editInverted = jCDataIndex.dataView.xaxis.isVertical;
        this.end = null;
        this.start = null;
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[jCDataIndex.point - this.firstLast.x][jCDataIndex.series.drawingOrder];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return;
        }
        if (this.start == null || this.end == null) {
            this.start = new Point(0, 0);
            this.end = new Point(0, 0);
        } else {
            this.chartArea.drawRubberBand(this.end, this.start);
        }
        if (this.editInverted) {
            this.start.x = n;
            this.start.y = barPoint.front.y + this.r.y;
            this.end.x = barPoint.front.x + this.r.x;
            this.end.y = barPoint.front.y + this.r.y + barPoint.front.height;
        } else {
            this.start.x = barPoint.front.x + this.r.x;
            this.start.y = n2;
            this.end.x = barPoint.front.x + this.r.x + barPoint.front.width;
            this.end.y = barPoint.front.height + barPoint.front.y + this.r.y;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
        int n3 = this.editInverted ? n - this.r.x : n2 - this.r.y;
        return n3;
    }
}

