/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import jclass.bwt.JCComponent;
import jclass.bwt.JCHeader;
import jclass.bwt.JCOutlinerComponent;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCOutlinerPrintEvent;
import jclass.bwt.JCOutlinerPrintListener;
import jclass.bwt.JCSerializable;
import jclass.util.JCVector;

public class JCOutlinerPrinter
implements JCSerializable {
    JCOutlinerComponent outliner;
    int page_width;
    int page_height;
    int page_resolution = 72;
    boolean repeat_header = true;
    boolean repeat_outline = true;
    boolean print_all_nodes = true;
    int internal_width;
    int internal_height;
    Insets margin = new Insets(this.page_resolution, this.page_resolution, this.page_resolution, this.page_resolution);
    int margin_unit = 1;
    int current_page;
    public static final int MARGIN_IN_INCHES = 0;
    public static final int MARGIN_IN_PIXELS = 1;

    public JCOutlinerPrinter(JCOutlinerComponent jCOutlinerComponent) {
        this.outliner = jCOutlinerComponent;
    }

    public boolean getHeaderOnEachPage() {
        return this.repeat_header;
    }

    public void setHeaderOnEachPage(boolean bl) {
        this.repeat_header = bl;
    }

    public int getMarginUnits() {
        return this.margin_unit;
    }

    public void setMarginUnits(int n) {
        if (this.margin_unit == 0) {
            this.margin_unit = 0;
            return;
        }
        this.margin_unit = 1;
    }

    public int getNumPages() {
        if (this.page_width * this.page_height == 0) {
            return 0;
        }
        return this.getNumHorizontalPages() * this.getNumVerticalPages();
    }

    public boolean getOutlineOnEachPage() {
        return this.repeat_outline;
    }

    public void setOutlineOnEachPage(boolean bl) {
        this.repeat_outline = bl;
    }

    public Dimension getPageDimensions() {
        return new Dimension(this.page_width, this.page_height);
    }

    public void setPageDimensions(int n, int n2) {
        this.page_width = n;
        this.page_height = n2;
        this.setInternalDimensions();
    }

    public int getPageHeight() {
        return this.page_height;
    }

    public void setPageHeight(int n) {
        this.page_height = n;
        this.setInternalDimensions();
    }

    public Insets getPageMargins() {
        return this.margin;
    }

    public Insets getDefaultPageMargins() {
        this.margin_unit = 1;
        this.margin = new Insets(72, 72, 72, 72);
        return this.margin;
    }

    public void setPageMargins(Insets insets) {
        this.margin = insets == null ? this.getDefaultPageMargins() : insets;
        this.setInternalDimensions();
    }

    public int getPageResolution() {
        return this.page_resolution;
    }

    public void setPageResolution(int n) {
        this.page_resolution = n;
        this.setInternalDimensions();
    }

    public int getPageWidth() {
        return this.page_width;
    }

    public void setPageWidth(int n) {
        this.page_width = n;
        this.setInternalDimensions();
    }

    public boolean getPrintAllNodes() {
        return this.print_all_nodes;
    }

    public void setPrintAllNodes(boolean bl) {
        this.print_all_nodes = bl;
    }

    public int getNumHorizontalPages() {
        int n = 1;
        int n2 = this.outliner.getNumColumns();
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.outliner.getColumnWidth(0);
        if (n3 > this.internal_width) {
            return 0;
        }
        int n4 = 1;
        while (n4 < n2) {
            int n5 = this.outliner.getColumnWidth(n4);
            n3 += n5;
            if (this.repeat_outline) {
                if (n3 == this.outliner.getColumnWidth(0) + this.outliner.getColumnWidth(n4) && n3 > this.internal_width) {
                    n3 = this.outliner.getColumnWidth(0);
                    ++n;
                } else if (n3 > this.internal_width) {
                    n3 = this.outliner.getColumnWidth(0) + this.outliner.getColumnWidth(n4);
                    ++n;
                }
            } else if (n3 == this.outliner.getColumnWidth(n4) && n3 > this.internal_width) {
                n3 = 0;
                ++n;
            } else if (n3 > this.internal_width) {
                n3 = this.outliner.getColumnWidth(n4);
                ++n;
            }
            ++n4;
        }
        return n;
    }

    public int getNumVerticalPages() {
        int n = 0;
        int n2 = this.outliner.getNumNodes();
        if (n2 == 0) {
            return n;
        }
        int n3 = JCComponent.getPreferredSize((Component)this.outliner.getHeader()).height;
        if (n3 > this.internal_height) {
            return n;
        }
        this.getNumHorizontalPages();
        int n4 = this.outliner.getNodeHeight();
        int n5 = 0;
        while (n5 < this.outliner.style_list.length) {
            n4 = Math.max(n4, this.outliner.calculateStyleHeight(this.outliner.style_list[n5]));
            ++n5;
        }
        n4 += 2 * this.outliner.getHighlightThickness() + this.outliner.getSpacing();
        int n6 = this.outliner.node_list.size();
        int n7 = this.internal_height - 2 * (this.outliner.getBorderThickness() + this.outliner.getHighlightThickness()) - this.outliner.getInsets().top - this.outliner.getInsets().bottom;
        int n8 = 0;
        int n9 = 0;
        JCOutlinerNode jCOutlinerNode = this.outliner.getRootNode();
        int n10 = 0;
        while (n10 < n6) {
            if (this.print_all_nodes || this.outliner.shouldBeDrawn(jCOutlinerNode)) {
                if (n8 + n4 > n9) {
                    n9 = n7;
                    if (this.repeat_header || n == 0) {
                        n9 -= JCComponent.getPreferredSize((Component)this.outliner.getHeader()).height;
                    }
                    ++n;
                    n8 = n4;
                } else {
                    n8 += n4;
                }
            }
            if ((jCOutlinerNode = this.outliner.getNextNode(jCOutlinerNode)) == null) break;
            ++n10;
        }
        return n;
    }

    public void drawPage(Graphics graphics, int n) throws IllegalArgumentException {
        Object object;
        this.current_page = n;
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.getNumPages()) {
            throw new IllegalArgumentException("invalid page number: " + n);
        }
        int n3 = this.getPageStartColumn(n2);
        int n4 = this.getNumHorizontalPages();
        if (n4 == 0) {
            return;
        }
        int n5 = n2 / n4 + 1;
        int n6 = n2 % n4 + 1;
        int n7 = this.outliner.getNumColumns() - 1;
        n7 = n6 == n4 ? this.outliner.getNumColumns() - 1 : this.getPageStartColumn(n2 + 1) - 1;
        graphics.setColor(this.outliner.getBackground());
        graphics.fillRect(0, 0, this.page_width, this.page_height);
        JCHeader jCHeader = this.outliner.getHeader();
        JCComponent[] jCComponentArray = jCHeader.getLabels();
        int n8 = this.margin.left;
        int n9 = this.margin.top;
        this.outliner.calcColumnWidths();
        int n10 = 0;
        if (this.repeat_header || n5 == 1) {
            int n11;
            n10 = JCComponent.getPreferredSize((Component)jCHeader).height;
            if (jCComponentArray.length > 0 && (this.repeat_outline || n6 == 1)) {
                n11 = jCComponentArray[0].getSize().width;
                jCComponentArray[0].setDoubleBuffer(false);
                object = graphics.create();
                ((Graphics)object).translate(n8, n9);
                jCComponentArray[0].repaint((Graphics)object, 0, 0, n11, n10);
                ((Graphics)object).dispose();
                jCComponentArray[0].setDoubleBuffer(true);
                n8 += n11 - 1;
            }
            n11 = n3;
            while (n11 <= n7) {
                int n12 = jCComponentArray[n11].getSize().width;
                jCComponentArray[n11].setDoubleBuffer(false);
                Graphics graphics2 = graphics.create();
                graphics2.translate(n8, n9);
                if (n8 + n12 - this.margin.left > this.internal_width) {
                    n12 = this.internal_width - n8 + this.margin.left;
                }
                jCComponentArray[n11].repaint(graphics2, 0, 0, n12, n10);
                graphics2.dispose();
                jCComponentArray[n11].setDoubleBuffer(true);
                n8 += n12 - 1;
                ++n11;
            }
        }
        Rectangle rectangle = new Rectangle(this.margin.left, n9 + n10, this.internal_width, this.internal_height - n10);
        int n13 = 0;
        if (this.repeat_outline || n6 == 1) {
            object = new int[2 + n7 - n3];
            object[0] = false;
            ++n13;
        } else {
            object = new int[1 + n7 - n3];
        }
        int n14 = n3;
        while (n14 <= n7) {
            object[n13++] = n14;
            ++n14;
        }
        this.outliner.paintOutliner(graphics, rectangle, this.getPageStartNode(n2), (int[])object, this.print_all_nodes);
        this.doPrintPageHeader(graphics, n);
        this.doPrintPageFooter(graphics, n);
    }

    int getCurrentPageTopPosition() {
        int n = this.current_page - 1;
        int n2 = this.getNumHorizontalPages();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n / n2 + 1;
        int cfr_ignored_0 = n % n2;
        if (this.repeat_header || n3 == 1) {
            return this.margin.top + JCComponent.getPreferredSize((Component)this.outliner.getHeader()).height;
        }
        return this.margin.top;
    }

    private JCOutlinerNode getPageStartNode(int n) {
        int n2;
        int n3 = this.getNumHorizontalPages();
        if (n3 == 0) {
            return null;
        }
        int n4 = n / n3 + 1;
        int cfr_ignored_0 = n % n3;
        if (n4 == 1) {
            return this.outliner.getRootNode();
        }
        int n5 = this.outliner.getNodeHeight();
        int n6 = 0;
        while (n6 < this.outliner.style_list.length) {
            n5 = Math.max(n5, this.outliner.calculateStyleHeight(this.outliner.style_list[n6]));
            ++n6;
        }
        n5 += 2 * this.outliner.getHighlightThickness() + this.outliner.getSpacing();
        int n7 = 0;
        int n8 = 1;
        while (n8 < n4) {
            n2 = this.internal_height - 2 * (this.outliner.getBorderThickness() + this.outliner.getHighlightThickness()) - this.outliner.getInsets().top - this.outliner.getInsets().bottom;
            if (this.repeat_header || n8 == 1) {
                n2 -= JCComponent.getPreferredSize((Component)this.outliner.getHeader()).height;
            }
            n7 += n2 / n5;
            ++n8;
        }
        if (++n7 > this.outliner.node_list.size() - 1) {
            return null;
        }
        n2 = 1;
        JCOutlinerNode jCOutlinerNode = this.outliner.getRootNode();
        while (jCOutlinerNode != null && n2 < n7) {
            if (this.print_all_nodes || this.outliner.shouldBeDrawn(jCOutlinerNode)) {
                ++n2;
            }
            jCOutlinerNode = this.outliner.getNextNode(jCOutlinerNode);
        }
        return jCOutlinerNode;
    }

    private int getPageStartColumn(int n) {
        int n2 = this.getNumHorizontalPages();
        if (n2 == 0) {
            return 0;
        }
        int cfr_ignored_0 = n / n2;
        int n3 = n % n2 + 1;
        if (n3 == 1) {
            return 1;
        }
        int n4 = 1;
        int n5 = 1;
        int n6 = this.outliner.getColumnWidth(0);
        int n7 = 1;
        while (n7 <= n3) {
            int n8 = 0;
            if (this.repeat_outline || n7 == 1) {
                n8 += n6;
            }
            n4 = n5;
            int n9 = n5;
            while (n9 < this.outliner.getNumColumns()) {
                if (this.repeat_outline && n9 == n5 && n6 + this.outliner.getColumnWidth(n9) > this.internal_width) {
                    n5 = n9 + 1;
                    break;
                }
                if (!this.repeat_outline && n9 == n5 && this.outliner.getColumnWidth(n9) > this.internal_width) {
                    n5 = n9 + 1;
                    break;
                }
                if ((n8 += this.outliner.getColumnWidth(n9)) > this.internal_width) {
                    n5 = n9;
                    break;
                }
                ++n9;
            }
            ++n7;
        }
        return n4;
    }

    private void setInternalDimensions() {
        int n = this.margin_unit == 0 ? this.page_resolution : 1;
        this.internal_width = this.page_width - n * (this.margin.left + this.margin.right);
        this.internal_height = this.page_height - n * (this.margin.top + this.margin.bottom);
    }

    private void doPrintPageHeader(Graphics graphics, int n) {
        Graphics graphics2 = graphics.create();
        int n2 = this.margin_unit == 0 ? this.page_resolution : 1;
        graphics2.clipRect(n2 * this.margin.left, 0, this.internal_width, n2 * this.margin.top);
        graphics2.translate(n2 * this.margin.left, 0);
        JCOutlinerPrintEvent jCOutlinerPrintEvent = new JCOutlinerPrintEvent(this.outliner, graphics2, n + 1, 1);
        JCVector jCVector = this.outliner.printListeners;
        int n3 = 0;
        while (n3 < jCVector.size()) {
            ((JCOutlinerPrintListener)jCVector.elementAt(n3)).printPageHeader(jCOutlinerPrintEvent);
            ++n3;
        }
        graphics2.dispose();
    }

    private void doPrintPageFooter(Graphics graphics, int n) {
        Graphics graphics2 = graphics.create();
        int n2 = this.margin_unit == 0 ? this.page_resolution : 1;
        graphics2.clipRect(n2 * this.margin.left, this.page_height - n2 * this.margin.bottom, this.internal_width, n2 * this.margin.bottom);
        graphics2.translate(n2 * this.margin.left, this.page_height - n2 * this.margin.bottom);
        JCOutlinerPrintEvent jCOutlinerPrintEvent = new JCOutlinerPrintEvent(this.outliner, graphics2, n, 2);
        JCVector jCVector = this.outliner.printListeners;
        int n3 = 0;
        while (n3 < jCVector.size()) {
            ((JCOutlinerPrintListener)jCVector.elementAt(n3)).printPageFooter(jCOutlinerPrintEvent);
            ++n3;
        }
        graphics2.dispose();
    }
}

