/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ProtocolEvent;
import oracle.help.htmlBrowser.ProtocolListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;
import oracle.help.topicDisplay.BrowserTopicDisplay;

public class HTMLPopupWindow
extends JComponent
implements URLListener,
ProtocolListener {
    public static double COMPONENT_PERCENTAGE = 0.8;
    public static double GOLDEN_RATIO = 1.618;
    public static double ACCEPTABLE_DIFFERENCE = 0.2;
    public static double MAX_ATTEMPT_COUNT = 5.0;
    public static int BROWSER_MINIMUM_WIDTH = 105;
    public static int SCROLLBAR_SIZE = 8;
    private JComponent _overComponent;
    private Component _glassPane;
    private JRootPane _rootPane;
    private JLayeredPane _layeredPane;
    private HTMLBrowser _popupBrowser;
    private Component _popupComponent;
    private Window _parentWindow;
    private PopupMouseListener _popupMouseListener;
    private PopupKeyListener _popupKeyListener;
    private PopupWindowListener _popupWindowListener;
    private BrowserTopicDisplay _parentDisplay;

    public HTMLPopupWindow(BrowserTopicDisplay browserTopicDisplay, Class clazz, URL uRL, Point point, JComponent jComponent) {
        this._parentDisplay = browserTopicDisplay;
        this._overComponent = jComponent;
        this._rootPane = jComponent.getRootPane();
        this._layeredPane = this._rootPane.getLayeredPane();
        this._glassPane = this._rootPane.getGlassPane();
        this._popupComponent = this;
        this._parentWindow = this._parentWindow(jComponent);
        this._popupBrowser = null;
        try {
            this._popupBrowser = (HTMLBrowser)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to create instance of HTMLBrowser for HTML Popup Window");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this._popupBrowser.getHTMLContainer(), "Center");
        this.setBackground(UIManager.getColor("ToolTip.background"));
        this.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.setBorder(UIManager.getBorder("ToolTip.border"));
        int n = 0;
        int n2 = 0;
        double d = Double.MAX_VALUE;
        int n3 = 0;
        boolean bl = false;
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 1.0;
        Dimension dimension = jComponent.getSize();
        Dimension dimension2 = new Dimension();
        dimension2.width = (int)((double)dimension.width * COMPONENT_PERCENTAGE);
        dimension2.height = (int)((double)dimension.height * COMPONENT_PERCENTAGE);
        Dimension dimension3 = new Dimension();
        Dimension dimension4 = new Dimension();
        this._layeredPane.add((Component)this, JLayeredPane.POPUP_LAYER);
        this.validate();
        this._popupBrowser.setURL(uRL, true);
        dimension3 = this._popupBrowser.getCurrentRenderedSize();
        dimension4.width = dimension3.width;
        if (dimension4.width < BROWSER_MINIMUM_WIDTH) {
            dimension4.width = BROWSER_MINIMUM_WIDTH;
        }
        if (dimension4.width > dimension2.width) {
            dimension4.width = dimension2.width;
        }
        this.setSize(dimension2.width, 20);
        this.validate();
        dimension3 = this._popupBrowser.getCurrentRenderedSize();
        dimension4.height = dimension3.height;
        if (dimension4.height > dimension2.height) {
            dimension4.height = dimension2.height;
        }
        Dimension dimension5 = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension2.width > dimension5.width / 2) {
            d4 = 0.5;
        }
        while (!bl) {
            int n4 = (int)((double)dimension2.width * d4);
            ++n3;
            if (n4 < dimension4.width) {
                n4 = dimension4.width;
            }
            this.setSize(n4, dimension4.height);
            this.validate();
            dimension3 = this._popupBrowser.getCurrentRenderedSize();
            int n5 = dimension3.height > dimension2.height ? dimension2.height : dimension3.height;
            double d5 = 1.0 * (double)n4 / (double)n5;
            if (Math.abs(d5 - GOLDEN_RATIO) < Math.abs(d - GOLDEN_RATIO)) {
                d = d5;
                n = n4;
                n2 = n5;
            }
            if ((double)n3 == MAX_ATTEMPT_COUNT || Math.abs(d - GOLDEN_RATIO) < ACCEPTABLE_DIFFERENCE) {
                bl = true;
                continue;
            }
            if (d5 > GOLDEN_RATIO) {
                d2 = d4;
            } else if (n4 == dimension2.width) {
                bl = true;
            } else {
                d3 = d4;
            }
            d4 = (d2 + d3) / 2.0;
        }
        this.setSize(n + SCROLLBAR_SIZE, n2 + SCROLLBAR_SIZE);
        Point point2 = this._translatePoint(this._overComponent.getParent(), this._parentWindow, this._overComponent.getLocation().x, this._overComponent.getLocation().y);
        this.setLocation(point2.x + (dimension.width - n) / 2, point2.y + (dimension.height - n2) / 2);
        this.validate();
        this._popupBrowser.setDefaultBackground(UIManager.getColor("ToolTip.background"));
        this._popupKeyListener = new PopupKeyListener();
        this._manageKeyListeners(true, this._popupKeyListener, this._parentWindow);
        this._popupMouseListener = new PopupMouseListener();
        this._manageMouseListeners(true, this._popupMouseListener, this._parentWindow);
        this._popupWindowListener = new PopupWindowListener();
        this._parentWindow.addWindowListener(this._popupWindowListener);
        this._popupBrowser.addURLListener(this);
        this._popupBrowser.addProtocolListener(this);
    }

    public void urlChanged(URLEvent uRLEvent) {
        if (uRLEvent != null && uRLEvent.getID() == 2000) {
            this.dispose();
            this._parentDisplay.setBrowserURL(uRLEvent.getURL());
        }
    }

    public void protocolReceived(ProtocolEvent protocolEvent) {
        if (protocolEvent != null) {
            this.dispose();
            this._parentDisplay.protocolReceived(protocolEvent);
        }
    }

    public synchronized void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
            this._manageMouseListeners(false, this._popupMouseListener, this._parentWindow);
            this._manageKeyListeners(false, this._popupKeyListener, this._parentWindow);
            this._parentWindow.removeWindowListener(this._popupWindowListener);
            this._layeredPane.remove(this);
            this._popupBrowser.dispose();
        }
    }

    protected void paintComponent(Graphics graphics) {
        UIUtils.fillBackground((Graphics)graphics, (JComponent)this);
    }

    private void _manageKeyListeners(boolean bl, KeyListener keyListener, Component component) {
        Component[] componentArray;
        if (bl) {
            component.addKeyListener(keyListener);
        } else {
            component.removeKeyListener(keyListener);
        }
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null) {
            int n = 0;
            while (n < componentArray.length) {
                this._manageKeyListeners(bl, keyListener, componentArray[n]);
                ++n;
            }
        }
    }

    private void _manageMouseListeners(boolean bl, MouseListener mouseListener, Component component) {
        Component[] componentArray;
        if (bl) {
            component.addMouseListener(mouseListener);
        } else {
            component.removeMouseListener(mouseListener);
        }
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null) {
            int n = 0;
            while (n < componentArray.length) {
                this._manageMouseListeners(bl, mouseListener, componentArray[n]);
                ++n;
            }
        }
    }

    private boolean _componentInSubTree(Component component, Component component2) {
        Component[] componentArray;
        if (component == component2) {
            return true;
        }
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (this._componentInSubTree(componentArray[n], component2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private Window _parentWindow(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private Point _translatePoint(Component component, Component component2, int n, int n2) {
        while (component != component2) {
            Point point = component.getLocation();
            n += point.x;
            n2 += point.y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    private class PopupWindowListener
    extends WindowAdapter {
        private PopupWindowListener() {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            HTMLPopupWindow.this.dispose();
        }
    }

    private class PopupKeyListener
    extends KeyAdapter {
        private PopupKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() != HTMLPopupWindow.this._parentWindow && !HTMLPopupWindow.this._componentInSubTree(HTMLPopupWindow.this._popupComponent, (Component)keyEvent.getSource())) {
                HTMLPopupWindow.this.dispose();
            }
        }
    }

    private class PopupMouseListener
    extends MouseAdapter {
        private PopupMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!HTMLPopupWindow.this._componentInSubTree(HTMLPopupWindow.this._popupComponent, (Component)mouseEvent.getSource())) {
                HTMLPopupWindow.this.dispose();
            }
        }
    }
}

