/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay;

import java.net.URL;
import java.util.ArrayList;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.topicDisplay.TopicDisplay;

public class DocumentStack {
    private int _currentPosition;
    private ArrayList _stack = new ArrayList();
    private TopicDisplay _topicDisplay;

    public DocumentStack(TopicDisplay topicDisplay) {
        this._topicDisplay = topicDisplay;
        this._currentPosition = 0;
    }

    public synchronized void clearStack() {
        this._stack.clear();
        this._currentPosition = 0;
    }

    private synchronized void _setURL(URL uRL) {
        try {
            SimpleURLTarget simpleURLTarget = new SimpleURLTarget(null, uRL.toString());
            SimpleTopic simpleTopic = new SimpleTopic(null, simpleURLTarget, null);
            this._topicDisplay.displayTopic(simpleTopic);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void addElement(URL uRL) {
        if (uRL != null && !uRL.equals(this.getURL())) {
            if (this._currentPosition < this._stack.size()) {
                this._stack.ensureCapacity(this._currentPosition);
            }
            this._stack.add(uRL);
            ++this._currentPosition;
        }
    }

    public synchronized boolean canGoBack() {
        return this._currentPosition > 1;
    }

    public synchronized void goBack() {
        if (this.canGoBack()) {
            --this._currentPosition;
            URL uRL = (URL)this._stack.get(this._currentPosition - 1);
            this._setURL(uRL);
        }
    }

    public synchronized boolean canGoForward() {
        return this._stack.size() > this._currentPosition;
    }

    public synchronized void goForward() {
        if (this.canGoForward()) {
            ++this._currentPosition;
            URL uRL = (URL)this._stack.get(this._currentPosition - 1);
            this._setURL(uRL);
        }
    }

    public synchronized URL getURL() {
        URL uRL = null;
        if (this._stack.size() > 0) {
            uRL = (URL)this._stack.get(this._currentPosition - 1);
        }
        return uRL;
    }
}

