/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.tocNavigator;

import java.awt.Component;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDeferringRoot;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.navigator.tocNavigator.RootItemModel;
import oracle.help.navigator.tocNavigator.TOCItem;
import oracle.help.navigator.tocNavigator.TOCItemFactory;
import oracle.help.navigator.tocNavigator.TOCPopupEvent;
import oracle.help.navigator.tocNavigator.TOCPopupListener;

public class TOCTree
extends DTree {
    private RootItemModel _rootData;
    private DTreeDeferringRoot _root;
    private ListenerManager _listeners = new ListenerManager();
    private TopicTreeNode _queuedSelection;

    public TOCTree(View[] viewArray) {
        this._rootData = new RootItemModel(viewArray);
        this._root = new DTreeDeferringRoot(null, null, (OneDModel)this._rootData, (DTreeItemFactory)TOCItemFactory.getInstance());
        this._queuedSelection = null;
        this.setRoot((DTreeRootItem)this._root);
    }

    public void addTOCView(View view) {
        this._rootData.addTOCView(view);
    }

    public void removeTOCView(View view) {
        this._rootData.removeTOCView(view);
    }

    public boolean selectClosestMatchingNode(URL uRL) {
        boolean bl = false;
        TopicTreeNode topicTreeNode = this._getCurrentSelection();
        TopicTreeNode topicTreeNode2 = this._rootData.findClosestMatchingNode(topicTreeNode, uRL);
        if (((Component)((Object)this)).isVisible()) {
            if (topicTreeNode2 != null) {
                this._selectNode(topicTreeNode2);
                bl = true;
            } else {
                this._deselectAll();
            }
        } else {
            this._queuedSelection = topicTreeNode2;
        }
        return bl;
    }

    public void addPopupRequestListener(TOCPopupListener tOCPopupListener) {
        if (tOCPopupListener != null) {
            this._listeners.addListener((EventListener)tOCPopupListener);
        }
    }

    public void removePopupRequestListener(TOCPopupListener tOCPopupListener) {
        if (tOCPopupListener != null) {
            this._listeners.removeListener((EventListener)tOCPopupListener);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            super.setVisible(true);
            if (this._queuedSelection == null) {
                this._deselectAll();
            } else {
                this._selectNode(this._queuedSelection);
            }
        } else {
            this._queuedSelection = this._getCurrentSelection();
            super.setVisible(false);
        }
    }

    void firePopupRequested(TOCPopupEvent tOCPopupEvent) {
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TOCPopupListener tOCPopupListener = (TOCPopupListener)enumeration.nextElement();
                tOCPopupListener.popupRequested(tOCPopupEvent);
            }
        }
    }

    private void _deselectAll() {
        try {
            this.setSelection(new DTreeSelection());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TopicTreeNode _getCurrentSelection() {
        TopicTreeNode topicTreeNode = null;
        if (((Component)((Object)this)).isVisible()) {
            DTreeSelection dTreeSelection = this.getSelection();
            if (dTreeSelection.getCount() != 0) {
                TOCItem tOCItem = (TOCItem)dTreeSelection.getFirstItem();
                topicTreeNode = tOCItem.getTopicTreeNode();
            }
        } else {
            topicTreeNode = this._queuedSelection;
        }
        return topicTreeNode;
    }

    private synchronized void _selectNode(TopicTreeNode topicTreeNode) {
        if (topicTreeNode != null) {
            this._recursiveExpansion(topicTreeNode.getParent());
            DTreeItem dTreeItem = (DTreeItem)topicTreeNode.getClientData();
            if (dTreeItem != null) {
                this.makeVisible(dTreeItem);
                try {
                    this.getSelectionManager().selectItem(dTreeItem);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void _recursiveExpansion(TopicTreeNode topicTreeNode) {
        if (topicTreeNode != null) {
            this._recursiveExpansion(topicTreeNode.getParent());
            DTreeItem dTreeItem = (DTreeItem)topicTreeNode.getClientData();
            if (dTreeItem != null) {
                dTreeItem.setExpanded(true);
                int n = dTreeItem.getItemCount();
                int n2 = 0;
                while (n2 < n) {
                    DTreeItem dTreeItem2 = dTreeItem.getItem(n2);
                    ++n2;
                }
            }
        }
    }
}

