/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.tocNavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.dTree.DTreeActivateListener;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.MenuUtils;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.tocNavigator.TOCItem;
import oracle.help.navigator.tocNavigator.TOCPopupEvent;
import oracle.help.navigator.tocNavigator.TOCPopupListener;
import oracle.help.navigator.tocNavigator.TOCTree;

public class TOCNavigator
extends Navigator
implements DTreeActivateListener,
PropertyChangeListener,
TOCPopupListener {
    private static String TYPE_TOCNAVIGATOR = "oracle.help.navigator.tocNavigator.TOCNavigator";
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String DEFAULT_LABEL_ID = "navigator.tocNavigator.default_label";
    private boolean _popupActive = false;
    private JScrollPane _scrollPane;
    private TOCTree _tocTree;
    private Topic _selectedTopic;
    private TopicTreeNode _selectedTopicNode;

    public void initNavigator(View[] viewArray) {
        View[] viewArray2 = viewArray;
        this._tocTree = new TOCTree(viewArray2);
        this._tocTree.addActivateListener(this);
        this._tocTree.addPopupRequestListener(this);
        ((Container)((Object)this._tocTree)).addPropertyChangeListener(this);
        this._selectedTopic = null;
        this._selectedTopicNode = null;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 1, 1, 1));
        this._scrollPane = new JScrollPane((Component)((Object)this._tocTree), 20, 30);
        this.add((Component)this._scrollPane, "Center");
    }

    public Topic getCurrentSelection() {
        return this._selectedTopic;
    }

    public TopicTreeNode getCurrentSelectionNode() {
        return this._selectedTopicNode;
    }

    public String getDefaultLabel() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String string = resourceBundle.getString(DEFAULT_LABEL_ID);
        return string;
    }

    public void addView(View view) {
        if (view != null && view.getType().equals(TYPE_TOCNAVIGATOR)) {
            this._tocTree.addTOCView(view);
        }
    }

    public void removeView(View view) {
        if (view != null && view.getType().equals(TYPE_TOCNAVIGATOR)) {
            this._tocTree.removeTOCView(view);
        }
    }

    public boolean selectMatchingTopic(URL uRL) {
        boolean bl = false;
        bl = this._tocTree.selectClosestMatchingNode(uRL);
        return bl;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this._tocTree.setVisible(bl);
    }

    public void printNavigator() {
        try {
            PrinterUtils.print((JComponent)((Object)this._tocTree), null, (boolean)false, (Frame)WindowUtils.parentFrame((Component)this), (String)"OHJ Table of Contents", null, null, null, (double)1.0, (double)1.0, (double)1.0, (double)1.0);
        }
        catch (Exception exception) {
            System.err.println("Error printing Navigator");
        }
    }

    public void dTreeItemActivate(DTreeItemEvent dTreeItemEvent) {
        if (dTreeItemEvent != null && dTreeItemEvent.getID() == 2004) {
            TOCItem tOCItem = (TOCItem)dTreeItemEvent.getItem();
            Topic topic = tOCItem.getTopic();
            this._fireTopicActivated(topic, 1);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DTreeSelection dTreeSelection = this._tocTree.getSelection();
        TOCItem tOCItem = (TOCItem)dTreeSelection.getFirstItem();
        if (tOCItem != null) {
            this._selectedTopic = tOCItem.getTopic();
            this._selectedTopicNode = tOCItem.getTopicTreeNode();
        } else {
            this._selectedTopic = null;
            this._selectedTopicNode = null;
        }
        this._fireTopicSelected(this._selectedTopic);
    }

    public void popupRequested(TOCPopupEvent tOCPopupEvent) {
        if (!this._popupActive) {
            this._popupActive = true;
            if (tOCPopupEvent != null) {
                if (tOCPopupEvent.getID() == 2000) {
                    Point point = tOCPopupEvent.getLocation();
                    Point point2 = this._scrollPane.getViewport().getViewPosition();
                    NewWindowPopup newWindowPopup = new NewWindowPopup(tOCPopupEvent.getTopic());
                    oracle.bali.ewt.util.MenuUtils.showPopupMenu((JPopupMenu)newWindowPopup, (Component)((Object)this._tocTree), (int)(point.x - point2.x), (int)(point.y - point2.y));
                } else {
                    this._popupActive = false;
                }
            }
        }
    }

    public void setScrollPaneBorder(Border border) {
        this._scrollPane.setBorder(border);
        this._scrollPane.repaint();
    }

    public void addTOCPopupRequestListener(TOCPopupListener tOCPopupListener) {
        this._tocTree.addPopupRequestListener(tOCPopupListener);
    }

    public void removeTOCPopupRequestListener(TOCPopupListener tOCPopupListener) {
        this._tocTree.removePopupRequestListener(tOCPopupListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        ((Component)((Object)this._tocTree)).addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        ((Component)((Object)this._tocTree)).removeMouseListener(mouseListener);
    }

    private void _fireTopicActivated(Topic topic, int n) {
        NavigatorEvent navigatorEvent = new NavigatorEvent(this, 2001, topic, n);
        this.fireNavigatorEvent(navigatorEvent);
    }

    private void _fireTopicSelected(Topic topic) {
        NavigatorEvent navigatorEvent = new NavigatorEvent(this, 2000, topic);
        this.fireNavigatorEvent(navigatorEvent);
    }

    private class NewWindowPopup
    extends JPopupMenu
    implements ActionListener {
        JMenuItem _displayNew;
        Topic _topic;

        public NewWindowPopup(Topic topic) {
            String string = MenuUtils.getDefaultMenuLabel("menu.Display_New");
            this._displayNew = new JMenuItem(string);
            MenuUtils.setMenuAttributes(this._displayNew, string, true);
            this._displayNew.setActionCommand(string);
            this._displayNew.addActionListener(this);
            this._topic = topic;
            this.add(this._displayNew);
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (!bl) {
                TOCNavigator.this._popupActive = false;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._displayNew) {
                TOCNavigator.this._fireTopicActivated(this._topic, 2);
            }
        }
    }
}

