/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.tocNavigator;

import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.dTree.DTreeDeferredChild;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.util.ImageLoader;
import oracle.help.navigator.tocNavigator.TOCItem;
import oracle.help.navigator.tocNavigator.TOCPopupEvent;
import oracle.help.navigator.tocNavigator.TOCTree;

public class TOCLeafItem
extends DTreeDeferredChild
implements TOCItem {
    private ImageIcon _leafIcon = null;
    private static ImageIcon _defaultLeafIcon = null;

    public Topic getTopic() {
        Topic topic = null;
        TopicTreeNode topicTreeNode = this.getTopicTreeNode();
        if (topicTreeNode != null) {
            topic = topicTreeNode.getTopic();
        }
        return topic;
    }

    public TopicTreeNode getTopicTreeNode() {
        TopicTreeNode topicTreeNode = null;
        DTreeDeferringParent dTreeDeferringParent = this.getDeferringParent();
        if (dTreeDeferringParent != null) {
            topicTreeNode = (TopicTreeNode)dTreeDeferringParent.getChildData(this.getIndex());
        }
        return topicTreeNode;
    }

    public String getLabel() {
        String string = null;
        Topic topic = this.getTopic();
        if (topic != null) {
            string = topic.getLabel();
        }
        return string;
    }

    public Icon getIcon() {
        if (this._leafIcon == null) {
            Image image = ImageLoader.loadImage(this.getTopic().getDefaultIcon());
            if (image == null) {
                Image image2;
                if (_defaultLeafIcon == null && (image2 = ImageLoader.loadImage(this.getTree().getClass(), "images/file.gif")) != null) {
                    _defaultLeafIcon = new ImageIcon(image2);
                }
                this._leafIcon = _defaultLeafIcon;
            } else {
                this._leafIcon = new ImageIcon(image);
            }
        }
        return this._leafIcon;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            TOCTree tOCTree = (TOCTree)this.getTree();
            Point point = new Point(this.getX() + mouseEvent.getX(), this.getY() + mouseEvent.getY());
            tOCTree.firePopupRequested(new TOCPopupEvent(this, 2000, this.getTopic(), point));
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }
}

