/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.Image;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JPanel;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.navigator.BaseNavigator;
import oracle.help.common.navigator.NavigatorHelper;
import oracle.help.library.Library;
import oracle.help.library.LibraryEvent;
import oracle.help.library.LibraryListener;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorException;
import oracle.help.navigator.NavigatorListener;

public abstract class Navigator
extends JPanel
implements LibraryListener,
BaseNavigator {
    protected Library library = null;
    protected String label = null;
    protected Image labelImage;
    protected String type;
    protected boolean filterByLabel = false;
    protected ArrayList views = null;
    protected ListenerManager listeners = null;

    public static Navigator createNavigator(String string, String string2, Image image) throws NavigatorException {
        return Navigator.createNavigator(string, null, string2, image, false);
    }

    public static Navigator createNavigator(String string, Library library, String string2, Image image, boolean bl) throws NavigatorException {
        View[] viewArray;
        if (string == null) {
            throw new IllegalArgumentException("Navigator.createNavigator: type parameter cannot be null");
        }
        Navigator navigator = null;
        try {
            viewArray = Class.forName(string);
            if (viewArray != null) {
                navigator = (Navigator)viewArray.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NavigatorException("Navigator.createNavigator: Could not find specified navigator class.  Make sure " + string + "is on your class path.");
        }
        catch (ClassCastException classCastException) {
            throw new NavigatorException("Specified navigator " + string + " not a subclass of oracle.help.navigator.Navigator");
        }
        catch (Exception exception) {
            throw new NavigatorException("Unable to create specified engine " + string);
        }
        if (navigator != null) {
            viewArray = null;
            viewArray = navigator.initBaseClass(library, string, string2, image, bl);
            navigator.initNavigator(viewArray);
        }
        return navigator;
    }

    public void addNavigatorListener(NavigatorListener navigatorListener) {
        if (navigatorListener != null) {
            this.listeners.addListener((EventListener)navigatorListener);
        }
    }

    public void removeNavigatorListener(NavigatorListener navigatorListener) {
        if (navigatorListener != null) {
            this.listeners.removeListener((EventListener)navigatorListener);
        }
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public Image getLabelImage() {
        return this.labelImage;
    }

    public void setLabelImage(Image image) {
        this.labelImage = image;
    }

    protected final View[] initBaseClass(Library library, String string, String string2, Image image, boolean bl) throws NavigatorException {
        View[] viewArray = null;
        int n = 0;
        this.label = string2;
        this.labelImage = image;
        this.library = library;
        this.filterByLabel = bl;
        this.type = string;
        this.listeners = new ListenerManager();
        this.views = new ArrayList();
        if (library != null) {
            this.library.addLibraryListener(this);
            viewArray = library.getViewsByType(this.type);
            if (bl) {
                viewArray = this.filterViewsByLabel(viewArray, string2);
            }
            if (viewArray != null) {
                n = 0;
                while (n < viewArray.length) {
                    this.views.add(viewArray[n]);
                    ++n;
                }
            }
        }
        return viewArray;
    }

    public void libraryChanged(LibraryEvent libraryEvent) {
        NavigatorHelper.libraryChanged(libraryEvent, this, this.filterByLabel, this.label, this.views);
    }

    protected void fireNavigatorEvent(NavigatorEvent navigatorEvent) {
        NavigatorHelper.fireNavigatorEvent(navigatorEvent, this.listeners);
    }

    protected View[] filterViewsByLabel(View[] viewArray, String string) {
        return NavigatorHelper.filterViewsByLabel(viewArray, string);
    }

    public abstract String getDefaultLabel();

    public abstract Topic getCurrentSelection();

    public abstract void removeView(View var1);

    public abstract void addView(View var1);

    public abstract void initNavigator(View[] var1);
}

