/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpset;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import oracle.help.common.AssociativeLink;
import oracle.help.common.TopicMap;
import oracle.help.common.View;
import oracle.help.common.WindowType;
import oracle.help.common.util.Canonicalizer;
import oracle.help.common.util.LocaleUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;
import oracle.help.library.helpset.HelpSetParseException;
import oracle.help.library.helpset.HelpSetSection;
import oracle.help.library.helpset.XMLLinkParser;

public class HelpSet
implements Book {
    public static final String TAG_HELPSET = "helpset";
    public static final String TAG_TITLE = "title";
    public static final String TAG_HOMEID = "homeid";
    public static final String TAG_SUBHELPSET = "subhelpset";
    public static final String TAG_WINTYPE = "wintype";
    public static final String TAG_HEIGHT = "height";
    public static final String TAG_WIDTH = "width";
    public static final String TAG_X = "x";
    public static final String TAG_Y = "y";
    public static final String TAG_TEXTFG = "textfg";
    public static final String TAG_LINKFG = "linkfg";
    public static final String TAG_BG = "bg";
    public static final String TAG_TOOLBAR = "toolbar";
    public static final String TAG_LINKS = "links";
    public static final String TAG_MAP = "maps";
    public static final String TAG_VIEW = "view";
    public static final String TAG_DATA = "data";
    public static final String TAG_KEY = "key";
    public static final String TAG_NAME = "name";
    public static final String TAG_TYPE = "type";
    public static final String TAG_MERGETYPE = "mergetype";
    public static final String TAG_LABEL = "label";
    public static final String TAG_MAPREF = "mapref";
    public static final String TAG_LINKREF = "linkref";
    public static final String PARAM_ID = "id";
    public static final String PARAM_URL = "url";
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_DEFAULT = "default";
    public static final String PARAM_ENGINE = "engine";
    public static final String PARAM_ENGINEPARAMS = "engineParams";
    public static final String PARAM_LOCATION = "location";
    public static final String PARAM_IMAGE = "image";
    private ArrayList _helpSetSections = new ArrayList();
    private ArrayList _views = new ArrayList();
    private ArrayList _windowTypes = new ArrayList();
    private ArrayList _associativeLinks = null;
    private ArrayList _maps = new ArrayList();
    private Object _viewLock = new Object();
    private Object _mapLock = new Object();
    private Object _linkLock = new Object();
    private String _controlFileEncoding = null;
    private String _helpSetDir = null;
    private URL _fileURL = null;
    private String _homeID = null;
    private String _title = null;
    private static final String TYPE_JAVAHELP_TOC_NEW = "javax.help.TOCView";
    private static final String TYPE_JAVAHELP_TOC_OLD = "javax.javahelp.TOC";
    private static final String TYPE_JAVAHELP_KEYWORD_NEW = "javax.help.IndexView";
    private static final String TYPE_JAVAHELP_KEYWORD_OLD = "javax.javahelp.Index";
    private static final String TYPE_JAVAHELP_SEARCH_NEW = "javax.help.SearchView";
    private static final String TYPE_JAVAHELP_SEARCH_OLD = "javax.javahelp.Search";
    private static final String TYPE_DEFAULT_ORACLE_TOC = "oracle.help.navigator.tocNavigator.TOCNavigator";
    private static final String TYPE_DEFAULT_ORACLE_KEYWORD = "oracle.help.navigator.keywordNavigator.KeywordNavigator";
    private static final String TYPE_DEFAULT_ORACLE_SEARCH = "oracle.help.navigator.searchNavigator.SearchNavigator";
    private static final String ENGINE_ORACLE_HHC_OLD = "oracle.help.HHC";
    private static final String ENGINE_ORACLE_HHC_NEW = "oracle.help.engine.HHCEngine";
    private static final String ENGINE_ORACLE_TOC_OLD = "oracle.help.TOC";
    private static final String ENGINE_ORACLE_TOC_NEW = "oracle.help.engine.TOCEngine";
    private static final String ENGINE_ORACLE_XMLTOC_OLD = "oracle.help.XMLTOC";
    private static final String ENGINE_ORACLE_XMLTOC_NEW = "oracle.help.engine.XMLTOCEngine";
    private static final String ENGINE_JAVAHELP_TOC_OLD = "javax.javahelp.TOC";
    private static final String ENGINE_JAVAHELP_TOC_NEW = "oracle.help.engine.XMLTOCEngine";
    private static final String ENGINE_ORACLE_HHK_OLD = "oracle.help.HHK";
    private static final String ENGINE_ORACLE_HHK_NEW = "oracle.help.engine.HHKEngine";
    private static final String ENGINE_ORACLE_TOK_OLD = "oracle.help.TOK";
    private static final String ENGINE_ORACLE_TOK_NEW = "oracle.help.engine.TOKEngine";
    private static final String ENGINE_ORACLE_XMLINDEX_OLD = "oracle.help.XMLIndex";
    private static final String ENGINE_ORACLE_XMLINDEX_NEW = "oracle.help.engine.XMLIndexEngine";
    private static final String ENGINE_JAVAHELP_INDEX_OLD = "javax.javahelp.Index";
    private static final String ENGINE_JAVAHELP_INDEX_NEW = "oracle.help.engine.XMLIndexEngine";
    private static final String ENGINE_ORACLE_SEARCH_OLD = "oracle.help.Search";
    private static final String ENGINE_ORACLE_SEARCH_NEW = "oracle.help.engine.SearchEngine";
    private static final String ENGINE_ORACLE_XMLMAP_NEW = "oracle.help.engine.XMLMapEngine";
    private static final String ENGINE_ORACLE_XMLMAPCONVENTION_NEW = "oracle.help.engine.XMLMapConventionEngine";

    public HelpSet() {
    }

    public HelpSet(Class clazz, String string) throws HelpSetParseException {
        this(clazz, string, StaticLocaleContext.getEncoding());
    }

    public HelpSet(Class clazz, String string, String string2) throws HelpSetParseException {
        this();
        URL uRL = null;
        string = Canonicalizer.fixSeparators(string);
        if (clazz == null || string == null) {
            throw new HelpSetParseException("Invalid Parameters to HelpSet constructor");
        }
        try {
            uRL = clazz.getResource(string);
        }
        catch (Exception exception) {
            throw new HelpSetParseException("Exception encountered in HelpSet constructor" + exception.getMessage());
        }
        this._initHelpSet(uRL, string2);
    }

    public HelpSet(URL uRL) throws HelpSetParseException {
        this(uRL, StaticLocaleContext.getEncoding());
    }

    public HelpSet(URL uRL, String string) throws HelpSetParseException {
        this();
        this._initHelpSet(uRL, string);
    }

    public URL mapIDToURL(String string) {
        URL uRL = null;
        Object object = this._mapLock;
        synchronized (object) {
            if (this._maps.size() == 0) {
                this._createMaps();
            }
        }
        int n = 0;
        while (n < this._maps.size()) {
            try {
                TopicMap topicMap = (TopicMap)this._maps.get(n);
                uRL = topicMap.mapIDToURL(string);
                if (uRL != null) {
                    return uRL;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        return null;
    }

    public String mapURLToWindowTypeName(URL uRL) {
        String string = null;
        Object object = this._mapLock;
        synchronized (object) {
            if (this._maps.size() == 0) {
                this._createMaps();
            }
        }
        int n = 0;
        while (n < this._maps.size()) {
            TopicMap topicMap = (TopicMap)this._maps.get(n);
            string = topicMap.mapURLToWindowTypeName(uRL);
            if (string != null) {
                return string;
            }
            ++n;
        }
        return string;
    }

    public String getBookTitle() {
        return this._title;
    }

    public View[] getViewsByType(String string) {
        View[] viewArray = null;
        ArrayList<View> arrayList = new ArrayList<View>();
        if (string == null) {
            return null;
        }
        Object object = this._viewLock;
        synchronized (object) {
            this._createViewObjects(true, string);
            int n = 0;
            while (n < this._views.size()) {
                View view = (View)this._views.get(n);
                if (view.getType().equals(string)) {
                    arrayList.add(view);
                }
                ++n;
            }
        }
        if (arrayList.size() > 0) {
            viewArray = new View[arrayList.size()];
            arrayList.toArray(viewArray);
        }
        return viewArray;
    }

    public View[] getAllViews() {
        View[] viewArray = null;
        Object object = this._viewLock;
        synchronized (object) {
            this._createViewObjects(false, "");
            if (this._views.size() > 0) {
                viewArray = new View[this._views.size()];
                this._views.toArray(viewArray);
            }
        }
        return viewArray;
    }

    public WindowType[] getWindowTypes() {
        WindowType[] windowTypeArray = null;
        if (this._windowTypes.size() > 0) {
            windowTypeArray = new WindowType[this._windowTypes.size()];
            this._windowTypes.toArray(windowTypeArray);
        }
        return windowTypeArray;
    }

    public AssociativeLink[] getAssociativeLinks() {
        AssociativeLink[] associativeLinkArray = null;
        Object object = this._linkLock;
        synchronized (object) {
            if (this._associativeLinks == null) {
                this._associativeLinks = new ArrayList();
                int n = 0;
                while (n < this._helpSetSections.size()) {
                    HelpSetSection helpSetSection = (HelpSetSection)this._helpSetSections.get(n);
                    AssociativeLink[] associativeLinkArray2 = null;
                    if (helpSetSection.getIdentifier().equals(TAG_LINKS) && !helpSetSection.isCompleted()) {
                        try {
                            XMLLinkParser xMLLinkParser = new XMLLinkParser();
                            associativeLinkArray2 = xMLLinkParser.parseLinkFile(helpSetSection.getDataLocationURL(), this._controlFileEncoding, this);
                        }
                        catch (Exception exception) {
                            System.err.println("Unable to parse link file" + helpSetSection.getDataLocationString());
                            exception.printStackTrace();
                            associativeLinkArray2 = null;
                        }
                        helpSetSection.setCompleted(true);
                        if (associativeLinkArray2 != null) {
                            int n2 = 0;
                            while (n2 < associativeLinkArray2.length) {
                                this._associativeLinks.add(associativeLinkArray2[n2]);
                                ++n2;
                            }
                        }
                    }
                    ++n;
                }
            }
        }
        if (this._associativeLinks.size() > 0) {
            associativeLinkArray = new AssociativeLink[this._associativeLinks.size()];
            this._associativeLinks.toArray(associativeLinkArray);
        }
        return associativeLinkArray;
    }

    public HelpSetSection[] getHelpSetSections() {
        HelpSetSection[] helpSetSectionArray = null;
        if (this._helpSetSections.size() > 0) {
            helpSetSectionArray = new HelpSetSection[this._helpSetSections.size()];
            this._helpSetSections.toArray(helpSetSectionArray);
        }
        return helpSetSectionArray;
    }

    public void setHomeID(String string) {
        this._homeID = string;
    }

    public String getHomeID() {
        return this._homeID;
    }

    public String getHelpSetEncoding() {
        return this._controlFileEncoding;
    }

    private void _initHelpSet(URL uRL, String string) throws HelpSetParseException {
        this._fileURL = uRL;
        this._helpSetDir = this._fileURL.toString();
        Canonicalizer.fixSeparators(this._helpSetDir);
        this._helpSetDir = this._helpSetDir.substring(0, this._helpSetDir.lastIndexOf(47) + 1);
        this._parseFile(this._fileURL, string);
    }

    private void _parseFile(URL uRL, String string) throws HelpSetParseException {
        this._controlFileEncoding = LocaleUtils.determineHelpSetEncoding(uRL);
        if (this._controlFileEncoding == null) {
            this._controlFileEncoding = string;
        }
        Parser parser = null;
        try {
            parser = ParserFactory.createParser(LocaleUtils.createInputStreamReader(uRL.openStream(), this._controlFileEncoding));
        }
        catch (XMLParseException xMLParseException) {
            throw new HelpSetParseException(xMLParseException.getMessage());
        }
        catch (IOException iOException) {
            throw new HelpSetParseException(iOException.getMessage());
        }
        XMLNode xMLNode = parser.getRoot();
        this._handleHelpset(xMLNode.getFirstChild());
    }

    private void _handleHelpset(XMLNode xMLNode) throws HelpSetParseException {
        if (xMLNode == null) {
            throw new HelpSetParseException("No toplevel tag in helpset file");
        }
        if (!xMLNode.tokenEquals(TAG_HELPSET)) {
            throw new HelpSetParseException("Toplevel tag is not <helpset>");
        }
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.tokenEquals(TAG_TITLE)) {
                this._handleTitle(xMLNode);
            } else if (xMLNode.tokenEquals(TAG_WINTYPE)) {
                this._handleWinType(xMLNode);
            } else if (xMLNode.tokenEquals(TAG_LINKS)) {
                this._handleLinkSection(xMLNode);
            } else if (xMLNode.tokenEquals(TAG_MAP)) {
                this._handleMap(xMLNode);
            } else if (xMLNode.tokenEquals(TAG_SUBHELPSET)) {
                this._handleSubhelpset(xMLNode);
            } else if (xMLNode.tokenEquals(TAG_VIEW)) {
                this._handleView(xMLNode);
            } else {
                throw new HelpSetParseException("Unknown tag under helpset " + xMLNode.getTokenValue());
            }
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void _handleTitle(XMLNode xMLNode) throws HelpSetParseException {
        String string = xMLNode.getString();
        if (string != null) {
            this._title = string;
        }
    }

    private void _handleHomeID(XMLNode xMLNode) throws HelpSetParseException {
        String string = xMLNode.getString();
        this.setHomeID(string);
    }

    private void _handleSubhelpset(XMLNode xMLNode) throws HelpSetParseException {
        HelpSetSection helpSetSection = new HelpSetSection(this, this._helpSetDir);
        helpSetSection.setIdentifier(TAG_SUBHELPSET);
        URL uRL = null;
        helpSetSection.setDataLocationString(xMLNode.getTokenProperty(PARAM_LOCATION));
        helpSetSection.setClassAttribute(xMLNode.getTokenProperty(PARAM_CLASS));
        this._helpSetSections.add(helpSetSection);
        try {
            uRL = helpSetSection.getDataLocationURL();
            uRL.openStream().close();
        }
        catch (Exception exception) {
            uRL = null;
        }
        HelpSet helpSet = null;
        if (uRL != null) {
            try {
                helpSet = new HelpSet(uRL, this._controlFileEncoding);
            }
            catch (Exception exception) {
                throw new HelpSetParseException("Error parsing subhelpset " + exception.getMessage());
            }
        }
        if (helpSet != null) {
            int n = 0;
            while (n < helpSet._helpSetSections.size()) {
                this._helpSetSections.add(helpSet._helpSetSections.get(n));
                ++n;
            }
            n = 0;
            while (n < helpSet._windowTypes.size()) {
                this._windowTypes.add(helpSet._windowTypes.get(n));
                ++n;
            }
        }
    }

    private void _handleMap(XMLNode xMLNode) throws HelpSetParseException {
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.tokenEquals(TAG_MAPREF)) {
                HelpSetSection helpSetSection = new HelpSetSection(this, this._helpSetDir);
                helpSetSection.setIdentifier(TAG_MAP);
                String string = xMLNode.getTokenProperty(PARAM_LOCATION);
                if (string == null) {
                    string = "fakeFile";
                }
                helpSetSection.setDataLocationString(string);
                helpSetSection.setClassAttribute(xMLNode.getTokenProperty(PARAM_CLASS));
                String string2 = xMLNode.getTokenProperty(PARAM_ENGINE);
                if (string2 == null) {
                    string2 = ENGINE_ORACLE_XMLMAP_NEW;
                }
                helpSetSection.setEngineClass(string2);
                String string3 = xMLNode.getTokenProperty(PARAM_ENGINEPARAMS);
                helpSetSection.setEngineParams(string3);
                try {
                    URL uRL = helpSetSection.getDataLocationURL();
                }
                catch (Exception exception) {
                    throw new HelpSetParseException("Unable to build url to mapfile" + exception.getMessage());
                }
                this._helpSetSections.add(helpSetSection);
            } else if (xMLNode.tokenEquals(TAG_HOMEID)) {
                this._handleHomeID(xMLNode);
            } else {
                throw new HelpSetParseException("Unknown tag in map: " + xMLNode.getTokenValue());
            }
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void _handleView(XMLNode xMLNode) throws HelpSetParseException {
        Object object;
        HelpSetSection helpSetSection = new HelpSetSection(this, this._helpSetDir);
        helpSetSection.setIdentifier(TAG_VIEW);
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            object = xMLNode.getTokenValue();
            if (((String)object).equalsIgnoreCase(TAG_LABEL)) {
                helpSetSection.setViewLabel(xMLNode.getString());
                if (xMLNode.getTokenProperty(PARAM_IMAGE) != null) {
                    helpSetSection.setLabelImageString(xMLNode.getTokenProperty(PARAM_IMAGE));
                }
            } else if (((String)object).equalsIgnoreCase(TAG_NAME)) {
                helpSetSection.setViewName(xMLNode.getString());
            } else if (((String)object).equalsIgnoreCase(TAG_TITLE)) {
                helpSetSection.setViewTitle(xMLNode.getString());
                if (xMLNode.getTokenProperty(PARAM_IMAGE) != null) {
                    helpSetSection.setTitleImageString(xMLNode.getTokenProperty(PARAM_IMAGE));
                }
            } else if (((String)object).equalsIgnoreCase("type")) {
                helpSetSection.setTypeClass(xMLNode.getString());
            } else if (((String)object).equalsIgnoreCase(TAG_DATA)) {
                helpSetSection.setEngineClass(xMLNode.getTokenProperty(PARAM_ENGINE));
                helpSetSection.setDataLocationString(xMLNode.getString());
                helpSetSection.setClassAttribute(xMLNode.getTokenProperty(PARAM_CLASS));
            } else if (((String)object).equalsIgnoreCase(TAG_MERGETYPE)) {
                // empty if block
            }
            xMLNode = xMLNode.getNextSibling();
        }
        helpSetSection.setTypeClass(this._checkTypeBackwardCompatibility(helpSetSection.getTypeClass()));
        helpSetSection.setEngineClass(this._checkEngineBackwardCompatibility(helpSetSection.getTypeClass(), helpSetSection.getEngineClass()));
        object = helpSetSection.getDataLocationURL();
        if (helpSetSection.getEngineClass() == null || helpSetSection.getTypeClass() == null || object == null) {
            throw new HelpSetParseException("Missing necessary data in view");
        }
        this._helpSetSections.add(helpSetSection);
    }

    private void _handleWinType(XMLNode xMLNode) throws HelpSetParseException {
        WindowType windowType = new WindowType(this);
        String string = xMLNode.getTokenProperty(PARAM_DEFAULT);
        if (string != null && string.equalsIgnoreCase("true")) {
            windowType.setDefault(true);
        }
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.tokenEquals(TAG_NAME)) {
                windowType.setName(xMLNode.getString());
            } else if (xMLNode.tokenEquals(TAG_HEIGHT)) {
                windowType.setHeight(xMLNode.getString());
            } else if (xMLNode.tokenEquals(TAG_WIDTH)) {
                windowType.setWidth(xMLNode.getString());
            } else if (xMLNode.tokenEquals(TAG_X)) {
                windowType.setX(xMLNode.getString());
            } else if (xMLNode.tokenEquals(TAG_Y)) {
                windowType.setY(xMLNode.getString());
            } else if (xMLNode.tokenEquals(TAG_TEXTFG)) {
                windowType.setTextFG(xMLNode.getString());
            } else if (xMLNode.tokenEquals(TAG_LINKFG)) {
                windowType.setLinkFG(xMLNode.getString());
            } else if (xMLNode.tokenEquals(TAG_BG)) {
                windowType.setPageBG(xMLNode.getString());
            } else if (xMLNode.tokenEquals(TAG_TITLE)) {
                windowType.setTitle(xMLNode.getString());
            } else if (xMLNode.tokenEquals(TAG_TOOLBAR)) {
                windowType.setToolbar(xMLNode.getString());
            } else {
                throw new HelpSetParseException("Unknown tag in wintype: " + xMLNode.getTokenValue());
            }
            xMLNode = xMLNode.getNextSibling();
        }
        if (windowType.getName() != null) {
            this._windowTypes.add(windowType);
        }
    }

    private void _handleLinkSection(XMLNode xMLNode) throws HelpSetParseException {
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (!xMLNode.tokenEquals(TAG_LINKREF)) {
                throw new HelpSetParseException("Unknown tag in link: " + xMLNode.getTokenValue());
            }
            HelpSetSection helpSetSection = new HelpSetSection(this, this._helpSetDir);
            helpSetSection.setIdentifier(TAG_LINKS);
            helpSetSection.setDataLocationString(xMLNode.getTokenProperty(PARAM_LOCATION));
            helpSetSection.setClassAttribute(xMLNode.getTokenProperty(PARAM_CLASS));
            try {
                URL uRL = helpSetSection.getDataLocationURL();
            }
            catch (Exception exception) {
                throw new HelpSetParseException("Error parsing link section" + exception.getMessage());
            }
            this._helpSetSections.add(helpSetSection);
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private String _checkTypeBackwardCompatibility(String string) {
        if (string != null) {
            if (string.equals(TYPE_JAVAHELP_TOC_NEW) || string.equals("javax.javahelp.TOC")) {
                string = TYPE_DEFAULT_ORACLE_TOC;
            } else if (string.equals(TYPE_JAVAHELP_KEYWORD_NEW) || string.equals("javax.javahelp.Index")) {
                string = TYPE_DEFAULT_ORACLE_KEYWORD;
            } else if (string.equals(TYPE_JAVAHELP_SEARCH_NEW) || string.equals(TYPE_JAVAHELP_SEARCH_OLD)) {
                string = TYPE_DEFAULT_ORACLE_SEARCH;
            }
        }
        return string;
    }

    private String _checkEngineBackwardCompatibility(String string, String string2) {
        if (string != null) {
            if (string.equals(TYPE_DEFAULT_ORACLE_TOC)) {
                if (string2 != null) {
                    if (string2.equals(ENGINE_ORACLE_HHC_OLD)) {
                        string2 = ENGINE_ORACLE_HHC_NEW;
                    } else if (string2.equals(ENGINE_ORACLE_TOC_OLD)) {
                        string2 = ENGINE_ORACLE_TOC_NEW;
                    } else if (string2.equals(ENGINE_ORACLE_XMLTOC_OLD)) {
                        string2 = "oracle.help.engine.XMLTOCEngine";
                    } else if (string2.equals("javax.javahelp.TOC")) {
                        string2 = "oracle.help.engine.XMLTOCEngine";
                    }
                } else {
                    string2 = "oracle.help.engine.XMLTOCEngine";
                }
            } else if (string.equals(TYPE_DEFAULT_ORACLE_KEYWORD)) {
                if (string2 != null) {
                    if (string2.equals(ENGINE_ORACLE_HHK_OLD)) {
                        string2 = ENGINE_ORACLE_HHK_NEW;
                    } else if (string2.equals(ENGINE_ORACLE_TOK_OLD)) {
                        string2 = ENGINE_ORACLE_TOK_NEW;
                    } else if (string2.equals(ENGINE_ORACLE_XMLINDEX_OLD)) {
                        string2 = "oracle.help.engine.XMLIndexEngine";
                    } else if (string2.equals("javax.javahelp.Index")) {
                        string2 = "oracle.help.engine.XMLIndexEngine";
                    }
                } else {
                    string2 = "oracle.help.engine.XMLIndexEngine";
                }
            } else if (string.equals(TYPE_DEFAULT_ORACLE_SEARCH)) {
                if (string2 != null) {
                    if (string2.equals(ENGINE_ORACLE_SEARCH_OLD)) {
                        string2 = ENGINE_ORACLE_SEARCH_NEW;
                    }
                } else {
                    string2 = ENGINE_ORACLE_SEARCH_NEW;
                }
            }
        }
        return string2;
    }

    private void _createViewObjects(boolean bl, String string) {
        if (bl && string == null) {
            return;
        }
        int n = 0;
        while (n < this._helpSetSections.size()) {
            HelpSetSection helpSetSection = (HelpSetSection)this._helpSetSections.get(n);
            if (helpSetSection.getIdentifier().equals(TAG_VIEW) && (!bl || helpSetSection.getTypeClass().equals(string)) && !helpSetSection.isCompleted()) {
                View view = null;
                DataEngine dataEngine = null;
                try {
                    Class<?> clazz = Class.forName(helpSetSection.getEngineClass());
                    if (clazz != null) {
                        dataEngine = (DataEngine)clazz.newInstance();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Could not find specified engine class.  Make sure " + helpSetSection.getEngineClass() + "is on your class path.");
                }
                catch (ClassCastException classCastException) {
                    System.err.println("Specified engine " + helpSetSection.getEngineClass() + " not a subclass of oracle.help.engine.DataEngine");
                }
                catch (Exception exception) {
                    System.err.println("Unable to create specified engine " + helpSetSection.getEngineClass());
                }
                if (dataEngine != null) {
                    try {
                        view = new View(this, helpSetSection.getViewBasePath(), helpSetSection.getTypeClass(), dataEngine, helpSetSection.getDataLocationURL(), helpSetSection.getHelpSetEncoding(), helpSetSection.getViewTitle(), helpSetSection.getViewLabel(), helpSetSection.getViewName());
                        view.setTitleImage(helpSetSection.getTitleImageTarget());
                        view.setLabelImage(helpSetSection.getLabelImageTarget());
                        this._views.add(view);
                    }
                    catch (Exception exception) {
                        view = null;
                        System.err.println("Exception encountered while creating View Object" + exception);
                    }
                }
                helpSetSection.setCompleted(true);
            }
            ++n;
        }
    }

    private void _createMaps() {
        int n = 0;
        while (n < this._helpSetSections.size()) {
            HelpSetSection helpSetSection = (HelpSetSection)this._helpSetSections.get(n);
            if (helpSetSection.getIdentifier().equals(TAG_MAP) && !helpSetSection.isCompleted()) {
                DataEngine dataEngine = null;
                try {
                    Class<?> clazz = Class.forName(helpSetSection.getEngineClass());
                    if (clazz != null) {
                        dataEngine = (DataEngine)clazz.newInstance();
                        URL uRL = helpSetSection.getDataLocationURL();
                        String string = helpSetSection.getEngineParams();
                        this._maps.add(dataEngine.createDataObject(null, null, uRL, this._controlFileEncoding, string));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Could not find specified engine class.  Make sure " + helpSetSection.getEngineClass() + "is on your class path.");
                }
                catch (ClassCastException classCastException) {
                    System.err.println("Specified engine " + helpSetSection.getEngineClass() + " not a subclass of oracle.help.engine.DataEngine");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (HelpSetParseException helpSetParseException) {
                    helpSetParseException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("Unable to create specified engine " + helpSetSection.getEngineClass());
                }
                helpSetSection.setCompleted(true);
            }
            ++n;
        }
    }
}

