/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Hashtable;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.graphics.TransparencyFilter;

public class ImageLoader {
    private static Hashtable _imageCache = new Hashtable();
    private static Image _iconImage = null;

    public static Image loadImage(Class clazz, String string) {
        URL uRL = null;
        try {
            uRL = clazz.getResource(string);
        }
        catch (Exception exception) {
            uRL = null;
        }
        return ImageLoader.loadImage(uRL);
    }

    public static Image loadImage(URL uRL) {
        String string;
        Image image = null;
        if (uRL != null && (image = (Image)_imageCache.get(string = uRL.toString())) == null) {
            Object object;
            try {
                object = uRL.getContent();
                if (object instanceof ImageProducer) {
                    ImageProducer imageProducer = (ImageProducer)object;
                    image = Toolkit.getDefaultToolkit().createImage(imageProducer);
                } else if (object instanceof Image) {
                    image = (Image)object;
                }
                if (image != null) {
                    ImageUtils.loadImage((Image)image);
                }
            }
            catch (Exception exception) {
                image = null;
            }
            if (image != null) {
                object = new TransparencyFilter(new Color(255, 153, 0));
                image = ImageUtils.createFilteredImage((Image)image, (ImageFilter)object);
            }
            if (image != null) {
                _imageCache.put(string, image);
            }
        }
        return image;
    }

    public static Image getIconImage() {
        return _iconImage;
    }

    public static void setIconImage(Image image) {
        _iconImage = image;
    }
}

