/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class XMLTOCEngine
extends DataEngine {
    private Book _book;
    private String _basePath;
    private static final String TAG_TOC = "toc";
    private static final String TAG_TOCITEM = "tocitem";
    private static final String PROP_ID = "target";
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";

    public Object createDataObject(View view, String string, URL uRL, String string2) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader bufferedReader = this._getBufferedReader(uRL, string2);
        return this.createDataObject(view, string, bufferedReader);
    }

    public Object createDataObject(View view, String string, BufferedReader bufferedReader) throws IOException {
        this._book = null;
        this._basePath = string;
        if (view != null) {
            this._book = view.getBook();
        }
        TopicTree topicTree = new TopicTree(this._book, string);
        TopicTreeNode topicTreeNode = topicTree.getRoot();
        Parser parser = ParserFactory.createParser(bufferedReader);
        XMLNode xMLNode = parser.getRoot();
        this._handleToc(xMLNode.getFirstChild(), topicTreeNode);
        return topicTree;
    }

    private void _handleToc(XMLNode xMLNode, TopicTreeNode topicTreeNode) throws XMLParseException {
        if (xMLNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOC)) {
            throw new XMLParseException("Toplevel tag is not TOC: " + xMLNode.getTokenValue());
        }
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            this._handleTocItem(xMLNode, topicTreeNode);
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void _handleTocItem(XMLNode xMLNode, TopicTreeNode topicTreeNode) throws XMLParseException {
        Object object;
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOCITEM)) {
            throw new XMLParseException("Tag is not tocitem: " + xMLNode.getTokenValue());
        }
        String string = xMLNode.getTokenProperty(PROP_ID);
        String string2 = xMLNode.getTokenProperty(PROP_IMAGE);
        SimpleTopic simpleTopic = new SimpleTopic(xMLNode.getTokenProperty(PROP_TEXT), this._book);
        if (string2 != null) {
            object = new IndirectTarget(this._book, string2);
            simpleTopic.setDefaultIcon((Target)object);
        }
        if (string != null) {
            object = new IndirectTarget(this._book, string);
            simpleTopic.setTarget((Target)object);
        }
        object = new TopicTreeNode(simpleTopic);
        topicTreeNode.addChild((TopicTreeNode)object);
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            this._handleTocItem(xMLNode, (TopicTreeNode)object);
            xMLNode = xMLNode.getNextSibling();
        }
    }
}

