/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import java.util.Vector;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.search.QueryResult;
import oracle.help.library.Book;

class ResultObject
implements QueryResult {
    public int fileno = -1;
    public String urlName = null;
    public String label = null;
    public boolean useful = false;
    public View view = null;
    private int _hitNumber = 0;
    private static int _maxHitNumber = 1;

    ResultObject() {
    }

    public Topic getResultTopic() {
        Book book = null;
        if (this.view != null) {
            book = this.view.getBook();
        }
        SimpleURLTarget simpleURLTarget = new SimpleURLTarget(this.view, this.urlName);
        SimpleTopic simpleTopic = new SimpleTopic(this.label, simpleURLTarget, book);
        return simpleTopic;
    }

    public int getResultScore() {
        return (int)(100.0f * ((float)this._hitNumber / (float)_maxHitNumber));
    }

    public int getHitNumber() {
        return this._hitNumber;
    }

    public void setHitNumber(int n) {
        this._hitNumber = n;
        if (this._hitNumber > _maxHitNumber) {
            _maxHitNumber = this._hitNumber;
        }
    }

    public static void resetMaxHitNumber() {
        _maxHitNumber = 1;
    }

    public static void QuickSort(Vector vector, int n, int n2) {
        if (n2 > n) {
            int n3 = ((ResultObject)vector.elementAt(n2)).getHitNumber();
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (((ResultObject)vector.elementAt(++n4)).getHitNumber() > n3) {
                    continue;
                }
                while (((ResultObject)vector.elementAt(--n5)).getHitNumber() < n3 && n5 > 0) {
                }
                if (n4 >= n5) break;
                ResultObject.SwapObject(vector, n4, n5);
            }
            ResultObject.SwapObject(vector, n4, n2);
            ResultObject.QuickSort(vector, n, n4 - 1);
            ResultObject.QuickSort(vector, n4 + 1, n2);
        }
    }

    private static void SwapObject(Vector vector, int n, int n2) {
        ResultObject resultObject = (ResultObject)vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(resultObject, n2);
    }
}

