/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import oracle.help.common.View;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.ResultObject;
import oracle.help.common.search.SearchExpression;

public class IndexFileQueryHandler
implements QueryHandler {
    private URL _url;
    private View _view;
    private InputStream _inStream;
    private char[] _alphabet;
    private long[] _alphaOffsets;
    private long _eowOffset;
    private long _fsOffset;
    private String _productTitle;
    private int _version;
    private String _encoding;
    private boolean _fileCase;
    private boolean _scoreAvailable;
    private boolean _titlesAvailable;
    private String _rootPath;
    private boolean _caseSensitive = false;
    private String _title;
    private int _maxHitCount;
    private long _pos;
    private Vector _results;
    private static Vector _freeObjects;
    private static final int FREEOBJECTS_CACHE_SIZE = 250;
    private boolean _stopSearch;
    private boolean _needToParseHeader = true;
    private static final int VERSION_10 = 10;
    private static final int VERSION_11 = 11;
    private static final int VERSION_20 = 20;
    static final String INDEX_VERSION = "OIN-INDEX-VERSION";
    static final String CHARACTER_SET = "CHARACTER-SET";
    static final String PRODUCT_TITLE = "PRODUCT-TITLE";
    static final String CASESENSITIVE = "CASESENSITIVE";
    static final String TITLES = "TITLES";
    static final String BLOCK_SIZE = "BLOCK-SIZE";
    static final String SCORES = "SCORES";
    static final String ROOT_PATH = "ROOTPATH";
    static final String TRUE = "TRUE";

    public static IndexFileQueryHandler getInstance(View view, String string, URL uRL) {
        if (_freeObjects == null) {
            _freeObjects = new Vector();
        }
        IndexFileQueryHandler indexFileQueryHandler = null;
        try {
            indexFileQueryHandler = new IndexFileQueryHandler(view, string, uRL);
            return indexFileQueryHandler;
        }
        catch (Exception exception) {
            System.out.println("Invalid IDX file URL.  IOException when accessing " + uRL.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public void setMaxHitCount(int n) {
        this._maxHitCount = n;
    }

    public int getMaxHitCount() {
        return this._maxHitCount;
    }

    public URL getIndexFileUrl() {
        return this._url;
    }

    public void stopSearch() {
        this._stopSearch = true;
    }

    public String productTitle() {
        return this._productTitle;
    }

    public synchronized Enumeration executeQuery(String[] stringArray, boolean bl, boolean bl2) throws IOException {
        if (this._needToParseHeader) {
            this._parseHeader();
        }
        ResultObject.resetMaxHitNumber();
        this._stopSearch = false;
        this._caseSensitive = bl2;
        return this._executeStringQuery(stringArray, bl);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Enumeration executeQuery(SearchExpression var1_1) throws IOException {
        block13: {
            block12: {
                if (this._needToParseHeader) {
                    this._parseHeader();
                }
                ResultObject.resetMaxHitNumber();
                if (var1_1 != null) {
                    this._caseSensitive = var1_1.isCaseSensitive();
                }
                try {
                    try {
                        var2_2 = this._executeBooleanQuery(var1_1);
                        if (var2_2 == null) {
                            var3_4 = null;
                            var6_6 = null;
                            break block12;
                        }
                        var4_14 = new Enumeration(){
                            int count = 0;

                            public boolean hasMoreElements() {
                                return this.count < var2_2.length;
                            }

                            public Object nextElement() {
                                if (this.count >= var2_2.length) {
                                    return null;
                                }
                                return var2_2[this.count++];
                            }
                        };
                        break block13;
                    }
                    catch (ThreadDeath var2_3) {
                        var3_5 = null;
                        var6_8 = null;
                        try {
                            if (this._inStream == null) return var3_5;
                            this._inStream.close();
                            this._inStream = null;
                            return var3_5;
                        }
                        catch (Exception var7_12) {
                            // empty catch block
                        }
                        return var3_5;
                    }
                }
                catch (Throwable var5_15) {
                    var6_9 = null;
                    try {}
                    catch (Exception var7_13) {
                        throw var5_15;
                    }
                    if (this._inStream == null) throw var5_15;
                    this._inStream.close();
                    this._inStream = null;
                    throw var5_15;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 80->102)] { 
lbl41:
            // 1 sources

            if (this._inStream == null) return var3_4;
            this._inStream.close();
            this._inStream = null;
            return var3_4;
lbl45:
            // 1 sources

            catch (Exception var7_10) {
                // empty catch block
            }
            return var3_4;
        }
        var6_7 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 80->102)] { 
lbl51:
        // 1 sources

        if (this._inStream == null) return var4_14;
        this._inStream.close();
        this._inStream = null;
        return var4_14;
lbl55:
        // 1 sources

        catch (Exception var7_11) {
            // empty catch block
        }
        return var4_14;
    }

    private void _checkStopSearch() {
        if (this._stopSearch) {
            throw new ThreadDeath();
        }
    }

    /*
     * Loose catch block
     */
    private Enumeration _executeStringQuery(String[] stringArray, boolean bl) throws IOException {
        Enumeration enumeration;
        block13: {
            block12: {
                stringArray = this._filter(stringArray);
                enumeration = null;
                if (this._fileCase && !this._caseSensitive) {
                    enumeration = this._executeComplexStringQuery(stringArray, bl);
                    break block12;
                }
                enumeration = this._executeSimpleStringQuery(stringArray, bl);
            }
            Object var6_4 = null;
            try {
                if (this._inStream != null) {
                    this._inStream.close();
                    this._inStream = null;
                }
                break block13;
            }
            catch (Exception exception) {}
            break block13;
            {
                catch (ThreadDeath threadDeath) {
                    enumeration = null;
                    Object var6_5 = null;
                    try {
                        if (this._inStream != null) {
                            this._inStream.close();
                            this._inStream = null;
                        }
                        break block13;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (this._inStream != null) {
                        this._inStream.close();
                        this._inStream = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return enumeration;
    }

    /*
     * Unable to fully structure code
     */
    private Enumeration _executeSimpleStringQuery(String[] var1_1, boolean var2_2) throws IOException {
        var3_3 = new String[var1_1.length];
        if (this._fileCase) {
            var5_4 = 0;
            while (var5_4 < var1_1.length) {
                var3_3[var5_4] = var1_1[var5_4];
                ++var5_4;
            }
        } else {
            var5_4 = 0;
            while (var5_4 < var1_1.length) {
                var3_3[var5_4] = var1_1[var5_4].toLowerCase();
                ++var5_4;
            }
        }
        this._bubbleSort(var3_3);
        var9_5 = 0;
        var10_6 = new byte[1000];
        var11_7 = 0;
        var12_8 = 0;
        var13_9 = 0;
        var14_10 = new byte[512];
        var17_11 = 0;
        var19_12 = false;
        this._pos = 0L;
        var4_13 = new long[var3_3.length];
        this._inStream = this._openInputStream(this._url);
        if (this._inStream == null) {
            System.out.println("index file missing : " + this._url.toString());
            return null;
        }
        var20_14 = !var2_2;
        while (!var19_12) {
            var15_16 = var16_17 = var9_5;
            var5_4 = var9_5;
            while (var5_4 < var3_3.length) {
                if (var3_3[var9_5].charAt(0) != var3_3[var5_4].charAt(0)) break;
                ++var16_17;
                ++var5_4;
            }
            if ((var22_20 = this._getAlphabetIndex(var3_3[var15_16].charAt(0))) == -1) {
                if (var2_2) {
                    var20_14 = true;
                    break;
                }
                var5_4 = var15_16;
                while (var5_4 < var16_17) {
                    var4_13[var5_4] = 0L;
                    ++var5_4;
                }
                var9_5 = var16_17;
                if (var16_17 != var3_3.length) continue;
                var19_12 = true;
                continue;
            }
            var23_21 = this._alphaOffsets[var22_20];
            var25_22 = var22_20 == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[var22_20 + 1];
            this._inputSkip(var23_21 - this._pos);
            this._pos = var23_21;
            var18_18 = false;
            while (!var19_12 && !var18_18) {
                block43: {
                    var27_23 = 0;
                    if ((long)var12_8 + (var25_22 - this._pos) > (long)var10_6.length) {
                        var11_7 = var10_6.length - var12_8;
                    } else {
                        var11_7 = (int)(var25_22 - this._pos);
                        var18_18 = true;
                    }
                    this._read(var10_6, var12_8, var11_7);
                    var13_9 = var11_7 + var12_8;
                    var12_8 = 0;
                    try {
                        var17_11 = var15_16;
                        var28_24 = 0;
                        var29_26 = 0;
                        var30_27 = null;
                        do {
                            var21_19 = 0;
                            var27_23 = var28_24;
                            if (this._version < 20) {
                                while ((var14_10[var21_19++] = var10_6[var28_24++]) != 32) {
                                }
                                var30_27 = new String(var14_10, 0, var21_19 - 1);
                            } else {
                                var29_26 = var10_6[var28_24++];
                                while (var29_26 != 0) {
                                    var14_10[var21_19++] = var10_6[var28_24++];
                                    --var29_26;
                                }
                                var30_27 = this._bytesToString(var14_10, 0, var21_19);
                            }
                            if (var3_3[var17_11].equals(var30_27)) {
                                var6_15 = 0;
                                while (var6_15 < 4) {
                                    var31_28 = var10_6[var28_24 + var6_15];
                                    if (var31_28 < 0) {
                                        var31_28 = 256 + var31_28;
                                    }
                                    v0 = var17_11;
                                    var4_13[v0] = var4_13[v0] | (long)(var31_28 << 8 * (3 - var6_15));
                                    ++var6_15;
                                }
                                ++var17_11;
                                if (!var2_2) {
                                    var20_14 = false;
                                }
                            } else if (var3_3[var17_11].compareTo(var30_27) < 0) {
                                var4_13[var17_11] = 0L;
                                ++var17_11;
                                if (var2_2) {
                                    var20_14 = true;
                                    var19_12 = true;
                                    break block43;
                                }
                            }
                            if ((var28_24 += 4) <= var13_9) continue;
                            throw new IndexOutOfBoundsException();
                        } while (var17_11 != var16_17);
                        break block43;
                    }
                    catch (IndexOutOfBoundsException var28_25) {
                        var12_8 = var13_9 - var27_23;
                        var5_4 = 0;
                        ** while (var5_4 < var12_8)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var10_6[var5_4] = var10_6[var27_23 + var5_4];
                        ++var5_4;
                        continue;
                    }
                }
                if (var17_11 == var3_3.length) {
                    var19_12 = true;
                }
                if (var17_11 == var16_17) break;
            }
            var9_5 = var16_17;
            this._checkStopSearch();
        }
        if (var20_14) {
            return null;
        }
        if (this._results.size() > 0) {
            var5_4 = 0;
            while (var5_4 < this._results.size()) {
                IndexFileQueryHandler._freeObjects.addElement(this._results.elementAt(var5_4));
                ++var5_4;
            }
            this._results.removeAllElements();
        }
        var5_4 = 0;
        while (var5_4 < var3_3.length) {
            if (var4_13[var5_4] != 0L) {
                this._inputSkip(var4_13[var5_4] - this._pos);
                this._pos = var4_13[var5_4];
                if (var5_4 == 0) {
                    this._readFileIndices(this._results, true);
                } else if (var2_2) {
                    this._readFileIndices(this._results, false);
                    if (this._results.size() == 0) {
                        break;
                    }
                } else {
                    this._readFileIndices(this._results, true);
                }
                this._checkStopSearch();
            }
            ++var5_4;
        }
        if (IndexFileQueryHandler._freeObjects.size() > 250) {
            var5_4 = IndexFileQueryHandler._freeObjects.size() - 250;
            while (var5_4 != 0) {
                IndexFileQueryHandler._freeObjects.removeElementAt(--var5_4);
            }
        }
        if (this._results.size() == 0) {
            return null;
        }
        this._inputSkip(this._fsOffset - this._pos);
        this._readFileNames(this._results, var10_6);
        this._results.trimToSize();
        if (this._scoreAvailable) {
            ResultObject.QuickSort(this._results, 0, this._results.size() - 1);
        }
        return this._results.elements();
    }

    /*
     * Unable to fully structure code
     */
    private Enumeration _executeComplexStringQuery(String[] var1_1, boolean var2_2) throws IOException {
        var3_3 = new String[var1_1.length];
        var7_4 = 0;
        while (var7_4 < var1_1.length) {
            var3_3[var7_4] = var1_1[var7_4].toLowerCase();
            ++var7_4;
        }
        this._bubbleSort(var3_3);
        var13_5 = 0;
        var14_6 = new byte[1000];
        var15_7 = 0;
        var16_8 = 0;
        var17_9 = 0;
        var18_10 = new byte[512];
        var21_11 = 0;
        var23_12 = false;
        this._pos = 0L;
        this._inStream = this._openInputStream(this._url);
        if (this._inStream == null) {
            System.out.println("index file missing : " + this._url.toString());
            return null;
        }
        var4_13 = new Vector<String>();
        var5_14 = new Vector<Long>();
        var24_15 = var2_2 == false;
        var26_16 = 0;
        while (var26_16 < 2) {
            var13_5 = 0;
            var23_12 = false;
            while (!var23_12) {
                var19_20 = var20_21 = var13_5;
                if (var26_16 == 0) {
                    var28_25 = Character.toUpperCase(var3_3[var13_5].charAt(0));
                    var7_4 = var13_5;
                    while (var7_4 < var3_3.length) {
                        if (var28_25 != Character.toUpperCase(var3_3[var7_4].charAt(0))) break;
                        ++var20_21;
                        ++var7_4;
                    }
                    var6_17 = new Character(var28_25).toString();
                    var6_17 = var6_17.concat(var3_3[var20_21 - 1].substring(1));
                    var27_24 = this._getAlphabetIndex(var28_25);
                } else {
                    var28_25 = var3_3[var13_5].charAt(0);
                    var7_4 = var13_5;
                    while (var7_4 < var3_3.length) {
                        if (var28_25 != var3_3[var7_4].charAt(0)) break;
                        ++var20_21;
                        ++var7_4;
                    }
                    var6_17 = var3_3[var20_21 - 1];
                    var27_24 = this._getAlphabetIndex(var28_25);
                }
                if (var27_24 == -1) {
                    var13_5 = var20_21;
                    if (var20_21 != var3_3.length) continue;
                    var23_12 = true;
                    continue;
                }
                var11_19 = this._alphaOffsets[var27_24];
                if (this._pos > var11_19) {
                    var13_5 = var20_21;
                    if (var20_21 != var3_3.length) continue;
                    var23_12 = true;
                    continue;
                }
                var28_26 = var27_24 == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[var27_24 + 1];
                this._inputSkip(var11_19 - this._pos);
                this._pos = var11_19;
                var22_22 = false;
                block9: while (!var23_12 && !var22_22) {
                    var30_28 = 0;
                    if ((long)var16_8 + (var28_26 - this._pos) > (long)var14_6.length) {
                        var15_7 = var14_6.length - var16_8;
                    } else {
                        var15_7 = (int)(var28_26 - this._pos);
                        var22_22 = true;
                    }
                    this._read(var14_6, var16_8, var15_7);
                    var17_9 = var15_7 + var16_8;
                    var16_8 = 0;
                    try {
                        var21_11 = var19_20;
                        var31_29 = 0;
                        var32_31 = null;
                        do {
                            var25_23 = 0;
                            var30_28 = var31_29;
                            if (this._version < 20) {
                                while ((var18_10[var25_23++] = var14_6[var31_29++]) != 32) {
                                }
                                var32_31 = new String(var18_10, 0, var25_23 - 1);
                            } else {
                                var34_33 = var14_6[var31_29++];
                                while (var34_33 != 0) {
                                    var18_10[var25_23++] = var14_6[var31_29++];
                                    --var34_33;
                                }
                                try {
                                    var32_31 = new String(var18_10, 0, var25_23, this._encoding);
                                }
                                catch (UnsupportedEncodingException var35_34) {
                                    var32_31 = new String(var18_10, 0, var25_23);
                                }
                            }
                            var33_32 = true;
                            var7_4 = var19_20;
                            while (var7_4 < var20_21) {
                                if (var32_31.equalsIgnoreCase(var3_3[var7_4])) {
                                    var33_32 = false;
                                    break;
                                }
                                ++var7_4;
                            }
                            if (!var33_32) {
                                var35_35 = 0L;
                                var8_18 = 0;
                                while (var8_18 < 4) {
                                    var37_36 = var14_6[var31_29 + var8_18];
                                    if (var37_36 < 0) {
                                        var37_36 = 256 + var37_36;
                                    }
                                    var35_35 |= (long)(var37_36 << 8 * (3 - var8_18));
                                    ++var8_18;
                                }
                                var4_13.addElement(var32_31);
                                var5_14.addElement(new Long(var35_35));
                                continue;
                            }
                            if (var6_17.compareTo(var32_31) >= 0) continue;
                            var22_22 = true;
                            continue block9;
                        } while ((var31_29 += 4) <= var17_9);
                        throw new IndexOutOfBoundsException();
                    }
                    catch (IndexOutOfBoundsException var31_30) {
                        var16_8 = var17_9 - var30_28;
                        var7_4 = 0;
                        ** while (var7_4 < var16_8)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var14_6[var7_4] = var14_6[var30_28 + var7_4];
                        ++var7_4;
                        continue;
lbl131:
                        // 1 sources

                    }
                }
                if (var20_21 == var3_3.length) {
                    var23_12 = true;
                }
                var13_5 = var20_21;
                this._checkStopSearch();
            }
            ++var26_16;
        }
        if (var4_13.size() == 0 || var2_2 && var4_13.size() < var3_3.length) {
            return null;
        }
        if (this._results.size() > 0) {
            var7_4 = 0;
            while (var7_4 < this._results.size()) {
                IndexFileQueryHandler._freeObjects.addElement(this._results.elementAt(var7_4));
                ++var7_4;
            }
            this._results.removeAllElements();
        }
        var28_27 = new Vector[var3_3.length];
        var7_4 = 0;
        while (var7_4 < var4_13.size()) {
            var8_18 = 0;
            while (var8_18 < var3_3.length) {
                if (var3_3[var8_18].equalsIgnoreCase((String)var4_13.elementAt(var7_4))) break;
                ++var8_18;
            }
            var11_19 = (Long)var5_14.elementAt(var7_4);
            if (var11_19 != 0L) {
                if (var28_27[var8_18] == null) {
                    var28_27[var8_18] = new Vector<E>();
                }
                this._inputSkip(var11_19 - this._pos);
                this._pos = var11_19;
                this._readFileIndices(var28_27[var8_18], true);
                this._checkStopSearch();
            }
            ++var7_4;
        }
        if (var2_2) {
            var7_4 = 0;
            while (var7_4 < var3_3.length) {
                if (var28_27[var7_4] == null) {
                    return null;
                }
                ++var7_4;
            }
        }
        this._results = var28_27[0];
        if (this._results == null) {
            this._results = new Vector<E>();
        }
        if (var1_1.length > 1) {
            if (var2_2) {
                var7_4 = 0;
                while (var7_4 < this._results.size()) {
                    var29_37 = (ResultObject)this._results.elementAt(var7_4);
                    var29_37.useful = true;
                    var8_18 = 1;
                    while (var8_18 < var1_1.length) {
                        if (this._findFileIndex(var28_27[var8_18], var29_37.fileno) == null) {
                            var29_37.useful = false;
                        }
                        this._checkStopSearch();
                        ++var8_18;
                    }
                    ++var7_4;
                }
                var8_18 = 1;
                while (var8_18 < var1_1.length) {
                    this._filterResults(var28_27[var8_18], true);
                    ++var8_18;
                }
                this._filterResults(this._results, false);
            } else {
                var7_4 = 1;
                while (var7_4 < var1_1.length) {
                    if (var28_27[var7_4] != null) {
                        var8_18 = 0;
                        while (var8_18 < var28_27[var7_4].size()) {
                            var29_37 = (ResultObject)var28_27[var7_4].elementAt(var8_18);
                            if (this._findFileIndex(this._results, var29_37.fileno) == null) {
                                this._results.addElement(var29_37);
                            } else {
                                var29_37.useful = false;
                            }
                            ++var8_18;
                        }
                        this._filterResults(var28_27[var7_4], false);
                    }
                    this._checkStopSearch();
                    ++var7_4;
                }
            }
        }
        if (IndexFileQueryHandler._freeObjects.size() > 250) {
            var7_4 = IndexFileQueryHandler._freeObjects.size() - 250;
            while (var7_4 != 0) {
                IndexFileQueryHandler._freeObjects.removeElementAt(--var7_4);
            }
        }
        if (this._results.size() == 0) {
            return null;
        }
        this._inputSkip(this._fsOffset - this._pos);
        this._readFileNames(this._results, var14_6);
        this._results.trimToSize();
        if (this._scoreAvailable) {
            ResultObject.QuickSort(this._results, 0, this._results.size() - 1);
        }
        return this._results.elements();
    }

    private ResultObject[] _executeBooleanQuery(SearchExpression searchExpression) throws IOException {
        ResultObject[] resultObjectArray = null;
        ResultObject[] resultObjectArray2 = null;
        ResultObject[] resultObjectArray3 = null;
        if (searchExpression.getOperator() == 0) {
            Enumeration enumeration = this._executeStringQuery(searchExpression.getData(), true);
            if (enumeration == null) {
                return null;
            }
            if (enumeration != null) {
                resultObjectArray3 = new ResultObject[this._results.size()];
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    resultObjectArray3[n++] = this._cloneResultObject((ResultObject)enumeration.nextElement());
                }
                return resultObjectArray3;
            }
        }
        if (searchExpression.getExpression1() != null) {
            resultObjectArray = this._executeBooleanQuery(searchExpression.getExpression1());
        }
        if (resultObjectArray == null && searchExpression.getOperator() == 4) {
            return null;
        }
        if (searchExpression.getOperator() == 3) {
            resultObjectArray3 = this._evaluateNOT(resultObjectArray);
            if (resultObjectArray != null) {
                this._cacheResultObjectArray(resultObjectArray, true);
            }
            return resultObjectArray3;
        }
        if (searchExpression.getExpression2() != null) {
            resultObjectArray2 = this._executeBooleanQuery(searchExpression.getExpression2());
        }
        if (resultObjectArray2 == null && searchExpression.getOperator() == 1) {
            return resultObjectArray;
        }
        if (resultObjectArray == null && searchExpression.getOperator() == 1) {
            return resultObjectArray2;
        }
        if (searchExpression.getOperator() == 1) {
            int n = 0;
            int n2 = 0;
            while (n2 < resultObjectArray.length) {
                resultObjectArray[n2].useful = false;
                int n3 = 0;
                while (n3 < resultObjectArray2.length) {
                    if (resultObjectArray[n2].fileno == resultObjectArray2[n3].fileno) {
                        resultObjectArray[n2].useful = true;
                        ++n;
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
            if (n == 0) {
                this._cacheResultObjectArray(resultObjectArray, true);
                this._cacheResultObjectArray(resultObjectArray2, true);
                return null;
            }
            resultObjectArray3 = new ResultObject[n];
            n = 0;
            n2 = 0;
            while (n2 < resultObjectArray.length) {
                if (resultObjectArray[n2].useful) {
                    resultObjectArray3[n++] = resultObjectArray[n2];
                }
                ++n2;
            }
            this._cacheResultObjectArray(resultObjectArray, false);
            this._cacheResultObjectArray(resultObjectArray2, true);
            return resultObjectArray3;
        }
        if (searchExpression.getOperator() == 2) {
            if (resultObjectArray == null) {
                return resultObjectArray2;
            }
            if (resultObjectArray2 == null) {
                return resultObjectArray;
            }
            int n = resultObjectArray.length + resultObjectArray2.length;
            int n4 = 0;
            while (n4 < resultObjectArray2.length) {
                resultObjectArray2[n4].useful = true;
                ++n4;
            }
            n4 = 0;
            while (n4 < resultObjectArray.length) {
                resultObjectArray[n4].useful = true;
                int n5 = 0;
                while (n5 < resultObjectArray2.length) {
                    if (resultObjectArray[n4].fileno == resultObjectArray2[n5].fileno) {
                        --n;
                        resultObjectArray2[n5].useful = false;
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
            resultObjectArray3 = new ResultObject[n];
            n = 0;
            n4 = 0;
            while (n4 < resultObjectArray.length) {
                resultObjectArray3[n++] = resultObjectArray[n4];
                ++n4;
            }
            n4 = 0;
            while (n4 < resultObjectArray2.length) {
                if (resultObjectArray2[n4].useful) {
                    resultObjectArray3[n++] = resultObjectArray2[n4];
                }
                ++n4;
            }
            this._cacheResultObjectArray(resultObjectArray2, false);
            return resultObjectArray3;
        }
        if (searchExpression.getOperator() == 4) {
            if (resultObjectArray2 == null) {
                return resultObjectArray;
            }
            int n = resultObjectArray.length;
            int n6 = 0;
            while (n6 < resultObjectArray.length) {
                resultObjectArray[n6].useful = true;
                int n7 = 0;
                while (n7 < resultObjectArray2.length) {
                    if (resultObjectArray[n6].fileno == resultObjectArray2[n7].fileno) {
                        resultObjectArray[n6].useful = false;
                        --n;
                    }
                    ++n7;
                }
                ++n6;
            }
            if (n == 0) {
                this._cacheResultObjectArray(resultObjectArray, true);
                this._cacheResultObjectArray(resultObjectArray2, true);
                return null;
            }
            resultObjectArray3 = new ResultObject[n];
            n = 0;
            n6 = 0;
            while (n6 < resultObjectArray.length) {
                if (resultObjectArray[n6].useful) {
                    resultObjectArray3[n++] = resultObjectArray[n6];
                }
                ++n6;
            }
            this._cacheResultObjectArray(resultObjectArray, false);
            this._cacheResultObjectArray(resultObjectArray2, true);
            return resultObjectArray3;
        }
        if (resultObjectArray != null) {
            this._cacheResultObjectArray(resultObjectArray, true);
        }
        if (resultObjectArray2 != null) {
            this._cacheResultObjectArray(resultObjectArray2, true);
        }
        return null;
    }

    private String _bytesToString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, this._encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    protected IndexFileQueryHandler(View view, String string, URL uRL) {
        this._url = uRL;
        this._view = view;
        this._maxHitCount = 50;
        this._results = new Vector();
    }

    private InputStream _openInputStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        if (uRL.getProtocol().equals("file")) {
            try {
                inputStream = new FileInputStream(uRL.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    private long _readUb4() throws IOException {
        long l = 0L;
        l = (long)this._readUb1() << 24 | (long)this._readUb1() << 16 | (long)this._readUb1() << 8 | (long)this._readUb1();
        return l;
    }

    private int _readUb2() throws IOException {
        int n = this._readUb1() << 8 | this._readUb1();
        return n;
    }

    private int _readUb1() throws IOException {
        int n = this._inStream.read();
        if (n < 0) {
            n += 256;
        }
        ++this._pos;
        return n;
    }

    private void _inputSkip(long l) throws IOException {
        long l2 = l;
        while (l2 > 0L) {
            long l3 = this._inStream.skip(l2);
            l2 -= l3;
        }
    }

    private String _readLine() throws IOException {
        char c;
        int n = 40;
        StringBuffer stringBuffer = new StringBuffer(n);
        while ((c = (char)this._inStream.read()) != '\n') {
            if (stringBuffer.length() == n) {
                stringBuffer.setLength(n += 40);
            }
            stringBuffer.append(c);
            ++this._pos;
        }
        ++this._pos;
        return stringBuffer.toString();
    }

    private void _read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 != n2) {
            int n4 = this._inStream.read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                throw new IOException();
            }
            n3 += n4;
            this._pos += (long)n4;
        }
    }

    private void _parseHeader() throws IOException {
        this._needToParseHeader = false;
        this._inStream = this._openInputStream(this._url);
        if (this._inStream == null) {
            throw new IOException(this._url.toString() + " could not be read ");
        }
        String string = this._readLine();
        if (!string.startsWith(INDEX_VERSION)) {
            throw new IOException("Illegal Index File");
        }
        if (string.equals("OIN-INDEX-VERSION 1.0")) {
            this._version = 10;
        } else if (string.equals("OIN-INDEX-VERSION 1.1")) {
            this._version = 11;
        } else if (string.equals("OIN-INDEX-VERSION 2.0")) {
            this._version = 20;
        } else {
            throw new IOException(string + "END");
        }
        string = this._readLine();
        if (this._version >= 20) {
            this._encoding = string.substring(CHARACTER_SET.length() + 1);
        }
        if (!(string = this._readLine()).startsWith(PRODUCT_TITLE)) {
            throw new IOException("Corrupted Index File :" + string);
        }
        this._productTitle = string.substring(PRODUCT_TITLE.length() + 1);
        string = this._readLine();
        if (!string.startsWith(TITLES)) {
            throw new IOException("Corrupted Index File");
        }
        this._titlesAvailable = string.endsWith(TRUE);
        string = this._readLine();
        if (!string.startsWith(CASESENSITIVE)) {
            throw new IOException("Corrupted Index File");
        }
        this._fileCase = string.endsWith(TRUE);
        this._readLine();
        if (this._version > 10) {
            string = this._readLine();
            if (!string.startsWith(SCORES)) {
                throw new IOException("Corrupted Index File");
            }
            this._scoreAvailable = string.endsWith(TRUE);
        }
        if (!(string = this._readLine()).startsWith(ROOT_PATH)) {
            throw new IOException("Corrupted Index File");
        }
        this._rootPath = string.substring(ROOT_PATH.length() + 1);
        int n = this._readUb2();
        this._alphabet = new char[n];
        this._alphaOffsets = new long[n];
        byte[] byArray = new byte[16];
        int n2 = 0;
        while (n2 < n) {
            if (this._version < 20) {
                this._alphabet[n2] = (char)this._readUb1();
            } else {
                int n3 = this._readUb1();
                if (n3 == 1) {
                    this._alphabet[n2] = (char)this._readUb1();
                } else {
                    if (n3 > 16) {
                        throw new IOException("Oracle Help Indexer does not support encodings requiring more than 16 bytes to specify a character");
                    }
                    int n4 = 0;
                    while (n4 < n3) {
                        byArray[n4] = (byte)this._readUb1();
                        ++n4;
                    }
                    String string2 = new String(byArray, 0, n3, this._encoding);
                    this._alphabet[n2] = string2.charAt(0);
                }
            }
            this._alphaOffsets[n2] = this._readUb4();
            ++n2;
        }
        this._eowOffset = this._readUb4();
        this._fsOffset = this._readUb4();
        this._inStream.close();
        this._inStream = null;
    }

    private int _getAlphabetIndex(char c) {
        int n = 0;
        while (n < this._alphabet.length) {
            if (this._alphabet[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private ResultObject _cloneResultObject(ResultObject resultObject) {
        ResultObject resultObject2 = null;
        if (_freeObjects.size() != 0) {
            resultObject2 = (ResultObject)_freeObjects.elementAt(0);
            _freeObjects.removeElementAt(0);
        } else {
            resultObject2 = new ResultObject();
        }
        resultObject2.view = resultObject.view;
        resultObject2.fileno = resultObject.fileno;
        resultObject2.useful = resultObject.useful;
        resultObject2.label = resultObject.label;
        resultObject2.urlName = resultObject.urlName;
        resultObject2.setHitNumber(resultObject.getHitNumber());
        return resultObject2;
    }

    private void _cacheResultObjectArray(ResultObject[] resultObjectArray, boolean bl) {
        int n = 0;
        while (n < resultObjectArray.length) {
            if (bl || !resultObjectArray[n].useful) {
                _freeObjects.addElement(resultObjectArray[n]);
            }
            ++n;
        }
    }

    private void _readFileIndices(Vector vector, boolean bl) throws IOException {
        int n;
        ResultObject resultObject;
        int n2 = 0;
        Vector vector2 = new Vector(10, 10);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            resultObject = (ResultObject)enumeration.nextElement();
            resultObject.useful = bl;
        }
        while ((n = this._readUb2()) != 65535) {
            if (this._scoreAvailable) {
                n2 = this._readUb1();
            }
            if ((resultObject = this._findFileIndex(vector, n)) == null) {
                if (!bl) continue;
                if (_freeObjects.size() != 0) {
                    resultObject = (ResultObject)_freeObjects.elementAt(0);
                    _freeObjects.removeElementAt(0);
                } else {
                    resultObject = new ResultObject();
                }
                resultObject.view = this._view;
                resultObject.fileno = n;
                resultObject.useful = true;
                resultObject.label = null;
                resultObject.urlName = null;
                resultObject.setHitNumber(n2);
                vector.addElement(resultObject);
                continue;
            }
            resultObject.useful = true;
            resultObject.setHitNumber(resultObject.getHitNumber() + n2);
        }
        this._filterResults(vector, false);
    }

    private void _readFileNames(Vector vector, byte[] byArray) throws IOException {
        int n = this._readUb2();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this._readUb1();
            this._read(byArray, 0, n3);
            ResultObject resultObject = this._findFileIndex(vector, n2);
            if (resultObject != null) {
                resultObject.view = this._view;
                resultObject.urlName = this._version < 20 ? new String(byArray, 0, n3) : this._bytesToString(byArray, 0, n3);
            }
            if (this._titlesAvailable) {
                n3 = this._readUb1();
                this._read(byArray, 0, n3);
                if (resultObject != null) {
                    resultObject.label = this._version < 20 ? new String(byArray, 0, n3) : this._bytesToString(byArray, 0, n3);
                }
            }
            if (n2 % 20 == 0) {
                this._checkStopSearch();
            }
            ++n2;
        }
    }

    /*
     * Loose catch block
     */
    private ResultObject[] _evaluateNOT(ResultObject[] resultObjectArray) throws IOException {
        ResultObject[] resultObjectArray2;
        block22: {
            int n;
            byte[] byArray;
            int n2;
            boolean bl;
            block19: {
                resultObjectArray2 = null;
                bl = false;
                n2 = 0;
                byArray = new byte[256];
                this._inStream = this._openInputStream(this._url);
                this._inStream.skip(this._fsOffset);
                n = this._readUb2();
                if (resultObjectArray != null) break block19;
                resultObjectArray2 = new ResultObject[n];
                break block20;
            }
            if (resultObjectArray.length != n) break block21;
            ResultObject[] resultObjectArray3 = null;
            Object var11_9 = null;
            try {
                this._inStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                block20: {
                    block21: {
                        return resultObjectArray3;
                    }
                    resultObjectArray2 = new ResultObject[n - resultObjectArray.length];
                }
                int n3 = 0;
                while (n3 < n) {
                    ResultObject resultObject;
                    int n4;
                    bl = false;
                    if (resultObjectArray == null) {
                        bl = true;
                    } else {
                        bl = true;
                        n4 = 0;
                        while (n4 < resultObjectArray.length) {
                            if (resultObjectArray[n4].fileno == n3) {
                                bl = false;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (bl) {
                        if (_freeObjects.size() != 0) {
                            int n5 = n2++;
                            ResultObject resultObject2 = (ResultObject)_freeObjects.elementAt(0);
                            resultObjectArray2[n5] = resultObject2;
                            resultObject = resultObject2;
                            _freeObjects.removeElementAt(0);
                        } else {
                            int n6 = n2++;
                            ResultObject resultObject3 = new ResultObject();
                            resultObjectArray2[n6] = resultObject3;
                            resultObject = resultObject3;
                        }
                    } else {
                        resultObject = null;
                    }
                    n4 = this._readUb1();
                    this._read(byArray, 0, n4);
                    if (resultObject != null) {
                        resultObject.view = this._view;
                        resultObject.urlName = this._version < 20 ? new String(byArray, 0, n4) : this._bytesToString(byArray, 0, n4);
                    }
                    if (this._titlesAvailable) {
                        n4 = this._readUb1();
                        this._read(byArray, 0, n4);
                        if (resultObject != null) {
                            resultObject.label = this._version < 20 ? new String(byArray, 0, n4) : this._bytesToString(byArray, 0, n4);
                        }
                    }
                    if (n3 % 20 == 0) {
                        this._checkStopSearch();
                    }
                    ++n3;
                }
            }
            Object var11_10 = null;
            try {
                this._inStream.close();
            }
            catch (Exception exception) {}
            break block22;
            catch (Throwable throwable) {
                Object var11_11 = null;
                try {
                    this._inStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return resultObjectArray2;
    }

    private void _filterResults(Vector vector, boolean bl) {
        int n = 0;
        int n2 = vector.size();
        int n3 = 0;
        while (n < n2) {
            ResultObject resultObject = (ResultObject)vector.elementAt(n - n3);
            if (!resultObject.useful || bl) {
                _freeObjects.addElement(resultObject);
                vector.removeElementAt(n - n3);
                ++n3;
            }
            ++n;
        }
    }

    private ResultObject _findFileIndex(Vector vector, int n) {
        if (vector.isEmpty()) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResultObject resultObject = (ResultObject)enumeration.nextElement();
            if (resultObject.fileno != n) continue;
            return resultObject;
        }
        return null;
    }

    private void _bubbleSort(String[] stringArray) {
        if (stringArray.length == 1) {
            return;
        }
        if (stringArray.length == 2) {
            if (stringArray[0].compareTo(stringArray[1]) > 0) {
                String string = stringArray[1];
                stringArray[1] = stringArray[0];
                stringArray[0] = string;
            }
            return;
        }
        int n = stringArray.length - 1;
        while (n >= 1) {
            int n2 = 1;
            while (n2 <= n) {
                if (stringArray[n2 - 1].compareTo(stringArray[n2]) > 0) {
                    String string = stringArray[n2 - 1];
                    stringArray[n2 - 1] = stringArray[n2];
                    stringArray[n2] = string;
                }
                ++n2;
            }
            --n;
        }
    }

    private String[] _filter(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() > 1) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }
}

