/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.tocNavigator;

import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Vector;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Topic;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.tocNavigator.MergingTopLevelNode;

public class RootItemCommonModel {
    private ArrayList _topLevelNodeInfos;
    private ArrayList _tocViews = new ArrayList();

    public RootItemCommonModel(View[] viewArray) {
        this._topLevelNodeInfos = new ArrayList();
        int n = 0;
        int n2 = 0;
        if (viewArray != null) {
            n = 0;
            while (n < viewArray.length) {
                ArrayList arrayList;
                View view = viewArray[n];
                if (!this._tocViews.contains(view) && (arrayList = this._createNodeInfos(view)).size() > 0) {
                    this._tocViews.add(view);
                    n2 = 0;
                    while (n2 < arrayList.size()) {
                        this._topLevelNodeInfos.add(arrayList.get(n2));
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public int getItemCount() {
        return this._topLevelNodeInfos.size();
    }

    public Object getData(int n) {
        TopicTreeNode topicTreeNode = null;
        if (n < this._topLevelNodeInfos.size()) {
            NodeInfo nodeInfo = (NodeInfo)this._topLevelNodeInfos.get(n);
            topicTreeNode = nodeInfo.node;
        }
        return topicTreeNode;
    }

    public ArrayList getTopLevelNodeInfos() {
        return this._topLevelNodeInfos;
    }

    public void setData(int n, Object object) {
    }

    public void addTOCView(View view) {
        int n = 0;
        if (!this._tocViews.contains(view)) {
            ArrayList arrayList = this._createNodeInfos(view);
            this._tocViews.add(view);
            if (arrayList.size() > 0) {
                n = 0;
                while (n < arrayList.size()) {
                    this._topLevelNodeInfos.add(arrayList.get(n));
                    this.fireModelEventAdd(this._topLevelNodeInfos.size() - 1);
                    ++n;
                }
            }
        }
    }

    public void removeTOCView(View view) {
        int n = 0;
        if (this._tocViews.contains(view)) {
            ((AbstractCollection)this._tocViews).remove(view);
            n = this._topLevelNodeInfos.size() - 1;
            while (n >= 0) {
                NodeInfo nodeInfo = (NodeInfo)this._topLevelNodeInfos.get(n);
                if (nodeInfo.isMerged) {
                    if (nodeInfo.node instanceof MergingTopLevelNode) {
                        MergingTopLevelNode mergingTopLevelNode = (MergingTopLevelNode)nodeInfo.node;
                        mergingTopLevelNode.removeNodesFromView(view);
                        this._topLevelNodeInfos.remove(n);
                        this.fireModelEventRemove(n);
                        if (mergingTopLevelNode.getNumChildren() > 0) {
                            this._topLevelNodeInfos.add(n, nodeInfo);
                            this.fireModelEventAdd(n);
                        }
                    }
                } else if (nodeInfo.view == view) {
                    this._topLevelNodeInfos.remove(n);
                    this.fireModelEventRemove(n);
                }
                --n;
            }
        }
    }

    public TopicTreeNode findClosestMatchingNode(TopicTreeNode topicTreeNode, URL uRL) {
        int n = Integer.MAX_VALUE;
        TopicTreeNode topicTreeNode2 = null;
        if (uRL != null) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < this._tocViews.size()) {
                Vector vector;
                View view = (View)this._tocViews.get(n2);
                TopicTree topicTree = this._getTopicTree(view);
                if (topicTree != null && (vector = topicTree.findNodesForURL(uRL)) != null) {
                    n3 = 0;
                    while (n3 < vector.size()) {
                        TopicTreeNode topicTreeNode3 = (TopicTreeNode)vector.elementAt(n3);
                        int n4 = this._calculateDistance(topicTreeNode, topicTreeNode3);
                        if (n4 < n) {
                            topicTreeNode2 = topicTreeNode3;
                            n = n4;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return topicTreeNode2;
    }

    protected void fireModelEventAdd(int n) {
    }

    protected void fireModelEventRemove(int n) {
    }

    private ArrayList _createNodeInfos(View view) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TopicTree topicTree = this._getTopicTree(view);
        if (topicTree != null) {
            Object object;
            Object object2;
            TopicTreeNode topicTreeNode = null;
            if (view.getTitle() != null) {
                object2 = new SimpleTopic(view.getTitle(), null, view.getBook(), view.getTitleImage(), null);
                topicTreeNode = new TopicTreeNode((Topic)object2);
            }
            if ((object2 = topicTree.getRoot().getChildren()) != null) {
                int n = 0;
                while (n < ((ArrayList)object2).size()) {
                    object = (TopicTreeNode)((ArrayList)object2).get(n);
                    if (topicTreeNode != null) {
                        topicTreeNode.addChild((TopicTreeNode)object);
                    } else {
                        NodeInfo nodeInfo = new NodeInfo((TopicTreeNode)object, view);
                        if (!this._tryToMergeNodeInfo(nodeInfo)) {
                            arrayList.add(nodeInfo);
                        }
                    }
                    ++n;
                }
            }
            if (topicTreeNode != null && !this._tryToMergeNodeInfo((NodeInfo)(object = new NodeInfo(topicTreeNode, view)))) {
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    private boolean _tryToMergeNodeInfo(NodeInfo nodeInfo) {
        Topic topic = nodeInfo.node.getTopic();
        if (topic != null && !topic.hasTarget() && nodeInfo.node.isBranch()) {
            int n = 0;
            n = 0;
            while (n < this._topLevelNodeInfos.size()) {
                NodeInfo nodeInfo2 = (NodeInfo)this._topLevelNodeInfos.get(n);
                Topic topic2 = nodeInfo2.node.getTopic();
                if (topic2 != null && nodeInfo2.node.isBranch() && topic2.getLabel().equals(topic.getLabel())) {
                    nodeInfo2.setMerged(true);
                    if (!(nodeInfo2.node instanceof MergingTopLevelNode)) {
                        nodeInfo2.node = new MergingTopLevelNode(nodeInfo2.view, nodeInfo2.node);
                    }
                    MergingTopLevelNode mergingTopLevelNode = (MergingTopLevelNode)nodeInfo2.node;
                    mergingTopLevelNode.addTopLevelNode(nodeInfo.view, nodeInfo.node);
                    this._topLevelNodeInfos.remove(n);
                    this.fireModelEventRemove(n);
                    this._topLevelNodeInfos.add(n, nodeInfo2);
                    this.fireModelEventAdd(n);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private TopicTree _getTopicTree(View view) {
        TopicTree topicTree = null;
        if (view != null) {
            try {
                topicTree = (TopicTree)view.getViewData();
                topicTree.findNodesForURL(null);
            }
            catch (Exception exception) {
                System.err.println("View passed to RootItemModel does not contain data in TopicTree format.");
                exception.printStackTrace();
                topicTree = null;
            }
        }
        return topicTree;
    }

    private int _calculateDistance(TopicTreeNode topicTreeNode, TopicTreeNode topicTreeNode2) {
        if (topicTreeNode == null || topicTreeNode2 == null) {
            return 0;
        }
        ArrayList<TopicTreeNode> arrayList = new ArrayList<TopicTreeNode>();
        ArrayList<TopicTreeNode> arrayList2 = new ArrayList<TopicTreeNode>();
        ArrayList<TopicTreeNode> arrayList3 = new ArrayList<TopicTreeNode>();
        TopicTreeNode topicTreeNode3 = topicTreeNode;
        while (topicTreeNode3 != null) {
            arrayList.add(topicTreeNode3);
            topicTreeNode3 = topicTreeNode3.getParent();
        }
        topicTreeNode3 = topicTreeNode2;
        while (topicTreeNode3 != null) {
            arrayList2.add(topicTreeNode3);
            topicTreeNode3 = topicTreeNode3.getParent();
        }
        int n = 0;
        while (n < arrayList.size()) {
            TopicTreeNode topicTreeNode4 = (TopicTreeNode)arrayList.get(n);
            if (arrayList2.contains(topicTreeNode4)) {
                arrayList3.add(topicTreeNode4);
            }
            ++n;
        }
        int n2 = arrayList.size() + arrayList2.size() - 2 * arrayList3.size();
        return n2;
    }

    protected class NodeInfo {
        public boolean isMerged = false;
        public View view = null;
        public TopicTreeNode node = null;

        public NodeInfo(TopicTreeNode topicTreeNode, View view) {
            this.node = topicTreeNode;
            this.view = view;
        }

        public void setMerged(boolean bl) {
            this.isMerged = bl;
        }
    }
}

