/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.keywordNavigator;

import java.text.Collator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.ResourceBundle;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.KeywordModelData;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.navigator.keywordNavigator.KeywordListItem;

public class KeywordModel {
    public static String SUB_ITEM_INDENT = "    ";
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String WORD_LIST_SEPARATOR = "navigator.keywordNavigator.wordListSeparator";
    private ArrayList _keyViews;
    private ArrayList _listItems;
    private int _itemCount;
    private Collator _localColl;
    private int _insertionCompareValue = -1;
    private boolean _leftToRight;
    private String _subItemSeparator;
    private KeywordModelData _keywordModelData;

    public KeywordModel(KeywordModelData keywordModelData, View[] viewArray) {
        this._keywordModelData = keywordModelData;
        this._keywordModelData.setKeywordModel(this);
        this._keyViews = new ArrayList();
        this._listItems = new ArrayList();
        this._itemCount = 0;
        this._localColl = Collator.getInstance(StaticLocaleContext.getLocale());
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this._subItemSeparator = resourceBundle.getString(WORD_LIST_SEPARATOR);
        this._leftToRight = true;
        if (viewArray != null) {
            int n = 0;
            while (n < viewArray.length) {
                if (!this._keyViews.contains(viewArray[n])) {
                    this._keyViews.add(viewArray[n]);
                }
                ++n;
            }
        }
        if (this._keyViews.size() > 0) {
            View[] viewArray2 = new View[this._keyViews.size()];
            this._keyViews.toArray(viewArray2);
            this._keywordModelData.scheduleKeywordMerge(viewArray2, true);
        }
    }

    public KeywordModelData getKeywordModelData() {
        return this._keywordModelData;
    }

    public void addView(View view) {
        if (view != null && !this._keyViews.contains(view)) {
            this._keyViews.add(view);
            View[] viewArray = new View[]{view};
            this._keywordModelData.scheduleKeywordMerge(viewArray, true);
        }
    }

    public void removeView(View view) {
        if (view != null && this._keyViews.contains(view)) {
            ((AbstractCollection)this._keyViews).remove(view);
            View[] viewArray = new View[]{view};
            this._keywordModelData.scheduleKeywordMerge(viewArray, false);
        }
    }

    public int getItemCount() {
        return this._listItems.size();
    }

    public Object getData(int n) {
        KeywordListItem keywordListItem;
        String string = null;
        if (n < this._listItems.size() && (keywordListItem = (KeywordListItem)this._listItems.get(n)) != null) {
            string = keywordListItem.displayLabel;
            if (keywordListItem.indented) {
                string = this._leftToRight ? SUB_ITEM_INDENT + string : string + SUB_ITEM_INDENT;
            }
        }
        return string;
    }

    public KeywordListItem getKeywordListItemForIndex(int n) {
        KeywordListItem keywordListItem = null;
        if (n < this._listItems.size()) {
            keywordListItem = (KeywordListItem)this._listItems.get(n);
        }
        return keywordListItem;
    }

    public String getSortingLabelForIndex(int n) {
        String string = null;
        if (n < this._listItems.size()) {
            KeywordListItem keywordListItem = (KeywordListItem)this._listItems.get(n);
            string = keywordListItem.sortingLabel;
        }
        return string;
    }

    public void mergeKeywordIndices(View[] viewArray, boolean bl) {
        if (viewArray != null) {
            int n = 0;
            while (n < viewArray.length) {
                if (bl) {
                    this._addViewItems(viewArray[n]);
                } else {
                    this._removeViewItems(viewArray[n]);
                }
                ++n;
            }
        }
    }

    private void _addViewItems(View view) {
        if (view != null) {
            ArrayList arrayList;
            TopicTree topicTree = this._getTopicTree(view);
            if (topicTree != null && (arrayList = topicTree.getRoot().getChildren()) != null) {
                int n = 0;
                while (n < arrayList.size()) {
                    this._addNodeItems((TopicTreeNode)arrayList.get(n), view, null);
                    ++n;
                }
            }
            this._keywordModelData.fireCurrentDataEvent();
        }
    }

    private void _removeViewItems(View view) {
        int n = 0;
        if (view != null) {
            n = this._listItems.size() - 1;
            while (n >= 0) {
                KeywordListItem keywordListItem = (KeywordListItem)this._listItems.get(n);
                keywordListItem.removeNodeInfosForView(view);
                if (keywordListItem.getNodeInfoCount() == 0) {
                    this._listItems.remove(n);
                    this._keywordModelData.handleDataEvent(n);
                }
                --n;
            }
            this._keywordModelData.fireCurrentDataEvent();
        }
    }

    private void _addNodeItems(TopicTreeNode topicTreeNode, View view, String string) {
        Object object;
        this._fixNodeWithSeparators(topicTreeNode);
        Topic topic = topicTreeNode.getTopic();
        String string2 = topic.getLabel();
        boolean bl = false;
        String string3 = string2;
        if (string != null) {
            bl = true;
            string3 = this._leftToRight ? string + this._subItemSeparator + " " + string3 : string3 + " " + this._subItemSeparator + string;
        }
        String string4 = this._convertForCollate(string3);
        int n = this._findInsertionPoint(string4) + 1;
        if (this._insertionCompareValue == 0 && this._listItems.size() > 0) {
            object = (KeywordListItem)this._listItems.get(n - 1);
            ((KeywordListItem)object).addNodeInfo(topicTreeNode, view);
        } else {
            object = new KeywordListItem(string2, string3, string4, bl);
            ((KeywordListItem)object).addNodeInfo(topicTreeNode, view);
            this._listItems.add(n, object);
        }
        this._keywordModelData.handleDataEvent(n);
        object = topicTreeNode.getChildren();
        if (object != null) {
            int n2 = 0;
            while (n2 < ((ArrayList)object).size()) {
                if (string == null) {
                    String string5 = string3;
                    this._addNodeItems((TopicTreeNode)((ArrayList)object).get(n2), view, string5);
                } else {
                    this._addNodeItems((TopicTreeNode)((ArrayList)object).get(n2), view, string);
                }
                ++n2;
            }
        }
    }

    private void _fixNodeWithSeparators(TopicTreeNode topicTreeNode) {
        Topic topic = topicTreeNode.getTopic();
        Target target = topic.getTarget();
        String string = topic.getLabel();
        int n = string.indexOf(this._subItemSeparator);
        if (n != -1) {
            KeywordTopicTreeNode keywordTopicTreeNode;
            ArrayList arrayList;
            String string2 = null;
            String string3 = null;
            if (this._leftToRight) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            } else {
                n = string.lastIndexOf(this._subItemSeparator);
                string2 = string.substring(n + 1);
                string3 = string.substring(0, n);
            }
            SimpleTopic simpleTopic = new SimpleTopic(string2, topic.getParentBook());
            SimpleTopic simpleTopic2 = new SimpleTopic(string3, target, topic.getParentBook());
            topicTreeNode.setTopic(simpleTopic);
            KeywordTopicTreeNode keywordTopicTreeNode2 = new KeywordTopicTreeNode(simpleTopic2, topicTreeNode);
            if (topicTreeNode instanceof KeywordTopicTreeNode && (arrayList = (keywordTopicTreeNode = (KeywordTopicTreeNode)topicTreeNode).getEntries()) != null) {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    keywordTopicTreeNode2.addEntry((KeywordTopicTreeNode)arrayList.get(n2));
                    ++n2;
                }
                keywordTopicTreeNode.removeAllEntries();
            }
            topicTreeNode.addChild(keywordTopicTreeNode2);
        }
    }

    public int findClosestListItem(String string) {
        if (this._listItems.size() == 0) {
            return -1;
        }
        String string2 = this._convertForCollate(string);
        int n = this._findInsertionPoint(string2);
        if (n == -1) {
            n = 0;
        } else {
            KeywordListItem keywordListItem = (KeywordListItem)this._listItems.get(n);
            if (this._localColl.compare(keywordListItem.convertedLabel.toLowerCase(), string2.toLowerCase()) != 0 && n + 1 < this._listItems.size()) {
                keywordListItem = (KeywordListItem)this._listItems.get(n + 1);
                if (this._leftToRight) {
                    if (keywordListItem.sortingLabel.toLowerCase().startsWith(string.toLowerCase())) {
                        ++n;
                    }
                } else if (keywordListItem.sortingLabel.toLowerCase().endsWith(string.toLowerCase())) {
                    ++n;
                }
            }
        }
        return n;
    }

    private int _findInsertionPoint(String string) {
        if (string == null) {
            return -1;
        }
        int n = 0;
        int n2 = this._listItems.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            KeywordListItem keywordListItem = (KeywordListItem)this._listItems.get(n3);
            this._insertionCompareValue = this._localColl.compare(string, keywordListItem.convertedLabel);
            if (this._insertionCompareValue == 0) {
                return n3;
            }
            if (this._insertionCompareValue < 0) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        return n2;
    }

    private String _convertForCollate(String string) {
        int n = string.length();
        char[] cArray = new char[]{'\'', ' ', '\''};
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isWhitespace(c)) {
                cArray[1] = c;
                stringBuffer.append(cArray);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (this._leftToRight) {
            stringBuffer.append(this._subItemSeparator);
        } else {
            stringBuffer.insert(0, this._subItemSeparator);
        }
        return stringBuffer.toString();
    }

    private TopicTree _getTopicTree(View view) {
        TopicTree topicTree = null;
        if (view != null) {
            try {
                topicTree = (TopicTree)view.getViewData();
            }
            catch (Exception exception) {
                System.err.println("View passed to KeywordModel does not contain data in TopicTree format.");
                exception.printStackTrace();
                topicTree = null;
            }
        }
        return topicTree;
    }
}

